AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils","com.atlassian.jira.jira-issue-nav-plugin:issuenav","com.atlassian.jira.jira-issue-nav-plugin:metrics"],function(){module("JIRA.Issues.Api",{setup:function(){var a=AJS.$("body");JIRA.Issues.Application.start();this.searchPageModule=JIRA.Issues.TestUtils.mockSearchPageModule();this.searchPageModule.registerViewContainers({issueContainer:AJS.$('<div class="hidden"></div>').appendTo(a),searchContainer:AJS.$("<div></div>").appendTo(a)});this.sandbox=sinon.sandbox.create();this.searchPageModule.changeLayout("list-view",{ajax:false});JIRA.Issues.Api.initialize({searchPageModule:this.searchPageModule})},teardown:function(){this.searchPageModule.issueContainer.remove();this.searchPageModule.searchContainer.remove();this.sandbox.restore()}});test("openFocusShifter",function(){var b=sinon.stub(JIRA.Issues.LayoutPreferenceManager,"getPreferredLayoutKey");b.returns("list-view");this.layoutPreferenceManager=sinon;var a=sinon.stub(this.searchPageModule,"openFocusShifter");JIRA.Issues.Api.openFocusShifter();ok(!a.called,"Does nothing when no issue is visible.");this.searchPageModule.fullScreenIssue.isVisible.returns(true);JIRA.Issues.Api.openFocusShifter();ok(a.called,"Opens the focus shifter when an issue is visible.");b.returns("split-view");this.searchPageModule.fullScreenIssue.isVisible.returns(false);JIRA.Issues.Api.openFocusShifter();ok(a.called,"Opens the focus shifter in split-view.");b.restore()});test("nextIssue()",function(){JIRA.Issues.Api.nextIssue();equal(this.searchPageModule.getCurrentLayout().nextIssue.callCount,1,"Next issue requested")});test("prevIssue()",function(){JIRA.Issues.Api.prevIssue();equal(this.searchPageModule.getCurrentLayout().prevIssue.callCount,1,"Previous issue requested")});test("getSelectedIssueId",function(){sinon.stub(this.searchPageModule,"getEffectiveIssueId").returns(42);equal(42,JIRA.Issues.Api.getSelectedIssueId(),"Returns the correct issue ID");ok(this.searchPageModule.getEffectiveIssueId.called,"SearchPageModule.getEffectiveIssueId called.")});test("getSelectedIssueKey",function(){sinon.stub(this.searchPageModule,"getEffectiveIssueKey").returns("JRA-123");equal("JRA-123",JIRA.Issues.Api.getSelectedIssueKey(),"Returns the correct issue key");ok(this.searchPageModule.getEffectiveIssueKey.called,"SearchPageModule.getEffectiveIssueKey called.")});test("switchLayouts",function(){var b=sinon.spy(this.searchPageModule,"changeLayout");var a={ajax:false};JIRA.Issues.Api.switchLayouts(a);equal(b.callCount,1,"changeLayout was called");deepEqual(b.lastCall.args,["split-view",a],"Changed to split view");JIRA.Issues.Api.switchLayouts(a);equal(b.callCount,2,"changeLayout was called");deepEqual(b.lastCall.args,["list-view",a],"Changed to list view")});test("isFullScreenIssueVisible",function(){var b=sinon.stub(this.searchPageModule,"isFullScreenIssueVisible");b.returns(true);var a=JIRA.Issues.Api.isFullScreenIssueVisible();equal(b.callCount,1,"changeLayout was called");equal(a,true,"Works when isFullScreenIssueVisible returns true");b.reset();b.returns(false);a=JIRA.Issues.Api.isFullScreenIssueVisible();equal(b.callCount,1,"changeLayout was called");equal(a,false,"Works when isFullScreenIssueVisible returns true");b.restore()});test("getFieldsOnSelectedIssue() with no selected issue",function(){strictEqual(JIRA.Issues.Api.getFieldsOnSelectedIssue(),undefined,"not an on issue -> no fields")});test("getFieldsOnSelectedIssue() with selected issue",function(){this.sandbox.stub(JIRA.Issues.Application,"request").withArgs("issueEditor:fields").returns(new JIRA.Components.IssueEditor.Collections.Fields([{id:"customfield_10001"},{id:"customfield_10002"}]));var a=[];JIRA.Issues.Api.getFieldsOnSelectedIssue().each(function(b){a.push(b.id)});deepEqual(a,["customfield_10001","customfield_10002"])});test("editFieldOnSelectedIssue() with non-existent field",function(){this.sandbox.stub(JIRA.Issues.Application,"request").withArgs("issueEditor:fields").returns([]);JIRA.Issues.Api.editFieldOnSelectedIssue("foobar");this.sandbox.stub(JIRA.Issues.Application,"execute");ok(!JIRA.Issues.Application.execute.called)});test("editFieldOnSelectedIssue() with non-editable field",function(){var b;var a;b=JIRA.Issues.TestUtils.mockIssueFieldModel("id",false,true);a=new Backbone.Collection([b]);this.sandbox.stub(JIRA.Issues.Application,"request").withArgs("issueEditor:fields").returns(a);this.sandbox.stub(JIRA.Issues.Application,"execute");JIRA.Issues.Api.editFieldOnSelectedIssue("id");ok(!JIRA.Issues.Application.execute.called)});test("editFieldOnSelectedIssue() with editable field",function(){var b;var a;b=JIRA.Issues.TestUtils.mockIssueFieldModel("id",true,true);a=new Backbone.Collection([b]);this.sandbox.stub(JIRA.Issues.Application,"request").withArgs("issueEditor:fields").returns(a);this.sandbox.stub(JIRA.Issues.Application,"execute");JIRA.Issues.Api.editFieldOnSelectedIssue("id");ok(JIRA.Issues.Application.execute.calledOnce,"Application.execute was called once");ok(JIRA.Issues.Application.execute.calledWithExactly("issueEditor:editField",b),"Command 'issueEditor:editField' was executed")});test("toggleIssueFullscreen() from standalone fullscreen issue",function(){var a=this.searchPageModule.standalone;this.searchPageModule.standalone=true;this.sandbox.stub(this.searchPageModule,"isFullScreenIssueVisible").returns(true);this.sandbox.spy(this.searchPageModule,"returnToSearch");JIRA.Issues.Api.toggleFullscreenIssue();sinon.assert.notCalled(this.searchPageModule.returnToSearch);this.searchPageModule.standalone=a});test("toggleIssueFullscreen() from fullscreen issue",function(){var a=this.searchPageModule.standalone;this.searchPageModule.standalone=false;this.sandbox.stub(this.searchPageModule,"isFullScreenIssueVisible").returns(true);this.sandbox.spy(this.searchPageModule,"returnToSearch");JIRA.Issues.Api.toggleFullscreenIssue();sinon.assert.calledOnce(this.searchPageModule.returnToSearch);this.searchPageModule.standalone=a});test("toggleIssueFullscreen() from split-view layout",function(){var a="FOO-123";var b={reset:true};this.sandbox.stub(this.searchPageModule,"isFullScreenIssueVisible").returns(false);this.sandbox.stub(this.searchPageModule,"isSplitViewLayout").returns(true);this.sandbox.stub(this.searchPageModule,"getEffectiveIssueKey").returns(a);this.sandbox.stub(JIRA.Issues.Application,"execute");JIRA.Issues.Api.toggleFullscreenIssue();sinon.assert.calledOnce(JIRA.Issues.Application.execute);sinon.assert.calledWith(JIRA.Issues.Application.execute,"navigation:navigate",{selectedIssueKey:a},b)});test("toggleIssueFullscreen() from list-view layout",function(){var a="FOO-123";var b={};this.sandbox.stub(this.searchPageModule,"isFullScreenIssueVisible").returns(false);this.sandbox.stub(this.searchPageModule,"isSplitViewLayout").returns(false);this.sandbox.stub(this.searchPageModule,"getEffectiveIssueKey").returns(a);this.sandbox.stub(JIRA.Issues.Application,"execute");JIRA.Issues.Api.toggleFullscreenIssue();sinon.assert.calledOnce(JIRA.Issues.Application.execute);sinon.assert.calledWith(JIRA.Issues.Application.execute,"navigation:navigate",{selectedIssueKey:a},b)});test("focusIssueList() delegates to SearchPageModule",function(){this.stub(this.searchPageModule,"focusIssueList");JIRA.Issues.Api.focusIssueList();sinon.assert.calledOnce(this.searchPageModule.focusIssueList)});test("focusIssueEditor() delegates to SearchPageModule",function(){this.stub(this.searchPageModule,"focusIssueEditor");JIRA.Issues.Api.focusIssueEditor();sinon.assert.calledOnce(this.searchPageModule.focusIssueEditor)})});