AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:pager-test"],function(){var d=require("jira/issues/modules/pager/model");var b=require("jira/issues/modules/pager/controller");var c=require("jira/components/test-utils/mockutils");var a=require("jira/components/test-utils/marionettemocker");module("jira/issues/modules/pager",{setup:function(){this.sandbox=sinon.sandbox.create();this.PagerModel=a.createEventedMock(this.sandbox,d);this.PagerController=a.createEventedMock(this.sandbox,b);this.callbacks={goBack:this.sandbox.stub(),nextItem:this.sandbox.stub(),previousItem:this.sandbox.stub()};this.PagerConstructor=c.spyAll(this.sandbox,c.requireWithMocks("jira/issues/modules/pager",{"jira/issues/modules/pager/model":this.PagerModel.constructor,"jira/issues/modules/pager/controller":this.PagerController.constructor}))},teardown:function(){this.sandbox.restore()}});test("When the pager is initialised, it should set up the model",function(){var e=new this.PagerConstructor();e.initialize();sinon.assert.calledOnce(this.PagerModel.constructor)});test("When pager is updated with data, it should update the model",function(){var e=new this.PagerConstructor();e.initialize();var f={foo:"bar"};e.update(f);sinon.assert.calledWith(this.PagerModel.update,f)});test("When pager is updated, it should not clear the model if the view is an error",function(){this.PagerModel.get.withArgs("isError").returns(true);var e=new this.PagerConstructor();e.initialize();e.update();sinon.assert.notCalled(this.PagerModel.clear)});test("When pager is updated, it should clear the model if the view is not an error",function(){this.PagerModel.get.withArgs("isError").returns(false);var e=new this.PagerConstructor();e.initialize();e.update();sinon.assert.calledOnce(this.PagerModel.clear)});test("When the pager is shown, it should set up the controller if it doesn't exist",function(){var e=new this.PagerConstructor(this.stub());e.initialize();e.show();sinon.assert.calledOnce(this.PagerController.constructor);sinon.assert.calledWith(this.PagerController.constructor,sinon.match({model:sinon.match(this.PagerModel)}))});test("When the pager is shown, it should set up controller events if it doesn't exist",function(){var e=new this.PagerConstructor(this.callbacks);e.initialize();e.show();this.PagerController.trigger("goBack");sinon.assert.calledOnce(this.callbacks.goBack,"Go back handler is called");this.PagerController.trigger("nextItem");sinon.assert.calledOnce(this.callbacks.nextItem,"Next item handler is called");this.PagerController.trigger("previousItem");sinon.assert.calledOnce(this.callbacks.previousItem,"Previous item handler is called")});test("When the pager is shown, it should call the controller",function(){var e="foo";var g="bar";var f=new this.PagerConstructor(this.stub());f.initialize();f.show(e,g);sinon.assert.calledWith(this.PagerController.show,e,g)});test("When the pager is closed, it should close the controller",function(){var e=new this.PagerConstructor(this.stub());e.initialize();e.show();e.close();sinon.assert.calledOnce(this.PagerController.close)});test("When the pager is closed, it should clear the model",function(){var e=new this.PagerConstructor();e.initialize();e.close();sinon.assert.calledOnce(this.PagerModel.clear)})});