AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:testutils","com.atlassian.jira.jira-issue-nav-plugin:navigation"],function(){var d=require("jira/components/issueviewer/services/darkfeatures");var g=require("jira/components/test-utils/mockutils");var b=require("jira/issues/modules/navigation/state");var a=require("jira/issues/modules/navigation/controller");var c=require("underscore");var f=require("jira/issues/application");var e=require("jira/issues/layout-preference-manager");module("NavigationController",{setup:function(){this.context=AJS.test.mockableModuleContext();this.context.mock("jira/issues/modules/navigation/state",function(){});this.sandbox=sinon.sandbox.create();this.canDismissCommentStub=this.sandbox.stub(f,"request").withArgs("issueEditor:canDismissComment").returns(true);this.preferredLayoutStub=this.sandbox.stub(e,"getPreferredLayoutKey").returns("split-view");this.darkFeatureEnabledStub=this.sandbox.stub(d.REDIRECT_FROM_GLOBAL_TO_PROJECT,"enabled").returns(false);this.NavigationControllerContructor=g.requireWithMocks("jira/issues/modules/navigation/controller",{"jira/components/issueviewer/services/darkfeatures":d,"jira/issues/modules/navigation/state":b,"jira/issues/application":f});this.navigationController=new this.NavigationControllerContructor({isFullPageLoad:false});this.stateChangedHandler=this.sandbox.spy();this.navigationController.on("stateChanged",this.stateChangedHandler)},teardown:function(){this.sandbox.restore()},createStateWith:function(){var h=c.toArray(arguments);var i=c.clone(new b());return c.extend.apply(null,[i].concat(h))}});test("stateChanged event contains correct properties",function(){var h={routerEvent:true,randomProperty:"1"};var i={jql:"test",selectedIssueKey:"TEST-1"};var j={filter:12};this.navigationController.navigate(i,h);sinon.assert.calledOnce(this.stateChangedHandler);sinon.assert.calledWithExactly(this.stateChangedHandler,this.createStateWith(i),h);this.navigationController.navigate(j);sinon.assert.calledTwice(this.stateChangedHandler);sinon.assert.calledWithExactly(this.stateChangedHandler,this.createStateWith(i,j),{});this.navigationController.navigate(j,{reset:true});sinon.assert.calledThrice(this.stateChangedHandler);sinon.assert.calledWithExactly(this.stateChangedHandler,this.createStateWith(j),{reset:true})});test("When navigating and the REDIRECT_FROM_GLOBAL_TO_PROJECT DarkFeature is off, it does not do a full page load of the URL",function(){var h={};var i={selectedIssueKey:"TEST-1"};this.navigationController.navigate(i,h);sinon.assert.calledOnce(this.stateChangedHandler);sinon.assert.calledWith(this.stateChangedHandler,this.createStateWith(i),h)});test("When navigating and the REDIRECT_FROM_GLOBAL_TO_PROJECT DarkFeature is on, it does a full page load of the URL",function(){this.darkFeatureEnabledStub.returns(true);var h={};var i={selectedIssueKey:"TEST-1",isStandaloneIssue:function(){return true},toUrl:function(){return"browse/TEST-1"}};this.navigationController.navigate(i,h);sinon.assert.calledOnce(this.stateChangedHandler);sinon.assert.calledWith(this.stateChangedHandler,this.createStateWith(i),c.extend(h,{forceFullPageLoad:true}))});test("stateChanged event is fired only if state has changed or forceRefreshParameter was passed",function(){var h={jql:"test",selectedIssueKey:"test"};this.navigationController.navigate(h);ok(this.stateChangedHandler.calledOnce,"State Changed event got triggered");this.navigationController.navigate(h);ok(this.stateChangedHandler.calledOnce,"State Changed event wasn't triggered for the second time");this.navigationController.navigate(h,{forceRefresh:true});ok(this.stateChangedHandler.calledTwice,"State Changed event was triggered");ok(this.stateChangedHandler.calledWithExactly(this.createStateWith(h),{}),"State Changed event has proper parameters")});test("Navigate to URL transforms state to URL with respect of the override parameter",function(){var i={jql:"test",filter:0};var l="/jql=abce";var m={filter:1};var k={getStateFromUrl:this.sandbox.stub().returns(i)};var j=new a({model:k,isFullPageLoad:false});this.sandbox.spy(j,"navigate");j.navigateToUrl(l);ok(j.navigate.calledOnce,"State Changed event got triggered");ok(j.navigate.calledWith(i),"State Changed event contains proper arguments");var h={routerEvent:true};j.navigateToUrl(l,h,m);ok(j.navigate.calledTwice,"State Changed event got triggered");ok(j.navigate.calledWithExactly(c.defaults(m,i),h),"State Changed event contains proper arguments")});test("fullPageLoad parameter is only passed down for the first navigation",function(){var i=new this.NavigationControllerContructor();i.on("stateChanged",this.stateChangedHandler);var j={jql:"test"};var k={jql:"2"};var h={routerEvent:true};i.navigate(j,h);ok(this.stateChangedHandler.calledOnce,"State Changed event got triggered");ok(this.stateChangedHandler.calledWithExactly(this.createStateWith(j),c.extend(h,{fullPageLoad:true})),"fullPageLoad is passed");i.navigate(k,h);ok(this.stateChangedHandler.calledTwice,"State Changed event got triggered");ok(this.stateChangedHandler.calledWithExactly(this.createStateWith(k),h),"fullPageLoad isn't passed")});test("Dirty comment warning is respected when navigating",function(){var h={jql:"test"};this.navigationController.navigate(h);ok(this.stateChangedHandler.calledOnce,"State changed event is fired");ok(this.stateChangedHandler.calledWith(this.createStateWith(h)),"State changed event is fired");this.canDismissCommentStub.returns(false);this.navigationController.navigate({jql:"test2"});ok(this.stateChangedHandler.calledOnce,"State changed event isn't fired when user doesn't want to dismiss the comment")});test("Event triggering is queued",function(){var i=[{jql:"state1"},{jql:"state2"}];var h=function(){this.navigationController.navigate(i[0])}.bind(this);var j=sinon.spy();this.navigationController.on("stateChanged",h);this.navigationController.on("stateChanged",j);this.navigationController.navigate(i[1]);sinon.assert.calledTwice(j);deepEqual(j.firstCall.args[0],this.createStateWith(i[1]));deepEqual(j.secondCall.args[0],this.createStateWith(i[0]),"Second state changed has been triggered after all handlers for the first one finished")})});