AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:search-test"], function () {
    "use strict";

    var metrics = require('internal/browser-metrics');
    var SearchService = require("jira/issues/components/search");
    var MockSearchModule = require("jira/issues/test/mock-search-module");

    module("JIRA.Components.SearchService", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.searchModule = new MockSearchModule();
            this.searchResults = this.searchModule.getResults();
            this.searchService = new SearchService({
                searchModule: this.searchModule,
                searchResults: this.searchResults
            });
        },

        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("selectNextIssue should trigger browser-metrics start", function() {
        this.sandbox.stub(metrics, "start");
        this.searchResults.hasSelectedIssue.returns(true);

        this.searchService.selectNextIssue();

        ok(metrics.start.calledOnce, "browser-metrics API was called once");
        equal(metrics.start.lastCall.args[0].key, "jira.issue.view", "browser-metrics API call should be for jira.issue.view");
    });

    test("selectPreviousIssue should trigger browser-metrics start", function() {
        this.sandbox.stub(metrics, "start");
        this.searchResults.hasSelectedIssue.returns(true);

        this.searchService.selectPreviousIssue();

        ok(metrics.start.calledOnce, "browser-metrics API was called once");
        equal(metrics.start.lastCall.args[0].key, "jira.issue.view", "browser-metrics API call should be for jira.issue.view");
    });

    test("Going to another page should trigger a before:search", function() {
        var trigger = this.sandbox.spy(this.searchService, "trigger");

        this.searchService.goToPage(1);

        sinon.assert.calledOnce(trigger);
        sinon.assert.calledWith(trigger, "before:search");
    });
});
