define('jira/issues/components/issue-table/views/results-count', ['require'], function (require) {
    "use strict";

    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var Templates = require('jira/issues/templates/issue-nav');

    /**
     * @class JIRA.Components.IssueNavigator.Views.ResultsCount
     *
     * This view renders the count of results in a search (e.g "1-20 of 42")
     *
     * @extends JIRA.Marionette.ItemView
     *
     * @param {object} options Options
     * @param {number} options.total Number of issues in this search
     * @param {number} options.startIndex Index of first issue displayed in the table
     * @param {number} options.pageSize Size of each page
     */
    return ItemView.extend({
        template: Templates.resultsCount,

        serializeData: function() {
            var total = this.options.total;
            var start = this.options.startIndex + 1;
            var end = this.options.startIndex + this.options.pageSize;
            return {
                start: start,
                end: Math.min(end, total),
                total: total
            };
        },

        onRender: function() {
            this.unwrapTemplate();
        }
    });
});
