define('jira/issues/components/issue-table/views/refresh-results', ['require'], function (require) {
    "use strict";

    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var Templates = require('jira/issues/templates/issue-nav');

    /**
     * @class JIRA.Components.IssueNavigator.Views.RefreshResults
     *
     * This view renders a 'refresh' button.
     *
     * @extends JIRA.Marionette.ItemView
     */
    return ItemView.extend({
        template: Templates.refreshResults,
        triggers: {
            /**
             * @event refresh
             * When the user clicks the refresh button
             */
            "click": "refresh"
        },

        onRender: function() {
            this.unwrapTemplate();
        }
    });
});
