AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:issuetable-component-test"],function(){var c=require("jquery");var b=require("underscore");var a=require("jira/issues/components/issue-table/views/issue-table");module("jira/issues/components/issue-table/views/issue-table",{HTML:["<table id='issuetable'>","<thead>","<tr class='rowHeader'><th class='sortable' onclick='alert(1)' data-id='key'>Key</th></tr>","<tr class='rowHeader'><th class='sortable' onclick='alert(2)' data-id='summary'>Summary</th></tr>","</thead>","<tbody>","<tr id='issuerow10000' class='focused issuerow' rel='10000'><td>JRA-1</td>     <td>My issue</td></tr>","<tr id='issuerow10010' class='issuerow' rel='10010'>       <td>JRA-2</td><td>My other issue</td></tr>","</tbody>","</table>"].join(""),renderView:function(e){var d=new a(b.extend({el:c("<div/>").appendTo("#qunit-fixture"),resultsTable:this.HTML},e));d.render();return d}});test("Clicking a row throws the 'highlightIssue' event",function(){var e=this.spy();var d=this.renderView();d.on("highlightIssue",e);d.$("tr:last-child").click();sinon.assert.calledWithExactly(e,10010)});test("highlightIssue highlights the specified issue",function(){var d=this.renderView();d.highlightIssue(10010);ok(d.$("tr:last-child").hasClass("focused"),"The correct row is highlighted");equal(d.$("tr.focused").length,1,"Only one row is highlighted")});test("Clicking on a sortable column header triggers the 'sort' event with the column's data-id",function(){var e=this.spy();var d=this.renderView();d.on("sort",e);d.$(".sortable").eq(0).click();sinon.assert.calledOnce(e);sinon.assert.calledWith(e,"key")});test("Rendering the table triggers the before:render event",function(){var e=this.spy();var d=this.renderView();d.on("before:render",e);d.render();sinon.assert.calledOnce(e)});test("Rendering the table triggers the render event",function(){var e=this.spy();var d=this.renderView();d.on("render",e);d.render();sinon.assert.calledOnce(e)});test("Rendering the table removes the onclick property from the headers",function(){var d=this.renderView();equal(d.$("th")[0].onclick,null)});test("When rendering the table, it marks the sorted column as active",function(){var d=this.renderView({sortOptions:{fieldId:"key"}});ok(d.$("th[data-id=key]").hasClass("active"))});test("When rendering the table, it marks the sorted column as descending",function(){var d=this.renderView({sortOptions:{fieldId:"key",order:"DESC"}});ok(d.$("th[data-id=key]").hasClass("descending"))});test("When rendering the table, it marks the sorted column as ascending",function(){var d=this.renderView({sortOptions:{fieldId:"key",order:"ASC"}});ok(d.$("th[data-id=key]").hasClass("ascending"))});test("When rendering the table, it adds the colHeaderLink class to all non-sorted columns",function(){var d=this.renderView({sortOptions:{fieldId:"key",order:"ASC"}});ok(!d.$("th[data-id=key]").hasClass("colHeaderLink"));ok(d.$("th[data-id=summary]").hasClass("colHeaderLink"))});test("When rendering the table, it adds the draggable functionality to the table",function(){this.spy(c.fn,"dragtable");this.renderView();sinon.assert.calledOnce(c.fn.dragtable);ok(typeof c.fn.dragtable.firstCall.args[0]==="object")});test("When rendering the table, it removes the text nodes from the results table",function(){var d=this.renderView();ok(d.$("table, tbody, thead, tr").contents().filter(function(){return this.nodeType===Node.TEXT_NODE}).length===0,"Text nodes are gone")});test("When closing the table, it removes the dragtable functionality",function(){var d=this.renderView();this.spy(c.fn,"dragtable");d.close();sinon.assert.calledOnce(c.fn.dragtable);sinon.assert.calledWith(c.fn.dragtable,"destroy")});test("When reordering the columns, it throws a 'columnsChanged' event",function(){var f=this.spy();var e=this.sandbox.useFakeTimers();var d=this.renderView();d.on("columnsChanged",f);d.$("th[data-id=key]").simulate("delayed-drag",{delay:300});e.tick(350);sinon.assert.calledOnce(f)});test("When clicking in the columns, the user needs to click for more than 250 ms to start the drag behaviour",function(){var e=this.sandbox.useFakeTimers();var d=this.renderView();d.$("th[data-id=key]").simulate("mousedown");e.tick(200);equal(d.$(".dragtable-sortable").length,0,"The dragable helper is not rendered");e.tick(100);equal(d.$(".dragtable-sortable").length,1,"The dragable helper is rendered")});test("It marks an issue as inaccessible",function(){var d=this.renderView();d.markIssueAsInaccessible(10010);var e=d.$("tr[rel=10010]");ok(e.hasClass("inaccessible-issue"),"The row is inaccessible");equal(e.find("td").length,1,"Table cells collapsed into one cell")});test("It updates an issue with the new data",function(){var e=this.renderView();e.updateIssue(10010,["<table id='issuetable'>","<tbody>","<tr id='issuerow10000' class='focused issuerow' rel='10000'><td>JRA-1</td><td>MY ISSUE</td></tr>","<tr id='issuerow10010' class='issuerow' rel='10010'><td>JRA-2</td><td>MY OTHER ISSUE</td></tr>","</tbody>","</table>"].join(""));var d=e.$("tr[rel=10010]");equal(d.find("td").eq(1).text(),"MY OTHER ISSUE")});test("When an issue is updated, it throws the 'issueRowUpdated' event",function(){var d=this.renderView();var e=this.spy();d.on("issueRowUpdated",e);d.updateIssue(10010,["<table id='issuetable'>","<tbody>","<tr id='issuerow10000' class='focused issuerow' rel='10000'><td>JRA-1</td><td>MY ISSUE</td></tr>","<tr id='issuerow10010' class='issuerow' rel='10010'><td>JRA-2</td><td>MY OTHER ISSUE</td></tr>","</tbody>","</table>"].join(""));sinon.assert.calledOnce(e)});test("When an issue is updated, it highlights the issue",function(){var d=this.renderView();this.spy(d,"highlightIssue");d.updateIssue(10010,["<table id='issuetable'>","<tbody>","<tr id='issuerow10000' class='focused issuerow' rel='10000'><td>JRA-1</td><td>MY ISSUE</td></tr>","<tr id='issuerow10010' class='issuerow' rel='10010'><td>JRA-2</td><td>MY OTHER ISSUE</td></tr>","</tbody>","</table>"].join(""));sinon.assert.calledOnce(d.highlightIssue);sinon.assert.calledWithExactly(d.highlightIssue,10010)})});