AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:issuetable-component-test"], function () {
    "use strict";

    var EndOfStableMessage = require("jira/issues/components/issue-table/views/end-of-stable-message");

    var TestUtils = require("jira/issues/test/utils");

    module("jira/issues/components/issue-table/views/end-of-stable-message", {
        setup: function () {
            this.searchResults = TestUtils.mockSearchResults();
        }
    });

    test("render() displays message on last page", function () {
        var messageView = new EndOfStableMessage({
            startIndex: 1,
            pageSize: 10,
            total: 50,
            displayableTotal: 20
        });
        messageView.render();

        ok(messageView.$el.html() !== "", "Message is rendered");
    });

    test("render() does not display message on non-last page", function () {
        var messageView = new EndOfStableMessage({
            startIndex: 0,
            pageSize: 5,
            total: 20,
            displayableTotal: 20
        });
        messageView.render();

        equal(messageView.$el.html(), "", "Message is not rendered");
    });

    test("render() does not display message on last page when there are no more results", function () {
        var messageView = new EndOfStableMessage({
            startIndex: 0,
            pageSize: 10,
            total: 10,
            displayableTotal: 10
        });
        messageView.render();

        equal(messageView.$el.html(), "", "Message is not rendered");
    });
});
