define('jira/issues/components/issue-table/views/empty-results', ['require'], function (require) {
    "use strict";

    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var LoginUtils = require('jira/issues/utils/login');
    var Templates = require('jira/issues/templates/issue-nav-table');
    var UserParams = require('jira/issues/user-params');
    var wrmContextPath = require('wrm/context-path');

    /**
     * @class JIRA.Components.IssueTable.Views.EmptyResults
     *
     * Renders a message that tells the user there are no issues, with an optional link to create an issue
     *
     * @extends JIRA.Marionette.ItemView
     *
     * @param {object} options Options
     * @param {boolean} options.jiraHasIssues Whether there are issues created in this JIRA instance
     */
    return ItemView.extend({
        template: Templates.noResults,

        serializeData: function() {
            var message;
            var hint;
            var cssClass;
            var createIssuePerm = UserParams.get().createIssue;

            if (!LoginUtils.isLoggedIn()) {
                message = AJS.I18n.getText('issuenav.results.none.found');
                hint = AJS.I18n.getText('issuenav.results.none.hint.login');
                cssClass = "not-logged-in-message";
            } else if (this.options.jiraHasIssues === false) {
                message = AJS.I18n.getText('issuenav.results.none.created');
                hint = createIssuePerm ? AJS.I18n.getText('issuenav.results.none.hint.firsttocreate') : null;
                cssClass = "empty-results-message";
            } else {
                message = AJS.I18n.getText('issuenav.results.none.found');
                hint = createIssuePerm ?
                    AJS.I18n.getText('issuenav.results.none.hint.modifyorcreate') :
                    AJS.I18n.getText('issuenav.results.none.hint.modify');
                cssClass = "no-results-message";
            }

            return {
                message: message,
                hint: hint,
                cssClass: cssClass
            };
        },

        onRender: function() {
            this.$el.addClass("empty-results");

            var $links = this.$('.no-results-hint a');
            if (!LoginUtils.isLoggedIn()) {
                $links.attr('href', LoginUtils.redirectUrlToCurrent()).addClass('login-link');
            } else {
                $links.addClass('create-issue').attr('href', wrmContextPath() + "/secure/CreateIssue!default.jspa");
            }

            this.hidePending();
        },

        showPending: function() {
            this.$el.addClass('pending');
        },

        hidePending: function() {
            this.$el.removeClass("pending");
        }
    });
});
