define('jira/issues/components/filters/views/list/module', ['require'], function (require) {
    "use strict";

    var _ = require('underscore');
    var Templates = require('jira/issues/components/filters/templates/list');
    var Layout = require('jira/components/libs/marionette-1.4.1/layout');

    /**
     * @class JIRA.Components.Filters.Views.List.Module
     *
     * Displays the main module for the list of filters. This view only renders the placeholder
     * for the other views (List, Empty or Error),  and an optional title
     *
     * @extends JIRA.Marionette.Layout
     */
    return Layout.extend({
        template: Templates.Module,

        /**
         * Title to display in the message
         * @type {string}
         */
        title: "",

        regions: {
            content: ".filter-content"
        },

        /**
         * @param {Object} options Options
         * @param {string} [options.title] Title of the module. If not provided, the module will be rendered without title markup.
         */
        initialize: function(options) {
            options = _.defaults({}, options, {
                title: ""
            });
            this.title = options.title;
        },

        templateHelpers: function() {
            return {
                title: this.title
            };
        }
    });
});
