define('jira/issues/components/filters/views/list/message', ['require'], function (require) {
    "use strict";

    var Templates = require('jira/issues/components/filters/templates/list');
    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');

    /**
     * @class JIRA.Components.Filters.Views.List.Message
     *
     * Displays a message
     *
     * @extends JIRA.Marionette.ItemView
     */
    return ItemView.extend({
        template: Templates.Message,

        /**
         * Text to display in the message
         * @type {string}
         */
        text: "",

        /**
         * @param {Object} options Options
         * @param {string} options.text Text to display in the message.
         */
        initialize: function(options) {
            this.text = options.text;
        },

        onRender: function() {
            this.unwrapTemplate();
        },

        templateHelpers: function() {
            return {
                text: this.text,
                className: this.className
            };
        }
    });
});
