AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"], function () {
    "use strict";

    var Message = require("jira/issues/components/filters/views/list/message");

    module("jira/issues/components/filters/views/list/message", {
        createView: function (options) {
            return new Message({
                text: options.text,
                className: options.className
            });
        }
    });

    test("When rendering, it renders the text", function () {
        var view = this.createView({text: "This is my message"});

        view.render();

        equal(view.$el.text(), "This is my message");
    });

    test("When rendering, it uses the provided class name", function () {
        var view = this.createView({className: "my-message"});

        view.render();

        ok(view.$el.hasClass("my-message"));
    });

    test("When rendering, it unwraps the template", function () {
        var view = this.createView({className: "my-message"});

        view.render();

        ok(view.$el.is("p"));
    });
});
