define('jira/issues/components/filters/views/list/list-with-actions', ['require'], function (require) {
    "use strict";

    var _ = require('underscore');
    var FilterWithActions = require('jira/issues/components/filters/views/list/filter-with-actions');
    var List = require('jira/issues/components/filters/views/list/list');

    /**
     * @class JIRA.Components.Filters.Views.List.ListWithActions
     *
     * Displays a list of filters
     *
     * @extends JIRA.Components.Filters.Views.List.List
     */
    return List.extend({
        itemView: FilterWithActions,

        /**
         * Whether the items of the list should include the actions dropdown
         * @type {boolean}
         */
        useActions: false,

        /**
         * @param {Object} options Options
         * @param {boolean} [options.useActions=false] Whether the action's trigger should be displayed
         */
        initialize: function(options) {
            options = _.defaults({}, options, {
                useActions: false
            });

            this.useActions = options.useActions;
        }
    });
});
