define('jira/issues/components/filters/views/list/list', ['require'], function (require) {
    "use strict";

    var FilterView = require('jira/issues/components/filters/views/list/filter');
    var CompositeView = require('jira/components/libs/marionette-1.4.1/compositeview');
    var Templates = require("jira/issues/components/filters/templates/list");

    /**
     * Displays a list of filters
     *
     * @extends JIRA.Marionette.CompositeView
     */
    return CompositeView.extend({
        template: Templates.List,
        itemView: FilterView,

        itemViewContainer: ".filter-list",

        onRender: function() {
            this.unwrapTemplate();
        },

        templateHelpers: function() {
            return {
                className: this.className
            };
        },

        unhighlightAllFilters: function() {
            this.children.apply("unhighlight");
        },

        /**
         * Highlight a filter. If the model does not exist in the collection represented by this list,
         * this method does nothing.
         *
         * @param {JIRA.Components.Filters.Models.Filter} filterModel Model to highlight
         */
        highlightFilter: function(filterModel) {
            var itemView = this.children.findByModel(filterModel);
            if (itemView) {
                itemView.highlight();
            }
        }
    });
});
