define('jira/issues/components/filters/views/list/filter-with-actions', ['require'], function (require) {
    "use strict";

    var _ = require('underscore');
    var Filter = require('jira/issues/components/filters/views/list/filter');

    /**
     * @class JIRA.Components.Filters.Views.List.FilterWithActions
     *
     * Renders each individual item in the filter's list, including a dropdown for the filter Actions
     *
     * @extends JIRA.Components.Filters.Views.List.Filter
     */
    return Filter.extend({
        ui: _.extend({
            actionsTrigger: ".filter-actions"
        }, Filter.prototype.ui),

        triggers: _.extend({
            "click .filter-actions": "openActions"
        }, Filter.prototype.triggers),

        templateHelpers: {
            useActions: true
        },

        /**
         * Returns the trigger used to display the Actions dropdown
         *
         * @returns {jQuery}
         */
        getActionsTrigger: function() {
            return this.ui.actionsTrigger;
        }
    });
});
