define('jira/issues/components/filters/views/list/filter', ['require'], function (require) {
    "use strict";

    var Templates = require('jira/issues/components/filters/templates/list');
    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');

    /**
     * @class JIRA.Components.Filters.Views.List.Filter
     *
     * Renders each individual item in the filter's list.
     *
     * @extends JIRA.Marionette.ItemView
     */
    return ItemView.extend({
        template: Templates.Filter,

        ui: {
            filterLink: ".filter-link"
        },

        triggers: {
            "simpleClick .filter-link:not(.requires-login)": "selectFilter"
        },

        modelEvents: {
            "change": "render"
        },

        onRender: function() {
            this.unwrapTemplate();
        },

        highlight: function() {
            this.ui.filterLink.addClass("active");
            this.ui.filterLink.scrollIntoView();
        },

        unhighlight: function() {
            this.ui.filterLink.removeClass("active");
        }
    });
});
