/**
 * Class with common functions for save as and copy dialogs.
 */
define("jira/issues/components/filters/views/dialogs/save-template-test-common", ["require"], function (require) {
    "use strict";
    var TestUtils = require("jira/issues/components/testutils");
    var Filter = require("jira/issues/components/filters/entities/filter");
    var Utils = require('jira/issue/utils');
    var FeatureFlags;

    return {
        setup: function () {
            this.server = sinon.fakeServer.create();
            this.sandbox = sinon.sandbox.create();
            this.sandbox.spy(Utils, 'isEmptyOrWhitespace');
            this.context = AJS.test.mockableModuleContext();
            FeatureFlags = this.FeatureFlagsMocked = {
                IS_FILTERS_IMPR_ENABLED: false
            };
            this.context.mock('jira/issue/utils', Utils);
            this.context.mock('jira/components/issueviewer/services/featureflags', this.FeatureFlagsMocked);
            this.SaveAsConstructor = this.context.require('jira/issues/components/filters/views/dialogs/save-as');
            this.CopyConstructor = this.context.require('jira/issues/components/filters/views/dialogs/copy');
        },

        teardown: function () {
            this.server.restore();
            this.sandbox.restore();
        },
        renderDialog: function (dialog, scope) {
            dialog.render();
            TestUtils.moveDialogToQunitFixture(dialog);

            // Respond the defaultShareScope request
            _.last(this.server.requests).respond(200, {"Content-Type": "application/json"}, JSON.stringify({scope: scope || "PRIVATE"}));
        },

        submitDialog: function (dialog, options) {
            var dialogForm = dialog.dialog.$form;
            options = options || {};
            if (options.name) {
                dialogForm.find("#filterName").val(options.name);
            }
            if (options.changeToPrivate) {
                dialogForm.find("#setSharingPrivate").prop('checked', true);
            }
            dialogForm.submit();

            _.last(this.server.requests).respond(options.responseCode || 200);
        },
        getRenderedFlagsMockedDialog: function (dialog) {
            this.renderDialog(dialog);
            return dialog;
        },
        getSaveSubmitButton: function () {
            return this.getSavePopup("proj=TEST").find("input:submit")[0];
        },
        getCopySubmitButton: function () {
            return this.getCopyPopup("proj=TEST").find("input:submit")[0];
        },
        getSaveEmptyJqlWarning: function (jql) {
            return this.getSavePopup(jql).find("div.aui-message.aui-message-warning")[0];
        },
        getCopyEmptyJqlWarning: function (jql) {
            return this.getCopyPopup(jql).find("div.aui-message.aui-message-warning")[0];
        },
        getSavePopup: function (jql) {
            return this.getRenderedFlagsMockedDialog(new this.SaveAsConstructor({
                jql: jql
            })).dialog.$popup;
        },
        getCopyPopup: function (jql) {
            return this.getRenderedFlagsMockedDialog(new this.CopyConstructor({
                model: new Filter({
                    name: "test filter",
                    id: "1234",
                    jql: jql
                })
            })).dialog.$popup;
        },
        invokeSubmitButtonTests: function (getDialogButton) {
            // filters impr flag value | property to be checked | should warning be shown
            var specs = [
                [true, "value", "savefilter.save"],
                [false, "value", "AUI.form.submit.button.text"],
                [true, "class", "aui-button aui-button-primary"],
                [false, "class", "aui-button submit"]
            ];
            specs.forEach(function (item) {
                FeatureFlags.IS_FILTERS_IMPR_ENABLED = item[0];
                var attributeValue = item[1];
                var actual = getDialogButton().getAttribute(attributeValue);
                var expected = item[2];
                equal(actual, expected,
                    "Is filters impr enabled? " + item[0] +
                    ". Property of save button to be checked: \"" + attributeValue +
                    "\". Expected value: " + expected +
                    ". Actual result is: " + actual);
            });
        },
        invokeEmptyJqlWarningTests: function (getDialogWarning) {
            // filters impr flag value  | JQL string to be tested | should warning be shown
            var specs = [
                [true, "", true],
                [true, "test", false],
                [false, "", false],
                [false, "test", false]
            ];

            specs.forEach(function (item) {
                FeatureFlags.IS_FILTERS_IMPR_ENABLED = item[0];
                var jqlString = item[1];
                var actual = getDialogWarning(jqlString) !== undefined;
                var expected = item[2];
                equal(actual, expected, "Is filters impr enabled? " + item[0] +
                    ". JQL is: \"" + jqlString +
                    "\". Should warning be shown? " + expected +
                    ". Actual result is: " + actual);
            });
            ok(Utils.isEmptyOrWhitespace.called, "Proper method which checks if JQL is empty has been called.");
        }
    };
});
AJS.namespace("JIRA.Components.Filters.Views.Dialogs.SaveTemplateTestCommon", null, require("jira/issues/components/filters/views/dialogs/save-template-test-common"));
