define('jira/issues/components/filters/views/dialogs/rename', ['require'], function (require) {
    "use strict";

    var Templates = require('jira/issues/components/filters/templates/dialogs');
    var DialogView = require('jira/components/libs/marionette-1.4.1/dialogview');
    var Meta = require('jira/util/data/meta');

    /**
     * @class JIRA.Components.Filters.Views.Dialogs.Rename
     *
     * @extends JIRA.Marionette.DialogView
     */
    return DialogView.extend({
        template: Templates.Rename,

        id: "rename-filter-dialog",

        serializeData: function() {
            return {
                modifierKey: Meta.get("keyboard-accesskey-modifier"),
                filter: this.model.toJSON()
            };
        },

        /**
         * Generate the data to be sent in the form request
         *
         * @param {jQuery} form Form container
         * @returns {Object} Data to be sent in the request
         */
        formToRequestData: function(form) {
            return {
                name: form.find('[name=name]').val(),
                id: this.model.getId(),
                favourite: true
            };
        },

        onSubmitError: function() {
            this.dialog.$form.find("#filterName").focus();
        }
    });
});
