define("jira/issues/components/filters/views/dialogs/delete", ["require"], function(require) {
    "use strict";

    var DialogUtil = require('jira/dialog/dialog-util');
    var wrmContextPath = require('wrm/context-path');
    var DialogView = require('jira/components/libs/marionette-1.4.1/dialogview');
    var Meta = require('jira/util/data/meta');

    var contextPath = wrmContextPath();

    /**
     * @class JIRA.Components.Filters.Views.Dialogs.Delete
     *
     * @extends JIRA.Marionette.DialogView
     */
    return DialogView.extend({
        id: "delete-filter-dialog",

        serializeData: function () {
            var data = {
                modifierKey: Meta.get("keyboard-accesskey-modifier")
            };

            if (this.model) {
                data.filter = this.model.toJSON();
            } else {
                data.filter = {subscriptions: {items: []}};
            }

            return data;
        },

        dialogOptions: function() {
            return {
                content: null, //override default behaviour of issuenav DialogView, which generates content using soy template
                url: contextPath + "/secure/DeleteFilter!default.jspa?filterId=" + this.model.id,
                ajaxOptions: DialogUtil.getDefaultAjaxOptions,
                submitHandler: null, //fall back to FormDialog's original behaviour
                onUnSuccessfulSubmit: this._onSubmitError.bind(this),
                onSuccessfulSubmit: this._onSubmitSuccess.bind(this),
                onDialogFinished: function(){} //ensure that we do not do a page reload post form submission
            };
        }
    });
});
