AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"],function(){var b=require("underscore");var c=require("jira/util/data/meta");var a=require("jira/issues/components/filters/entities/filter");var d=require("jira/issues/components/filters/views/dialogs/copy");var e=require("jira/issues/components/filters/views/dialogs/save-template-test-common");module("jira/issues/components/filters/views/dialogs/copy",{setup:function(){e.setup()},teardown:function(){e.teardown()}});test("It should check if the default sharing for the user is GLOBAL",function(){var g=new d({model:new a({name:"test filter"})});e.renderDialog(g);var f=b.last(e.server.requests);ok(f.url.match("/rest/api/2/filter/defaultShareScope"),"Request to the right REST endpoint");equal(f.method,"GET","Request uses GET method")});test("It should display a switch-to-private checkbox If the default sharing for the user is GLOBAL",function(){var f=new d({model:new a({name:"test filter"})});e.renderDialog(f,"GLOBAL");ok(f.dialog.$form.find("#setSharingPrivate:checkbox"),"The form contains a checkbox for sharingPrivate");equal(f.dialog.$form.find("label[for=setSharingPrivate]").text(),"issuenav.filters.sharing.default.changetoprivate","The form contains a text about changing the default share scope to private")});test("It should not display a switch-to-private checkbox If the default sharing for the user is PRIVATE",function(){var f=new d({model:new a({name:"test filter"})});e.renderDialog(f,"PRIVATE");equal(f.dialog.$form.find("#setSharingPrivate:checkbox").length,0,"The form does not contain a checkbox for sharingPrivate")});test("It should pass the name when submitting the form",function(){var f=new d({model:new a({name:"test filter"})});e.renderDialog(f);e.submitDialog(f,{name:"This filter is a copy"});equal(JSON.parse(b.last(e.server.requests).requestBody).name,"This filter is a copy")});test("It should pass the original filter id when submitting the form",function(){var f=new d({model:new a({name:"test filter",id:"1234"})});e.renderDialog(f);e.submitDialog(f);equal(JSON.parse(b.last(e.server.requests).requestBody).id,"1234")});test("It should copy the filter as favourite when submitting the form",function(){var f=new d({model:new a({name:"test filter",id:"1234"})});e.renderDialog(f);e.submitDialog(f);equal(JSON.parse(b.last(e.server.requests).requestBody).favourite,true)});test("It should display the 'Copy' header when rendering the form",function(){var f=new d({model:new a({name:"test filter",id:"1234"})});e.renderDialog(f);equal(f.dialog.$popup.find("h2").text(),"issue.nav.filters.copyialog.title : test filter")});test("It should prefill the filters name with 'Copy of ...'",function(){this.stub(AJS,"format");var f=new d({model:new a({name:"test filter",id:"1234"})});e.renderDialog(f);sinon.assert.calledWith(AJS.format,"common.words.copyof","test filter")});test("It should display a message when copying a filter from another user",function(){this.stub(c,"get").withArgs("remote-user").returns("myUser");this.stub(AJS,"format");var f=new d({model:new a({name:"test filter",id:"1234",ownerUserName:"ownerUser",ownerDisplayName:"Mr. filter's owner"})});e.renderDialog(f);sinon.assert.calledWith(AJS.format,"issue.nav.filters.savedialog.desc.otherowner","Mr. filter's owner")});test("It should change user's default sharing to private when the switch-to-private checkbox is marked",function(){var g=new d({model:new a({name:"test filter",id:"1234"})});e.renderDialog(g,"GLOBAL");e.submitDialog(g,{changeToPrivate:true});var f=b.last(e.server.requests);deepEqual(JSON.parse(f.requestBody),{scope:"PRIVATE"},"Request payload is valid");ok(f.url.match("/rest/api/2/filter/defaultShareScope"),"Request to the right REST endpoint");equal(f.method,"PUT","Request uses PUT method")});test("It should focus the name field when there is an error submitting the form",function(){var f=new d({model:new a({name:"test filter",id:"1234"})});e.renderDialog(f);e.submitDialog(f,{responseCode:500});ok(document.activeElement===f.dialog.$popup.find("#filterName")[0])});test("Check all cases for changing the submit button values",function(){e.invokeSubmitButtonTests(function(){return e.getCopySubmitButton()})});test("Check all cases for showing/not showing empty JQL warning",function(){e.invokeEmptyJqlWarningTests(function(f){return e.getCopyEmptyJqlWarning(f)})})});