AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"],function(){var b=require("jquery");var a=require("jira/issues/components/filters/entities/filter");module("jira/issues/components/filters/views/header",{setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.FeatureFlagsMocked={IS_FILTERS_IMPR_ENABLED:false};this.LoginUtils=require("jira/issues/utils/login");this.context.mock("jira/components/issueviewer/services/featureflags",this.FeatureFlagsMocked);this.context.mock("jira/issues/utils/login",this.LoginUtils);this.HeaderConstructor=this.context.require("jira/issues/components/filters/views/header")},teardown:function(){this.sandbox.restore()},isDisabled:function(c){return c[0].className.indexOf("disabled")!==-1},checkWhatTipsyShows:function(d,e){var c=this.renderHeader().withMyOwnFilter().render();c.disableButton(c.ui.saveAsButton,d);c.dirtyTipsy.show();equal(c.dirtyTipsy.options.tipsy.title(),e)},renderHeader:function(){var e=new a({id:1,name:"My filter",ownerUserName:"some user"});var h;var g;var d=this.sandbox;var c=this.LoginUtils;var f=this.HeaderConstructor;return{withOthersFilter:function(){d.stub(c,"loggedInUserName").returns("myUser");e.set("ownerUserName","other user");return this},withMyOwnFilter:function(){d.stub(c,"loggedInUserName").returns("myUser");e.set("ownerUserName","myUser");return this},withFavouriteFilter:function(){d.stub(c,"loggedInUserName").returns("myUser");e.set("ownerUserName","other user");e.set("favourite",true);return this},withNoFavouriteFilter:function(){d.stub(c,"loggedInUserName").returns("myUser");e.set("ownerUserName","other user");e.set("favourite",false);return this},withSystemFilter:function(){e.set("isSystem",true);return this},withInvalidFilter:function(){e.set("isValid",false);return this},withEditedFilter:function(){g=true;return this},withDirtyFilter:function(){h=true;return this},withFilterName:function(i){e.set("name",i);return this},withLoggedInUser:function(){d.stub(c,"loggedInUserName").returns("logged in user");return this},withAnonymousUser:function(){d.stub(c,"loggedInUserName").returns(undefined);return this},withoutFilter:function(){e=null;return this},render:function(){var i=new f({el:b("#qunit-fixture")});i.render({model:e,isDirty:h,isEdited:g});return i}}}});test("It triggers the 'toogleFavourite' event when clicking on the star icon",function(){var d=this.spy();var c=this.renderHeader().withOthersFilter().render();c.on("toogleFavourite",d);c.ui.filterFavouriteButton.click();sinon.assert.calledOnce(d)});test("It triggers the 'saveAs' event when clicking on the 'Save As' button",function(){var d=this.spy();var c=this.renderHeader().withOthersFilter().render();c.on("saveAs",d);c.ui.saveAsButton.click();sinon.assert.calledOnce(d)});test("It triggers the 'save' event when clicking on the 'Save' button",function(){var d=this.spy();var c=this.renderHeader().withMyOwnFilter().withEditedFilter().render();c.on("save",d);c.ui.saveButton.click();sinon.assert.calledOnce(d)});test("It triggers the 'discard' event when clicking on the 'Discard changes' link",function(){var d=this.spy();var c=this.renderHeader().withMyOwnFilter().withEditedFilter().render();c.on("discard",d);c.ui.discardChangesButton.click();sinon.assert.calledOnce(d)});test("It triggers the 'details' event when clicking on the 'Details' link",function(){var d=this.spy();var c=this.renderHeader().withOthersFilter().render();c.on("details",d);c.ui.detailsTrigger.click();sinon.assert.calledOnce(d);sinon.assert.calledWith(d,c.ui.detailsTrigger)});test("It renders the 'Save' operation as main button when rendering dirty filter owned by the current user",function(){var c=this.renderHeader().withMyOwnFilter().withEditedFilter().render();equal(c.$el.find(".aui-button.save-changes").length,1)});test("It does not render the 'Save' operation when the filter is not dirty",function(){var c=this.renderHeader().withMyOwnFilter().render();ok(!c.ui.saveButton[0])});test("It does not render the 'Save' operation when the current user is not the owner of the filter",function(){var c=this.renderHeader().withOthersFilter().render();ok(!c.ui.saveButton[0])});test("It renders the 'Save As' as main operation when the user is logged in",function(){var c=this.renderHeader().withLoggedInUser().render();equal(c.$el.find(".aui-button.save-as-new-filter").length,1)});test("It renders the 'Save As' as secondary operation when the filter is dirty",function(){var c=this.renderHeader().withMyOwnFilter().withEditedFilter().render();equal(c.$el.find(".aui-button.save-as-new-filter").length,0)});test("It does not render the 'Save As' operation when the user is anonymous",function(){var c=this.renderHeader().withAnonymousUser().render();ok(!c.ui.saveAsButton[0])});test("It renders the 'Discard changes' operation when the filter is dirty",function(){var c=this.renderHeader().withEditedFilter().render();ok(c.ui.discardChangesButton[0])});test("It renders the 'Discard changes' operation when the filter is dirty and the user is anonymous",function(){var c=this.renderHeader().withAnonymousUser().withEditedFilter().render();equal(c.$el.find(".aui-button.discard-filter-changes").length,1)});test("It does not render the 'Discard changes' operation when the filter is not dirty",function(){var c=this.renderHeader().render();ok(!c.ui.discardChangesButton[0])});test("It renders the 'Details' if the filter is owned by the current user",function(){var c=this.renderHeader().withMyOwnFilter().render();ok(c.ui.detailsTrigger[0])});test("It renders the 'Details' if the filter is owned by the another user",function(){var c=this.renderHeader().withOthersFilter().render();ok(c.ui.detailsTrigger[0])});test("It renders the 'Details' if the filter is owned by the another user",function(){var c=this.renderHeader().withOthersFilter().render();ok(c.ui.detailsTrigger[0])});test("It does not render the 'Details' if the filter is from the system",function(){var c=this.renderHeader().withSystemFilter().render();ok(!c.ui.detailsTrigger[0])});test("It displays the favourite star if the filter is owned by the current user",function(){var c=this.renderHeader().withMyOwnFilter().render();ok(c.ui.filterFavouriteButton[0])});test("It displays the favourite star if the filter is owned by the another user",function(){var c=this.renderHeader().withMyOwnFilter().render();ok(c.ui.filterFavouriteButton[0])});test("It does not display the favourite star if the filter is from the system",function(){var c=this.renderHeader().withSystemFilter().render();ok(!c.ui.filterFavouriteButton[0])});test("It does not display the favourite star for anonymous users",function(){var c=this.renderHeader().withAnonymousUser().render();ok(!c.ui.filterFavouriteButton[0])});test("The favourite star is on if the filter is favourite",function(){var c=this.renderHeader().withFavouriteFilter().render();equal(c.$el.find(".fav-link.aui-iconfont-star").length,1)});test("The favourite star is off if the filter is not favourite",function(){var c=this.renderHeader().withNoFavouriteFilter().render();equal(c.$el.find(".fav-link.aui-iconfont-unstar").length,1)});test("It renders the 'Search' header with just the 'SaveAs' operation if there is no filter",function(){var c=this.renderHeader().withoutFilter().render();ok(c.$el.find(".search-title").text()==="search.search");ok(c.ui.saveAsButton[0],"Save As");ok(!c.ui.detailsTrigger[0],"Details");ok(!c.ui.discardChangesButton[0],"Discard changes");ok(!c.ui.saveButton[0],"Save");ok(!c.ui.filterFavouriteButton[0],"Favourite")});test("It renders the 'Search' header with no operations if the filter is not valid",function(){var c=this.renderHeader().withInvalidFilter().render();ok(c.$el.find(".search-title").text()==="search.search");ok(!c.ui.saveAsButton[0],"Save As");ok(!c.ui.detailsTrigger[0],"Details");ok(!c.ui.discardChangesButton[0],"Discard changes");ok(!c.ui.saveButton[0],"Save");ok(!c.ui.filterFavouriteButton[0],"Favourite")});test("It renders the filter's name in the header",function(){var c=this.renderHeader().withFilterName("This is my filter").render();ok(c.$el.find(".search-title").text()==="This is my filter")});test("It renders the 'Edited' label when the view with a dirty filter is updated",function(){var c=this.renderHeader().withMyOwnFilter().withEditedFilter().render();c.render({model:c.model,isEdited:true});equal(c.$el.find(".filter-edited-item").text(),"search.edited")});test("It disables the 'Save' button when the filter is marked as invalid",function(){var c=this.renderHeader().withMyOwnFilter().withEditedFilter().render();c.markAsInvalid(false);ok(this.isDisabled(c.ui.saveButton))});test("It does not render the 'Save As' dropdown option when the filter is marked as dirty",function(){var c=this.renderHeader().withMyOwnFilter().withDirtyFilter().render();equal(c.$el.find(".aui-dropdown2 .save-as-new-filter").length,0)});test("Check all cases for disabling/enabling 'Save As' button",function(){var c=[[true,false,true],[false,false,false],[true,true,true],[false,true,false]];var d=this;c.forEach(function(f){d.FeatureFlagsMocked.IS_FILTERS_IMPR_ENABLED=f[0];var e=d.renderHeader().withoutFilter().withEditedFilter().render();e.markAsInvalid(f[1]);var g=d.isDisabled(e.ui.saveAsButton);equal(f[2],g,"Is Filters impr flag enabled? "+f[0]+". Does JQL contains an error? "+f[1]+". Should the 'Save As' button be disabled? "+f[2]+". Is the 'Save As' button disabled? "+g)})});test("When button is disabled because of an error, tipsy shows message to correct the error first",function(){this.checkWhatTipsyShows(true,"search.cant.save.need.fix.error.first")});test("When button is disabled because search hasn't been performed, tipsy shows message to run the query first",function(){this.checkWhatTipsyShows(false,"search.cant.save.need.to.run.search.first")})});