define('jira/issues/components/filters/views/details', ['require'], function (require) {
    "use strict";

    var _ = require('underscore');
    var wrmContextPath = require('wrm/context-path');
    var Templates = require('jira/issues/components/filters/templates/details');
    var InlineDialogView = require('jira/components/libs/marionette-1.4.1/inlinedialogview');
    var LoginUtils = require('jira/issues/utils/login');
    var UserParams = require('jira/issues/user-params');

    var contextPath = wrmContextPath();

    /**
     * @class JIRA.Components.Filters.Controllers.Details
     *
     * @extends JIRA.Marionette.InlineDialogView
     */
    return InlineDialogView.extend({
        template: Templates.Main,
        id: "filter-details-overlay",

        dialogOptions: {
            addActiveClass: true,
            hideDelay: 36e5,
            offsetX: -36,
            width: 400
        },

        initialize: function(options) {
            this.trigger = options.triggerEl;
        },

        serializeData: function() {
            var currentFilter = this.model;
            var shares = _.sortBy(currentFilter.getSharePermissions(), function(share) {
                var criteria = [share.type];
                if (share.group) criteria.push(share.group.name);
                if (share.project) criteria.push(share.project.name);
                if (share.role) criteria.push(share.role.name);
                return criteria;
            });
            var subscriptions = _.clone(currentFilter.getSubscriptions());
            var canEdit = LoginUtils.loggedInUserName() === currentFilter.getOwnerUserName();

            subscriptions.additionalLength = currentFilter.getNumberOfAdditionalSubscriptions();

            var data = {
                filter: currentFilter.toJSON(),
                sharePermissions: shares,
                subscriptions: subscriptions,
                permissions: {
                    // The "Edit Permissions" link should be displayed whenever the user can actually change sharing permissions.
                    // This is possible even when they do not have "create shared objects" permission. @see JRADEV-14810
                    userHasEditSharingPermission: canEdit && (!!UserParams.createSharedObjects() || shares.length > 0),
                    userHasEditPermission: canEdit
                },
                userIsLoggedIn: LoginUtils.isLoggedIn(),
                returnUrl: window.location
            };

            if (currentFilter.getOwner()) {
                _.extend(data, {
                    owner: currentFilter.getOwner() || "",
                    ownerUserName: currentFilter.getOwnerUserName() || "",
                    avatarUrl: currentFilter.getAvatarUrl(),
                    ownerUrl: contextPath + '/secure/ViewProfile.jspa?name=' + encodeURIComponent(currentFilter.getOwnerUserName())
                });
            }

            return data;
        },

        onRender: function() {
            // Hack to work around JIRA's LayerManager.js closing this dialog.
            this.dialog.bind("click", function(event) {
                event.stopPropagation();
            });
        }
    });
});
