AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"], function () {
    "use strict";

    var jQuery = require("jquery");
    var LoginUtils = require("jira/issues/utils/login");
    var UserParams = require("jira/issues/user-params");
    var Filter = require("jira/issues/components/filters/entities/filter");
    var Details = require("jira/issues/components/filters/views/details");

    var stupidFakeSubscriptionsModel = {
        'items': [],
        'size': 0,
        'start-index': 0,
        'end-index': 0,
        'max-results': 1000
    };
    var model = new Filter({
        id: 1,
        name: "My filter",
        ownerUserName: "some user",
        subscriptions: stupidFakeSubscriptionsModel
    });

    module("jira/issues/components/filters/views/details", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(LoginUtils, "isLoggedIn");
            this.sandbox.stub(LoginUtils, "loggedInUserName");
            this.sandbox.stub(UserParams, "createSharedObjects");
            this.triggerEl = jQuery("<button type='button'></button>").appendTo("#qunit-fixture");
        },

        teardown: function() {
            if (this.detailsView) {
                this.detailsView.remove();
                this.detailsView = null;
            }
            this.sandbox.restore();
        },

        renderDetails: function(model) {
            this.sandbox.stub(model, "getNumberOfAdditionalSubscriptions").returns(0); // To avoid the model#getSubscriptions insanity. BRAAAAAAAAAAAAACE!!
            this.detailsView = new Details({
                model: model,
                triggerEl: this.triggerEl
            });

            this.detailsView.render();
        }
    });

    test("renders 'Edit permissions' when the user owns the filter and can edit shared objects", function() {
        LoginUtils.loggedInUserName.returns("some user");
        UserParams.createSharedObjects.returns(true);
        this.renderDetails(model);
        equal(this.detailsView.$(".edit-permissions").length, 1, "should be an edit permissions link");
    });

    test("does not render 'Edit permissions' when the user cannot edit shared objects", function() {
        LoginUtils.loggedInUserName.returns("some user");
        UserParams.createSharedObjects.returns(false);
        this.renderDetails(model);
        equal(this.detailsView.$(".edit-permissions").length, 0, "should not be an edit permissions link");
    });
});
