define('jira/issues/components/filters/entities/filters', ['require'], function (require) {
    "use strict";

    var _ = require('underscore');
    var Filter = require('jira/issues/components/filters/entities/filter');
    var Brace = require('jira/components/libs/brace');

    /**
     * @class JIRA.Components.Filters.Collections.Filters
     *
     * A collection of FilterModel objects.
     *
     * @extends Brace.Collection
     */
    return Brace.Collection.extend({

        model: Filter,

        fetch: function () {
            var promise = Brace.Collection.prototype.fetch.apply(this, arguments);

            promise.done(_.bind(function () {
                this.fetchState = "fetched";
                this.trigger("change:fetchState", this.fetchState);
            }, this));

            promise.fail(_.bind(function () {
                this.fetchState = "error";
                this.trigger("change:fetchState", this.fetchState);
            }, this));

            return promise;
        },

        initialize: function(models, options) {
            options = options || {};
            this.fetchState = options.fetchState;
        }
    });
});
