AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"],function(){var b=require("wrm/context-path");var a=require("jira/issues/utils/login");var c=require("jira/issues/components/filters/entities/filter");module("jira/issues/components/filters/entities/filter",{setup:function(){this.sandbox=sinon.sandbox.create();this.server=this.sandbox.useFakeServer()},teardown:function(){this.sandbox.restore()}});test("It uses the owner's display name as owner",function(){var d=new c({ownerDisplayName:"Mr Charlie Test"});equal(d.getOwner(),"Mr Charlie Test")});test("It uses the owner's user name as owner",function(){var d=new c({ownerUserName:"charlie_test"});equal(d.getOwner(),"charlie_test")});test("It uses the owner's display name as owner even if owner's user name is present",function(){var d=new c({ownerDisplayName:"Mr Charlie Test",ownerUserName:"charlie_test"});equal(d.getOwner(),"Mr Charlie Test")});test("System filters are not favourites",function(){var d=new c({isSystem:true});ok(!d.isFavouriteFilter())});test("Favourite filters are favourites",function(){var d=new c({favourite:true});ok(d.isFavouriteFilter())});test("The URL contains the filter ID and the expand for subscriptions",function(){var d=new c({id:1234});equal(d.url(),b()+"/rest/api/2/filter/1234?expand=subscriptions[-5:]&enableSharedUsers=false")});test("System filters does not belong to the current user",function(){var d=new c({isSystem:true});ok(!d.isMyFilter())});test("A filter belongs to the current user if the username matches",function(){this.stub(a,"loggedInUserName").returns("fred");var d=new c({ownerUserName:"fred"});ok(d.isMyFilter())});test("A filter does not belong to the current user if the username does not match",function(){this.stub(a,"loggedInUserName").returns("fred");var d=new c({ownerUserName:"charlie"});ok(!d.isMyFilter())});test("It extract the filter basic attributes from a server response",function(){var d=new c();var g={id:1,name:"name",description:"description",jql:"jql",isSystem:false,favourite:true,requiresLogin:true,sharePermissions:["some","value"],owner:{name:"anna",displayName:"Mrs. Anna",avatarUrls:{"48x48":"http://my/avatar.png"}}};var e={avatarUrl:"http://my/avatar.png",description:"description",favourite:true,id:1,isSystem:false,jql:"jql",name:"name",ownerDisplayName:"Mrs. Anna",ownerUserName:"anna",requiresLogin:true,subscriptions:undefined,sharePermissions:["some","value"]};var f=d.parse(g);deepEqual(f,e)});test("It extract the subscrition in reverse order from the server response",function(){var d=new c();var f={subscriptions:{items:["a","b","c"]}};var e=d.parse(f);deepEqual(e.subscriptions.items,["c","b","a"])});test("It computes the number of additional subscriptions",function(){var d=new c();d.set({subscriptions:{size:10,items:["a","b","c"]}},{parse:true});equal(d.getNumberOfAdditionalSubscriptions(),7)});test("It computes the number of additional subscriptions when the model has no subscriptions",function(){var d=new c({subscriptions:{items:{}}});equal(d.getNumberOfAdditionalSubscriptions(),0)});test("When converting the model to JSON, public filters require no login",function(){var d=new c({requiresLogin:false});ok(!d.toJSON().requiresLoginForUser)});test("When converting the model to JSON, private filters require no login for authenticated user",function(){this.stub(a,"isLoggedIn").returns(true);var d=new c({requiresLogin:true});ok(!d.toJSON().requiresLoginForUser)});test("When converting the model to JSON, private filters require login for anonymous user",function(){this.stub(a,"isLoggedIn").returns(false);var d=new c({requiresLogin:true});ok(d.toJSON().requiresLoginForUser)});test("Save favourite marks the model as favourite before getting the server response",function(){this.sandbox.useFakeServer();var d=new c({favourite:false});d.saveFavourite(true);ok(d.get("favourite"),true)});test("Saving a model as favourite sends a PUT request to the REST API",function(){var e=this.sandbox.useFakeServer();var d=new c({id:1234});d.saveFavourite(true);equal(e.requests[0].url,b()+"/rest/api/1.0/filters/1234/favourite");equal(e.requests[0].method,"PUT")});test("Saving a model as non-favourite sends a DELETE request to the REST API",function(){var e=this.sandbox.useFakeServer();var d=new c({id:1234});d.saveFavourite(false);equal(e.requests[0].url,b()+"/rest/api/1.0/filters/1234/favourite");equal(e.requests[0].method,"DELETE")});test("Saving a save a model as favourite cancels the previous request",function(){var e=this.sandbox.useFakeServer();var d=new c({id:1234});d.saveFavourite(false);d.saveFavourite(false);ok(e.requests[0].aborted)});test("When a favourite request is not successful, the filter favourite state",function(){var e=this.sandbox.useFakeServer();var d=new c({favourite:true});d.saveFavourite(false);e.requests[0].respond(500);ok(d.get("favourite"))});test("When a favourite request is successful, the filter is marked as favourite",function(){var e=this.sandbox.useFakeServer();var d=new c({favourite:true});d.saveFavourite(false);e.requests[0].respond(200,{},'<?xml version="1.0" encoding="UTF-8" standalone="yes"?><text-message>Success in setting favourite for : admin:1 (SearchRequest - 10200) - favourite state: false</text-message>');ok(!d.get("favourite"))});test("When a filter is saved with a new JQL, it sends a request to the REST API",function(){var f=this.sandbox.useFakeServer();var d=new c({id:1234,name:"My filter",favourite:false});d.saveFilter("project=X");var e={id:1234,name:"My filter",favourite:false,jql:"project=X"};equal(f.requests[0].url,d.url());equal(f.requests[0].method,"PUT");deepEqual(JSON.parse(f.requests[0].requestBody),e)});test("When a filter is saved with a new JQL, the attributes are updated with the server response",function(){var e=this.sandbox.useFakeServer();var d=new c({id:1234});d.saveFilter("project=X");e.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify({id:1234,jql:"project=X",name:"a"}));equal(d.id,1234,"The new id is saved in the model");equal(d.get("jql"),"project=X","The JQL is saved in the model");equal(d.get("name"),"a","The name is saved in the model")});test("When a filter is saved successfully, it throws a JIRA.trace",function(){this.stub(JIRA,"trace");var e=this.sandbox.useFakeServer();var d=new c({id:1234});d.saveFilter("project=X");e.requests[0].respond(200);sinon.assert.calledOnce(JIRA.trace);sinon.assert.calledWith(JIRA.trace,"jira.filter.saved")})});