define('jira/issues/components/filters/entities/favourite-filters', ['require'], function (require) {
    "use strict";

    var wrmContextPath = require('wrm/context-path');
    var Filters = require('jira/issues/components/filters/entities/filters');

    /**
     * @class JIRA.Components.Filters.Collections.FavouriteFilters
     *
     * @extends JIRA.Components.Filters.Collections.Filters
     */
    return Filters.extend({
        url: wrmContextPath() + "/rest/api/2/filter/favourite?expand=subscriptions[-5:]&enableSharedUsers=false",

        comparator: function(filter1, filter2) {
            return filter1.getName().toLowerCase().localeCompare(filter2.getName().toLowerCase());
        }
    });
});
