define("jira/issues/application", ["require"], function (require) {
    "use strict";

    var InlineEditParams = require('jira/components/util/inlineeditparams');

    var app = new JIRA.Marionette.Application();

    app.addInitializer(function () {
        this.module("JIRA.Components.Pager", JIRA.Components.Pager.AppModule);

        if (InlineEditParams.isEnabled()) {
            this.module("JIRA.Components.IssueEditor", new JIRA.Components.IssueEditor.AppModule().definition);
        } else {
            this.module("JIRA.Components.IssueEditor", new JIRA.Components.IssueEditor.NoInlineAppModule().definition);
        }

        this.module("JIRA.Components.Analytics", new JIRA.Components.Analytics.AppModule().definition);
        JIRA.Issues.AnalyticsLoader.init();

        var NavigationModule = require('jira/issues/modules/navigation/module');
        this.module("JIRA.Components.Navigation", new NavigationModule().definition);
    });

    return app;
});
AJS.namespace("JIRA.Issues.Application", null, require("jira/issues/application"));
