whenever sqlerror exit 1;
ALTER PROFILE DEFAULT LIMIT PASSWORD_LIFE_TIME UNLIMITED;
alter user SYSTEM IDENTIFIED BY oracle;

alter system set OPTIMIZER_MODE = FIRST_ROWS;
alter system set OPTIMIZER_DYNAMIC_SAMPLING = 11;

DECLARE
    v_count INTEGER := 0;
BEGIN
  SELECT COUNT (1) INTO v_count FROM dba_users WHERE username = UPPER ('jirauser2');
  IF v_count != 0
  THEN
      EXECUTE IMMEDIATE('DROP USER jirauser2 CASCADE');
  END IF;
  v_count := 0;
  SELECT COUNT (1) INTO v_count FROM dba_tablespaces WHERE tablespace_name = UPPER('jiradb2');
  IF v_count != 0
  THEN
      EXECUTE IMMEDIATE('DROP TABLESPACE jiradb2 INCLUDING CONTENTS AND DATAFILES');
  END IF;
  EXECUTE IMMEDIATE(q'{CREATE TABLESPACE jiradb2 DATAFILE '/tmp/jiradb2.dbf' SIZE 32m AUTOEXTEND ON NEXT 32m MAXSIZE 4096m EXTENT MANAGEMENT LOCAL}');
  EXECUTE IMMEDIATE('CREATE USER jirauser2 IDENTIFIED BY jirauser2 DEFAULT TABLESPACE jiradb2 QUOTA UNLIMITED ON jiradb2');
  EXECUTE IMMEDIATE('GRANT CONNECT, RESOURCE, IMP_FULL_DATABASE TO jirauser2');
  EXECUTE IMMEDIATE('GRANT READ, WRITE ON DIRECTORY DATA_PUMP_DIR TO jirauser2');
END;
/

EXIT;