"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue","com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks"],function(){var e,t=require("qunit/TestUtils"),s=require("jquery"),i=require("viewissue/summary/MockSummaryModel");module("JIRA.DevStatus.ReviewView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.restoreRequire=t.synchronizeAsyncRequiresWithContext(this.context),this.sandbox=sinon.sandbox.create(),this.server=sinon.fakeServer.create(),this.fixture=s("#qunit-fixture"),this.statusPanel=s("<div></div>").appendTo(this.fixture),e=t.spyAnalyticMethods("Reviews",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),e.ReviewsAnalytics.fireSummaryShownEvent=sinon.spy(),e.ReviewsAnalytics.fireSummaryClickedEvent=sinon.spy(),this.livestamp=s.fn.livestamp,s.fn.livestamp=sinon.spy()},teardown:function(){this.restoreRequire(),this.sandbox.restore(),this.server.restore(),t.cleanAllDialogs(),s.fn.livestamp=this.livestamp},createView:function(e,t){t="undefined"==typeof t||t;var s=new i;s.getOverall.returns(e);var n=this.context.require("viewissue/summary/review/ReviewView"),a=new n({model:s,el:this.statusPanel,analyticsModel:{getIssue:sinon.stub(),getSummary:sinon.stub().returns({unicorn:"awesome"})},dataAttrs:{issueKey:"TEST-1",issueId:1e3}});a.render(),t&&(ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"))},reviewData:function(e,t,s,i,n,a){return{count:e,state:t&&t.toUpperCase(),stateCount:s,dueDate:i||null,lastUpdated:n||null,overDue:a||!1}}}),test("render with no reviews",function(){this.createView({count:0},!1),ok(!this.statusPanel.html(),"content is empty"),ok(this.statusPanel.hasClass("hidden"),"panel is hidden")}),test("render with single review",function(){this.createView(this.reviewData(1,"Review",1,"2013-11-06T14:13:42.246+0100")),equal(this.statusPanel.find(".count").text(),"1","review count shown"),equal(this.statusPanel.find(".summary").text(),"1 review","review message shown"),equal(this.statusPanel.find(".aui-lozenge").text(),"Open","review state shown"),ok(this.statusPanel.find("time").length,"timestamp rendered"),ok(0==this.statusPanel.find(".sub-text").text().indexOf("Due"),"Due date shown"),ok(!this.statusPanel.find(".sub-text.overdue").length,"review is not rendered as overdue")}),test("render overdue review",function(){this.createView(this.reviewData(1,"Review",1,"2013-11-06T14:13:42.246+0100",null,!0)),ok(this.statusPanel.find(".sub-text.overdue").length,"review rendered as overdue")}),test("render with single review and no due date",function(){this.createView(this.reviewData(1,"Approval",1,null,"2013-11-06T14:13:42.246+0100")),equal(this.statusPanel.find(".count").text(),"1","review count shown"),equal(this.statusPanel.find(".summary").text(),"1 review","review message shown"),equal(this.statusPanel.find(".aui-lozenge").text(),"Approval","review state shown"),ok(this.statusPanel.find("time").length,"timestamp rendered"),ok(0==this.statusPanel.find(".sub-text").text().indexOf("Updated"),"last update date shown")}),test("render with single review no date",function(){this.createView(this.reviewData(1,"Summarize",1)),equal(this.statusPanel.find(".count").text(),"1","review count shown"),equal(this.statusPanel.find(".summary").text(),"1 review","review message shown"),equal(this.statusPanel.find(".aui-lozenge").text(),"Summarize","review state shown"),ok(!this.statusPanel.find("time").length,"timestamp not rendered")}),test("render with multiple reviews in different states",function(){this.createView(this.reviewData(3,"Closed",2,"2013-11-06T14:13:42.246+0100")),equal(this.statusPanel.find(".count").text(),"2","review count shown"),equal(this.statusPanel.find(".summary").text(),"2 reviews","review message shown"),equal(this.statusPanel.find(".aui-lozenge").text(),"Closed","review state shown"),ok(this.statusPanel.find("time").length,"timestamp rendered")}),test("render with multiple reviews in same state",function(){this.createView(this.reviewData(3,"Rejected",3,"2013-11-06T14:13:42.246+0100")),equal(this.statusPanel.find(".count").text(),"3","review count shown"),equal(this.statusPanel.find(".summary").text(),"3 reviews","review message shown"),equal(this.statusPanel.find(".aui-lozenge").text(),"Rejected","review state shown"),ok(this.statusPanel.find("time").length,"timestamp rendered")}),test("event is sent when the summary link is clicked",function(){this.createView(this.reviewData(10,"Summarize",1)),this.statusPanel.find(".summary").click(),equal(e.ReviewsAnalytics.fireSummaryClickedEvent.callCount,1),ok(e.ReviewsAnalytics.fireSummaryClickedEvent.getCall(0).calledWith({unicorn:"awesome"}))})});