"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue","com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks"],function(){var t,e=require("util/DateUtils"),s=require("underscore"),i=require("jquery"),n=require("qunit/TestUtils"),a=require("viewissue/summary/MockSummaryModel");module("JIRA.DevStatus.BuildView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create(),this.server=sinon.fakeServer.create(),this.fixture=i("#qunit-fixture"),this.statusPanel=i("<div></div>").appendTo(this.fixture),this.restoreRequire=n.synchronizeAsyncRequiresWithContext(this.context),t=n.spyAnalyticMethods("Builds",this.sandbox),this.context.mock("analytics/devstatus-analytics",t),this.livestamp=i.fn.livestamp,i.fn.livestamp=sinon.spy()},teardown:function(){this.restoreRequire(),this.sandbox.restore(),this.server.restore(),n.cleanAllDialogs(),i("body").css("overflow","initial"),i.fn.livestamp=this.livestamp},createView:function(t){var e=new a;e.getOverall.returns(t);var s={getIssue:sinon.stub(),getSummary:sinon.stub().returns({unicorn:"awesome"})},i=this.context.require("viewissue/summary/build/BuildView");this.view=new i({model:e,el:this.statusPanel,analyticsModel:s,dataAttrs:{issueKey:"TEST-1",issueId:1e3}})}}),test("not show panel",function(){this.createView({count:0}),this.view.render(),ok(!this.statusPanel.html(),"content is not rendered"),ok(this.statusPanel.hasClass("hidden"),"panel is hidden"),this.statusPanel.find(".summary-build").click(),ok(!s.isObject(this.view.detailDialogBuildView),"DetailDialogBuildView is not created when link doesn't exist")}),test("render and show panel",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:1,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0,successfulBuildCount:1,unknownBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),this.statusPanel.find(".summary").click(),ok(s.isObject(this.view.detailDialogBuildView),"DetailDialogBuildView is created when the link is clicked")}),test("render and show panel - one successful",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:1,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0,successfulBuildCount:1,unknownBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"1","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"1 build","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-approve"),"success icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - all successful",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0,successfulBuildCount:5,unknownBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"5","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"5 builds","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-approve"),"success icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - successful and failed",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:2,successfulBuildCount:3,unknownBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"2","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"2 builds failing","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-error"),"failure icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - successful and unknown",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0,successfulBuildCount:3,unknownBuildCount:2}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"3","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"3 builds","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-error"),"failure icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - successful, unknown, failed",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:6,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:1,successfulBuildCount:3,unknownBuildCount:2}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"1","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"1 build failing","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-error"),"failure icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - one failed",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:1,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:1,successfulBuildCount:0,unknownBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"1","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"1 build failing","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-error"),"failure icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - all failed",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:5,successfulBuildCount:0,unknownBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"5","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"5 builds failing","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-error"),"failure icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - failed and unknown",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:3,successfulBuildCount:0,unknownBuildCount:2}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"3","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"3 builds failing","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-error"),"failure icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - one unknown",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:1,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0,successfulBuildCount:0,unknownBuildCount:1}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"1","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"1 build incomplete","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-devtools-task-cancelled"),"unknown icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("render and show panel - all unknown",function(){e.setFormat("YYYY-MM-DD"),this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0,successfulBuildCount:0,unknownBuildCount:5}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),equal(this.statusPanel.find(".count").text(),"5","summary count is correct"),equal(this.statusPanel.find(".summary").text(),"5 builds incomplete","summary message is correct"),ok(this.statusPanel.has(".aui-iconfont-devtools-task-cancelled"),"unknown icon is shown"),equal(this.statusPanel.find("time.livestamp").attr("title"),"2010-01-01","timestamp is correct")}),test("event is sent when the summary link is clicked",function(){this.createView({count:5,lastUpdated:"2010-01-01T12:34:56.000+0100",failedBuildCount:0}),this.view.render(),ok(this.statusPanel.html(),"content is rendered"),ok(!this.statusPanel.hasClass("hidden"),"panel is not hidden"),this.statusPanel.find(".summary").click(),ok(s.isObject(this.view.detailDialogBuildView),"DetailDialogBuildView is created when the link is clicked"),equal(t.BuildsAnalytics.fireSummaryClickedEvent.callCount,1),ok(t.BuildsAnalytics.fireSummaryClickedEvent.getCall(0).calledWith({unicorn:"awesome"})),t.BuildsAnalytics.fireSummaryClickedEvent.reset()})});