"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e=require("jquery"),t=require("qunit/TestUtils");module("JIRA.DevStatus.SummaryTransitionView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create(),this.fixture=e("#qunit-fixture"),this.context.mock("util/DateUtils",{addTooltip:this.sandbox.stub()}),this.mockDefer=t.mockDefer()},createView:function(){this.panel=e("<div></div>").appendTo(this.fixture),this.model={getOverall:this.sandbox.stub(),getPreviousOverall:this.sandbox.stub()};var t=this.context.require("viewissue/summary/SummaryTransitionView");return this.view=new t({el:this.panel,model:this.model}),this.view._startSlideDownTransition=this.sandbox.stub(),this.view._startRollTransition=this.sandbox.stub(),this.view},sampleRollingContent:function(t){return e("<div class='rolling-container'><div class='rolling-content'><span>"+t+"</span></div></div>")},sampleSlideContent:function(t,n){var i=e("<div class='sliding-container'><span>"+t+"</span></div>");return i.height(n),i},teardown:function(){this.sandbox.restore(),this.mockDefer.restore()}}),test("Render slide down transition if old data doesnt exist",function(){var e=this.createView(),t=this.sampleRollingContent("new");e.renderVisible(t),ok(e._startSlideDownTransition.calledWith(this.panel,0),"The panel is set to start a slide down transition")}),test("Render rolling transition if old data exist",function(){var e=this.createView();this.panel.html(this.sampleRollingContent("old")),this.model.getPreviousOverall.returns({count:1});var t=this.sampleRollingContent("new");e.renderVisible(t),equal(this.panel.find(".old-content").text(),"old","Old content is appended to the container"),equal(this.panel.find(".rolling-content").children().eq(0).text(),"new","New content is positioned before the old content"),ok(e._startRollTransition.called,"The panel is set to start a rolling transition")}),test("Does not render rolling transition if data has not changed",function(){var e=this.createView();this.panel.html(this.sampleRollingContent("old")),this.model.getPreviousOverall.returns({count:1}),this.model.getOverall.returns({count:1});var t=this.sampleRollingContent("new");e.renderVisible(t),ok(!e._startRollTransition.called,"The panel is NOT set to start a rolling transition"),equal(this.panel.find(".old-content").length,0,"There is no old content"),equal(this.panel.find(".rolling-content").text(),"new","Contents are still being rendered")}),test("Old data is appended correctly to new containers",function(){var t=this.createView(),n=e("<div></div>");n.append(this.sampleRollingContent("1")),n.append(this.sampleRollingContent("2")),n.append(this.sampleRollingContent("3"));var i=e("<div></div>");i.append(this.sampleRollingContent("4")),i.append(this.sampleRollingContent("5")),i.append(this.sampleRollingContent("6")),t._prepareContentsForTransition(i,n),equal(i.find(".rolling-container").length,3,"There are 3 rolling containers");var l=i.find(".rolling-content");equal(l.length,3,"There are 3 rolling contents too"),equal(l.eq(0).text(),"41"),equal(l.eq(1).text(),"52"),equal(l.eq(2).text(),"63"),equal(i.find(".old-content").length,3,"There are 3 old contents as well")}),test("Height for sliding containers are correctly set to jQuery data",function(){var t=this.createView(),n=e("<div></div>");n.append(this.sampleSlideContent("1",11)),n.append(this.sampleSlideContent("2",22)),n.append(this.sampleSlideContent("3",33)),this.panel.html(n),this.model.getPreviousOverall.returns({count:1});var i=e("<div></div>");i.append(this.sampleSlideContent("4",4)),i.append(this.sampleSlideContent("5",5)),i.append(this.sampleSlideContent("6",6)),t.renderVisible(i);var l=this.panel.find(".sliding-container");equal(l.length,3,"There are 3 sliding containers"),equal(l.eq(0).data("prevHeight"),11),equal(l.eq(1).data("prevHeight"),22),equal(l.eq(2).data("prevHeight"),33),ok(3===t._startSlideDownTransition.callCount,"The inner container in the panel is set to start a slide down transition 3 times"),ok(11===t._startSlideDownTransition.getCall(0).args[1]),ok(22===t._startSlideDownTransition.getCall(1).args[1]),ok(33===t._startSlideDownTransition.getCall(2).args[1])}),test("Match up all available elements when 2 different renderings have different number of elements",function(){var t=this.createView(),n=e("<div></div>");n.append(this.sampleRollingContent("1")),n.append(this.sampleRollingContent("2")),n.append(this.sampleRollingContent("3"));var i=e("<div></div>");i.append(this.sampleRollingContent("4")),i.append(this.sampleRollingContent("5")),t._prepareContentsForTransition(i,n),equal(i.find(".rolling-container").length,2,"There are 2 rolling containers");var l=i.find(".rolling-content");equal(l.length,2,"There are 3 rolling contents too"),equal(l.eq(0).text(),"41"),equal(l.eq(1).text(),"52"),equal(i.find(".old-content").length,2,"There are 2 old contents as well")})});