"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:test-mocks","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var n=require("viewissue/summary/SummaryErrorView"),e=require("underscore"),s=require("jquery"),t=require("viewissue/summary/MockSummaryModel"),i="Learn about this issue or go to application links to fix it.";module("JIRA.DevStatus.SummaryErrorView",{setup:function(){this.sandbox=sinon.sandbox.create(),this.fixture=s("#qunit-fixture"),this.createPanel()},teardown:function(){this.sandbox.restore()},createPanel:function(){this.panel=s('<div class="message-panel hidden">').appendTo(this.fixture)},createMockModel:function(n){n=n||{};var s=n.errorInstances||[],i=n.configInstances||[],a=e.isUndefined(n.hasErrors)?!(e.isEmpty(s)&&e.isEmpty(i)):n.hasErrors,r=new t;return r.get.withArgs("hasErrors").returns(a),r.get.withArgs("errorInstances").returns(s),r.get.withArgs("configInstances").returns(i),r},createInstances:function(n){return e.map(e.range(1,n+1),function(n){return{name:"inst_"+n,baseUrl:"#"+n}})},assertGenericMsg:function(n){var e=this.panel.html().indexOf("JIRA is having difficulty contacting the applications that supply development status information");ok(n?e>=0:e<0,"generic error msg is "+(n?"":"not ")+"shown")},assertAndGetGenericMsgIndex:function(){var n="JIRA is having difficulty contacting ",e=this.panel.html().indexOf(n);return ok(e>=0,"instance error msg is shown"),e+n.length+1},assertOccur:function(n,e,s,t){ok(n.indexOf(e,s)>=0,t)},assertOccurBefore:function(n,e,s,t,i){var a=n.indexOf(e,t),r=n.indexOf(s,t);ok(a>=0&&a<r,i)},assertOccurAfter:function(n,e,s,t,i){var a=n.indexOf(s,t),r=n.indexOf(e,a);ok(r>=0&&a>=0,i)},assertOccurBetween:function(n,e,s,t,i,a){var r=n.indexOf(s,i),o=n.indexOf(e,r+s.length),c=n.indexOf(t,r+s.length);ok(r>=0&&o>=0&&c>=0&&o>r&&o<c,a)},assertNotOccurBetween:function(n,e,s,t,i,a){var r=n.indexOf(s,i),o=n.indexOf(e,r+s.length),c=n.indexOf(t,r+s.length);ok(o<0||o>=0&&r>=0&&c>=0&&(o<r||o>c),a)},getConfigErrors:function(){var n=this.panel.find(".config-errors:visible");return{description:n.find(".description"),hints:n.find(".hints"),findLink:function(e){return n.find(AJS.format("span[data-name={0}] a",e))}}}}),test("don't show panel when no errors",function(){var e=this.createMockModel(),s=new n({model:e,el:this.panel});s.render(),ok(this.panel.hasClass("hidden"),"panel is hidden"),ok(!this.panel.html(),"content is not rendered")}),test("show panel when errors without instances",function(){var e=this.createMockModel({hasErrors:!0}),s=new n({model:e,el:this.panel});s.render(),ok(!this.panel.hasClass("hidden"),"panel is not hidden"),ok(this.panel.html(),"content is rendered"),this.assertGenericMsg(!0)}),test("show panel when errors with 1 instance",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"}]}),s=new n({model:e,el:this.panel});s.render(),ok(!this.panel.hasClass("hidden"),"panel is not hidden"),ok(this.panel.html(),"content is rendered"),this.assertGenericMsg(!1);var t=this.assertAndGetGenericMsgIndex(),i=this.panel.html();this.assertOccur(i,"instance 1",t,"instance 1 is shown")}),test("show panel when errors with 2 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"}]}),s=new n({model:e,el:this.panel});s.render(),ok(!this.panel.hasClass("hidden"),"panel is not hidden"),ok(this.panel.html(),"content is rendered"),this.assertGenericMsg(!1);var t=this.assertAndGetGenericMsgIndex(),i=this.panel.html();this.assertOccurBefore(i,"instance 1","instance 2",t,"instance 1 is shown before instance 2"),this.assertOccurBetween(i,"> and ","instance 1","instance 2",t,"'1 and 2' is shown"),this.assertNotOccurBetween(i,">, and ","instance 1","instance 2",t,"'1, and 2' is not shown"),this.assertOccurAfter(i,"instance 2","instance 1",t,"instance 2 is shown")}),test("show panel when errors with 3 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"},{name:"instance 3",baseUrl:"#"}]}),s=new n({model:e,el:this.panel});s.render(),ok(!this.panel.hasClass("hidden"),"panel is not hidden"),ok(this.panel.html(),"content is rendered"),this.assertGenericMsg(!1);var t=this.assertAndGetGenericMsgIndex(),i=this.panel.html();this.assertOccurBefore(i,"instance 1","instance 2",t,"instance 1 is shown before instance 2"),this.assertOccurBetween(i,">, ","instance 1","instance 2",t,"'1, 2' is shown"),this.assertNotOccurBetween(i,"> and ","instance 1","instance 2",t,"'1 and 2' is not shown"),this.assertNotOccurBetween(i,">, and ","instance 1","instance 2",t,"'1, and 2' is not shown"),this.assertOccurBetween(i,"instance 2","instance 1","instance 3",t,"instance 2 is shown"),this.assertOccurBetween(i,">, and ","instance 2","instance 3",t,"'2, and 3' is shown"),this.assertNotOccurBetween(i,"> and ","instance 1","instance 2",t,"'2 and 3' is not shown"),this.assertOccurAfter(i,"instance 3","instance 2",t,"instance 3 is shown")}),test("show panel when errors with 4 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"},{name:"instance 3",baseUrl:"#"},{name:"instance 4",baseUrl:"#"}]}),s=new n({model:e,el:this.panel});s.render(),ok(!this.panel.hasClass("hidden"),"panel is not hidden"),ok(this.panel.html(),"content is rendered"),this.assertGenericMsg(!1);var t=this.assertAndGetGenericMsgIndex(),i=this.panel.html();this.assertOccurBefore(i,"instance 1","instance 2",t,"instance 1 is shown before instance 2"),this.assertOccurBetween(i,">, ","instance 1","instance 2",t,"'1, 2' is shown"),this.assertNotOccurBetween(i,"> and ","instance 1","instance 2",t,"'1 and 2' is not shown"),this.assertNotOccurBetween(i,">, and ","instance 1","instance 2",t,"'1, and 2' is not shown"),this.assertOccurBetween(i,"instance 2","instance 1","instance 3",t,"instance 2 is shown"),this.assertOccurBetween(i,">, ","instance 2","instance 3",t,"'2, 3' is shown"),this.assertNotOccurBetween(i,"> and ","instance 1","instance 2",t,"'2 and 3' is not shown"),this.assertNotOccurBetween(i,">, and ","instance 1","instance 2",t,"'2, and 3' is not shown"),this.assertOccurBetween(i,"instance 3","instance 2","another application",t,"instance 3 is shown"),this.assertOccurAfter(i,"and another application","instance 3",t,"'and another instance' is shown")}),test("show panel when errors with 5 instances",function(){var e=this.createMockModel({errorInstances:[{name:"instance 1",baseUrl:"#"},{name:"instance 2",baseUrl:"#"},{name:"instance 3",baseUrl:"#"},{name:"instance 4",baseUrl:"#"},{name:"instance 5",baseUrl:"#"}]}),s=new n({model:e,el:this.panel});s.render(),ok(!this.panel.hasClass("hidden"),"panel is not hidden"),ok(this.panel.html(),"content is rendered"),this.assertGenericMsg(!1);var t=this.assertAndGetGenericMsgIndex(),i=this.panel.html();this.assertOccurBefore(i,"instance 1","instance 2",t,"instance 1 is shown before instance 2"),this.assertOccurBetween(i,">, ","instance 1","instance 2",t,"'1, 2' is shown"),this.assertNotOccurBetween(i,"> and ","instance 1","instance 2",t,"'1 and 2' is not shown"),this.assertNotOccurBetween(i,">, and ","instance 1","instance 2",t,"'1, and 2' is not shown"),this.assertOccurBetween(i,"instance 2","instance 1","instance 3",t,"instance 2 is shown"),this.assertOccurBetween(i,">, ","instance 2","instance 3",t,"'2, 3' is shown"),this.assertNotOccurBetween(i,"> and ","instance 1","instance 2",t,"'2 and 3' is not shown"),this.assertNotOccurBetween(i,">, and ","instance 1","instance 2",t,"'2, and 3' is not shown"),this.assertOccurBetween(i,"instance 3","instance 2"," and 2 more applications",t,"instance 3 is shown"),this.assertOccurAfter(i,"and 2 more applications","instance 3",t,"'and 2 more applications' is shown")}),test("show configuration error for 1 instance",function(){var e=(new n({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(1)})}).render(),this.getConfigErrors());equal(e.description.text(),"Couldn't read data from inst_1.","config error shown for inst_1"),equal(e.hints.text(),i,"config hints shown")}),test("show configuration error for 2 instances",function(){var e=(new n({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(2)})}).render(),this.getConfigErrors());equal(e.description.text(),"Couldn't read data from inst_1 and inst_2.","config error shown for inst_1+inst_2"),equal(e.hints.text(),i,"config hints shown")}),test("show configuration error for 3 instances",function(){var e=(new n({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(3)})}).render(),this.getConfigErrors());equal(e.description.text(),"Couldn't read data from inst_1, inst_2, and inst_3.","config error shown for inst_1+inst_2+inst_3"),equal(e.hints.text(),i,"config hints shown")}),test("show configuration error for 4 instances",function(){var e=(new n({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(4)})}).render(),this.getConfigErrors());equal(e.description.text(),"Couldn't read data from inst_1, inst_2, inst_3, and 1 other application.","config error shown for inst_1+inst_2+inst_3+1 more"),equal(e.hints.text(),i,"config hints shown")}),test("show configuration error for 5 instances",function(){var e=(new n({el:this.panel,model:this.createMockModel({configInstances:this.createInstances(5)})}).render(),this.getConfigErrors());equal(e.description.text(),"Couldn't read data from inst_1, inst_2, inst_3, and 2 other applications.","config error shown for inst_1+inst_2+inst_3+2 more"),equal(e.hints.text(),i,"config hints shown")}),test("configuration error links are correct",function(){var s=this.createInstances(4),t=(new n({el:this.panel,model:this.createMockModel({configInstances:s})}).render(),this.getConfigErrors()),i=s.slice(0,3);e.each(i,function(n){var e=n.name,s=n.baseUrl,i=t.findLink(e);deepEqual({href:i.attr("href"),text:i.text()},{href:s,text:e},AJS.format("{0} links to {1}",n.name,s))})}),test("show both connection and configuration errors",function(){new n({el:this.panel,model:this.createMockModel({errorInstances:[{name:"inst_1",baseUrl:"#1"}],configInstances:[{name:"inst_2",baseUrl:"#2"}]})}).render();equal(this.getConfigErrors().description.text(),"Couldn't read data from inst_2.","config error is shown"),this.assertOccur(this.panel.text(),"JIRA is having difficulty contacting inst_1","connection error is also shown")})});