"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource","com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e,t=require("util/DateUtils"),n=require("qunit/TestUtils"),s=require("viewissue/dialog/deployment/DetailDialogDeploymentView"),a=require("underscore"),i=require("jquery");module("JIRA.DevStatus.DetailDialogDeploymentView",{setup:function(){this.sandbox=sinon.sandbox.create(),this.issueKey="DEV-1",this.issueId=1e4,this.server=sinon.fakeServer.create(),this.context=AJS.test.mockableModuleContext(),e=n.spyAnalyticMethods("Deployments",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),this.livestamp=i.fn.livestamp,i.fn.livestamp=sinon.spy()},teardown:function(){this.sandbox.restore(),this.server.restore(),n.cleanAllDialogs(),i.fn.livestamp=this.livestamp},getDetailDialog:function(){var e=i(".jira-dialog");return{heading:e.find(".devstatus-dialog-heading"),content:e.find(".devstatus-dialog-content")}},createView:function(e,t){return new s({count:e,dataType:"deployment",issueKey:this.issueKey,tabs:{bamboo:{name:"Bamboo",count:t}}})},assertNoNoPermissionMessage:function(){ok(0===this.getDetailDialog().content.find(".no-permission-to-view-all").length,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(0===this.getDetailDialog().content.find(".aui-message-warning:has(.connection-error)").length,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage(),this.assertNoConnectionErrorWarning()}}),test("Test lock screen renders if no data would be displayed",function(){var e="fecru",t={detail:[{deploymentProjects:[]}]},n=this.createView(7,7),s=i("#qunit-fixture");s.html('<div id="tab-content-'+e+'"><div class="detail-content-container"></div></div>'),n.$el=s,n.renderSuccess=this.sandbox.spy(),n._handleFetchSucceeded(e,t),ok(n.renderSuccess.neverCalledWith(e,t.detail));var a=n.getContentContainer(e),o=a.find(".no-permission-to-view-all");ok(o.find(".lock-image").length>0,"has lock image"),equal(o.text(),"You don't have access to view all related deployments. Please contact your administrator.")}),test("Test sorting of projects and environments",function(){var e=this.createView(7,7);deepEqual(e.sortProjects([{name:"z",environments:[{name:"a",lastDeployed:"2013-10-22T12:00:00.000+0100"},{name:"c"},{name:"b",lastDeployed:"2013-10-22T12:02:00.000+0100"}]},{name:"a",environments:[{name:"a",lastDeployed:"2013-10-22T12:00:00.000+0100"}]},{name:"M",environments:[{name:"a",lastDeployed:"2013-10-22T12:01:00.000+0100"},{name:"b",lastDeployed:"2013-10-22T12:03:00.000+0100"},{name:"c",lastDeployed:"2013-10-22T12:02:00.000+0100"}]}]),[{name:"M",environments:[{name:"a",lastDeployed:"2013-10-22T12:01:00.000+0100"},{name:"b",lastDeployed:"2013-10-22T12:03:00.000+0100"},{name:"c",lastDeployed:"2013-10-22T12:02:00.000+0100"}]},{name:"z",environments:[{name:"a",lastDeployed:"2013-10-22T12:00:00.000+0100"},{name:"c"},{name:"b",lastDeployed:"2013-10-22T12:02:00.000+0100"}]},{name:"a",environments:[{name:"a",lastDeployed:"2013-10-22T12:00:00.000+0100"}]}])}),test("Test environment count",function(){var e=this.createView();equal(e.getEnvironmentCount([]),0,"no projects"),equal(e.getEnvironmentCount([{name:"a",environments:[{environmentId:1}]}]),1,"single project, single environment"),equal(e.getEnvironmentCount([{name:"z",environments:[{environmentId:1},{environmentId:2},{environmentId:3}]}]),3,"single project, multiple environments"),equal(e.getEnvironmentCount([{name:"a",environments:[{environmentId:0}]},{name:"z",environments:[{environmentId:1},{environmentId:2},{environmentId:3}]}]),4,"multiple projects, multiple builds")}),test("Test dialog title for single deployment environment",function(){var e=this.createView(1,1);e.show();var t=this.getDetailDialog();equal(t.heading.text(),"DEV-1: 1 deployment")}),test("Test dialog title for multiple deployment environment",function(){var e=this.createView(2,1);e.show();var t=this.getDetailDialog();equal(t.heading.text(),"DEV-1: 2 deployments")}),test("Test deployment detail dialog with success request",function(){expect(137),t.setFormat("YYYY-MM-DD");var n=this.createView(5);n.show();var s=this.getDetailDialog(),o=s.content.find(".status-loading"),l=s.content.find(".tabs-pane.active-pane"),r=[{name:"Deployment Two",latestVersionName:"1.1",environments:[{name:"Integration",status:"Deployed",latestRelease:"1.1-feature",lastDeployed:"2013-11-19"},{name:"Production",status:"Not deployed",latestRelease:"1.1",lastDeployed:"2013-11-15"},{name:"Environment with deleted release",status:"Not deployed",latestRelease:"1.2",lastDeployed:"2013-11-15",versionDeleted:!0}]},{name:"Deployment Two",latestVersionName:"1.1",environments:[{name:"Dogfooding",status:"Deployed",latestRelease:"1.1-feature",lastDeployed:"2013-11-19"},{name:"Integration",status:"Not deployed",latestRelease:"1.2",lastDeployed:"2013-11-17"},{name:"Production",status:"Not deployed",latestRelease:"1.1",lastDeployed:"2013-11-15"}]},{name:"Deployment One",latestVersionName:"release-5",environments:[{name:"Dogfooding",status:"Failed",latestRelease:"release-5",lastDeployed:"2013-11-19"},{name:"Integration",status:"Not deployed",latestRelease:"release-3",lastDeployed:"2013-11-17"},{name:"Production",status:"Not deployed",latestRelease:"release-3",lastDeployed:"2013-11-15"}]},{name:"Deployment One",latestVersionName:"release-5",environments:[{name:"Integration",status:"Not deployed",latestRelease:"release-3",lastDeployed:"2013-11-17"},{name:"Production",status:"Not deployed",latestRelease:"release-3",lastDeployed:"2013-11-15"}]}];ok("block"==o.css("display"),"A spinner is visible when there is an onflight ajax request"),ok(o.children().length>0),ok(l.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request"),AJS.TestContractManager.respondToRequest("detail3LO-bamboo",this.server.requests[0]),AJS.TestContractManager.respondToRequest("bambooDetailDeployment-multiple",this.server.requests[1]),this.assertNoErrorMessagesInCanvas();var d=s.content.find(".detail-deployments-container");ok("none"==o.css("display"),"A spinner is no longer visible when the onflight ajax request has completed"),ok(!l.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed"),equal(d.length,r.length,"Number of project tables rendered into the dialog is correct"),a.each(d,a.bind(function(t,n){var s=i(t),o="Project["+n+"]: ",l=s.find(".project-link");equal(l.text(),r[n].name,o+"the project name exist and is correct"),strictEqual(l.attr("target"),void 0,o+"clicking on project link opens in the same tab"),l.click(),ok(e.DeploymentsAnalytics.fireDetailProjectClicked.called,o+"analytic event is fired correctly when clicking on project link"),e.DeploymentsAnalytics.fireDetailProjectClicked.reset();var d=s.find(".commit-info");equal(d.text(),"Commits were in release "+r[n].latestVersionName,o+"commits-from information exist and is correct");var c=s.find(".deployments-table tr.environment-row");equal(c.length,r[n].environments.length,o+"list of environments exist and contains the correct number of rows"),a.each(c,a.bind(function(t,s){var a=i(t),o="Project["+n+"], environment["+s+"]: ",l=r[n].environments[s],d=a.find(".environment"),c=d.find(".environment-link");equal(c.text(),l.name,o+"the environment name exist and is correct"),strictEqual(c.attr("target"),void 0,o+"clicking on environment link opens in the same tab"),c.click(),ok(e.DeploymentsAnalytics.fireDetailEnvironmentClicked.called,o+"analytic event is fired correctly when clicking on environment link"),e.DeploymentsAnalytics.fireDetailEnvironmentClicked.reset();var m=a.find(".status .aui-lozenge");equal(m.text(),l.status,o+"the environment status exist and is correct"),"Deployed"===l.status?ok(m.hasClass("aui-lozenge-success"),"environment status lozenge is green"):ok(!m.hasClass("aui-lozenge-success"),"environment status lozenge is not green");var u=a.find(".release");if(l.versionDeleted){equal(u.text(),l.latestRelease,o+"the release name exist and is correct");var p=u.find(".release-link");ok(0==p.length,o+"release link is not present")}else{var p=u.find(".release-link");equal(p.text(),l.latestRelease,o+"the release name exist and is correct"),strictEqual(p.attr("target"),void 0,o+"clicking on release link opens in the same tab"),p.click(),ok(e.DeploymentsAnalytics.fireDetailReleaseClicked.called,o+"analytic event is fired correctly when clicking on release link"),e.DeploymentsAnalytics.fireDetailReleaseClicked.reset()}var v=a.find(".timestamp .livestamp");ok(0!=v.length,o+"time stamp is rendered into the table"),equal(v.attr("title"),l.lastDeployed,o+"tooltip is correctly appended onto the timestamp element")},this))},this))})});