"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource","com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e,t=require("util/DateUtils"),i=require("qunit/TestUtils"),a=require("viewissue/dialog/build/DetailDialogBuildView"),s=require("underscore"),n=require("jquery");module("JIRA.DevStatus.DetailDialogBuildView",{setup:function(){this.sandbox=sinon.sandbox.create(),this.issueKey="DEV-1",this.issueId=1e4,this.server=sinon.fakeServer.create(),this.context=AJS.test.mockableModuleContext(),e=i.spyAnalyticMethods("Builds",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),this.livestamp=n.fn.livestamp,n.fn.livestamp=sinon.spy()},teardown:function(){this.sandbox.restore(),this.server.restore(),i.cleanAllDialogs(),n.fn.livestamp=this.livestamp},getDetailDialog:function(){var e=n(".jira-dialog");return{heading:e.find(".devstatus-dialog-heading"),content:e.find(".devstatus-dialog-content")}},createView:function(e,t){return new a({count:e,dataType:"build",issueKey:this.issueKey,tabs:{bamboo:{name:"Bamboo",count:t}}})},assertNoNoPermissionMessage:function(){ok(0===this.getDetailDialog().content.find(".no-permission-to-view-all").length,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(0===this.getDetailDialog().content.find(".aui-message-warning:has(.connection-error)").length,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage(),this.assertNoConnectionErrorWarning()}}),test("Test lock screen renders if no data would be displayed",function(){var e="fecru",t={detail:[{projects:[]}]},i=this.createView(7,7),a=n("#qunit-fixture");a.html('<div id="tab-content-'+e+'"><div class="detail-content-container"></div></div>'),i.$el=a,i.renderSuccess=this.sandbox.spy(),i._handleFetchSucceeded(e,t),ok(i.renderSuccess.neverCalledWith(e,t.detail));var s=i.getContentContainer(e),l=s.find(".no-permission-to-view-all");ok(l.find(".lock-image").length>0,"has lock image"),equal(l.text(),"You don't have access to view all related builds. Please contact your administrator.")}),test("Test sorting of projects and plans",function(){var e=this.createView(7,7);deepEqual(e.sortProjectsAndPlans([{name:"z",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}},{name:"b",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}}]},{name:"a",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}}]},{name:"M",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}},{name:"b",build:{finishedDate:"2013-10-22T12:03:00.000+0100"}}]}]),[{name:"M",plans:[{name:"b",build:{finishedDate:"2013-10-22T12:03:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}},{name:"a",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}}]},{name:"z",plans:[{name:"b",build:{finishedDate:"2013-10-22T12:02:00.000+0100"}},{name:"c",build:{finishedDate:"2013-10-22T12:01:00.000+0100"}},{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}}]},{name:"a",plans:[{name:"a",build:{finishedDate:"2013-10-22T12:00:00.000+0100"}}]}])}),test("Test build count",function(){var e=this.createView();equal(e.getBuildCount([]),0,"no projects"),equal(e.getBuildCount([{name:"a",plans:[{key:"A-A"}]}]),1,"single project, single build"),equal(e.getBuildCount([{name:"z",plans:[{key:"Z-A"},{key:"Z-C"},{key:"Z-B"}]}]),3,"single project, multiple builds"),equal(e.getBuildCount([{name:"a",plans:[{key:"A-A"}]},{name:"z",plans:[{key:"Z-A"},{key:"Z-C"},{key:"Z-B"}]}]),4,"multiple projects, multiple builds")}),test("Test has artifacts",function(){var e=this.createView();ok(!e.hasArtifacts([]),"no projects"),ok(!e.hasArtifacts([{name:"a",plans:[]}]),"single project, no plans"),ok(!e.hasArtifacts([{name:"a",plans:[{key:"Z-A"},{key:"Z-C"}]}]),"single project, multiple plans, no build info"),ok(!e.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{}},{key:"Z-C",build:{}}]}]),"single project, multiple plans, no artifact info"),ok(!e.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{artifacts:[]}},{key:"Z-C",build:{artifacts:[]}}]}]),"single project, multiple plans, empty artifact info"),ok(e.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{artifacts:[]}},{key:"Z-C",build:{artifacts:["one"]}}]}]),"single project, multiple plans, got artifact"),ok(e.hasArtifacts([{name:"a",plans:[{key:"Z-A",build:{artifacts:[]}},{key:"Z-C",build:{artifacts:[]}}]},{name:"b",plans:[{key:"X-A",build:{artifacts:[]}},{key:"X-C",build:{artifacts:["one"]}}]}]),"multiple projects, multiple plans, got artifact")}),test("Test dialog title for single build",function(){var e=this.createView(1,1);e.show();var t=this.getDetailDialog();equal(t.heading.text(),"DEV-1: 1 build")}),test("Test dialog title for multiple builds",function(){var e=this.createView(2,1);e.show();var t=this.getDetailDialog();equal(t.heading.text(),"DEV-1: 2 builds")}),test("Test build detail build dialog with success request",function(){expect(160),t.setFormat("YYYY-MM-DD");var i=this.createView(5);i.show();var a=this.getDetailDialog(),l=a.content.find(".status-loading"),o=a.content.find(".tabs-pane.active-pane"),r=[{name:"Bamboo",plans:[{disabled:!1,isBranch:!1,build:{date:"2013-11-19",result:"Passed in 2 hours",status:"SUCCESS",latestBuild:5}}]},{name:"Bamboo AAA",plans:[{disabled:!1,isBranch:!1,build:{date:"2013-11-19",result:"Passed in under 1 second",status:"SUCCESS",latestBuild:5,fixesBuildNumber:4}},{disabled:!1,isBranch:!0,build:{date:"2013-11-17",result:"Failed in 1 second",status:"FAILED",latestBuild:3}},{disabled:!0,isBranch:!1,build:{date:"2013-11-15",result:"9 tests passed in 80 seconds",status:"SUCCESS",latestBuild:3}}]},{name:"Bamboo",plans:[{disabled:!1,isBranch:!1,build:{date:"2013-11-19",result:"Passed in 2 hours",status:"SUCCESS",latestBuild:5}}]},{name:"Bamboo 2",plans:[{disabled:!1,isBranch:!1,build:{date:"2013-11-13",result:"1 test failed in 27 hours",status:"FAILED",latestBuild:5}},{disabled:!1,isBranch:!1,build:{date:"2013-11-09",result:"Build incomplete",status:"UNKNOWN",latestBuild:88}},{disabled:!0,isBranch:!1,build:{date:"2013-11-09",result:"1 test passed in 6 minutes",status:"SUCCESS",latestBuild:3}}]},{name:"Bamboo BBB",plans:[{disabled:!1,isBranch:!1,build:{date:"2013-11-13",result:"1 test failed in 1 minute",status:"FAILED",latestBuild:5}},{disabled:!1,isBranch:!0,build:{date:"2013-11-11",result:"1 of 3 tests failed in 88 minutes",status:"FAILED",latestBuild:3}},{disabled:!0,isBranch:!1,build:{date:"2013-11-09",result:"1 test passed in 1 hour",status:"SUCCESS",latestBuild:3}}]}];ok("block"==l.css("display"),"A spinner is visible when there is an onflight ajax request"),ok(l.children().length>0),ok(o.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request"),AJS.TestContractManager.respondToRequest("detail3LO-bamboo",this.server.requests[0]),AJS.TestContractManager.respondToRequest("bambooDetailBuild-multiple",this.server.requests[1]),this.assertNoErrorMessagesInCanvas();var d=a.content.find(".detail-builds-container");ok("none"==l.css("display"),"A spinner is no longer visible when the onflight ajax request has completed"),ok(!o.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed"),equal(d.length,r.length,"Number of project tables rendered into the dialog is correct"),s.each(d,s.bind(function(t,i){var a=n(t),l="Project["+i+"]: ",o=a.find(".project-link");equal(o.text(),r[i].name,l+"the project name exist and is correct"),strictEqual(o.attr("target"),void 0,l+"clicking on project link opens in the same tab"),o.click(),ok(e.BuildsAnalytics.fireDetailProjectClicked.called,l+"analytic event is fired correctly when clicking on project link"),e.BuildsAnalytics.fireDetailProjectClicked.reset();var d=a.find(".builds-table tr.plan-row");equal(d.length,r[i].plans.length,l+"list of builds exist and contains the correct number of rows"),s.each(d,s.bind(function(t,a){var s=n(t),l="Project["+i+"], plan["+a+"]: ",o=r[i].plans[a],d=o.build,u=s.find(".plan"),c=u.find(".plan-link");strictEqual(c.attr("target"),void 0,l+"clicking on plan link opens in the same tab"),c.click(),ok(e.BuildsAnalytics.fireDetailPlanClicked.called,l+"analytic event is fired correctly when clicking on plan link"),e.BuildsAnalytics.fireDetailPlanClicked.reset(),equal(u.find(".aui-lozenge.disabled").length,o.disabled?1:0,"disabled lozenge present or not"),equal(u.find(".aui-icon.aui-iconfont-devtools-branch-small").length,o.isBranch?1:0,"branch icon present or not");var h=s.find(".build"),p=h.find(".aui-icon");"SUCCESS"==d.status?ok(p.hasClass("aui-iconfont-approve"),l+"has correct icon"):"FAILED"==d.status?ok(p.hasClass("aui-iconfont-error"),l+"has correct icon"):"UNKNOWN"==d.status&&ok(p.hasClass("aui-iconfont-devtools-task-cancelled"),l+"has correct icon");var b=h.find(".build-link");equal(b.text(),"#"+d.latestBuild,l+"latest build number is correct"),strictEqual(b.attr("target"),void 0,l+"clicking on build link opens in the same tab"),b.click(),ok(e.BuildsAnalytics.fireDetailBuildClicked.called,l+"analytic event is fired correctly when clicking on build link"),e.BuildsAnalytics.fireDetailBuildClicked.reset();var f=s.find(".result");equal(f.text(),d.result,l+"the build result exist and is correct");var m=f.find("a");equal(m.length,0,"fixes build link not present at all times");var g=s.find(".timestamp .livestamp");ok(0!=g.length,l+"time stamp is rendered into the table"),equal(g.attr("title"),d.date,l+"tooltip is correctly appended onto the timestamp element")},this))},this))})});