"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource","com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e,t=require("util/DateUtils"),i=require("qunit/TestUtils"),r=require("viewissue/dialog/DetailDialogReviewView"),s=require("underscore"),a=require("jquery");module("JIRA.DevStatus.DetailDialogReviewView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create(),this.issueKey="DEV-1",this.issueId=1e4,this.server=sinon.fakeServer.create(),this.templateSpy=void 0,e=i.spyAnalyticMethods("Reviews",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),e.ReviewsAnalytics.fireDetailReviewClicked=sinon.spy(),this.livestamp=a.fn.livestamp,a.fn.livestamp=sinon.spy()},teardown:function(){this.sandbox.restore(),this.server.restore(),i.cleanAllDialogs(),a("body").css("overflow","initial"),a.fn.livestamp=this.livestamp},getDetailDialog:function(){var e=a(".jira-dialog");return{heading:e.find(".devstatus-dialog-heading"),content:e.find(".devstatus-dialog-content"),getReviewContainer:function(){return this.content.find(".detail-reviews-container")},getRows:function(){return this.getReviewContainer().find("tbody tr")},getColumns:function(e){var t=a(e);return{review:t.find(".review"),title:t.find(".title"),state:t.find(".state"),author:t.find(".author"),reviewers:t.find(".reviewer-container .vcs-user"),extraReviewersLozenge:t.find(".reviewer-container .extrareviewers-tooltip"),reviewerAvatarCount:t.find(".reviewer img").length,truncatedReviewerCount:parseInt(t.find(".reviewer").text()),commentCount:parseInt(t.find(".comment .count").text()),timestamp:t.find(".timestamp"),overDue:t.find(".timestamp .overdue").length>0}},getNoPermissionToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all")},getExtraReviewerInlineDialog:function(e){return{rowsElement:e.find("tr"),rowsValue:function(){var e=[];return s.each(this.rowsElement,function(t){var i=a(t);e.push({name:i.find(".reviewer-name").text(),hasAvatar:i.find(".reviewer-avatar img").length>0})}),e}}}}},createView:function(e){var t=new r({count:e,issueKey:this.issueKey,issueId:this.issueId,tabs:{fecru:{name:"FishEye / Crucible",count:e}},dataType:"review",reviewersThreshold:2});return this.templateSpy=sinon.spy(t,"template"),t},assertNoNoPermissionMessage:function(){ok(0===this.getDetailDialog().content.find(".no-permission-to-view-all").length,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(0===this.getDetailDialog().content.find(".aui-message-warning:has(.connection-error)").length,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage(),this.assertNoConnectionErrorWarning()},assertColumnContent:function(e,t,i,r,s,a,n,o,l,d){var c=e.getColumns(e.getRows()[t]);return equal(c.review.text(),i,"Review id rendered for "+i),ok(c.title.text().match(r),"Review title rendered for "+i),equal(c.state.text(),s,"Review status rendered for "+i),equal(c.author.find(".extra-content-in-title").attr("original-title"),a,"Author rendered for "+i),ok(c.author.find("img").length>0,"Avatar rendered for "+i),equal(c.reviewerAvatarCount,n,"Review avatars rendered for  "+i),deepEqual(c.truncatedReviewerCount,o,"Extra reviewer badge rendered "+i),deepEqual(c.commentCount,l,"Comment count rendered for "+i),ok(c.timestamp.text().match(d),"Timestamp rendered for "+i),c}}),test("Test lock screen renders if no data would be displayed",function(){var e="fecru",t={detail:[{reviews:[]}]},i=this.createView(),r=a("#qunit-fixture");r.html('<div id="tab-content-'+e+'"><div class="detail-content-container"></div></div>'),i.$el=r,i.renderSuccess=this.sandbox.spy(),i._handleFetchSucceeded(e,t),ok(i.renderSuccess.neverCalledWith(e,t.detail));var s=i.getContentContainer(e),n=s.find(".no-permission-to-view-all");ok(n.find(".lock-image").length>0,"has lock image"),equal(n.text(),"You don't have access to view all related reviews. Please contact your administrator.")}),test("Test content table is not rendered when JSON response empty",function(){var e=this.createView(1),t=a('<div class="jira-dialog"></div>').appendTo(a("#qunit-fixture")),i=a('<div class="devstatus-dialog-content"></div>').appendTo(t);e.getContentContainer=this.sandbox.stub().returns(i),e.renderSuccess("fecru",[]);var r=this.getDetailDialog();equal(r.getReviewContainer().length,0,"Dialog container doesn't exists"),equal(r.getRows().length,0,"Table/rows are rendered into the dialog"),equal(r.getNoPermissionToViewAllMessage().length,1,"Contains no permission to view all message")}),test("Test responses from multiple connected products are combined",function(){var e=this.createView(),t=[{id:"CR-1",lastModified:"2013-11-20T11:49:10.512+0100",state:"Review"},{id:"CR-2",lastModified:"2013-11-20T23:59:10.512+0100",state:"Review"}],i=[{id:"CR-3",lastModified:"2013-10-20T11:49:10.512+0100",state:"Review"},{id:"CR-4",lastModified:"2013-12-20T11:49:10.512+0100",state:"Review"}];e.renderSuccess("fecru",[{reviews:t},{reviews:i}]),deepEqual(this.templateSpy.getCall(0).args[0].reviews,[i[1],t[1],t[0],i[0]],"Reviews combined before template call")}),test("Test sorting reviews by lastModified",function(){var e=this.createView(),t=[{id:"CR-1",lastModified:"2013-11-20T11:49:10.512+0100",state:"Review"},{id:"CR-2",lastModified:"2013-11-20T23:59:10.512+0100",state:"Review"},{id:"CR-3",lastModified:"2013-10-20T11:49:10.512+0100",state:"Review"},{id:"CR-4",lastModified:"2013-12-20T11:49:10.512+0100",state:"Review"},{id:"CR-5",lastModified:"2013-11-20T11:49:10.512+0100",dueDate:"2014-12-20T11:49:10.512+0100",state:"Review"},{id:"CR-6",lastModified:"2013-11-20T11:49:10.512+0100",dueDate:"2012-12-20T11:49:10.512+0100",state:"Review"}];e.renderSuccess("fecru",[{reviews:t}]),deepEqual(this.templateSpy.getCall(0).args[0].reviews,[t[5],t[4],t[3],t[1],t[0],t[2]],"Reviews sorted before template call")}),test("Test complete and rejected reviews don't have due dates",function(){var e=this.createView(),t={id:"CR-1",lastModified:"2013-11-20T11:49:10.512+0100",dueDate:"4999-11-20T11:49:10.512+0100",reviewers:[]},i=s.extend({state:"Review"},t),r=s.extend({state:"Closed"},t),a=s.extend({state:"Rejected"},t);e.renderSuccess("fecru",[{reviews:[i]}]),e.renderSuccess("fecru",[{reviews:[r]}]),e.renderSuccess("fecru",[{reviews:[a]}]),deepEqual(this.templateSpy.getCall(0).args[0].reviews,[i],"Review in progress due date not stripped"),deepEqual(this.templateSpy.getCall(1).args[0].reviews,[s.omit(r,"dueDate")],"Review closed due date stripped"),deepEqual(this.templateSpy.getCall(2).args[0].reviews,[s.omit(a,"dueDate")],"Review rejected due date stripped")}),test("Test sorting reviewers by completion status",function(){var e=this.createView(),t=[{name:"d",complete:!0},{name:"c",complete:!1},{name:"b",complete:!0},{name:"a",complete:!1}],i=[{id:"CR-1",state:"Review",reviewers:t}],r=s(i).map(e._updateReviewers)[0].reviewers;deepEqual(r,[t[2],t[0],t[3],t[1]],"Reviewers sorted before template call")}),test("Test author is excluded from reviewers list",function(){var e=this.createView(),t=[{name:"amy"},{name:"bernice"}],i=[{id:"CR-1",state:"Review",reviewers:t,author:{name:"amy",avatar:"http://foo/bar",emailAddress:"amy@example.com"}}],r=s(i).map(e._updateReviewers)[0].reviewers;ok(s.contains(r,{name:"amy"})===!1,"Author should not be in the reviewers list")}),test("Test transforming reviewers",function(){var e=this.createView(),t={name:"c"},i=[{name:"b",complete:!1},{name:"a",complete:!0}],r=[{id:"CR-1",state:"Review",reviewers:i,moderator:t}],a=s(r).map(e._updateReviewers)[0].reviewers;deepEqual(a,[t,i[1],i[0]],"Moderator inserted into reviewers")}),test("Test transforming reviewers doesn't add moderator if he's the author",function(){var e=this.createView(),t={name:"a",avatar:"http://foo/bar",emailAddress:"moder@tor.com"},i=[{name:"b",complete:!1}],r=[{id:"CR-1",state:"Review",reviewers:i,moderator:t,author:t}],a=s(r).map(e._updateReviewers)[0].reviewers;deepEqual(a,[i[0]],"Moderator not inserted into reviewers if he's a reviewer as well")}),test("Test filtering reviews",function(){var e=this.createView(),t=[{id:"CR-1",state:"Draft"},{id:"CR-2",state:"Review"},{id:"CR-3",state:"Approval"},{id:"CR-4",state:"Closed"},{id:"CR-5",state:"Dead"},{id:"CR-6",state:"Unknown"},{id:"CR-6",state:"Summarize"},{id:"CR-7",state:"Rejected"}];e.renderSuccess("fecru",[{reviews:t}]),deepEqual(this.templateSpy.getCall(0).args[0].reviews,[t[1],t[2],t[3],t[6],t[7]],"Reviews filtered before template call")}),test("Test event sent when review id clicked",function(){var t=this.createView(0);t.show(),t.renderSuccess("fecru",[{reviews:[{id:"CR-2",state:"Review",commentCount:666}]}]),a(".review-link").click(),ok(e.ReviewsAnalytics.fireDetailReviewClicked.calledOnce,"analytics event fired when clicking review id"),a(".comment-link").click(),ok(e.ReviewsAnalytics.fireDetailReviewClicked.calledTwice,"analytics event fired when clicking comments link")}),test("Test review detail renders dialog with success request",function(){expect(58),t.setFormat("YYYY-MM-DD");var e=this.createView(5);e.show();var i=this.getDetailDialog(),r=i.content.find(".status-loading"),s=i.content.find(".tabs-pane.active-pane");ok("block"==r.css("display"),"A spinner is visible when there is an onflight ajax request"),ok(r.children().length>0),ok(s.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request"),AJS.TestContractManager.respondToRequest("detail3LO-fecru",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailReviews-multiple",this.server.requests[1]),this.assertNoErrorMessagesInCanvas(),ok("none"==r.css("display"),"A spinner is no longer visible when the onflight ajax request has completed"),ok(!s.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed"),equal(i.getRows().length,5,"Number of pull request rows rendered into the table is correct");var a=this.assertColumnContent(i,0,"PERM-7","patch #2815684","Open","System Administrator",3,NaN,1,/^Due/);ok(a.reviewers.eq(0).find(".approved").length>0,"Review completion mark rendered correctly"),ok(a.reviewers.eq(0).find(".fade").length>0,"Review completion fade rendered correctly"),ok(a.overDue,"PERM-7 overdue"),this.assertColumnContent(i,1,"CR-244","DEF-1 Row row row your boat","Open","Geoff Crain",2,7,2,/^Due/),this.assertColumnContent(i,2,"CR-256","DEF-1: 1","Approval","Matt Quail",2,NaN,NaN,/^Due/);var n=this.assertColumnContent(i,3,"DEF-10","DEF-1: 1","Closed","Matt Quail",2,2,NaN,/^(?!Due).*$/);ok(!n.overDue,"DEF-10 not overdue");var o=this.assertColumnContent(i,4,"DEF-4",".*","Closed","Geoff Crain",0,NaN,101,/^(?!Due)/);ok(!o.overDue,"DEF-4 not overdue")}),test("Test reviewer tooltip in detail dialog",function(){t.setFormat("YYYY-MM-DD");var e=this.createView(5);e.show();var i=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detail3LO-fecru",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailReviews-multiple",this.server.requests[1]);var r=1;ok(!s.isObject(e.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is NOT created when the pull request link is NOT hovered"),i.getColumns(i.getRows()[r]).extraReviewersLozenge.mouseenter().mousemove(),ok(s.isObject(e.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is created when the pull request link is hovered");var a=i.getExtraReviewerInlineDialog(e.reviewerInlineDialogView.activeExtraReviewersToolTip.$content);equal(a.rowsElement.length,7,"number of reviewers in tooltip is correct"),deepEqual(s.pluck(a.rowsValue(),"name"),["Brendan Humphreys","Conor MacNeill","George Filippoff","Matt Quail","Peter McNeil","Wojciech Seliga","joe lowercase"],"tooltip content is correct"),i.getColumns(i.getRows()[r]).extraReviewersLozenge.mouseleave(),ok(!e.reviewerInlineDialogView.activeExtraReviewersToolTip.visible,"activeExtraReviewersToolTip is hidden when mouse is removed")}),test("Test extra reviewers are spliced after sorting",function(){var e=this.createView(),t=[{reviews:[{id:"CR-1",state:"REVIEW",reviewers:[{name:"a",complete:!1},{name:"b",complete:!1},{name:"c",complete:!0},{name:"d",complete:!0}],moderator:{name:"m"}}]}],i=e._prepareReviews(t),r=JSON.parse(i[0].extraReviewers),a=i[0].reviewers;deepEqual(s.pluck(a,"name"),["Moderator: m","c","d","a","b"],"reviewers should be sorted: moderator first, then completed then notcompleted"),deepEqual(s.pluck(r,"name"),["d","a","b"],"extraReviewers should be the tail of the all-reviewer list")})});