"use strict";function _defineProperty(e,t,a){return t in e?Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!0}):e[t]=a,e}AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource","com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e,t=require("util/DateUtils"),a=require("qunit/TestUtils"),i=require("viewissue/dialog/DetailDialogPullRequestView"),s=require("underscore"),n=require("jquery");module("JIRA.DevStatus.DetailDialogPullRequestView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create(),this.issueKey="DEV-1",this.issueId=1e4,this.server=sinon.fakeServer.create(),e=a.spyAnalyticMethods("PullRequests",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),this.livestamp=n.fn.livestamp,n.fn.livestamp=sinon.spy()},teardown:function(){this.sandbox.restore(),this.server.restore(),a.cleanAllDialogs(),n("body").css("overflow","initial"),n.fn.livestamp=this.livestamp},getDetailDialog:function(){var e=n(".jira-dialog");return{heading:e.find(".devstatus-dialog-heading"),content:e.find(".devstatus-dialog-content"),getPullRequestContainer:function(){return this.content.find(".detail-pullrequests-container")},getRows:function(){return this.getPullRequestContainer().find(".pullrequest-row")},getColumns:function(e){var t=n(e);return{author:t.find(".author"),state:t.find(".state"),id:t.find(".pullrequest-id"),title:t.find(".title"),commentCount:t.find(".comment"),reviewer:t.find(".reviewer"),timestamp:t.find(".last-updated")}},getLinks:function(e){var t=this.getColumns(e);return{pullRequest:t.title.find(".pullrequest-link")}},getNoPermissionToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all")},getExtraReviewerInlineDialog:function(e){return{rowsElement:e.find("tr"),rowsValue:function(){var e=[];return s.each(this.rowsElement,function(t){var a=n(t);e.push({name:a.find(".reviewer-name").text(),hasAvatar:a.find(".reviewer-avatar img").length>0})}),e}}}}},createView:function(e){return new i({count:10,issueKey:this.issueKey,issueId:this.issueId,tabs:{bitbucket:{name:"Bitbucket",count:e||9}},dataType:"pullrequest",reviewersThreshold:2})},assertNoNoPermissionMessage:function(){ok(0===this.getDetailDialog().content.find(".no-permission-to-view-all").length,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(0===this.getDetailDialog().content.find(".aui-message-warning:has(.connection-error)").length,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage(),this.assertNoConnectionErrorWarning()}}),test("Test content table is not rendered when JSON response empty",function(){var e=this.createView(),t=n('<div class="jira-dialog"></div>').appendTo(n("#qunit-fixture")),a=n('<div class="devstatus-dialog-content"></div>').appendTo(t);e.getContentContainer=this.sandbox.stub().returns(a),e.renderSuccess("bitbucket",[]);var i=this.getDetailDialog();equal(i.getPullRequestContainer().length,0,"Dialog container doesn't exists"),equal(i.getRows().length,0,"Table/rows are not rendered into the dialog"),equal(i.getNoPermissionToViewAllMessage().length,1,"Contains no permission to view all message")}),test("Test lock screen renders if no data would be displayed",function(){var e="fecru",t={detail:[{pullRequests:[]}]},a=this.createView(),i=n("#qunit-fixture");i.html('<div id="tab-content-'+e+'"><div class="detail-content-container"></div></div>'),a.$el=i,a.renderSuccess=this.sandbox.spy(),a._handleFetchSucceeded(e,t),ok(a.renderSuccess.neverCalledWith(e,t.detail));var s=a.getContentContainer(e),r=s.find(".no-permission-to-view-all");ok(r.find(".lock-image").length>0,"has lock image"),equal(r.text(),"You don't have access to view all related pull requests. Please contact your administrator.")}),test("Test author properly excluded from reviewers",function(){var e=this.createView(),t=[{reviewers:[_defineProperty({name:"amy"},"name","bernice")],author:{name:"amy"}}],a=e._removeAuthorFromReviewers(t);deepEqual(a,[{reviewers:[{name:"bernice"}],author:{name:"amy"}}])}),test("Test empty reviewer PR does not error",function(){var e=this.createView(),t=[{reviewers:[],author:{name:"amy"}}],a=e._removeAuthorFromReviewers(t);deepEqual(a,[{reviewers:[],author:{name:"amy"}}])}),test("Test reviewerless PR does not error",function(){var e=this.createView(),t=[{author:{name:"amy"}}],a=e._removeAuthorFromReviewers(t);deepEqual(a,[{author:{name:"amy"}}])}),test("Test authorless PR is unchanged",function(){var e=this.createView(),t=[{reviewers:[_defineProperty({name:"amy"},"name","bernice")]}],a=e._removeAuthorFromReviewers(t);deepEqual(a,[{reviewers:[_defineProperty({name:"amy"},"name","bernice")]}])}),test("Test responses from multiple connected products are combined and sorted",function(){var e=this.createView();e.template=this.sandbox.spy(),e.getContentContainer=this.sandbox.stub().returns(n("<div></div>")),e.renderSuccess("product",[{pullRequests:[{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"}]},{pullRequests:[{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"}]}]),deepEqual(e.template.getCall(0).args[0].pullRequests,[{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"}].reverse())}),test("Test list of pull requests are ordered by pull request id and name",function(){var e=this.createView();deepEqual(e._getSortedPullRequestsByDate([{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"},{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"}]),[{id:"#5",name:"bbbb",lastUpdate:"2013-08-22T15:33:50.000+1100"},{id:"#1",name:"zzzzzzz",lastUpdate:"2013-09-22T15:33:50.000+1100"},{id:"#999",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"dddd",lastUpdate:"2013-10-22T15:33:50.000+1100"},{id:"#3",name:"eeee",lastUpdate:"2013-10-22T15:33:50.000+1102"},{id:"#2",name:"ccccc",lastUpdate:"2013-11-22T15:33:50.000+1100"}].reverse())}),test("Test sorting reviewers in pull requests",function(){var e=this.createView(),t=[{id:"#991",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A",approved:!1},{name:"B",approved:!0},{name:"C",approved:!1}]},{id:"#992",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A"},{name:"B",approved:!0},{name:"C",approved:!1}]},{id:"#993",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"C",approved:!1},{name:"B",approved:!1},{name:"A",approved:!1}]},{id:"#995",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"C",approved:!0},{name:"B",approved:!0},{name:"A",approved:!0}]},{id:"#994",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{approved:!1},{approved:!0},{name:"C",approved:!1}]}];e._sortReviewers(t),deepEqual(t,[{id:"#991",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"B",approved:!0},{name:"A",approved:!1},{name:"C",approved:!1}]},{id:"#992",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"B",approved:!0},{name:"A"},{name:"C",approved:!1}]},{id:"#993",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A",approved:!1},{name:"B",approved:!1},{name:"C",approved:!1}]},{id:"#995",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"A",approved:!0},{name:"B",approved:!0},{name:"C",approved:!0}]},{id:"#994",name:"haha",lastUpdate:"2013-10-22T15:33:50.000+1100",reviewers:[{name:"C",approved:!1}]}])}),test("Test detail pullrequest dialog with success request",function(){expect(86),t.setFormat("YYYY-MM-DD");var e=this.createView(5);e.show();var a=this.getDetailDialog(),i=a.content.find(".status-loading"),n=a.content.find(".tabs-pane.active-pane");ok("block"==i.css("display"),"A spinner is visible when there is an onflight ajax request"),ok(i.children().length>0),ok(n.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request"),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]),this.assertNoErrorMessagesInCanvas(),ok("none"==i.css("display"),"A spinner is no longer visible when the onflight ajax request has completed"),ok(!n.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed"),equal(a.getRows().length,6,"Number of pull request rows rendered into the table is correct");var r=[2,5],o={1:3,0:1};s.each(a.getRows(),function(e,t){var i=a.getColumns(e);ok(0!==i.author.children().length,"Author column is not empty"),ok(0!==i.author.find("img").length,"Author column has avatar"),ok(!s.isEmpty(i.state.text()),"State column is not empty"),ok(!s.isEmpty(i.title.text()),"Title column is not empty"),ok(null!=i.id.find("a"),"ID content is a link"),ok(null!=i.title.find("a"),"Title content is a link"),ok(i.title.find("a").attr("href").indexOf("https://bitbucket.org/fusiontestaccount/ddd-one/pull-request/")!==-1,"Title content has a link"),s.contains(r,t)?(equal(i.reviewer.children().length,0,"Reviewer column is empty"),equal(i.reviewer.find("img").length,0,"Reviewer column does not have avatar")):(ok(0!==i.reviewer.children().length,"Reviewer column is NOT empty"),ok(0!==i.reviewer.find("img").length,"Reviewer column has avatar"));var n=o[""+t];n?equal(i.commentCount.text(),"Comments"+n,"Comment count is correct"):equal(i.commentCount.children().length,0,"Reviewer column is empty"),ok(0===s.size(i.source),"No Source column"),ok(0===s.size(i.destination),"No Destination column"),ok(!s.isEmpty(i.timestamp.text()),"Timestamp column is not empty")})}),test("Test reviewer tooltip in detail dialog",function(){t.setFormat("YYYY-MM-DD");var e=this.createView(5);e.options.reviewersThreshold=-1,e.show();var a=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]),equal(a.getRows().length,6,"Number of pull request rows rendered into the table is correct");var i=3;ok(!s.isObject(e.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is NOT created when the pull request link is NOT hovered"),a.getColumns(a.getRows()[i]).reviewer.find(".extrareviewers-tooltip").mouseenter(),ok(s.isObject(e.reviewerInlineDialogView.activeExtraReviewersToolTip),"activeExtraReviewersToolTip is created when the pull request link is hovered");var n=a.getExtraReviewerInlineDialog(e.reviewerInlineDialogView.activeExtraReviewersToolTip.$content);equal(n.rowsElement.length,1,"number of reviewers in tooltip is correct"),deepEqual(n.rowsValue(),[{name:"Jimmy Kurniawan",hasAvatar:!0}],"tooltip content is correct"),a.getColumns(a.getRows()[i]).reviewer.find(".extrareviewers-tooltip").mouseleave(),ok(!e.reviewerInlineDialogView.activeExtraReviewersToolTip.visible,"activeExtraReviewersToolTip is hidden when mouse is removed")}),test("Test clicking pull request link in pull request detail dialog fires the correct analytics",function(){expect(13);var t=this.createView(5);t.show();var a=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]),equal(a.getRows().length,6,"Number of pull request rows rendered into the table is correct"),s.each(a.getRows(),function(t,i){var s=a.getLinks(t);s.pullRequest.click(),ok(e.PullRequestsAnalytics.fireDetailPullRequestClicked.called,"Analytic event is fired correctly when clicking on pull request link on row "+(i+1)),ok(e.PullRequestsAnalytics.fireDetailPullRequestClicked.calledWith("bitbucket"),"Analytic event is fired correctly when clicking on pull request link on row "+(i+1)),e.PullRequestsAnalytics.fireDetailPullRequestClicked.reset()})})});