"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource","com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){require("wr-resource!templates_viewissue_devstatus-detail-dialog.soy.js!templates/viewissue/devstatus-detail-dialog.soy"),require("wr-resource!templates_fusion-widget_fusion-widget-common.soy.js!templates/fusion-widget/fusion-widget-common.soy"),require("wr-resource!templates_viewissue_commit_devstatus-detail-dialog-commit-files.soy.js!templates/viewissue/commit/devstatus-detail-dialog-commit-files.soy"),require("wr-resource!templates_viewissue_devstatus-detail-dialog-commit.soy.js!templates/viewissue/devstatus-detail-dialog-commit.soy");var e=require("util/DateUtils"),t=require("util/DevStatusNavigation"),i=require("analytics/devstatus-analytics"),s=require("underscore"),n=require("jquery"),a=require("jira/util/data/meta"),o=require("qunit/TestUtils"),r=require("viewissue/dialog/DetailDialogCommitView");module("JIRA.DevStatus.DetailDialogCommitView",{setup:function(){this.sandbox=sinon.sandbox.create(),this.issueKey="DEV-1",this.issueId=123,this.server=sinon.fakeServer.create(),this.restoreAsyncRequire=o.synchronizeAsyncRequires(),this.repoClickedStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailRepoClicked"),this.commitClickedStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailCommitClicked"),this.branchesShownStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailBranchesShown"),this.reviewsShownStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailReviewsShown"),this.reviewClickedStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailReviewClicked"),this.fileExpandedStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailFileExpandedClicked"),this.filesExpandedStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailFilesExpandedClicked"),this.fileClickedStub=this.sandbox.stub(i.CommitsAnalytics,"fireDetailFileClicked"),this.createReviewClicked=this.sandbox.stub(i.CommitsAnalytics,"fireDetailCreateReviewClicked"),this.livestamp=n.fn.livestamp,n.fn.livestamp=sinon.spy()},teardown:function(){this.restoreAsyncRequire(),this.sandbox.restore(),this.server.restore(),o.cleanAllDialogs(),n("body").css("overflow","initial"),a.set("fusion-open-detail-dialog",void 0),clearTimeout(this.qunitTestTimer),n.fn.livestamp=this.livestamp},qunitTestTimer:null,getCommitDetailDialog:function(){var e=n(".jira-dialog");return{heading:e.find(".devstatus-dialog-heading"),content:e.find(".devstatus-dialog-content")}},getCommitRows:function(e){return e.find("tbody tr.commitrow")},createView:function(e,t){return new r({count:10,el:t,issueId:this.issueId,issueKey:this.issueKey,tabs:{bitbucket:{name:"Bitbucket",count:e||9}}})},assertNoNoPermissionMessage:function(){ok(0===this.getCommitDetailDialog().content.find(".no-permission-to-view-all").length,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(0===this.getCommitDetailDialog().content.find(".aui-message-warning:has(.connection-error)").length,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage(),this.assertNoConnectionErrorWarning()},renderViewFromContracts:function(e,t){var i=this.createView(t||5);i.show();for(var s=0;s<e.length;s++)AJS.TestContractManager.respondToRequest(e[s],this.server.requests[s])},renderFromData:function(e,t){t=t||"fecru";var i=n("#qunit-fixture");i.html('<div id="tab-content-'+t+'"><div class="detail-content-container"></div></div>');var s=this.createView(1,i);return s.renderSuccess(t,e),s},checkForRequestWithNumRetries:function(e,t){var i=this,s=500,n=setInterval(function(){i.server.requests.length>e?(clearTimeout(n),t(),o.testFinish(!0,i)):0===s&&(clearTimeout(n),QUnit.assert.ok(!1,"sinon did not get the fake request that should have been sent"),o.testFinish(!0,i)),s-=1},10)}}),test("Test bitbucket detail commits repositories and commits are ordered",function(){var e=this.createView();deepEqual(e.sortRepositoriesAndCommits([{name:"z",commits:[]},{name:"a",commits:[]},{name:"M",commits:[{authorTimestamp:"2013-10-22T15:33:50.000+1100"},{authorTimestamp:"2011-10-22T15:33:50.000+1100"},{authorTimestamp:"2012-10-22T15:33:50.000+1100"}]}]),[{name:"a",commits:[]},{name:"M",commits:[{authorTimestamp:"2013-10-22T15:33:50.000+1100"},{authorTimestamp:"2012-10-22T15:33:50.000+1100"},{authorTimestamp:"2011-10-22T15:33:50.000+1100"}]},{name:"z",commits:[]}])}),test("Test commit detail dialog renders reviews and branches",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewsAndBranches"]);var e=this.getCommitRows(n(".devstatus-detail-table")),t=e.eq(0),i=e.eq(1),s=e.eq(2),a=t.find(".branches-link"),o=i.find(".branches-link"),r=s.find(".reviews-link");equal(a.find(".aui-iconfont-devtools-branch-small").length,1,"Branch icon rendered"),equal(a.find(".branch-count").length,0,"Branch count not rendered"),equal(t.find(".reviews-link").length,0,"Review lozenge not rendered"),equal(o.find(".aui-iconfont-devtools-branch-small").length,1,"Branch icon rendered"),equal(o.find(".branch-count").text(),"21","Branch count rendered"),equal(r.length,1,"Review link rendered"),equal(r.text(),"Open","Review link status rendered")}),test("Test commit detail dialog renders instance names",function(){var e=this.renderFromData([{repositories:[{name:"instance1-repo1"},{name:"instance1-repo2"}],_instance:{name:"instance1"}},{repositories:[{name:"instance2-repo1"}],_instance:{name:"instance2"}}]),t=e.$el.find(".repository-instance");equal(t.length,3,"Rendered repository instance names"),equal(t.eq(0).text(),"(instance1)","Rendered repository instance name"),equal(t.eq(1).text(),"(instance1)","Rendered repository instance name"),equal(t.eq(2).text(),"(instance2)","Rendered repository instance name")}),test("Test repository instance names aren't rendered when there's only one",function(){var e=this.createView(),t=e.concatResults([{repositories:[{name:"instance1-repo1"},{name:"instance1-repo2"}],_instance:{name:"instance1",singleInstance:!0}}]);ok(!t[0].showInstance,"Set to not show instance for repos from a single instance"),ok(!t[1].showInstance,"Set to not show instance for repos from a single instance")}),test("Test commit detail dialog renders default avatar if none provided",function(){var e="http://localhost/foobar",t=this.renderFromData([{repositories:[{name:"instance1-repo1",avatar:e},{name:"instance1-repo2"}]}]),i=t.$el.find(".project-avatar");equal(i.length,2,"Rendered repository avatars"),equal(i.eq(0).find("img").attr("src"),e,"Rendered provided repository avatar image"),equal(i.eq(1).find(".aui-iconfont-devtools-repository").length,1,"Rendered default repository avatar if no image provided")}),test("Test commit detail dialog uses repository avatar description for project tooltip",function(){var e=this.renderFromData([{repositories:[{name:"instance1-repo1",avatarDescription:"project"},{name:"instance1-repo2"}]}]),t=e.$el.find(".project-avatar");equal(t.eq(0).attr("title"),"project"),equal(t.eq(1).attr("title"),void 0)}),test("Test commit detail dialog renders files",function(){function e(e,t,i){var n=s.eq(e);equal(n.find(".filecount").text(),t);var a=n.next();i(a.find(".file"))}function t(e){return function(t){equal(t.length,e.length),t.each(function(t){var i=n(this);equal(i.find(".changetype").text().toUpperCase(),e[t].type),equal(i.find(".filename").text(),e[t].name)})}}function i(e){return function(t){equal(t.length,e.length),t.each(function(t){var i=n(this);e[t].type?equal(i.find(".lines").text().toUpperCase(),e[t].type):(equal(i.find(".lines .added").text(),"+"+e[t].added),equal(i.find(".lines .removed").text(),"-"+e[t].removed)),equal(i.find(".filename").text(),e[t].name)})}}this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-files"]);var s=this.getCommitRows(n(".devstatus-detail-table"));e(0,"10 files",t([{type:"ADDED",name:"a"},{type:"COPIED",name:"b"},{type:"MOVED",name:"c"},{type:"DELETED",name:"d"},{type:"MODIFIED",name:"e"}])),e(1,"",t([])),e(2,"3 files",i([{type:"ADDED",name:"a"},{type:"DELETED",name:"b"},{name:"c",added:3,removed:8}])),e(3,"1 file",t([{type:"MODIFIED",name:"plugins/branch-utils/src/test/java/com/atlassian/stash/internal/branch/list/aheadbehind/ShowBranchAheadBehindCountingOutputHandlerTest.java"}]))}),test("Test commit detail dialog file count",function(){equal(n(JIRA.Templates.DevStatus.DetailDialog.filesColumn({count:1})).text(),"1 file"),equal(n(JIRA.Templates.DevStatus.DetailDialog.filesColumn({count:99})).text(),"99 files"),equal(n(JIRA.Templates.DevStatus.DetailDialog.filesColumn({count:100})).text(),"100+ files")}),test("Test commit detail dialog toggle files",function(){function e(e){equal(o.text(),e?"Hide files":"Show all files","Expand show/hide state")}function t(e,t){equal(a.eq(e).next().hasClass("hidden"),t,"File row visibility: "+e)}function i(e){a.eq(e).find(".filecount a").click()}var s=this;this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-files"]);var a=this.getCommitRows(n(".devstatus-detail-table")).filter(function(){return""!==n(this).find(".filecount").text()}),o=a.closest(".detail-commits-container").find(".file-expand a");ok(!0,"Everything should be closed"),e(!1),a.each(function(e){t(e,!0)}),ok(!0,"Toggle one file at a time"),a.each(function(n){i(n),ok(s.fileExpandedStub.calledOnce,"Analytic event fired when showing files for a single commit"),s.fileExpandedStub.reset(),t(n,!1),e(!0)}),ok(!0,"Hide one"),i(0),t(0,!0),e(!0),ok(!s.fileExpandedStub.called,"Analytic event not fired when hiding files for a single commit"),ok(!0,"Hide them all"),o.click(),ok(!this.filesExpandedStub.called,"Analytic event not fired when hiding all files"),e(!1),a.each(function(e){t(e,!0)}),ok(!0,"Expand them all"),o.click(),ok(this.filesExpandedStub.called,"Analytic event fired when showing all files"),e(!0),a.each(function(e){t(e,!1)}),ok(!0,"Hide one file"),i(0),t(0,!0),e(!0),n(".filename:visible a").eq(0).click(),ok(this.fileClickedStub.called)}),test("Test lock screen renders if no data would be displayed",function(){var e="fecru",t={detail:[{repositories:[]}]},i=this.createView(),s=n("#qunit-fixture");s.html('<div id="tab-content-'+e+'"><div class="detail-content-container"></div></div>'),i.$el=s,i.renderSuccess=this.sandbox.spy(),i._handleFetchSucceeded(e,t),ok(i.renderSuccess.neverCalledWith(e,t.detail));var a=i.getContentContainer(e),o=a.find(".no-permission-to-view-all");ok(o.find(".lock-image").length>0,"has lock image"),equal(o.text(),"You don't have access to view all related commits. Please contact your administrator.")}),test("Filenames are correctly clipped",function(){var e="long-name/averylongnameindeed/indeeditissuchaverylongnameimrathershocked/whyisitthatthefilenameisstillgoing/thisisincrediblehave/you/ever/seen/AnythingLikeIt.java",t=this.renderFromData([{repositories:[{name:"instance1-repo1",avatarDescription:"project",commits:[{fileCount:1,author:"mclovin",files:[{changeType:"BLOGGED",url:"http://example.com",path:e}]}]}]}]),i=this.getCommitRows(t.$el.find(".devstatus-detail-table")),s=i.eq(0);ok(t.$el.find(".filerow").hasClass("hidden")),t.$el.find(".file .filename").css("white-space","nowrap").css("width","300px"),s.find(".filecount a").click();var n=t.$el.find(".file .filename a").eq(0);ok(n.text().length<e.length)}),test("Test commit detail dialog renders branch tooltip",o.withFakeTimer(function(e){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewsAndBranches"]);var t=this.getCommitRows(n(".devstatus-detail-table")).eq(1),i=t.find(".branches-link");i.trigger("mouseover"),e.tick(500);var s=n(".branch-tooltip");equal(s.length,1,"Branch tooltip rendered"),ok(this.branchesShownStub.calledWith("bitbucket"),"Analytic event fired when branches tooltip rendered");var a=s.find(".branch-name-tooltip");equal(a.length,5,"All branches rendered"),equal(a.eq(0).text(),"master","Branch name rendered"),equal(a.eq(1).text(),"manybranches-test-190fds-df-very-long-branch-name-very-long-long","Branch name rendered"),equal(a.eq(2).text(),"manybranches-test-4","Branch name rendered"),equal(a.eq(3).text(),"manybranches-test-3","Branch name rendered"),equal(a.eq(4).text(),"manybranches-test-2","Branch name rendered"),equal(s.find(".branch-tooltip-summary").text(),"and 16 more","Branch summary rendered"),s.parent().parent().remove()})),test("Test commit detail dialog renders review popup",o.withFakeTimer(function(e){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewsAndBranches"]);var t=this.getCommitRows(n(".devstatus-detail-table")).eq(2),i=t.find(".reviews-link");i.mouseenter(),e.tick(500);var s=n("#inline-dialog-commit-reviews-popup-1");equal(s.length,1,"Review popup rendered"),ok(this.reviewsShownStub.calledWith("bitbucket"),"Analytic event fired when review popup rendered");var a=s.find(".inline-review-row");equal(a.length,2,"All reviews rendered"),equal(a.eq(0).find(".inline-review-id").text(),"CR-256","Review id rendered"),equal(a.eq(0).find(".inline-review-state").text(),"Open","Review state rendered"),equal(a.eq(1).find(".inline-review-id").text(),"DEF-10","Review id rendered"),equal(a.eq(1).find(".inline-review-state").text(),"Closed","Review state rendered"),a.eq(0).find("a").click(),ok(this.reviewClickedStub.calledWith("bitbucket"),"Analytic event fired when review clicked");var o=s.find(".inline-review-summary");equal(o.text(),"and 18 more","Review summary rendered"),equal(o.find("a").attr("href"),"http://lpater-dev:8060/foo/changelog/gitsample?cs=155a0e9308d7e4b06ad1ec146244980839f61951","Review summary link rendered"),o.find("a").click(),ok(this.reviewClickedStub.calledTwice,"Analytic event fired when review clicked"),s.remove()})),test("Test reviews are sorted by priority",function(){var e=this.createView(),t={id:"cs1",reviews:{totalCount:9,reviews:[{id:"CR-6",state:"CLOSED"},{id:"CR-5",state:"REJECTED"},{id:"CR-1",state:"REVIEW"},{id:"CR-3",state:"APPROVAL"},{id:"CR-4",state:"SUMMARIZE"},{id:"CR-2",state:"REVIEW"}]}};e._orderCommitReviews(t),deepEqual(s.reduce(t.reviews.reviews,function(e,t){return e.push(t.id),e},[]),["CR-1","CR-2","CR-3","CR-4","CR-5","CR-6"])}),test("Test reviews in invalid states are filtered",function(){var e=this.createView(),t={id:"cs1",reviews:{totalCount:9,reviews:[{id:"CR-6",state:"DRAFT"},{id:"CR-5",state:"DEAD"},{id:"CR-1",state:"REVIEW"},{id:"CR-3",state:"fooo"},{id:"CR-4"}]}};e._orderCommitReviews(t),equal(t.reviews.reviews.length,1,"Reviews in invalid states were filtered"),equal(t.reviews.reviews[0].id,"CR-1","Reviews in valid states were preserved")}),test("Test checking if repositories have reviews",function(){var e=this.createView(),t=[{name:"a",commits:[]},{name:"b",commits:[{id:"1"}]},{name:"c",commits:[{id:"1",reviews:null}]},{name:"d",commits:[{id:"1",reviews:void 0}]},{name:"e",commits:[{id:"1",reviews:{}}]},{name:"f",commits:[{id:"1",reviews:{totalCount:0,reviews:[]}}]},{name:"g",commits:[{id:"1",reviews:{totalCount:100,reviews:[{id:"CR-1"}]}}]},{name:"g",commits:[{id:"0"},{id:"1",reviews:{totalCount:100,reviews:[{id:"CR-1"}]}}]}];e.transformRepositories(t),ok(!t[0].showReviews,"don't show reviews if no commits"),ok(!t[1].showReviews,"dont't show reviews if no commits with review prop"),ok(!t[2].showReviews,"don't show reviews if review prop null"),ok(!t[3].showReviews,"don't show reviews if review prop undefined"),ok(t[4].showReviews,"show reviews if review object present"),ok(t[5].showReviews,"show reviews if review object present"),ok(t[6].showReviews,"show reviews if review object present"),ok(t[7].showReviews,"show reviews if review object in at least one commit")}),test("Test checking if repositories have branches",function(){var e=this.createView(),t=[{name:"a",commits:[]},{name:"b",commits:[{id:"1"}]},{name:"c",commits:[{id:"1",branches:null}]},{name:"d",commits:[{id:"1",branches:void 0}]},{name:"e",commits:[{id:"1",branches:{}}]},{name:"f",commits:[{id:"1",branches:{totalCount:0,branches:[]}}]},{name:"g",commits:[{id:"1",branches:{totalCount:100,branches:[{id:"CR-1"}]}}]},{name:"g",commits:[{id:"0"},{id:"1",branches:{totalCount:100,branches:[{id:"CR-1"}]}}]}];e.transformRepositories(t),ok(!t[0].showBranches,"don't show branches if no commits"),ok(!t[1].showBranches,"dont't show branches if no commits with branches prop"),ok(!t[2].showBranches,"don't show branches if branches prop null"),ok(!t[3].showBranches,"don't show branches if branches prop undefined"),ok(t[4].showBranches,"show branches if branches object present"),ok(t[5].showBranches,"show branches if branches object present"),ok(t[6].showBranches,"show branches if branches object present"),ok(t[7].showBranches,"show branches if branches object in at least one commit")}),test("Test checking if repositories have files",function(){var e=this.createView(),t=[{name:"a",commits:[{id:"1"}]},{name:"b",commits:[{id:"1",files:[]}]}];e.transformRepositories(t),ok(!t[0].showFiles,"don't show files if commit object has no files"),ok(t[1].showFiles,"show files if commit object has files")}),test("Test get unique commit count",function(){var e=this.createView();equal(e.getUniqueCommitCount([]),0,"no repo"),equal(e.getUniqueCommitCount([{name:"M"}]),0,"one repo no commits"),equal(e.getUniqueCommitCount([{name:"M",commits:[]}]),0,"one repo empty commits"),equal(e.getUniqueCommitCount([{name:"M",commits:[{id:void 0},{id:null},{id:"3"},{name:"name"}]}]),1,"one repo with null id"),equal(e.getUniqueCommitCount([{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),3,"one repo"),equal(e.getUniqueCommitCount([{name:"z",commits:[]},{name:"a",commits:[]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),3,"one repo with empty repo"),equal(e.getUniqueCommitCount([{name:"z",commits:[]},{name:"a",commits:[{id:"4"}]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),4,"two repos with no overlap"),equal(e.getUniqueCommitCount([{name:"z",commits:[]},{name:"a",commits:[{id:"1"},{id:"4"}]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),4,"two repos with overlap"),equal(e.getUniqueCommitCount([{name:"z",commits:[{id:"5"},{id:"3"}]},{name:"a",commits:[{id:"1"},{id:"4"}]},{name:"M",commits:[{id:"1"},{id:"2"},{id:"3"}]}]),5,"three repos with overlap")}),test("Test bitbucket detail commits dialog with success request",function(){expect(28),e.setFormat("YYYY-MM-DD");var t=this.createView(5);t.show();var i=this.getCommitDetailDialog(),a=i.content.find(".status-loading"),o=i.content.find(".tabs-pane.active-pane"),r=["repoAWESOME","repoGOOD","repoone"],l=[3,1,2];ok("block"==a.css("display"),"A spinner is visible when there is an onflight ajax request"),ok(a.children().length>0),ok(o.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request"),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("bitbucketDetailCommit-multipleRepo",this.server.requests[1]),this.assertNoErrorMessagesInCanvas();var c=i.content.find(".detail-commits-container"),d=i.content.find("tr[data-changesetid='jklmnalsotoolong']");ok("none"==a.css("display"),"A spinner is no longer visible when the onflight ajax request has completed"),ok(!o.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed"),equal(c.length,r.length,"Number of commit tables rendered into the dialog is correct"),s.each(c,s.bind(function(e,t){var i=n(e),s=i.find(".repository-link");equal(s.text(),r[t],"The repository name exist and is correct: "+t),s.click(),ok(this.repoClickedStub.called,"Analytic event is fired correctly when clicking on repo link: "+t);var a=this.getCommitRows(i.find(".commits-table"));equal(a.length,l[t],"List of commits exist and contains the correct number: "+t);var o=a.find(".changesetid");o.eq(0).click(),ok(this.commitClickedStub.called,"Analytic event is fired correctly when clicking on commit link: "+t);var c=a.find(".timestamp .livestamp");ok(0!=c.length,"Time stamp is rendered into the table"),equal(c.attr("title"),"2013-09-23","Tooltip is correctly appended onto the timestamp element: "+t)},this)),ok(d.hasClass("merge"),"Merge commit is correctly displayed"),equal(d.find(".aui-lozenge.merge").length,1,"Merge row is correctly appended with a merge lozenge")}),test("Test bitbucket detail commits dialog with success request with one repo",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-oneRepo"],2),this.assertNoErrorMessagesInCanvas();var e=this.getCommitDetailDialog().content.find(".detail-commits-container");equal(e.length,1,"One commit table is rendered into the dialog"),equal(e.find(".repository-link").text(),"repoone","The repository name exist and is correct")}),test("Test bitbucket detail commits dialog with success request and errors",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-multipleRepoWithErrors"],2),equal(this.server.requests.length,3,"A third request was sent"),ok(this.server.requests[2].url.indexOf("/provider/auth-status")>0,"The third request was to re-fetch auth status"),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[2]),this.assertNoNoPermissionMessage();var e=this.getCommitDetailDialog();equal(e.content.find(".detail-commits-container").length,3,"There are still commits visible with errors"),equal(e.content.find(".authentication-problem h2").length,0,"No authenticate message is shown when there is data"),equal(e.content.find(".connection-problem h2").length,0,"No connection message is shown in full canvas when there is data"),equal(e.content.find(".aui-message-warning").length,1,"Connection message is prepended to commit table when there is connection problem");var t=e.content.find(".aui-message-warning").text();ok(t.indexOf("JIRA is having difficulty contacting")>=0&&t.indexOf("If this condition persists, please contact your ")>=0,"Correct connection message is prepended to commit table when there is connection problem")}),test("Test bitbucket detail commits dialog with only authentication errors",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit3LO-stashUnauthorizedError"]),equal(this.server.requests.length,3,"A third request was sent"),ok(this.server.requests[2].url.indexOf("/provider/auth-status")>0,"The third request was to re-fetch auth status"),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[2]);var e=this.getCommitDetailDialog();equal(e.content.find(".detail-commits-container").length,0,"There is no commits table on ajax request without data"),equal(e.content.find(".authentication-problem h2").text(),"Authenticate to see related commits","Authentication message is shown when there's no data and with authentication problem")}),test("Test bitbucket detail commits dialog with only connection errors",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit3LO-stashOtherError"]),equal(this.server.requests.length,2,"No auth status re-fetch request was sent");var e=this.getCommitDetailDialog();equal(e.content.find(".detail-commits-container").length,0,"There is no commits table on ajax request without data"),equal(e.content.find(".connection-problem h2").text(),"Unable to retrieve commit information","Connection message is shown in full canvas when there's no data and with connection problem")}),test("Test bitbucket detail commits dialog with success but no permission to view any commits",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-empty"],1);var e=this.getCommitDetailDialog();equal(e.content.find(".detail-commits-container").length,0,"There is no commits table on fail ajax request"),equal(e.content.find(".no-permission-to-view-all").text(),"You don't have access to view all related commits. Please contact your administrator.","No permission message is shown in full canvas where there's no data")}),test("Test bitbucket detail commits dialog with success but no permission to view some commits",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-multipleRepo"],6),this.assertNoConnectionErrorWarning();var e=this.getCommitDetailDialog();ok(e.content.find(".detail-commits-container").length>0,"There are commits visible"),equal(e.content.find(".no-permission-to-view-all").text(),"You don't have access to view all related commits. Please contact your administrator.","No permission message is shown in full canvas where there's no data")}),test("Test bitbucket detail commits dialog with fail request",function(){this.renderViewFromContracts(["detailCommit3LO-stash","bitbucketDetailCommit-failRequest"]);var e=this.getCommitDetailDialog();equal(e.content.find(".detail-commits-container").length,0,"There is no commits table on fail ajax request"),equal(e.content.find(".connection-problem h2").text(),"Unable to retrieve commit information","A message is shown when ajax request failed")}),test("Test review creation for changeset",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation"]);var e=this.getCommitDetailDialog(),t=e.content.find(".commits-table .create-review-commit a");t.click(),equal(t.length,1,"Create review link rendered"),equal(t.eq(0).attr("href"),"http://fecru/cru/create?repo=gitsample&csid=3da7cf6a980221195e9d09dd80c30c3a002a0c54","Correct href rendered"),ok(this.createReviewClicked.calledWith("bitbucket",!1))}),asyncTest("Test review creation for single instance",function(){var e=this;this.sandbox.stub(t,"navigate"),this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation"]);var i=this.getCommitDetailDialog(),s=i.content.find(".create-review-instance a");equal(s.length,1,"Create review link rendered"),s.eq(0).click(),this.checkForRequestWithNumRetries(2,function(){equal(e.server.requests.length,3,"Request for targets sent"),AJS.TestContractManager.respondToRequest("createReviewDialog-targets",e.server.requests[2]),equal(n("#devstatus-cta-create-review-dialog:visible").length,0,"No dialog shown"),ok(t.navigate.called,"Navigate called"),equal(t.navigate.getCall(0).args[0],"http://lpater-dev:8060/foo/cru/create?issueKey=DEF-1&issueSummary=1&issueDescription=This+is+an+issue+descriptopn","Navigated to the right url"),ok(e.createReviewClicked.calledWith("bitbucket",!0))})}),asyncTest("Test review creation for multiple instances",function(){this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation-twoInstances"]);var e=this.getCommitDetailDialog(),t=this,i=e.content.find(".create-review-instance a");equal(i.length,1,"Create review link rendered"),i.eq(0).click(),this.checkForRequestWithNumRetries(2,function(){equal(t.server.requests.length,3,"Request for targets sent"),AJS.TestContractManager.respondToRequest("createReviewDialog-targets",t.server.requests[2]),n("#devstatus-cta-create-review-dialog .target").eq(0).click(),equal(n("#devstatus-cta-create-review-dialog").length,1,"Choose instance dialog shown"),equal(n("#devstatus-cta-create-review-dialog .target").length,2,"Two instances shown in the picker"),equal(n("#devstatus-cta-create-review-dialog .target .title").eq(0).text(),"lpater-dev","Instance name shown"),equal(n("#devstatus-cta-create-review-dialog .target .title").eq(1).text(),"lpater-dev-2","Instance name shown"),ok(!n("#devstatus-cta-create-review-dialog .target").eq(0).hasClass("selected"),"Primary instance picked by default"),ok(n("#devstatus-cta-create-review-dialog .target").eq(1).hasClass("selected"),"Primary instance picked by default"),ok(t.createReviewClicked.calledWith("bitbucket",!0))})}),test("Test review creation works by following link - single instance",function(){a.set("fusion-open-detail-dialog","create-review-bitbucket"),this.sandbox.stub(t,"navigate"),this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation","createReviewDialog-targets"]);this.getCommitDetailDialog();ok(t.navigate.called,"Navigate called"),equal(t.navigate.getCall(0).args[0],"http://lpater-dev:8060/foo/cru/create?issueKey=DEF-1&issueSummary=1&issueDescription=This+is+an+issue+descriptopn","Navigated to the right url")}),test("Test review creation works by following link - multiple instances",function(){a.set("fusion-open-detail-dialog","create-review-bitbucket"),this.renderViewFromContracts(["detailCommit3LO-stash","detailCommit-reviewCreation-twoInstances","createReviewDialog-targets"]);this.getCommitDetailDialog();equal(n("#devstatus-cta-create-review-dialog:visible").length,1,"Choose instance dialog shown")}),test("Test create review instances not shown if no link from remote",function(){var e=this.renderFromData([{repositories:[{name:"foo",commits:[]}],_instance:{name:"theta"}},{repositories:[{name:"foo",commits:[{author:"lpater"}]}],_instance:{name:"zeta"}},{repositories:[{name:"foo",commits:[{createReviewUrl:"http://review",author:"lpater"}]}],_instance:{name:"eta"}},{repositories:[],_instance:{name:"teta"}}]);deepEqual(s.pluck(e.createReviewDialog.instances,"name"),["eta"])}),test("Heading text for commits contains no duplicates",function(){var e=this.createView();e.show();var t=this.getCommitDetailDialog();equal(t.heading.text(),this.issueKey+": 10 unique commits")}),test("Heading text for commits contains duplicates",function(){var e=this.createView();e.model.set("tabs",{bitbucket:{name:"Bitbucket",count:7},stash:{name:"Stash",count:6}}),e.show();var t=this.getCommitDetailDialog();equal(t.heading.text(),this.issueKey+": 10 unique commits (and 3 duplicates)")}),test("No links rendered if urls missing",function(){var e=this.renderFromData([{repositories:[{name:"django-piston",commits:[{id:"0694841",displayId:"0694841",message:"foo",fileCount:10,author:{name:"fff"},files:[{path:"README"}]}]}]}]),t=e.$el.find(".repository-link"),i=e.$el.find(".commitrow"),s=e.$el.find(".filerow"),n=e.$el.find(".more-files-info");equal(t.find("a").length,0,"Repo header not rendered as a link"),equal(t.text(),"django-piston","Repo name rendered"),equal(i.find("td.changeset a").length,0,"Csid not rendered as a link"),equal(i.find("td.changeset").text(),"0694841","Csid rendered"),equal(s.find("a").length,0,"Filename not rendered as a link"),equal(s.find(".filename").text(),"README","Filename rendered"),equal(n.find("a").length,0,"More row not rendered as a link"),equal(n.text(),"and 9 more","More row has the right file count")})});