"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-contract-test-resource","com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e,t=require("util/DateUtils"),s=require("qunit/TestUtils"),i=require("viewissue/dialog/DetailDialogBranchView"),a=require("underscore"),n=require("jquery");module("JIRA.DevStatus.DetailDialogBranchView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create(),this.issueKey="DEV-1",this.issueId=1e4,this.server=sinon.fakeServer.create(),e=s.spyAnalyticMethods("Branches",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),this.livestamp=n.fn.livestamp,n.fn.livestamp=sinon.spy()},teardown:function(){this.sandbox.restore(),this.server.restore(),s.cleanAllDialogs(),n("body").css("overflow","initial"),n.fn.livestamp=this.livestamp},getDetailDialog:function(){var e=n(".jira-dialog");return{heading:e.find(".devstatus-dialog-heading"),content:e.find(".devstatus-dialog-content"),getBranchContainer:function(){return this.content.find(".detail-branches-container")},getRows:function(){return this.getBranchContainer().find(".branch-row")},getColumns:function(e){var t=n(e);return{repository:t.find(".repository"),branch:t.find(".branch"),review:t.find(".review"),pullRequest:t.find(".pullrequest"),action:t.find(".action"),changeset:t.find(".changeset"),lastUpdated:t.find(".last-updated time")}},getLinks:function(e){var t=this.getColumns(e);return{repository:t.repository.find(".repository-link"),branch:t.branch.find(".branch-link"),pullRequest:t.pullRequest.find(".pullrequest-link"),createPullRequest:t.action.find(".create-pullrequest-link"),createReview:t.action.find(".create-review-link"),changeset:t.changeset.find(".changeset-link")}},getPullRequestInlineDialog:function(e){return{rowsElement:e.find("tr"),rowsValue:function(){var e=[];return a.each(this.rowsElement,function(t){var s=n(t);e.push({name:s.find(".pullrequest-name").text(),state:s.find(".pullrequest-state").text()})}),e}}},getReviewsInlineDialog:function(e,t){t.mouseenter().mousemove(),e.tick(500);var s=n(".aui-inline-dialog");return equal(s.length,1,"Should find exactly one popup"),{reviewsPopup:s,reviewRows:s.find(".inline-review-row"),moreCell:s.find(".inline-review-summary"),moreLink:s.find(".inline-review-summary a"),remove:function(){s.remove()}}},getNoPermissionToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all")}}},createView:function(e,t){return this.view=new i({count:10,issueKey:this.issueKey,issueId:this.issueId,el:t,tabs:{bitbucket:{name:"Bitbucket",count:e||9}}}),this.view},setAnalyticsDataForView:function(e,t){this.view.analyticIssueData={isAssignee:e,isAssignable:t}},assertNoNoPermissionMessage:function(){ok(0===this.getDetailDialog().content.find(".no-permission-to-view-all").length,"There is NO no-permission-to-view message")},assertNoConnectionErrorWarning:function(){ok(0===this.getDetailDialog().content.find(".aui-message-warning:has(.connection-error)").length,"There is NO connection error message")},assertNoErrorMessagesInCanvas:function(){this.assertNoNoPermissionMessage(),this.assertNoConnectionErrorWarning()},renderFromData:function(e){var t="fecru",s=n("#qunit-fixture");s.html('<div id="tab-content-'+t+'"><div class="detail-content-container"></div></div>');var i=this.createView(1,s);return i.renderSuccess(t,e),i}}),test("Test content table is not rendered when JSON response empty",function(){var e=this.createView(),t=n('<div class="jira-dialog"></div>').appendTo(n("#qunit-fixture")),s=n('<div class="devstatus-dialog-content"></div>').appendTo(t);e.getContentContainer=this.sandbox.stub().returns(s),e.renderSuccess("bitbucket",[]);var i=this.getDetailDialog();equal(i.getBranchContainer().length,0,"Dialog container doesn't exists"),equal(i.getRows().length,0,"Table/rows are not rendered into the dialog"),equal(i.getNoPermissionToViewAllMessage().length,1,"Contains no permission to view all message")}),test("Test lock screen renders if no data would be displayed",function(){var e="fecru",t={detail:[{branches:[]}]},s=this.createView(),i=n("#qunit-fixture");i.html('<div id="tab-content-'+e+'"><div class="detail-content-container"></div></div>'),s.$el=i,s.renderSuccess=this.sandbox.spy(),s._handleFetchSucceeded(e,t),ok(s.renderSuccess.neverCalledWith(e,t.detail));var a=s.getContentContainer(e),o=a.find(".no-permission-to-view-all");ok(o.find(".lock-image").length>0,"has lock image"),equal(o.text(),"You don't have access to view all related branches. Please contact your administrator.")}),test("Test responses from multiple connected products are combined and sorted",function(){var e=this.createView();e.template=this.sandbox.spy(),e.getContentContainer=this.sandbox.stub().returns(n("<div></div>")),e.renderSuccess("product",[{branches:[{name:"D",pullRequests:[],repository:[]},{name:"C",pullRequests:[],repository:[]}]},{branches:[{name:"B",pullRequests:[],repository:[]}]}]),deepEqual(e.template.getCall(0).args[0].branches,[{name:"B",pullRequests:[],repository:[],pullRequestState:{data:"[]",status:void 0,total:0}},{name:"C",pullRequests:[],repository:[],pullRequestState:{data:"[]",status:void 0,total:0}},{name:"D",pullRequests:[],repository:[],pullRequestState:{data:"[]",status:void 0,total:0}}])}),test("Test list of branches are ordered by repository name and then branch name",function(){var e=this.createView();deepEqual(e._sortBranchesByName([{name:"D",repository:{name:"B"},pullRequests:[{id:"#4",name:"a"},{id:"#3",name:"b"}]},{name:"C",repository:{name:"B"},pullRequests:[]},{name:"C",repository:{name:"0"},pullRequests:[]},{name:"D",repository:{name:"0"},pullRequests:[]},{name:"B",repository:{name:"0"},pullRequests:[]}]),[{name:"B",repository:{name:"0"},pullRequests:[]},{name:"C",repository:{name:"0"},pullRequests:[]},{name:"D",repository:{name:"0"},pullRequests:[]},{name:"C",repository:{name:"B"},pullRequests:[]},{name:"D",repository:{name:"B"},pullRequests:[{id:"#4",name:"a"},{id:"#3",name:"b"}]}])}),test("List of pull requests are summarised for branch",function(){var e=this.createView();deepEqual(e._populatePullRequestStateByBranch([{name:"D",url:"http://somelocation.com"},{name:"C",url:"http://somelocation2.com"},{name:"A",url:"http://somelocation3.com"}],[{status:"MERGED",source:{url:"http://somelocation.com"}},{status:"DECLINED",source:{url:"http://somelocation.com"}},{status:"OPEN",url:"http://url.com",source:{url:"http://somelocation2.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"OPEN",source:{url:"http://somelocation3.com"}},{status:"DECLINED",source:{url:"http://somelocation3.com"}}]),[{name:"D",url:"http://somelocation.com",pullRequestState:{data:JSON.stringify([{status:"MERGED",source:{url:"http://somelocation.com"}},{status:"DECLINED",source:{url:"http://somelocation.com"}}]),status:"MERGED",total:2}},{name:"C",url:"http://somelocation2.com",pullRequestState:{data:JSON.stringify([{status:"OPEN",url:"http://url.com",source:{url:"http://somelocation2.com"}}]),status:"OPEN",total:1}},{name:"A",url:"http://somelocation3.com",pullRequestState:{data:JSON.stringify([{status:"OPEN",source:{url:"http://somelocation3.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"MERGED",source:{url:"http://somelocation3.com"}},{status:"DECLINED",source:{url:"http://somelocation3.com"}}]),status:"OPEN",total:4}}])}),test("Sort pull requests by status",function(){var e=this.createView();deepEqual(e._sortPullRequestsByStatus([{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.083+1100"},{status:"OPEN",lastUpdated:"2013-11-15T16:52:40.081+1100"}]),[{status:"OPEN",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.083+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"MERGED",lastUpdated:"2013-11-15T16:52:40.081+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.082+1100"},{status:"DECLINED",lastUpdated:"2013-11-15T16:52:40.081+1100"}])}),test("Branches with null repository is not rendered",function(){this.issueKey="DEV-2",this.issueId=10001;var e=this.createView(4);e.show(),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-nullRepo",this.server.requests[1]);var t=this.getDetailDialog();equal(t.getRows().length,0,"No branch is rendered onto the dialog")}),test("Test detail branch dialog with success request",function(){expect(63),t.setFormat("YYYY-MM-DD");var e=this.createView(4);e.show();var s=this.getDetailDialog(),i=s.content.find(".status-loading"),n=s.content.find(".tabs-pane.active-pane");ok("block"==i.css("display"),"A spinner is visible when there is an onflight ajax request"),ok(i.children().length>0),ok(n.hasClass("loading"),"Dialog content is faded out when there is an onflight ajax request"),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]),this.assertNoErrorMessagesInCanvas(),ok("none"==i.css("display"),"A spinner is no longer visible when the onflight ajax request has completed"),ok(!n.hasClass("loading"),"Dialog content is no longer faded out when ajax has completed"),equal(s.getRows().length,5,"Number of branch rows rendered into the table is correct");var o=[0];a.each(s.getRows(),function(e,t){var i=s.getColumns(e);ok(!a.isEmpty(i.repository.text()),"Repository column is not empty"),ok(null!=i.repository.find("a"),"Repository content is a link"),equal(i.repository.find("a").attr("href"),"https://bitbucket.org/fusiontestaccount/ddd-one","Repository content has a link");var n=i.branch.text();ok(!a.isEmpty(n),"Branch column is not empty"),ok(null!=i.branch.find("a"),"Branch content is a link"),equal(i.branch.find("a").attr("href"),"https://bitbucket.org/fusiontestaccount/ddd-one/branch/"+encodeURIComponent(n),"Branch content has a link"),a.contains(o,t)?ok(a.isEmpty(i.pullRequest.text()),"Pullrequest column is empty"):ok(!a.isEmpty(i.pullRequest.text()),"Pullrequest column is not empty"),ok(!a.isEmpty(i.action.text()),"Action column is not empty"),ok(null!=i.action.find("a"),"Action content is a link"),ok(i.action.find("a").attr("href").indexOf("https://bitbucket.org/fusiontestaccount/ddd-one/pull-requests/new")!==-1,"Action content has a link")}),ok(!a.isObject(e.activePullRequestsToolTip),"PullRequestsToolTip is NOT created when the pull request link is NOT hovered"),s.getColumns(s.getRows()[1]).pullRequest.find(".pullrequest-tooltip").mouseenter(),ok(a.isObject(e.activePullRequestsToolTip),"PullRequestsToolTip is created when the pull request link is hovered");var r=s.getPullRequestInlineDialog(e.activePullRequestsToolTip.$content);equal(r.rowsElement.length,3,"number of statuses in tooltip is correct"),deepEqual(r.rowsValue(),[{name:"#6 DEV-1 everything is nice and good and i did not forget to add issue key to commit message and PR title",state:"OPEN"},{name:"#5 DEV-1 everything is nice and good and i did not forget to add issue key to commit message and PR title",state:"MERGED"},{name:"#4 DEV-1 everything is nice and good and i did not forget to add issue key to commit message and PR title",state:"DECLINED"}],"tooltip content is correct"),s.getColumns(s.getRows()[1]).pullRequest.find(".pullrequest-tooltip").mouseleave(),ok(!e.activePullRequestsToolTip.visible,"PullRequestsToolTip is hidden when mouse is removed")}),test("Test detail branch dialog with last commit details",function(){var e=this.createView(3);e.show(),AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-lastCommit",this.server.requests[1]);var t=this.getDetailDialog();equal(t.getRows().length,1,"Rendered rows");var s=t.getRows()[0];equal(t.getColumns(s).lastUpdated.attr("datetime"),"1385729932000"),equal(t.getLinks(s).changeset.text(),"1f79b9a"),equal(t.getLinks(s).changeset.attr("href"),"http://lpater-dev:8060/foo/changelog/gitsample?cs=1f79b9a3f334ee9db41d30193a3b3ceae7da7899"),ok(!t.getColumns(s).action.length),ok(!t.getColumns(s).pullRequest.length)}),test("Test getting branch features",function(){var e=this.createView(3),t=[{}],s=[{pullRequestState:{total:1}}],i=[{lastCommit:{displayId:"faf",authorTimestamp:"abc"}}],a=[{lastCommit:{displayId:"faf"}}],n=[{lastCommit:{displayId:"faf",authorTimestamp:"abc"},createPullRequestUrl:"http://foo"}],o=[{createReviewUrl:"http://review"}],r=[{lastCommit:{displayId:"faf",authorTimestamp:"abc"},reviews:{totalCount:6}}],l=e._getBranchFeatures(t),u=e._getBranchFeatures(s),c=e._getBranchFeatures(i),d=e._getBranchFeatures(a),h=e._getBranchFeatures(n),m=e._getBranchFeatures(o),p=e._getBranchFeatures(r);ok(!l.lastCommitId),ok(!l.lastCommitTimestamp),ok(!l.pullRequests),ok(!l.reviews),ok(!u.lastCommitId),ok(!u.lastCommitTimestamp),ok(u.pullRequests),ok(!u.reviews),ok(c.lastCommitId),ok(c.lastCommitTimestamp),ok(!c.pullRequests),ok(!c.reviews),ok(d.lastCommitId),ok(!d.lastCommitTimestamp),ok(!d.pullRequests),ok(!d.reviews),ok(h.lastCommitId),ok(h.lastCommitTimestamp),ok(h.pullRequests),ok(!h.reviews),ok(!m.lastCommitId),ok(!m.lastCommitTimestamp),ok(!m.pullRequests),ok(m.reviews),ok(p.lastCommitId),ok(p.lastCommitTimestamp),ok(!p.pullRequests),ok(p.reviews)}),test("Test analytics for branch detail dialog",function(){function t(e,t,s){ok(e,s),ok(t,s)}function s(s,i){var n=e.BranchesAnalytics[s].getCall(i),o=a.isObject(n),r=o&&n.calledWith("bitbucket"),l="Analytic event is fired for "+s+" link on row "+(i+1);t(o,r,l)}function i(s,i){var a=e.BranchesAnalytics.fireDetailPullRequestLozengeClick,n=a.called,o=n&&a.calledWith("bitbucket"),r="";i&&(n=!n,o=!o,r=" NOT");var l="Analytics for pull request click is"+r+" called for row "+(s+1);t(n,o,l),a.reset()}function n(s,i,a){var n=e.BranchesAnalytics.fireDetailCreatePullRequestClicked,o="Analytics for create pull request is called for row "+(s+1)+" ("+i+", "+a+")";t(n.called,n.calledWith("bitbucket",i,a),o),n.reset()}expect(61);var o=this.createView(4);o.show();var r=this.getDetailDialog();AJS.TestContractManager.respondToRequest("detailCommit3LO-stash",this.server.requests[0]),AJS.TestContractManager.respondToRequest("detailBranchPullRequest-multiple",this.server.requests[1]),equal(r.getRows().length,5,"Number of branch rows rendered into the table is correct");var l=this,u=[0];a.each(r.getRows(),function(e,t){var o=r.getLinks(e);o.repository.click(),s("fireDetailRepoClicked",t),o.branch.click(),s("fireDetailBranchClicked",t),o.pullRequest.click(),i(t,a.contains(u,t)),l.setAnalyticsDataForView(!0),o.createPullRequest.click(),n(t,!0),l.setAnalyticsDataForView(!1,!0),o.createPullRequest.click(),n(t,!1,!0),l.setAnalyticsDataForView(!1,!1),o.createPullRequest.click(),n(t,!1,!1)})}),test("No links rendered if urls missing",function(){var e=this.renderFromData([{branches:[{repository:{name:"django-piston"},name:"default",lastCommit:{id:"c4b2d21",displayId:"c4b2d21"}}]}]),t=e.$el.find(".branch-row");equal(t.find("a").length,0,"No links rendered"),equal(t.find(".repository").text(),"django-piston","Repo name rendered"),equal(t.find(".branch").text(),"default","Branch name rendered"),equal(t.find(".changeset").text(),"c4b2d21","Csid rendered")});var o=[{branches:[{repository:{name:"repo-with-branch-reviews"},name:"FECRU-1234-reviewed-branch",createReviewUrl:"http://crucible/cru/create?reviewedBranch=FECRU-1234-reviewed-branch&repository=repo-with-branch-reviews"}]}];test("Should render create review links if available",function(){var e=this.renderFromData(o),t=this.getDetailDialog(),s=e.$el.find(".branch-row");equal(t.getLinks(s).createReview.text(),"Create review"),equal(t.getLinks(s).createReview.attr("href"),"http://crucible/cru/create?reviewedBranch=FECRU-1234-reviewed-branch&repository=repo-with-branch-reviews")}),test("Should send analytics event when create review clicked",function(){var t=this.renderFromData(o),s=t.$el.find(".branch-row");this.getDetailDialog().getLinks(s).createReview.click(),ok(e.BranchesAnalytics.fireDetailCreateReviewClicked.called,"Called analytics method when create review clicked")});var r=[{branches:[{repository:{name:"repo-with-branch-reviews"},name:"FECRU-1234-reviewed-branch",reviews:{totalCount:11,reviews:[{id:"CR-FE-8006",url:"https://fisheye.dev.internal.atlassian.com/cru/CR-FE-8006",state:"CLOSED",title:"title1"},{id:"CR-FE-8012",url:"https://fisheye.dev.internal.atlassian.com/cru/CR-FE-8012",state:"REVIEW",title:"title2"}],url:"http://moremoremore"}},{repository:{name:"repo-with-branch-reviews"},name:"FECRU-5678-other-branch",reviews:{totalCount:14,reviews:[{id:"CR-FE-8006",url:"https://fisheye.dev.internal.atlassian.com/cru/CR-FE-8006",state:"SUMMARIZE",title:"title1"}]}},{repository:{name:"repo-with-branch-reviews"},name:"FECRU-5678-other-branch",reviews:{totalCount:1,reviews:[{id:"CR-FE-8006",url:"https://fisheye.dev.internal.atlassian.com/cru/CR-FE-8006",state:"SUMMARIZE",title:"title1"}]}}]}];test("Should render review state if available",function(){var e=this.renderFromData(r),t=this.getDetailDialog(),s=e.$el.find(".branch-row").eq(0),i=e.$el.find(".branch-row").eq(1);equal(t.getColumns(s).review.text(),"Open"),equal(t.getColumns(i).review.text(),"Summarize")}),test("Should show popup with review list when hovered",s.withFakeTimer(function(t){var s=this.renderFromData(r),i=s.$el.find(".branch-row .review-link").eq(0),a=this.getDetailDialog().getReviewsInlineDialog(t,i),n=a.reviewRows.eq(0),o=a.reviewRows.eq(1);equal(a.reviewsPopup.length,1,"Review popup rendered"),equal(a.reviewRows.length,2,"All reviews shown"),equal(n.find(".inline-review-id").text(),"CR-FE-8012","Review id rendered"),equal(n.find(".inline-review-state").text(),"Open","Review state rendered"),equal(o.find(".inline-review-id").text(),"CR-FE-8006","Review id rendered"),equal(o.find(".inline-review-state").text(),"Closed","Review state rendered"),equal(a.moreLink.attr("href"),"http://moremoremore"),equal(a.moreLink.text(),"and 9 more"),n.find("a").click(),ok(e.BranchesAnalytics.fireDetailReviewLozengeClick.called,"Triggered analytic event when review clicked"),a.remove()})),test("Should show the 'and more' text in popup as plain text if no link provided",s.withFakeTimer(function(e){var t=this.renderFromData(r),s=t.$el.find(".branch-row .review-link").eq(1),i=this.getDetailDialog().getReviewsInlineDialog(e,s);equal(i.moreLink.length,0,"No 'more' link rendered if not provided"),ok(i.moreCell.text(),"and 13 more","More message still shown"),i.remove()})),test("Should show no 'and more' text if all the reviews were shown",s.withFakeTimer(function(e){var t=this.renderFromData(r),s=t.$el.find(".branch-row .review-link").eq(2),i=this.getDetailDialog().getReviewsInlineDialog(e,s);equal(i.moreLink.length,0,"No 'more' link rendered if all reviews rendered"),equal(i.moreCell.length,0,"No 'more' text rendered if all reviews rendered"),i.remove()}))});