"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:devstatus-qunit-test-utils","com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){var e,t=require("viewissue/dialog/BaseDetailDialogModel"),s=require("viewissue/dialog/BaseDetailDialogView"),i=require("underscore"),a=require("jquery"),n=require("qunit/TestUtils");module("JIRA.DevStatus.BaseDetailDialogView",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create(),this.issueKey="AWESOME-1",this.model=this._mockOfClass(t),this.mockLocalStorage={getItem:function(e){},setItem:function(e,t){}},this.context=AJS.test.mockableModuleContext(),this.context.mock("util/DevStatusLocalStorage",this.mockLocalStorage),s=this.context.require("viewissue/dialog/BaseDetailDialogView"),e=n.spyAnalyticMethods("Summary",this.sandbox),this.context.mock("analytics/devstatus-analytics",e),this.livestamp=a.fn.livestamp,a.fn.livestamp=sinon.spy()},teardown:function(){this.sandbox.restore(),n.cleanAllDialogs(),a("body").css("overflow","initial"),a.fn.livestamp=this.livestamp},testFinish:function(e){n.testFinish(e,this)},waitUntilElementIsVisible:function(e,t,s){n.waitUntilElementIsVisible(e,t,s,this)},getDevStatusDetailDialog:function(){var e=a(".jira-dialog");return{content:e.find(".devstatus-dialog-content"),footer:e.find(".buttons-container.form-footer"),getUnableToViewAllMessage:function(){return this.content.find(".no-permission-to-view-all").text()}}},createView:function(t){t||(t={});var i=new s(t);return i.analytics=e.SummaryAnalytics,i},createDefaultView:function(e){return this.createCommitView(e)},createCommitView:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:2;return this.createView({type:"commit",model:this.model,count:e,issueKey:this.issueKey})},createBranchView:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:2;return this.createView({type:"branch",model:this.model,count:e,issueKey:this.issueKey})},_mockOfClass:function(e){var t={};return i.each(i.functions(e.prototype),function(e){t[e]=sinon.stub()}),t},assertVisible:function(e,t){ok(e.is(":visible")&&!e.hasClass("hidden"),t)},assertInvisible:function(e,t){ok(!e.is(":visible")||e.hasClass("hidden"),t)},setupViewForOAuthDanceErrorTest:function(){var e=this.createDefaultView(1234);this.model.get.withArgs("tabs").returns(this.defaultTabs),e.show()},mockApplinkProperties:function(){return{id:1234,appUri:"appUri",appName:"appName",appType:"appType"}},mockMessagesForAdmin:function(){return{adminError:"Some error to show to an admin",adminErrorDetails:["detail 1","detail 2"]}},mockMessagesForAdminWithoutDetails:function(){return{adminError:"Some error to show to an admin"}},mockMessagesForUser:function(){return{userError:"Some error to show to a user"}},assertThatTheErrorDetailsAreCorrect:function(e,t){e.length!==t.length&&ok(!1,"the actual error details did not match the expected");for(var s=0;s<t.length;s++)for(var i=0;i<e.length&&t[s]!==a(e[i]).text();i++)i===e.length-1&&ok(!1,"the actual error details did not match the expected")},assertThisTabAsOnlyActiveTab:function(e,t){var s=t.content.find(".tabs-menu").find(".menu-item"),n=t.content.find(".form-body").find(".tabs-pane"),r=i.filter(s,function(e,t){return a(e).hasClass("active-tab")});ok(1===r.length,"Only one tab should be active at a time"),ok(r[0].id==="tab-menu-"+e,"Correct tab active when "+e+" is stored");var o=i.filter(n,function(e,t){return a(e).hasClass("active-pane")});ok(1===o.length,"Only one pane should be active at a time"),ok(o[0].id==="tab-content-"+e,"Correct pane active when "+e+" is stored")},defaultTabOrder:["bitbucket","fecru","stash"],defaultTabs:{bitbucket:{count:5e3,name:"Bitbucket"},fecru:{count:1,name:"Fisheye / Crucible"},stash:{count:99,name:"Stash"}},sourceStash1:{typeName:"Stash",type:"stash",name:"Stash Dev One",baseUrl:"https://stash1.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc91"},sourceStash2:{typeName:"Stash",type:"stash",name:"Stash Dev Two",baseUrl:"https://stash2.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc92"},sourceStash3:{typeName:"Stash",type:"stash",name:"Stash Dev Three",baseUrl:"https://stash3.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc93"},sourceStash4:{typeName:"Stash",type:"stash",name:"Stash Dev Four",baseUrl:"https://stash4.dev.atlassian.com",applicationLinkId:"62153ed0-1c05-3f55-886f-d46708ffcc94"}}),test("Test default values are set when not provided",function(){var e=this.createView();ok(i.isObject(e.model),"A detail dialog model is created if not provided"),ok(null!=e.options.width,"Width parameter is defined if not provided")}),test("Test default values are NOT set when width is provided",function(){var e=this.createView({model:this.model,width:9e3});equal(e.model,this.model,"Provided dialog model parameter is respected"),equal(e.options.width,9e3,"Provided width parameter is respected")}),test("Tabs are ordered and keep data attributes",function(){this.model.get.withArgs("tabs").returns({y:{foo:10},a:{},z:{bar:20},b:{}}),console.log(this.createDefaultView()._convertTabsForSoy()),deepEqual(this.createDefaultView()._convertTabsForSoy(),[{type:"a"},{type:"b"},{type:"y",foo:10},{type:"z",bar:20}])}),test("Tabs are not rendered when there is only one product",function(){var e={bitbucket:{count:5e3}};this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView(1);t.show(),ok(this.model.switchTab.calledWith("bitbucket"),"The initial ajax call is made on show()");var s=this.getDevStatusDetailDialog(),i=s.content.find(".tabs-menu");equal(i.find(".menu-item").length,1,"There is only one tab"),ok(null!=i,"Tabs menu element exist"),this.assertInvisible(i,"Tabs menu is not visible")}),test("Tabs are rendered when there are more than one product",function(){expect(13);var e=this,t=this.defaultTabOrder,s=this.defaultTabs;this.model.get.withArgs("tabs").returns(s);var n=this.createDefaultView(99999);n.show(),ok(this.model.switchTab.calledWith("bitbucket"),"The initial ajax call is made on show()");var r=this.getDevStatusDetailDialog(),o=r.content.find(".tabs-menu"),h=o.find(".menu-item");ok(null!=o,"Tabs menu element exist"),this.assertVisible(o,"Tabs menu is visible"),equal(h.length,3,"There are three tabs"),i.each(h,function(i,n){var r=t[n],o=a(i);equal(o.text(),s[r].name+s[r].count,"Tabs content is correct with app name + count"),o.children().click(),ok(e.model.switchTab.calledWith(r,!1),"Tab clicks are propagated properly back to the model without forceFetch"),e.model.switchTab.reset()}),n.shouldRefreshOnTabSwitch=function(){return!0},i.each(h,function(s,i){var n=t[i],r=a(s);r.children().click(),ok(e.model.switchTab.calledWith(n,!0),"Tab clicks are propagated properly back to the model with forceFetch"),e.model.switchTab.reset()})}),test("Clicked tab is stored locally by project and by view type",function(){var e=this;expect(3),sinon.spy(this.mockLocalStorage,"setItem"),this.model.get.withArgs("tabs").returns(this.defaultTabs);var t=this.defaultTabOrder,s=this.createDefaultView(99999);s.show();var n=this.getDevStatusDetailDialog(),r=n.content.find(".tabs-menu"),o=r.find(".menu-item"),h=this.issueKey.split("-")[0],c=s.options.type;i.each(o,function(s,i){var n=t[i],r=a(s);r.children().click(),ok(e.mockLocalStorage.setItem.calledWith("stored-tab-"+h+"-"+c,n),n+" was clicked and stored correctly under: stored-tab-"+h+"-"+c),e.model.switchTab.reset()}),this.mockLocalStorage.setItem.restore()}),test("The correct tab is rendered if there is a last tab stored",function(){var e=this;expect(12),sinon.stub(this.mockLocalStorage,"getItem"),this.model.get.withArgs("tabs").returns(this.defaultTabs);var t=this.defaultTabOrder;i.each(t,function(t){e.mockLocalStorage.getItem.withArgs("stored-tab-AWESOME-commit").returns(t),e.createDefaultView(99999).show(),e.assertThisTabAsOnlyActiveTab(t,e.getDevStatusDetailDialog()),e.model.switchTab.reset()}),this.mockLocalStorage.getItem.restore()}),test("Different view types render independently stored tabs",function(){expect(8),sinon.stub(this.mockLocalStorage,"getItem"),this.mockLocalStorage.getItem.withArgs("stored-tab-AWESOME-commit").returns("stash"),this.mockLocalStorage.getItem.withArgs("stored-tab-AWESOME-branch").returns("fecru"),this.model.get.withArgs("tabs").returns(this.defaultTabs),this.createCommitView(99999).show(),this.assertThisTabAsOnlyActiveTab("stash",this.getDevStatusDetailDialog()),this.model.switchTab.reset(),this.createBranchView(99999).show(),this.assertThisTabAsOnlyActiveTab("fecru",this.getDevStatusDetailDialog()),this.model.switchTab.reset(),this.mockLocalStorage.getItem.restore()}),test("Different projects render independently stored tabs",function(){expect(8),sinon.stub(this.mockLocalStorage,"getItem"),this.mockLocalStorage.getItem.withArgs("stored-tab-ONE-commit").returns("stash"),this.mockLocalStorage.getItem.withArgs("stored-tab-TWO-commit").returns("fecru"),this.model.get.withArgs("tabs").returns(this.defaultTabs);var e=this.createView({type:"commit",model:this.model,count:99999,issueKey:"ONE-111"});e.show(),this.assertThisTabAsOnlyActiveTab("stash",this.getDevStatusDetailDialog()),this.model.switchTab.reset();var t=this.createView({type:"commit",model:this.model,count:99999,issueKey:"TWO-222"});t.show(),this.assertThisTabAsOnlyActiveTab("fecru",this.getDevStatusDetailDialog()),this.model.switchTab.reset(),this.mockLocalStorage.getItem.restore()}),test("The default tab is rendered if the stored tab is removed",function(){expect(4),sinon.stub(this.mockLocalStorage,"getItem"),this.mockLocalStorage.getItem.withArgs("stored-tab-AWESOME-commit").returns("stash");var e={bitbucket:{count:5e3,name:"Bitbucket"},fecru:{count:1,name:"Fisheye / Crucible"}};this.model.get.withArgs("tabs").returns(e);var t=this.defaultTabOrder[0];this.createDefaultView(99999).show(),this.assertThisTabAsOnlyActiveTab(t,this.getDevStatusDetailDialog()),this.model.switchTab.reset(),this.mockLocalStorage.getItem.restore()}),test("The default tab is rendered if stored tab is corrupted or not found",function(){expect(4),sinon.stub(this.mockLocalStorage,"getItem"),this.mockLocalStorage.getItem.returns("undefined"),this.model.get.withArgs("tabs").returns(this.defaultTabs);var e=this.defaultTabOrder[0];this.createDefaultView(99999).show(),this.assertThisTabAsOnlyActiveTab(e,this.getDevStatusDetailDialog()),this.model.switchTab.reset(),this.mockLocalStorage.getItem.restore()}),test("Tabs are rendered when switched away before data is back",function(){expect(7);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView(99999);t.show(),ok(this.model.switchTab.calledWith("bitbucket"),"The initial ajax call is made on show()"),t.renderSuccess=sinon.stub(),t._renderError=sinon.stub(),t._handleFetchSucceeded("stash",{detail:["stash-data"]}),ok(t.renderSuccess.calledWith("stash",["stash-data"]),"stash pane is rendered first"),ok(t._renderError.calledWith("stash",void 0,!0),"error is handled on stash first"),t._handleFetchSucceeded("bitbucket",{detail:["bb-data1","bb-data2"],errors:"error"}),ok(t.renderSuccess.calledWith("bitbucket",["bb-data1","bb-data2"]),"bitbucket pane is rendered later"),ok(t._renderError.calledWith("bitbucket","error",!0),"error is handled on bitbucket later"),t._handleFetchSucceeded("fecru",{detail:[],errors:"error"}),ok(t.renderSuccess.neverCalledWith("fecru",void 0),"fecru pane is NOT rendered"),ok(t._renderError.calledWith("fecru","error",!1),"error is handled on bitbucket later")}),test("Authentication status footer is not rendered when no errors",function(){expect(3);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash1,authenticated:!0,configured:!0}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertInvisible(a,"Status div is not visible")}),test("Authentication status footer is rendered when there is one auth error",function(){expect(6);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash1,authenticated:!1,configured:!0}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertVisible(a,"Status div is visible"),ok(a.text().indexOf("You might be able to see more information by authenticating with the following application:")>=0,"Status div contains right message title");var n=a.find(".instance");equal(n.length,1,"One unauth instance is shown"),ok(n.text(),this.sourceStash1.name,"Unauth instance name is correct")}),test("Authentication screen shown when there is no data",function(){expect(2);var e=this.createDefaultView();e.renderSuccess=sinon.stub(),e._renderNoPermissionToViewAllWarning=sinon.stub(),e._handleFetchSucceeded("stash",{detail:[]}),ok(e.renderSuccess.neverCalledWith("stash",["stash-data"]),"stash pane is rendered first"),ok(e._renderNoPermissionToViewAllWarning.calledWith("stash"),"No Permission called")}),test("Authentication screen not shown when there is data",function(){expect(2);var e=this.createDefaultView();e.renderSuccess=sinon.stub(),e._renderNoPermissionToViewAllWarning=sinon.stub(),e._handleFetchSucceeded("stash",{detail:["things"]}),ok(e.renderSuccess.calledWith("stash",["things"]),"stash pane is rendered first"),ok(e._renderNoPermissionToViewAllWarning.neverCalledWith("stash"),"No Permission called")}),test("Authentication screen not shown when hasData overridden",function(){expect(2);var e=this.createDefaultView();e.renderSuccess=sinon.stub(),e._renderNoPermissionToViewAllWarning=sinon.stub(),e.hasData=function(){return!1},e._handleFetchSucceeded("stash",{detail:["things"]}),ok(e.renderSuccess.neverCalledWith("stash",["things"]),"stash pane is rendered first"),ok(e._renderNoPermissionToViewAllWarning.calledWith("stash"),"No Permission called")}),test("Authentication status footer is NOT rendered when there is one incorrectly configured link with auth error",function(){expect(3);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash1,authenticated:!1,configured:!1}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertInvisible(a,"Status div is not visible")}),test("Authentication status footer is rendered when there is one auth error with non-errors",function(){expect(6);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash2,authenticated:!0,configured:!0},{source:this.sourceStash1,authenticated:!1,configured:!0},{source:this.sourceStash3,authenticated:!0,configured:!0}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertVisible(a,"Status div is visible"),ok(a.text().indexOf("You might be able to see more information by authenticating with the following application:")>=0,"Status div contains right message title");var n=a.find(".instance");equal(n.length,1,"One unauth instance is shown"),ok(n.text(),this.sourceStash1.name,"Unauth instance name is correct")}),test("Authentication status footer is NOT rendered when there is one incorrectly configured link with other correctly configured links",function(){expect(3);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash2,authenticated:!0,configured:!0},{source:this.sourceStash1,authenticated:!1,configured:!1},{source:this.sourceStash3,authenticated:!0,configured:!0}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertInvisible(a,"Status div is not visible")}),test("Authentication status footer is rendered when there is one incorrectly configured link with other correctly configured links, but with auth error",function(){expect(6);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash2,authenticated:!0,configured:!0},{source:this.sourceStash1,authenticated:!1,configured:!1},{source:this.sourceStash3,authenticated:!1,configured:!0}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertVisible(a,"Status div is visible"),ok(a.text().indexOf("You might be able to see more information by authenticating with the following application:")>=0,"Status div contains right message title");var n=a.find(".instance");equal(n.length,1,"One unauth instance is shown"),ok(n.text(),this.sourceStash1.name,"Unauth instance name is correct")}),test("Authentication status footer is rendered when there are two auth errors",function(){expect(6);var e=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(e);var t=this.createDefaultView();t.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var s=[{source:this.sourceStash1,authenticated:!1,configured:!0},{source:this.sourceStash2,authenticated:!1,configured:!0}];t._handleAuthSucceeded(s);var i=this.getDevStatusDetailDialog(),a=i.footer.find(".oauth-status");ok(null!=a&&a.length>0,"Status div element exist"),this.assertVisible(a,"Status div is visible"),ok(a.text().indexOf("You might be able to see more information by authenticating with the following applications:")>=0,"Status div contains right message title");var n=a.find(".instance");equal(n.length,2,"Two unauth instances are shown"),equal(n.text(),this.sourceStash1.name+this.sourceStash2.name,"Unauth instance names are correct")}),test("Authentication status footer is rendered when there are three auth errors",n.withFakeTimer(function(e){expect(11);var t=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(t);var s=this.createDefaultView();s.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var i=[{source:this.sourceStash1,authenticated:!1,configured:!0},{source:this.sourceStash2,authenticated:!1,configured:!0},{source:this.sourceStash3,authenticated:!1,configured:!0}];s._handleAuthSucceeded(i);var n=this.getDevStatusDetailDialog(),r=n.footer.find(".oauth-status");ok(null!=r&&r.length>0,"Status div element exist"),this.assertVisible(r,"Status div is visible"),ok(r.text().indexOf("You might be able to see more information by authenticating with the following applications:")>=0,"Status div contains right message title");var o=r.find(".instance");equal(o.length,2,"Two unauth instances are shown"),equal(o.text(),this.sourceStash1.name+this.sourceStash2.name,"Shown unauth instance names are correct");var h=r.find(".more-instances");equal(h.length,1,"The link for more unauth instances is shown"),h.click(),e.tick(1);var c=a(document).find("#inline-dialog-instance-list-popup");equal(c.length,1,"Inline dialog for more instances is created"),this.assertVisible(c,"Inline dialog is visible after clicking on more link");var l=c.find(".instance");equal(l.length,1,"One instance in the inline dialog"),equal(l.text(),this.sourceStash3.name,"Shown unauth instance name in popup is correct")})),test("Authentication status footer is rendered when there are four auth errors",n.withFakeTimer(function(e){expect(11);var t=(this.defaultTabOrder,this.defaultTabs);this.model.get.withArgs("tabs").returns(t);var s=this.createDefaultView();s.show(),ok(this.model.fetchAuthenticationStatuses.calledWith(),"The fetch auth ajax call is made on show()");var i=[{source:this.sourceStash1,authenticated:!1,configured:!0},{source:this.sourceStash2,authenticated:!1,configured:!0},{source:this.sourceStash3,authenticated:!1,configured:!0},{source:this.sourceStash4,authenticated:!1,configured:!0}];s._handleAuthSucceeded(i);var n=this.getDevStatusDetailDialog(),r=n.footer.find(".oauth-status");ok(null!=r&&r.length>0,"Status div element exist"),this.assertVisible(r,"Status div is visible"),ok(r.text().indexOf("You might be able to see more information by authenticating with the following applications:")>=0,"Status div contains right message title");var o=r.find(".instance");equal(o.length,2,"Two unauth instances are shown"),equal(o.text(),this.sourceStash1.name+this.sourceStash2.name,"Shown unauth instance names are correct");var h=r.find(".more-instances");equal(h.length,1,"The link for more unauth instances is shown"),h.click(),e.tick(1);var c=a(document).find("#inline-dialog-instance-list-popup");equal(c.length,1,"Inline dialog for more instances is created"),this.assertVisible(c,"Inline dialog is visible after clicking on more link");var l=c.find(".instance");equal(l.length,2,"Two instances in the inline dialog"),equal(l.text(),this.sourceStash3.name+this.sourceStash4.name,"Shown unauth instance names in popup are correct")})),test("Test analytics are fired when clicked on product tab",function(){expect(10);var t=this,s=this.defaultTabOrder,n=this.defaultTabs;this.model.get.withArgs("tabs").returns(n);var r=this.createDefaultView(99999);r.show();var o=this.getDevStatusDetailDialog().content.find(".tabs-menu").find(".menu-item");equal(o.length,3,"There are three tabs"),i.each(o,function(i,n){var r=s[n],o=a(i);o.children().click(),ok(t.model.switchTab.calledWith(r,!1),"Tab clicks are propagated properly back to the model without forceFetch"),ok(e.SummaryAnalytics.fireDetailTabClicked.called,"Analytic event is fired correctly when clicking on product tab in detail dialog"),ok(e.SummaryAnalytics.fireDetailTabClicked.calledWith(r,void 0),"Analytic event is fired correctly when clicking on product tab in detail dialog"),t.model.switchTab.reset()})}),test("Test sanitised pane id",function(){var e="bad.id",t={};t[e]={count:1,name:"Invalid"},this.model.get.withArgs("tabs").returns(t);var s=this.createDefaultView(99999);s.show(),ok(1===s._getPane(e).length)}),test("Anon user always see a message to login if count is different regardless of error case",function(){var e=this.sandbox.stub(JIRA.Users.LoggedInUser,"isAnonymous");this.model.get.withArgs("tabs").returns(this.defaultTabs);var t=this.createDefaultView();t.show(),this.model.get.withArgs("contentMap").returns({stash:{}}),e.returns(!1),t.renderNoPermissionToViewAllWarningAtBottom("stash",1),equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"Unable to retrieve development information Please contact your administrator."),t.getContentContainer("stash").empty(),this.model.get.withArgs("contentMap").returns({stash:{}}),e.returns(!0),t.renderNoPermissionToViewAllWarningAtBottom("stash",1),equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"Unable to retrieve development information You might be able to view more by authenticating with JIRA."),t.getContentContainer("stash").empty(),this.model.get.withArgs("contentMap").returns({stash:{errors:{empty:!1}}}),e.returns(!1),t.renderNoPermissionToViewAllWarningAtBottom("stash",1),equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),""),t.getContentContainer("stash").empty(),this.model.get.withArgs("contentMap").returns({stash:{errors:{empty:!1}}}),e.returns(!0),t.renderNoPermissionToViewAllWarningAtBottom("stash",1),equal(this.getDevStatusDetailDialog().getUnableToViewAllMessage(),"Unable to retrieve development information You might be able to view more by authenticating with JIRA."),t.getContentContainer("stash").empty()}),test("Incapable error is not shown in detail dialog",function(){function e(){var e=t.getContentContainer(s),i=e.find(".instance");ok(2===i.length),equal(i.eq(0).text(),"squirtle"),equal(i.eq(1).text(),"charmander"),ok(e.text().indexOf("pikachu")===-1,"There is no mention of the incapable instance at all in detail dialog")}expect(16),this.model.get.withArgs("tabs").returns(this.defaultTabs);var t=this.createDefaultView(99999);t.show();var s="bitbucket",a=[{error:"unathorized",instance:{baseUrl:"sss",name:"squirtle"}},{error:"random",instance:{baseUrl:"ccc",name:"charmander"}},{error:"incapable",instance:{baseUrl:"ppp",name:"pikachu"}}];i.each([!0,!1],function(n){i.each([!0,!1],function(i){t._renderError(s,a,n,i),e(),t.getContentContainer(s).empty()})})}),asyncTest("applinks.auth.denied event with an admin error message is rendered correctly",function(){var e=this,t=this.mockApplinkProperties(),s=this.mockMessagesForAdmin();this.setupViewForOAuthDanceErrorTest(),this.isAdmin=sinon.sandbox.stub(JIRA,"isAdmin"),this.isAdmin.returns(!0),expect(1),a(document).trigger("applinks.auth.denied",[t,s]),this.waitUntilElementIsVisible(".connection-problem",0,function(t){var i=t.find(".admin-error"),a=t.find(".admin-error-details li");strictEqual(i.text(),s.adminError,"The actual admin error should match the expected one"),e.assertThatTheErrorDetailsAreCorrect(a,s.adminErrorDetails),e.testFinish(!0)},this)}),asyncTest("applinks.auth.denied event with a user error message is rendered correctly",function(){var e=this,t=this.mockApplinkProperties(),s=this.mockMessagesForUser();this.setupViewForOAuthDanceErrorTest(),this.isAdmin=sinon.sandbox.stub(JIRA,"isAdmin"),this.isAdmin.returns(!1),expect(1),a(document).trigger("applinks.auth.denied",[t,s]),this.waitUntilElementIsVisible(".authentication-problem",0,function(t){var i=t.find(".user-error");strictEqual(i.text(),s.userError,"The actual user error should match the expected error"),e.testFinish(!0)},this)}),asyncTest("applinks.auth.denied event with an admin error shows a connection problem but not the details to a non-admin user",function(){var e=this,t=this.mockApplinkProperties(),s=this.mockMessagesForAdmin();this.setupViewForOAuthDanceErrorTest(),this.isAdmin=sinon.sandbox.stub(JIRA,"isAdmin"),this.isAdmin.returns(!1),expect(1),a(document).trigger("applinks.auth.denied",[t,s]),this.waitUntilElementIsVisible(".connection-problem",0,function(t){var s=t.find(".admin-error"),i=t.find(".admin-error-details");ok(0===s.length&&0===i.length,"Details of connection error should be hidden"),e.testFinish(!0)},this)}),asyncTest("applinks.auth.denied event with an admin error message but no details should not show any details",function(){var e=this,t=this.mockApplinkProperties(),s=this.mockMessagesForAdminWithoutDetails();this.setupViewForOAuthDanceErrorTest(),this.isAdmin=sinon.sandbox.stub(JIRA,"isAdmin"),this.isAdmin.returns(!0),expect(2),a(document).trigger("applinks.auth.denied",[t,s]),this.waitUntilElementIsVisible(".connection-problem",0,function(t){var i=t.find(".admin-error"),a=t.find(".admin-error-details li");strictEqual(i.text(),s.adminError,"The actual admin error should match the expected one"),strictEqual(a.length,0,"Messages with no details should not show any details"),e.testFinish(!0)},this)})});