"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-devstatus-view-issue"],function(){module("local-storage",{setup:function(){this.sandbox=sinon.sandbox.create(),this.context=AJS.test.mockableModuleContext(),this.mockLocalStorage={getItem:function(e){},setItem:function(e,t){},removeItem:function(e){},clear:function(){}},this.context.mock("util/LocalStorage",this.mockLocalStorage),this.mockConsole={log:function(){},error:function(){}},this.context.mock("jira/util/logger",this.mockConsole),this.model=this.context.require("util/DevStatusLocalStorage"),this.getItemStub=this.sandbox.stub(this.mockLocalStorage,"getItem"),this.setItemStub=this.sandbox.stub(this.mockLocalStorage,"setItem"),this.removeItemStub=this.sandbox.stub(this.mockLocalStorage,"removeItem"),this.clearStub=this.sandbox.stub(this.mockLocalStorage,"clear"),this.errorStub=this.sandbox.stub(this.mockConsole,"error")},teardown:function(){this.sandbox.restore()},doesNotThrow:function(e,t){try{e(),ok(!0,t)}catch(o){ok(!1,t)}}}),test("LocalStorage utility calls window.localStorage methods appropriately",function(){expect(4),this.model.getItem("key"),ok(this.getItemStub.withArgs("key").calledOnce,"localStorage.getItem() called correctly"),this.model.setItem("key","value"),ok(this.setItemStub.withArgs("key","value").calledOnce,"localStorage.setItem() called correctly"),this.model.removeItem("key"),ok(this.removeItemStub.withArgs("key").calledOnce,"localStorage.removeItem() called correctly"),this.model.clear(),ok(this.clearStub.calledOnce,"localStorage.clear() called correctly")}),test("LocalStorage utility catches exceptions from window.localStorage methods",function(){expect(4),this.getItemStub["throws"](),this.doesNotThrow(this.model.getItem,"getItem() handles localStorage.getItem() exceptions"),this.setItemStub["throws"](),this.doesNotThrow(this.model.setItem,"setItem() handles localStorage.setItem() exceptions"),this.removeItemStub["throws"](),this.doesNotThrow(this.model.removeItem,"removeItem() handles localStorage.removeItem() exceptions"),this.clearStub["throws"](),this.doesNotThrow(this.model.clear,"clear() handles localStorage.clear() exceptions")}),test("LocalStorage utility correctly logs exceptions from window.localStorage methods",function(){expect(4),this.getItemStub["throws"]({name:"GetItemException"}),this.model.getItem("key"),ok(this.errorStub.withArgs("Couldn't retrieve locally stored value for key 'key': GetItemException").calledOnce,"getItem() logs the correct error to the console"),this.setItemStub["throws"]({name:"SetItemException"}),this.model.setItem("key","value"),ok(this.errorStub.withArgs("Couldn't store 'key' & 'value' key-value pair locally: SetItemException").calledOnce,"setItem() logs the correct error to the console"),this.removeItemStub["throws"]({name:"RemoveItemException"}),this.model.removeItem("key"),ok(this.errorStub.withArgs("Couldn't remove locally stored value for key 'key': RemoveItemException").calledOnce,"removeItem() logs the correct error to the console"),this.clearStub["throws"]({name:"ClearLocalStorageException"}),this.model.clear(),ok(this.errorStub.withArgs("Couldn't clear local storage: ClearLocalStorageException").calledOnce,"clear() logs the correct error to the console")}),test("LocalStorage utility logs KB Article link when local storage quota is exceeded",function(){var e="Browser local storage is full. For more information please follow https://confluence.atlassian.com/jirakb/functionality-in-jira-fails-due-to-exceeding-chrome-quota-762874705.html",t="Couldn't store 'key' & 'value' key-value pair locally: QuotaExceededError. "+e,o="Couldn't store 'firefox-key' & 'firefox-value' key-value pair locally: NS_ERROR_DOM_QUOTA_REACHED. "+e,r={code:22,name:"QuotaExceededError"};this.setItemStub["throws"](r),this.model.setItem("key","value"),ok(this.errorStub.withArgs(t).calledOnce,"Quota exceeded exception is logged on non-Firefox browsers with KB link");var l={code:1014,name:"NS_ERROR_DOM_QUOTA_REACHED"};this.setItemStub["throws"](l),this.model.setItem("firefox-key","firefox-value"),ok(this.errorStub.withArgs(o).calledOnce,"Quota exceeded exception is logged on Firefox with KB link")})});