"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-smart-commits"],function(){var o="046b6c7f-0b8a-43b9-b35d-6489e6daee91";module("Smart Commits config controller Tests",{setup:function(){this.MockConfigModel=Backbone.Model.extend({fetch:function(){},setError:function(){}}),this.MockConfigView=Backbone.View.extend({showContent:function(){}}),this.context=AJS.test.mockableModuleContext(),this.context.mock("smartcommits/smart-commits-config-model",this.MockConfigModel),this.context.mock("smartcommits/smart-commits-config-view",this.MockConfigView),this.controller=this.context.require("smartcommits/smart-commits-config-controller")},teardown:function(){}}),test("Should create config model and view when openConfig is called",function(){var t=sinon.spy(this.MockConfigModel.prototype,"initialize"),n=sinon.spy(this.MockConfigView.prototype,"initialize"),e=sinon.spy(this.MockConfigView.prototype,"render");this.controller.openConfig(o),sinon.assert.calledWithExactly(t,{applinkId:o});var i=n.args[0][0];ok(i.model instanceof this.MockConfigModel),ok("function"==typeof i.template),ok("function"==typeof i.contentTemplate),ok("function"==typeof i.errorTemplate),sinon.assert.calledOnce(e)}),test("Should set error to model when fetch return with error",function(){var t={status:400,statusText:"Bad request",responseText:"Bad request description"},n=(sinon.stub(this.MockConfigModel.prototype,"fetch",function(o){o.error({},t)}),sinon.spy(this.MockConfigModel.prototype,"setError")),e=sinon.spy(this.MockConfigView.prototype,"showContent");this.controller.openConfig(o);var i=n.args[0][0];sinon.assert.calledOnce(n),ok(i,"Should call model.setError with error object"),sinon.assert.calledOnce(e)}),test("Should call view show content without setting an error when successfully fetch model",function(){var t=(sinon.stub(this.MockConfigModel.prototype,"fetch",function(o){o.success()}),sinon.spy(this.MockConfigModel.prototype,"setError")),n=sinon.spy(this.MockConfigView.prototype,"showContent");this.controller.openConfig(o),sinon.assert.callCount(t,0),sinon.assert.calledOnce(n)}),test("Should not show any dialog when new applink is not capable of smart commits",function(){this.MockConfigModel.prototype.isSmartCommitCapable=function(){},sinon.stub(this.MockConfigModel.prototype,"fetch",function(o){o.success()}),sinon.stub(this.MockConfigModel.prototype,"isSmartCommitCapable",function(o){return!1});var t=sinon.spy(this.MockConfigView.prototype,"render"),n=sinon.spy(this.MockConfigView.prototype,"showContent");this.controller.openConfigForNewApplink(o),sinon.assert.callCount(t,0),sinon.assert.callCount(n,0)}),test("Should not show any dialog when rest call return error",function(){this.MockConfigModel.prototype.isSmartCommitCapable=function(){};var t=(sinon.stub(this.MockConfigModel.prototype,"fetch",function(o){}),sinon.spy(this.MockConfigView.prototype,"render")),n=sinon.spy(this.MockConfigView.prototype,"showContent");this.controller.openConfigForNewApplink(o),sinon.assert.callCount(t,0),sinon.assert.callCount(n,0)}),test("Should show smart commits config dialog for new applink when it is capable of smart commits",function(){sinon.stub(this.MockConfigModel.prototype,"fetch",function(o){o.success()}),this.MockConfigModel.prototype.isSmartCommitCapable=function(){},this.MockConfigModel.prototype.setSmartCommitLocallyEnabled=function(){},sinon.stub(this.MockConfigModel.prototype,"isSmartCommitCapable",function(o){return!0});var t=sinon.spy(this.MockConfigModel.prototype,"initialize"),n=sinon.spy(this.MockConfigModel.prototype,"setSmartCommitLocallyEnabled"),e=sinon.spy(this.MockConfigView.prototype,"render"),i=sinon.spy(this.MockConfigView.prototype,"showContent");this.controller.openConfigForNewApplink(o),ok(t.args[0][0].skipRemoteCheckForSmartCommit,"Should set skipRemoteCheck to true with new created applink"),ok(n.calledBefore(i)," Should call model.setSmartCommitLocallyEnabled before rendering the view");var s=n.args[0][0];ok(s," Should call model.setSmartCommitLocallyEnabled with true to set initial value of smart commits to be enabled"),sinon.assert.callCount(n,1),sinon.assert.callCount(e,1),sinon.assert.callCount(i,1)})});