"use strict";AJS.test.require(["com.atlassian.jira.plugins.jira-development-integration-plugin:__test__entrypoint-releasereport","com.atlassian.jira.plugins.jira-development-integration-plugin:tab-view-test-util"],function(){var t=require("jquery"),e=require("releasereport/tab-view-test-util"),s=require("releasereport/dev-status-dialog-bridge"),a=require("releasereport/release-report-analytics");module("tab-view",{setup:function(){this.sandbox=sinon.sandbox.create(),this.model={updateData:this.sandbox.spy(),on:this.sandbox.stub(),get:this.sandbox.stub(),shouldUpdateData:this.sandbox.stub()},this.fixture=t("#qunit-fixture"),this.defaultProjectKey="projectKey",this.defaultProject={key:this.defaultProjectKey},this.defaultVersionId="versionId",this.sandbox.stub(a,"triggerIssueTabAnalytics"),this.sandbox.stub(a,"triggerIssueClickAnalytics"),this.sandbox.stub(a,"triggerWarningTabAnalytics"),this.sandbox.stub(a,"triggerWarningCategoryAnalytics"),this.sandbox.stub(a,"triggerReleaseNotesLinkAnalytics"),this.sandbox.stub(a,"triggerFusionWidgetClicked"),this.sandbox.stub(a,"triggerEvent"),this.sandbox.stub(s,"showDialog")},teardown:function(){this.sandbox.restore()},createRestResponse:function(t,s,a,i){return{tabContent:i,releaseTabs:e.createTabs(t,a),statusCategoryCounts:e.createCategoryCounts(t,s),totalIssueCount:t.allIssues}},findById:function(t,e){return t.find('[id="'+e+'"]')},createIssueListTemplate:function(){return e.createIssueList({issues:[e.createIssue({id:1,key:"TEST-1",summary:"my bug"})],avatars:[],unassignedAvatar:{},issueCount:1})},resetStubAnalytics:function(){a.triggerIssueClickAnalytics.reset(),a.triggerWarningTabAnalytics.reset(),a.triggerWarningCategoryAnalytics.reset(),a.triggerReleaseNotesLinkAnalytics.reset(),a.triggerIssueTabAnalytics.reset(),a.triggerFusionWidgetClicked.reset(),a.triggerEvent.reset()}}),test("should update model when tab is clicked",function(){var t=e.createReport({});this.fixture.append(t);var s={preventDefault:this.sandbox.stub()};s.currentTarget=this.findById(t,e.Tabs.WARNINGS.id),this.model.shouldUpdateData.withArgs(e.Tabs.WARNINGS.id).returns(!0);var a=e.createTabView(this.sandbox,this.fixture,t,this.model);a._updateTabContent(s),ok(s.preventDefault.calledOnce),ok(this.model.updateData.withArgs(e.Tabs.WARNINGS.id,this.defaultProjectKey,this.defaultVersionId).calledOnce,"model should be updated")}),test("should update view for event fetchTabContentSucceeded",function(){var t=e.createReport({}),s=e.createTabView(this.sandbox,this.fixture,t),a={warnings:5,allIssues:18,done:5,inProgress:6,todo:7},i={done:30,inProgress:33,todo:37},r="some new tab content",n=this.createRestResponse(a,i,e.Tabs.ALL_ISSUES.id,r);s.model.trigger("fetchTabContentSucceeded",n),strictEqual(t.find("#release-report-tab-body-content").html(),r,"should update tab content"),strictEqual(this.findById(t,e.Tabs.TO_DO.id).find(".tab-count").text(),String(a.todo),"should update todo tab count"),strictEqual(this.findById(t,e.Tabs.IN_PROGRESS.id).find(".tab-count").text(),String(a.inProgress),"should update inProgress tab count"),strictEqual(this.findById(t,e.Tabs.DONE.id).find(".tab-count").text(),String(a.done),"should update done tab count"),strictEqual(this.findById(t,e.Tabs.WARNINGS.id).find(".tab-count").text(),String(a.warnings),"should update warning tab count"),strictEqual(this.findById(t,e.Tabs.ALL_ISSUES.id).find(".tab-count").text(),String(a.allIssues),"should update all issues tab count")}),test("should publish analytics when release notes link is clicked",function(){this.resetStubAnalytics();var t=e.createReport({});e.createTabView(this.sandbox,this.fixture,t),t.find("#release-report-notes-link").click();var s={versionId:this.defaultVersionId,projectKey:this.defaultProjectKey,status:"unreleased",overdue:!1,daysRemaining:10};ok(a.triggerReleaseNotesLinkAnalytics.calledWith(s))}),test("should publish analytics for issue tabs when view is rendered",function(){this.resetStubAnalytics();var t=e.createReport({selectedTab:e.Tabs.ALL_ISSUES.id,tabContent:this.createIssueListTemplate().html(),counts:{warnings:0,allIssues:1,done:0,inProgress:0,todo:0}});e.createTabView(this.sandbox,this.fixture,t);var s=a.triggerIssueTabAnalytics.args,i=s[0][0],r=s[0][1],n=s[0][2],o=s[0][3];strictEqual(i,"release-report.all-issues-tab","Argument onTabLoadAnalyticsEvent is correct for ReleaseReportAnalytics.triggerIssueTabAnalytics");var d={versionId:this.defaultVersionId,projectKey:this.defaultProjectKey,status:"unreleased",overdue:!1,daysRemaining:10,totalTabItems:1};deepEqual(r,d,"Event attributes are correct for ReleaseReportAnalytics.triggerIssueTabAnalytics");var u=n.find("a.fusion-widget");strictEqual(u.data("issue-id"),1,"Matched correct table row with issue id"),strictEqual(u.data("issue-key"),"TEST-1","Matched correct table row with issue id"),equal(null!=u.data("dev-summary"),!0,"dev summary json exists for issue"),strictEqual(o.eq(0).hasClass("fusion-widget"),!0,"Matched correct fusion widget")}),test("should publish analytics when fusion widget is clicked in the Issues tab",function(){this.resetStubAnalytics();var t=e.createReport({selectedTab:e.Tabs.IN_PROGRESS.id,tabContent:this.createIssueListTemplate().html(),counts:{warnings:0,allIssues:0,done:0,inProgress:1,todo:0}});e.createTabView(this.sandbox,this.fixture,t),this.resetStubAnalytics(),t.find(".development .fusion-widget").click();var s=a.triggerFusionWidgetClicked.args,i=s[0][0],r=s[0][1];strictEqual(i,e.Tabs.IN_PROGRESS.analyticsOnTabLoad,"Matched correct fusion widget dataType"),strictEqual(r,"pullrequest","Matched correct fusion widget dataType")}),test("should display devStatus detail dialog when fusion widget is clicked",function(){var t=e.createReport({selectedTab:e.Tabs.IN_PROGRESS.id,tabContent:this.createIssueListTemplate().html(),counts:{warnings:0,allIssues:0,done:0,inProgress:1,todo:0}});e.createTabView(this.sandbox,this.fixture,t),t.find(".development .fusion-widget").click(),strictEqual(s.showDialog.called,!0,"DevStatusDialogBridge.showDialog has been called");var a=s.showDialog.args,i=a[0][0],r=a[0][1],n=a[0][2],o=a[0][3],d=a[0][4];strictEqual(o,"pullrequest","Matched correct fusion widget dataType"),strictEqual(i,"TEST-1","Matched correct parameter issueKey for DevStatusDialogBridge.showDialog"),strictEqual(r,1,"Matched correct parameter issueId for DevStatusDialogBridge.showDialog"),strictEqual(o,"pullrequest","Matched correct parameter dataType for DevStatusDialogBridge.showDialog"),strictEqual(d,!1,"Matched correct parameter showContactAdminForm for DevStatusDialogBridge.showDialog"),strictEqual(n.byInstanceType.stash.count,1,"Matched correct parameter devSummary for DevStatusDialogBridge.showDialog")})});