--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner:
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner:
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: AO_21D670_WHITELIST_RULES; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_21D670_WHITELIST_RULES" (
  "ALLOWINBOUND" boolean,
  "EXPRESSION" text NOT NULL,
  "ID" integer NOT NULL,
  "TYPE" character varying(255) NOT NULL
);


ALTER TABLE "AO_21D670_WHITELIST_RULES" OWNER TO jirauser2;

--
-- Name: AO_21D670_WHITELIST_RULES_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_21D670_WHITELIST_RULES_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_21D670_WHITELIST_RULES_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_21D670_WHITELIST_RULES_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_21D670_WHITELIST_RULES_ID_seq" OWNED BY "AO_21D670_WHITELIST_RULES"."ID";


--
-- Name: AO_38321B_CUSTOM_CONTENT_LINK; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_38321B_CUSTOM_CONTENT_LINK" (
  "CONTENT_KEY" character varying(255),
  "ID" integer NOT NULL,
  "LINK_LABEL" character varying(255),
  "LINK_URL" character varying(255),
  "SEQUENCE" integer DEFAULT 0
);


ALTER TABLE "AO_38321B_CUSTOM_CONTENT_LINK" OWNER TO jirauser2;

--
-- Name: AO_38321B_CUSTOM_CONTENT_LINK_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_38321B_CUSTOM_CONTENT_LINK_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_38321B_CUSTOM_CONTENT_LINK_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_38321B_CUSTOM_CONTENT_LINK_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_38321B_CUSTOM_CONTENT_LINK_ID_seq" OWNED BY "AO_38321B_CUSTOM_CONTENT_LINK"."ID";


--
-- Name: AO_3B1893_LOOP_DETECTION; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_3B1893_LOOP_DETECTION" (
  "COUNTER" integer DEFAULT 0 NOT NULL,
  "EXPIRES_AT" bigint DEFAULT 0 NOT NULL,
  "ID" integer NOT NULL,
  "SENDER_EMAIL" text NOT NULL
);


ALTER TABLE "AO_3B1893_LOOP_DETECTION" OWNER TO jirauser2;

--
-- Name: AO_3B1893_LOOP_DETECTION_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_3B1893_LOOP_DETECTION_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_3B1893_LOOP_DETECTION_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_3B1893_LOOP_DETECTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_3B1893_LOOP_DETECTION_ID_seq" OWNED BY "AO_3B1893_LOOP_DETECTION"."ID";


--
-- Name: AO_4AEACD_WEBHOOK_DAO; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_4AEACD_WEBHOOK_DAO" (
  "ENABLED" boolean,
  "ENCODED_EVENTS" text,
  "FILTER" text,
  "ID" integer NOT NULL,
  "JQL" character varying(255),
  "LAST_UPDATED" timestamp without time zone NOT NULL,
  "LAST_UPDATED_USER" character varying(255) NOT NULL,
  "NAME" text NOT NULL,
  "REGISTRATION_METHOD" character varying(255) NOT NULL,
  "URL" text NOT NULL,
  "PARAMETERS" text,
  "EXCLUDE_ISSUE_DETAILS" boolean
);


ALTER TABLE "AO_4AEACD_WEBHOOK_DAO" OWNER TO jirauser2;

--
-- Name: AO_4AEACD_WEBHOOK_DAO_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_4AEACD_WEBHOOK_DAO_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_4AEACD_WEBHOOK_DAO_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_4AEACD_WEBHOOK_DAO_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_4AEACD_WEBHOOK_DAO_ID_seq" OWNED BY "AO_4AEACD_WEBHOOK_DAO"."ID";


--
-- Name: AO_550953_SHORTCUT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_550953_SHORTCUT" (
  "ID" integer NOT NULL,
  "NAME" character varying(255),
  "PROJECT_ID" bigint,
  "SHORTCUT_URL" text,
  "URL" character varying(255),
  "ICON" character varying(255)
);


ALTER TABLE "AO_550953_SHORTCUT" OWNER TO jirauser2;

--
-- Name: AO_550953_SHORTCUT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_550953_SHORTCUT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_550953_SHORTCUT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_550953_SHORTCUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_550953_SHORTCUT_ID_seq" OWNED BY "AO_550953_SHORTCUT"."ID";


--
-- Name: AO_563AEE_ACTIVITY_ENTITY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_563AEE_ACTIVITY_ENTITY" (
  "ACTIVITY_ID" bigint NOT NULL,
  "ACTOR_ID" integer,
  "CONTENT" text,
  "GENERATOR_DISPLAY_NAME" character varying(255),
  "GENERATOR_ID" character varying(450),
  "ICON_ID" integer,
  "ID" character varying(450),
  "ISSUE_KEY" character varying(255),
  "OBJECT_ID" integer,
  "POSTER" character varying(255),
  "PROJECT_KEY" character varying(255),
  "PUBLISHED" timestamp without time zone,
  "TARGET_ID" integer,
  "TITLE" character varying(255),
  "URL" character varying(450),
  "USERNAME" character varying(255),
  "VERB" character varying(450)
);


ALTER TABLE "AO_563AEE_ACTIVITY_ENTITY" OWNER TO jirauser2;

--
-- Name: AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq" OWNED BY "AO_563AEE_ACTIVITY_ENTITY"."ACTIVITY_ID";


--
-- Name: AO_563AEE_ACTOR_ENTITY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_563AEE_ACTOR_ENTITY" (
  "FULL_NAME" character varying(255),
  "ID" integer NOT NULL,
  "PROFILE_PAGE_URI" character varying(450),
  "PROFILE_PICTURE_URI" character varying(450),
  "USERNAME" character varying(255)
);


ALTER TABLE "AO_563AEE_ACTOR_ENTITY" OWNER TO jirauser2;

--
-- Name: AO_563AEE_ACTOR_ENTITY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_563AEE_ACTOR_ENTITY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_563AEE_ACTOR_ENTITY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_563AEE_ACTOR_ENTITY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_563AEE_ACTOR_ENTITY_ID_seq" OWNED BY "AO_563AEE_ACTOR_ENTITY"."ID";


--
-- Name: AO_563AEE_MEDIA_LINK_ENTITY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_563AEE_MEDIA_LINK_ENTITY" (
  "DURATION" integer,
  "HEIGHT" integer,
  "ID" integer NOT NULL,
  "URL" character varying(450),
  "WIDTH" integer
);


ALTER TABLE "AO_563AEE_MEDIA_LINK_ENTITY" OWNER TO jirauser2;

--
-- Name: AO_563AEE_MEDIA_LINK_ENTITY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_563AEE_MEDIA_LINK_ENTITY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_563AEE_MEDIA_LINK_ENTITY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_563AEE_MEDIA_LINK_ENTITY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_563AEE_MEDIA_LINK_ENTITY_ID_seq" OWNED BY "AO_563AEE_MEDIA_LINK_ENTITY"."ID";


--
-- Name: AO_563AEE_OBJECT_ENTITY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_563AEE_OBJECT_ENTITY" (
  "CONTENT" character varying(255),
  "DISPLAY_NAME" character varying(255),
  "ID" integer NOT NULL,
  "IMAGE_ID" integer,
  "OBJECT_ID" character varying(450),
  "OBJECT_TYPE" character varying(450),
  "SUMMARY" character varying(255),
  "URL" character varying(450)
);


ALTER TABLE "AO_563AEE_OBJECT_ENTITY" OWNER TO jirauser2;

--
-- Name: AO_563AEE_OBJECT_ENTITY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_563AEE_OBJECT_ENTITY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_563AEE_OBJECT_ENTITY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_563AEE_OBJECT_ENTITY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_563AEE_OBJECT_ENTITY_ID_seq" OWNED BY "AO_563AEE_OBJECT_ENTITY"."ID";


--
-- Name: AO_563AEE_TARGET_ENTITY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_563AEE_TARGET_ENTITY" (
  "CONTENT" character varying(255),
  "DISPLAY_NAME" character varying(255),
  "ID" integer NOT NULL,
  "IMAGE_ID" integer,
  "OBJECT_ID" character varying(450),
  "OBJECT_TYPE" character varying(450),
  "SUMMARY" character varying(255),
  "URL" character varying(450)
);


ALTER TABLE "AO_563AEE_TARGET_ENTITY" OWNER TO jirauser2;

--
-- Name: AO_563AEE_TARGET_ENTITY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_563AEE_TARGET_ENTITY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_563AEE_TARGET_ENTITY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_563AEE_TARGET_ENTITY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_563AEE_TARGET_ENTITY_ID_seq" OWNED BY "AO_563AEE_TARGET_ENTITY"."ID";


--
-- Name: AO_575BF5_PROVIDER_ISSUE; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_575BF5_PROVIDER_ISSUE" (
  "ID" integer NOT NULL,
  "ISSUE_ID" bigint DEFAULT 0 NOT NULL,
  "PROVIDER_SOURCE_ID" character varying(255) NOT NULL,
  "STALE_AFTER" bigint
);


ALTER TABLE "AO_575BF5_PROVIDER_ISSUE" OWNER TO jirauser2;

--
-- Name: AO_575BF5_PROVIDER_ISSUE_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_575BF5_PROVIDER_ISSUE_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_575BF5_PROVIDER_ISSUE_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_575BF5_PROVIDER_ISSUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_575BF5_PROVIDER_ISSUE_ID_seq" OWNED BY "AO_575BF5_PROVIDER_ISSUE"."ID";


--
-- Name: AO_587B34_PROJECT_CONFIG; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_587B34_PROJECT_CONFIG" (
  "CONFIGURATION_GROUP_ID" character varying(255) NOT NULL,
  "ID" integer NOT NULL,
  "NAME" character varying(255),
  "NAME_UNIQUE_CONSTRAINT" character varying(255) NOT NULL,
  "PROJECT_ID" bigint DEFAULT 0 NOT NULL,
  "ROOM_ID" bigint DEFAULT 0 NOT NULL,
  "VALUE" character varying(255)
);


ALTER TABLE "AO_587B34_PROJECT_CONFIG" OWNER TO jirauser2;

--
-- Name: AO_587B34_PROJECT_CONFIG_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_587B34_PROJECT_CONFIG_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_587B34_PROJECT_CONFIG_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_587B34_PROJECT_CONFIG_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_587B34_PROJECT_CONFIG_ID_seq" OWNED BY "AO_587B34_PROJECT_CONFIG"."ID";


--
-- Name: AO_5FB9D7_AOHIP_CHAT_LINK; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_5FB9D7_AOHIP_CHAT_LINK" (
  "ADDON_TOKEN_EXPIRY" timestamp without time zone,
  "API_URL" character varying(255),
  "CONNECT_DESCRIPTOR" text,
  "GROUP_ID" integer DEFAULT 0,
  "GROUP_NAME" character varying(255),
  "ID" integer NOT NULL,
  "OAUTH_ID" character varying(255),
  "SECRET_KEY" character varying(255),
  "SYSTEM_PASSWORD" character varying(255),
  "SYSTEM_TOKEN_EXPIRY" timestamp without time zone,
  "SYSTEM_USER" character varying(255),
  "SYSTEM_USER_TOKEN" character varying(255),
  "TOKEN" character varying(255)
);


ALTER TABLE "AO_5FB9D7_AOHIP_CHAT_LINK" OWNER TO jirauser2;

--
-- Name: AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq" OWNED BY "AO_5FB9D7_AOHIP_CHAT_LINK"."ID";


--
-- Name: AO_5FB9D7_AOHIP_CHAT_USER; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_5FB9D7_AOHIP_CHAT_USER" (
  "HIP_CHAT_LINK_ID" integer,
  "HIP_CHAT_USER_ID" character varying(255),
  "HIP_CHAT_USER_NAME" character varying(255),
  "ID" integer NOT NULL,
  "REFRESH_CODE" character varying(255),
  "USER_KEY" character varying(255),
  "USER_SCOPES" character varying(255),
  "USER_TOKEN" character varying(255),
  "USER_TOKEN_EXPIRY" timestamp without time zone
);


ALTER TABLE "AO_5FB9D7_AOHIP_CHAT_USER" OWNER TO jirauser2;

--
-- Name: AO_5FB9D7_AOHIP_CHAT_USER_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_5FB9D7_AOHIP_CHAT_USER_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_5FB9D7_AOHIP_CHAT_USER_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_5FB9D7_AOHIP_CHAT_USER_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_5FB9D7_AOHIP_CHAT_USER_ID_seq" OWNED BY "AO_5FB9D7_AOHIP_CHAT_USER"."ID";


--
-- Name: AO_60DB71_AUDITENTRY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_AUDITENTRY" (
  "CATEGORY" character varying(255) NOT NULL,
  "DATA" text NOT NULL,
  "ENTITY_CLASS" character varying(255) NOT NULL,
  "ENTITY_ID" bigint NOT NULL,
  "ID" bigint NOT NULL,
  "TIME" bigint,
  "USER" character varying(255)
);


ALTER TABLE "AO_60DB71_AUDITENTRY" OWNER TO jirauser2;

--
-- Name: AO_60DB71_AUDITENTRY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_AUDITENTRY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_AUDITENTRY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_AUDITENTRY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_AUDITENTRY_ID_seq" OWNED BY "AO_60DB71_AUDITENTRY"."ID";


--
-- Name: AO_60DB71_BOARDADMINS; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_BOARDADMINS" (
  "ID" bigint NOT NULL,
  "KEY" character varying(255) NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL,
  "TYPE" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_BOARDADMINS" OWNER TO jirauser2;

--
-- Name: AO_60DB71_BOARDADMINS_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_BOARDADMINS_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_BOARDADMINS_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_BOARDADMINS_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_BOARDADMINS_ID_seq" OWNED BY "AO_60DB71_BOARDADMINS"."ID";


--
-- Name: AO_60DB71_CARDCOLOR; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_CARDCOLOR" (
  "COLOR" character varying(255),
  "ID" bigint NOT NULL,
  "POS" integer DEFAULT 0 NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL,
  "STRATEGY" character varying(255),
  "VAL" character varying(255)
);


ALTER TABLE "AO_60DB71_CARDCOLOR" OWNER TO jirauser2;

--
-- Name: AO_60DB71_CARDCOLOR_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_CARDCOLOR_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_CARDCOLOR_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_CARDCOLOR_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_CARDCOLOR_ID_seq" OWNED BY "AO_60DB71_CARDCOLOR"."ID";


--
-- Name: AO_60DB71_CARDLAYOUT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_CARDLAYOUT" (
  "FIELD_ID" character varying(255) NOT NULL,
  "ID" bigint NOT NULL,
  "MODE_NAME" character varying(255) NOT NULL,
  "POS" integer DEFAULT 0 NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_CARDLAYOUT" OWNER TO jirauser2;

--
-- Name: AO_60DB71_CARDLAYOUT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_CARDLAYOUT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_CARDLAYOUT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_CARDLAYOUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_CARDLAYOUT_ID_seq" OWNED BY "AO_60DB71_CARDLAYOUT"."ID";


--
-- Name: AO_60DB71_COLUMN; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_COLUMN" (
  "ID" bigint NOT NULL,
  "MAXIM" double precision,
  "MINIM" double precision,
  "NAME" character varying(255),
  "POS" integer DEFAULT 0 NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_COLUMN" OWNER TO jirauser2;

--
-- Name: AO_60DB71_COLUMNSTATUS; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_COLUMNSTATUS" (
  "COLUMN_ID" bigint NOT NULL,
  "ID" bigint NOT NULL,
  "POS" integer DEFAULT 0 NOT NULL,
  "STATUS_ID" character varying(255)
);


ALTER TABLE "AO_60DB71_COLUMNSTATUS" OWNER TO jirauser2;

--
-- Name: AO_60DB71_COLUMNSTATUS_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_COLUMNSTATUS_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_COLUMNSTATUS_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_COLUMNSTATUS_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_COLUMNSTATUS_ID_seq" OWNED BY "AO_60DB71_COLUMNSTATUS"."ID";


--
-- Name: AO_60DB71_COLUMN_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_COLUMN_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_COLUMN_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_COLUMN_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_COLUMN_ID_seq" OWNED BY "AO_60DB71_COLUMN"."ID";


--
-- Name: AO_60DB71_DETAILVIEWFIELD; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_DETAILVIEWFIELD" (
  "FIELD_ID" character varying(255) NOT NULL,
  "ID" bigint NOT NULL,
  "POS" integer DEFAULT 0 NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_DETAILVIEWFIELD" OWNER TO jirauser2;

--
-- Name: AO_60DB71_DETAILVIEWFIELD_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_DETAILVIEWFIELD_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_DETAILVIEWFIELD_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_DETAILVIEWFIELD_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_DETAILVIEWFIELD_ID_seq" OWNED BY "AO_60DB71_DETAILVIEWFIELD"."ID";


--
-- Name: AO_60DB71_ESTIMATESTATISTIC; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_ESTIMATESTATISTIC" (
  "FIELD_ID" character varying(255),
  "ID" bigint NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL,
  "TYPE_ID" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_ESTIMATESTATISTIC" OWNER TO jirauser2;

--
-- Name: AO_60DB71_ESTIMATESTATISTIC_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_ESTIMATESTATISTIC_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_ESTIMATESTATISTIC_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_ESTIMATESTATISTIC_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_ESTIMATESTATISTIC_ID_seq" OWNED BY "AO_60DB71_ESTIMATESTATISTIC"."ID";


--
-- Name: AO_60DB71_ISSUERANKING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_ISSUERANKING" (
  "CUSTOM_FIELD_ID" bigint DEFAULT 0 NOT NULL,
  "ID" bigint NOT NULL,
  "ISSUE_ID" bigint DEFAULT 0 NOT NULL,
  "NEXT_ID" bigint
);


ALTER TABLE "AO_60DB71_ISSUERANKING" OWNER TO jirauser2;

--
-- Name: AO_60DB71_ISSUERANKINGLOG; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_ISSUERANKINGLOG" (
  "CUSTOM_FIELD_ID" bigint,
  "ID" bigint NOT NULL,
  "ISSUE_ID" bigint,
  "LOG_TYPE" character varying(255),
  "NEW_NEXT_ID" bigint,
  "NEW_PREVIOUS_ID" bigint,
  "OLD_NEXT_ID" bigint,
  "OLD_PREVIOUS_ID" bigint,
  "SANITY_CHECKED" character varying(255)
);


ALTER TABLE "AO_60DB71_ISSUERANKINGLOG" OWNER TO jirauser2;

--
-- Name: AO_60DB71_ISSUERANKINGLOG_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_ISSUERANKINGLOG_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_ISSUERANKINGLOG_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_ISSUERANKINGLOG_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_ISSUERANKINGLOG_ID_seq" OWNED BY "AO_60DB71_ISSUERANKINGLOG"."ID";


--
-- Name: AO_60DB71_ISSUERANKING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_ISSUERANKING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_ISSUERANKING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_ISSUERANKING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_ISSUERANKING_ID_seq" OWNED BY "AO_60DB71_ISSUERANKING"."ID";


--
-- Name: AO_60DB71_LEXORANK; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_LEXORANK" (
  "FIELD_ID" bigint DEFAULT 0 NOT NULL,
  "ID" bigint NOT NULL,
  "ISSUE_ID" bigint DEFAULT 0 NOT NULL,
  "LOCK_HASH" character varying(255),
  "LOCK_TIME" bigint,
  "RANK" character varying(255) NOT NULL,
  "TYPE" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "AO_60DB71_LEXORANK" OWNER TO jirauser2;

--
-- Name: AO_60DB71_LEXORANKBALANCER; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_LEXORANKBALANCER" (
  "DISABLE_RANK_OPERATIONS" boolean NOT NULL,
  "FIELD_ID" bigint NOT NULL,
  "ID" bigint NOT NULL,
  "REBALANCE_TIME" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_LEXORANKBALANCER" OWNER TO jirauser2;

--
-- Name: AO_60DB71_LEXORANKBALANCER_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_LEXORANKBALANCER_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_LEXORANKBALANCER_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_LEXORANKBALANCER_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_LEXORANKBALANCER_ID_seq" OWNED BY "AO_60DB71_LEXORANKBALANCER"."ID";


--
-- Name: AO_60DB71_LEXORANK_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_LEXORANK_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_LEXORANK_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_LEXORANK_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_LEXORANK_ID_seq" OWNED BY "AO_60DB71_LEXORANK"."ID";


--
-- Name: AO_60DB71_NONWORKINGDAY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_NONWORKINGDAY" (
  "ID" bigint NOT NULL,
  "ISO8601_DATE" character varying(255) NOT NULL,
  "WORKING_DAYS_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_NONWORKINGDAY" OWNER TO jirauser2;

--
-- Name: AO_60DB71_NONWORKINGDAY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_NONWORKINGDAY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_NONWORKINGDAY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_NONWORKINGDAY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_NONWORKINGDAY_ID_seq" OWNED BY "AO_60DB71_NONWORKINGDAY"."ID";


--
-- Name: AO_60DB71_QUICKFILTER; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_QUICKFILTER" (
  "DESCRIPTION" character varying(255),
  "ID" bigint NOT NULL,
  "NAME" character varying(255) NOT NULL,
  "POS" integer DEFAULT 0 NOT NULL,
  "QUERY" character varying(255),
  "RAPID_VIEW_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_QUICKFILTER" OWNER TO jirauser2;

--
-- Name: AO_60DB71_QUICKFILTER_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_QUICKFILTER_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_QUICKFILTER_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_QUICKFILTER_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_QUICKFILTER_ID_seq" OWNED BY "AO_60DB71_QUICKFILTER"."ID";


--
-- Name: AO_60DB71_RANKABLEOBJECT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_RANKABLEOBJECT" (
  "ID" bigint NOT NULL,
  "TYPE" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_RANKABLEOBJECT" OWNER TO jirauser2;

--
-- Name: AO_60DB71_RANKABLEOBJECT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_RANKABLEOBJECT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_RANKABLEOBJECT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_RANKABLEOBJECT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_RANKABLEOBJECT_ID_seq" OWNED BY "AO_60DB71_RANKABLEOBJECT"."ID";


--
-- Name: AO_60DB71_RANK_ISSUE_LINK; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_RANK_ISSUE_LINK" (
  "ISSUE_ID" bigint NOT NULL,
  "NEXT_ID" bigint
);


ALTER TABLE "AO_60DB71_RANK_ISSUE_LINK" OWNER TO jirauser2;

--
-- Name: AO_60DB71_RAPIDVIEW; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_RAPIDVIEW" (
  "CARD_COLOR_STRATEGY" character varying(255),
  "ID" bigint NOT NULL,
  "NAME" character varying(255) NOT NULL,
  "OWNER_USER_NAME" character varying(255) NOT NULL,
  "SAVED_FILTER_ID" bigint NOT NULL,
  "SHOW_DAYS_IN_COLUMN" boolean,
  "SPRINTS_ENABLED" boolean,
  "SPRINT_MARKERS_MIGRATED" boolean,
  "SWIMLANE_STRATEGY" character varying(255)
);


ALTER TABLE "AO_60DB71_RAPIDVIEW" OWNER TO jirauser2;

--
-- Name: AO_60DB71_RAPIDVIEW_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_RAPIDVIEW_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_RAPIDVIEW_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_RAPIDVIEW_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_RAPIDVIEW_ID_seq" OWNED BY "AO_60DB71_RAPIDVIEW"."ID";


--
-- Name: AO_60DB71_SPRINT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_SPRINT" (
  "CLOSED" boolean NOT NULL,
  "COMPLETE_DATE" bigint,
  "END_DATE" bigint,
  "ID" bigint NOT NULL,
  "NAME" character varying(255) NOT NULL,
  "RAPID_VIEW_ID" bigint,
  "SEQUENCE" bigint,
  "STARTED" boolean,
  "START_DATE" bigint
);


ALTER TABLE "AO_60DB71_SPRINT" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SPRINTMARKER; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_SPRINTMARKER" (
  "ID" bigint DEFAULT 0 NOT NULL,
  "MARKER_CONTEXT" bigint NOT NULL,
  "NAME" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_SPRINTMARKER" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SPRINT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_SPRINT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_SPRINT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SPRINT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_SPRINT_ID_seq" OWNED BY "AO_60DB71_SPRINT"."ID";


--
-- Name: AO_60DB71_STATSFIELD; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_STATSFIELD" (
  "ID" bigint NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL,
  "TYPE_ID" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_STATSFIELD" OWNER TO jirauser2;

--
-- Name: AO_60DB71_STATSFIELD_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_STATSFIELD_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_STATSFIELD_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_STATSFIELD_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_STATSFIELD_ID_seq" OWNED BY "AO_60DB71_STATSFIELD"."ID";


--
-- Name: AO_60DB71_SUBQUERY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_SUBQUERY" (
  "ID" bigint NOT NULL,
  "QUERY" character varying(255),
  "RAPID_VIEW_ID" bigint,
  "SECTION" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_SUBQUERY" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SUBQUERY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_SUBQUERY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_SUBQUERY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SUBQUERY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_SUBQUERY_ID_seq" OWNED BY "AO_60DB71_SUBQUERY"."ID";


--
-- Name: AO_60DB71_SWIMLANE; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_SWIMLANE" (
  "DEFAULT_LANE" boolean NOT NULL,
  "DESCRIPTION" character varying(255),
  "ID" bigint NOT NULL,
  "NAME" character varying(255) NOT NULL,
  "POS" integer DEFAULT 0 NOT NULL,
  "QUERY" character varying(255),
  "RAPID_VIEW_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_SWIMLANE" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SWIMLANE_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_SWIMLANE_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_SWIMLANE_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_SWIMLANE_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_SWIMLANE_ID_seq" OWNED BY "AO_60DB71_SWIMLANE"."ID";


--
-- Name: AO_60DB71_TRACKINGSTATISTIC; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_TRACKINGSTATISTIC" (
  "FIELD_ID" character varying(255),
  "ID" bigint NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL,
  "TYPE_ID" character varying(255) NOT NULL
);


ALTER TABLE "AO_60DB71_TRACKINGSTATISTIC" OWNER TO jirauser2;

--
-- Name: AO_60DB71_TRACKINGSTATISTIC_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_TRACKINGSTATISTIC_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_TRACKINGSTATISTIC_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_TRACKINGSTATISTIC_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_TRACKINGSTATISTIC_ID_seq" OWNED BY "AO_60DB71_TRACKINGSTATISTIC"."ID";


--
-- Name: AO_60DB71_VERSION; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_VERSION" (
  "ID" bigint NOT NULL,
  "START_DATE" bigint,
  "VERSION_ID" bigint NOT NULL
);


ALTER TABLE "AO_60DB71_VERSION" OWNER TO jirauser2;

--
-- Name: AO_60DB71_VERSION_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_VERSION_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_VERSION_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_VERSION_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_VERSION_ID_seq" OWNED BY "AO_60DB71_VERSION"."ID";


--
-- Name: AO_60DB71_WORKINGDAYS; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_60DB71_WORKINGDAYS" (
  "FRIDAY" boolean NOT NULL,
  "ID" bigint NOT NULL,
  "MONDAY" boolean NOT NULL,
  "RAPID_VIEW_ID" bigint NOT NULL,
  "SATURDAY" boolean NOT NULL,
  "SUNDAY" boolean NOT NULL,
  "THURSDAY" boolean NOT NULL,
  "TIMEZONE" character varying(255) NOT NULL,
  "TUESDAY" boolean NOT NULL,
  "WEDNESDAY" boolean NOT NULL
);


ALTER TABLE "AO_60DB71_WORKINGDAYS" OWNER TO jirauser2;

--
-- Name: AO_60DB71_WORKINGDAYS_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_60DB71_WORKINGDAYS_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_60DB71_WORKINGDAYS_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_60DB71_WORKINGDAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_60DB71_WORKINGDAYS_ID_seq" OWNED BY "AO_60DB71_WORKINGDAYS"."ID";


--
-- Name: AO_97EDAB_USERINVITATION; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_97EDAB_USERINVITATION" (
  "APPLICATION_KEYS" character varying(255),
  "EMAIL_ADDRESS" character varying(255),
  "EXPIRY" timestamp without time zone,
  "ID" integer NOT NULL,
  "REDEEMED" boolean,
  "SENDER_USERNAME" character varying(255),
  "TOKEN" character varying(255)
);


ALTER TABLE "AO_97EDAB_USERINVITATION" OWNER TO jirauser2;

--
-- Name: AO_97EDAB_USERINVITATION_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_97EDAB_USERINVITATION_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_97EDAB_USERINVITATION_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_97EDAB_USERINVITATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_97EDAB_USERINVITATION_ID_seq" OWNED BY "AO_97EDAB_USERINVITATION"."ID";


--
-- Name: AO_A0B856_WEB_HOOK_LISTENER_AO; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_A0B856_WEB_HOOK_LISTENER_AO" (
  "DESCRIPTION" text,
  "ENABLED" boolean,
  "EVENTS" text,
  "EXCLUDE_BODY" boolean,
  "FILTERS" text,
  "ID" integer NOT NULL,
  "LAST_UPDATED" timestamp without time zone NOT NULL,
  "LAST_UPDATED_USER" character varying(255),
  "NAME" text NOT NULL,
  "PARAMETERS" text,
  "REGISTRATION_METHOD" character varying(255) NOT NULL,
  "URL" text NOT NULL
);


ALTER TABLE "AO_A0B856_WEB_HOOK_LISTENER_AO" OWNER TO jirauser2;

--
-- Name: AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq" OWNED BY "AO_A0B856_WEB_HOOK_LISTENER_AO"."ID";


--
-- Name: AO_A44657_HEALTH_CHECK_ENTITY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_A44657_HEALTH_CHECK_ENTITY" (
  "ID" integer NOT NULL
);


ALTER TABLE "AO_A44657_HEALTH_CHECK_ENTITY" OWNER TO jirauser2;

--
-- Name: AO_A44657_HEALTH_CHECK_ENTITY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_A44657_HEALTH_CHECK_ENTITY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_A44657_HEALTH_CHECK_ENTITY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_A44657_HEALTH_CHECK_ENTITY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_A44657_HEALTH_CHECK_ENTITY_ID_seq" OWNED BY "AO_A44657_HEALTH_CHECK_ENTITY"."ID";


--
-- Name: AO_B9A0F0_APPLIED_TEMPLATE; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_B9A0F0_APPLIED_TEMPLATE" (
  "ID" integer NOT NULL,
  "PROJECT_ID" bigint DEFAULT 0,
  "PROJECT_TEMPLATE_MODULE_KEY" character varying(255),
  "PROJECT_TEMPLATE_WEB_ITEM_KEY" character varying(255)
);


ALTER TABLE "AO_B9A0F0_APPLIED_TEMPLATE" OWNER TO jirauser2;

--
-- Name: AO_B9A0F0_APPLIED_TEMPLATE_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_B9A0F0_APPLIED_TEMPLATE_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_B9A0F0_APPLIED_TEMPLATE_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_B9A0F0_APPLIED_TEMPLATE_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_B9A0F0_APPLIED_TEMPLATE_ID_seq" OWNED BY "AO_B9A0F0_APPLIED_TEMPLATE"."ID";


--
-- Name: AO_CFF990_AOTRANSITION_FAILURE; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_CFF990_AOTRANSITION_FAILURE" (
  "ERROR_MESSAGES" text,
  "FAILURE_TIME" timestamp without time zone,
  "ID" integer NOT NULL,
  "ISSUE_ID" bigint DEFAULT 0,
  "LOG_REFERRAL_HASH" character varying(255),
  "TRANSITION_ID" bigint DEFAULT 0,
  "TRIGGER_ID" bigint DEFAULT 0,
  "USER_KEY" character varying(255),
  "WORKFLOW_ID" character varying(255)
);


ALTER TABLE "AO_CFF990_AOTRANSITION_FAILURE" OWNER TO jirauser2;

--
-- Name: AO_CFF990_AOTRANSITION_FAILURE_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_CFF990_AOTRANSITION_FAILURE_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_CFF990_AOTRANSITION_FAILURE_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_CFF990_AOTRANSITION_FAILURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_CFF990_AOTRANSITION_FAILURE_ID_seq" OWNED BY "AO_CFF990_AOTRANSITION_FAILURE"."ID";


--
-- Name: AO_DEB285_BLOG_AO; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_DEB285_BLOG_AO" (
  "AUTHOR" character varying(255),
  "ID" bigint NOT NULL,
  "TEXT" character varying(255)
);


ALTER TABLE "AO_DEB285_BLOG_AO" OWNER TO jirauser2;

--
-- Name: AO_DEB285_BLOG_AO_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_DEB285_BLOG_AO_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_DEB285_BLOG_AO_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_DEB285_BLOG_AO_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_DEB285_BLOG_AO_ID_seq" OWNED BY "AO_DEB285_BLOG_AO"."ID";


--
-- Name: AO_DEB285_COMMENT_AO; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_DEB285_COMMENT_AO" (
  "AUTHOR" character varying(255),
  "BLOG_ID" bigint,
  "COMMENT" character varying(255),
  "DATE" timestamp without time zone,
  "ID" integer NOT NULL
);


ALTER TABLE "AO_DEB285_COMMENT_AO" OWNER TO jirauser2;

--
-- Name: AO_DEB285_COMMENT_AO_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_DEB285_COMMENT_AO_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_DEB285_COMMENT_AO_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_DEB285_COMMENT_AO_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_DEB285_COMMENT_AO_ID_seq" OWNED BY "AO_DEB285_COMMENT_AO"."ID";


--
-- Name: AO_E8B6CC_BRANCH; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_BRANCH" (
  "ID" integer NOT NULL,
  "NAME" character varying(255),
  "REPOSITORY_ID" integer
);


ALTER TABLE "AO_E8B6CC_BRANCH" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_BRANCH_HEAD_MAPPING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_BRANCH_HEAD_MAPPING" (
  "BRANCH_NAME" character varying(255),
  "HEAD" character varying(255),
  "ID" integer NOT NULL,
  "REPOSITORY_ID" integer
);


ALTER TABLE "AO_E8B6CC_BRANCH_HEAD_MAPPING" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq" OWNED BY "AO_E8B6CC_BRANCH_HEAD_MAPPING"."ID";


--
-- Name: AO_E8B6CC_BRANCH_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_BRANCH_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_BRANCH_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_BRANCH_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_BRANCH_ID_seq" OWNED BY "AO_E8B6CC_BRANCH"."ID";


--
-- Name: AO_E8B6CC_CHANGESET_MAPPING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_CHANGESET_MAPPING" (
  "AUTHOR" character varying(255),
  "AUTHOR_EMAIL" character varying(255),
  "BRANCH" character varying(255),
  "DATE" timestamp without time zone,
  "FILES_DATA" text,
  "FILE_COUNT" integer DEFAULT 0,
  "FILE_DETAILS_JSON" text,
  "ID" integer NOT NULL,
  "ISSUE_KEY" character varying(255),
  "MESSAGE" text,
  "NODE" character varying(255),
  "PARENTS_DATA" character varying(255),
  "PROJECT_KEY" character varying(255),
  "RAW_AUTHOR" character varying(255),
  "RAW_NODE" character varying(255),
  "REPOSITORY_ID" integer DEFAULT 0,
  "SMARTCOMMIT_AVAILABLE" boolean,
  "VERSION" integer
);


ALTER TABLE "AO_E8B6CC_CHANGESET_MAPPING" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_CHANGESET_MAPPING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_CHANGESET_MAPPING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_CHANGESET_MAPPING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_CHANGESET_MAPPING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_CHANGESET_MAPPING_ID_seq" OWNED BY "AO_E8B6CC_CHANGESET_MAPPING"."ID";


--
-- Name: AO_E8B6CC_COMMIT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_COMMIT" (
  "AUTHOR" character varying(255),
  "AUTHOR_AVATAR_URL" character varying(255),
  "DATE" timestamp without time zone NOT NULL,
  "DOMAIN_ID" integer DEFAULT 0 NOT NULL,
  "ID" integer NOT NULL,
  "MERGE" boolean,
  "MESSAGE" text,
  "NODE" character varying(255),
  "RAW_AUTHOR" character varying(255)
);


ALTER TABLE "AO_E8B6CC_COMMIT" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_COMMIT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_COMMIT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_COMMIT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_COMMIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_COMMIT_ID_seq" OWNED BY "AO_E8B6CC_COMMIT"."ID";


--
-- Name: AO_E8B6CC_GIT_HUB_EVENT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_GIT_HUB_EVENT" (
  "CREATED_AT" timestamp without time zone NOT NULL,
  "GIT_HUB_ID" character varying(255) DEFAULT '0'::character varying NOT NULL,
  "ID" integer NOT NULL,
  "REPOSITORY_ID" integer NOT NULL,
  "SAVE_POINT" boolean
);


ALTER TABLE "AO_E8B6CC_GIT_HUB_EVENT" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_GIT_HUB_EVENT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_GIT_HUB_EVENT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_GIT_HUB_EVENT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_GIT_HUB_EVENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_GIT_HUB_EVENT_ID_seq" OWNED BY "AO_E8B6CC_GIT_HUB_EVENT"."ID";


--
-- Name: AO_E8B6CC_ISSUE_MAPPING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_ISSUE_MAPPING" (
  "ID" integer NOT NULL,
  "ISSUE_ID" character varying(255),
  "NODE" character varying(255),
  "PROJECT_KEY" character varying(255),
  "REPOSITORY_URI" character varying(255)
);


ALTER TABLE "AO_E8B6CC_ISSUE_MAPPING" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_MAPPING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_ISSUE_MAPPING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_ISSUE_MAPPING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_MAPPING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_ISSUE_MAPPING_ID_seq" OWNED BY "AO_E8B6CC_ISSUE_MAPPING"."ID";


--
-- Name: AO_E8B6CC_ISSUE_MAPPING_V2; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_ISSUE_MAPPING_V2" (
  "AUTHOR" character varying(255),
  "BRANCH" character varying(255),
  "DATE" timestamp without time zone,
  "FILES_DATA" text,
  "ID" integer NOT NULL,
  "ISSUE_ID" character varying(255),
  "MESSAGE" text,
  "NODE" character varying(255),
  "PARENTS_DATA" character varying(255),
  "RAW_AUTHOR" character varying(255),
  "RAW_NODE" character varying(255),
  "REPOSITORY_ID" integer DEFAULT 0,
  "VERSION" integer
);


ALTER TABLE "AO_E8B6CC_ISSUE_MAPPING_V2" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq" OWNED BY "AO_E8B6CC_ISSUE_MAPPING_V2"."ID";


--
-- Name: AO_E8B6CC_ISSUE_TO_BRANCH; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_ISSUE_TO_BRANCH" (
  "BRANCH_ID" integer,
  "ID" integer NOT NULL,
  "ISSUE_KEY" character varying(255)
);


ALTER TABLE "AO_E8B6CC_ISSUE_TO_BRANCH" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq" OWNED BY "AO_E8B6CC_ISSUE_TO_BRANCH"."ID";


--
-- Name: AO_E8B6CC_ISSUE_TO_CHANGESET; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_ISSUE_TO_CHANGESET" (
  "CHANGESET_ID" integer,
  "ID" integer NOT NULL,
  "ISSUE_KEY" character varying(255),
  "PROJECT_KEY" character varying(255)
);


ALTER TABLE "AO_E8B6CC_ISSUE_TO_CHANGESET" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq" OWNED BY "AO_E8B6CC_ISSUE_TO_CHANGESET"."ID";


--
-- Name: AO_E8B6CC_MESSAGE; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_MESSAGE" (
  "ADDRESS" character varying(255) NOT NULL,
  "ID" integer NOT NULL,
  "PAYLOAD" text NOT NULL,
  "PAYLOAD_TYPE" character varying(255) NOT NULL,
  "PRIORITY" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "AO_E8B6CC_MESSAGE" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_MESSAGE_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_MESSAGE_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_MESSAGE_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_MESSAGE_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_MESSAGE_ID_seq" OWNED BY "AO_E8B6CC_MESSAGE"."ID";


--
-- Name: AO_E8B6CC_MESSAGE_QUEUE_ITEM; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_MESSAGE_QUEUE_ITEM" (
  "ID" integer NOT NULL,
  "LAST_FAILED" timestamp without time zone,
  "MESSAGE_ID" integer NOT NULL,
  "QUEUE" character varying(255) NOT NULL,
  "RETRIES_COUNT" integer DEFAULT 0 NOT NULL,
  "STATE" character varying(255) NOT NULL,
  "STATE_INFO" character varying(255)
);


ALTER TABLE "AO_E8B6CC_MESSAGE_QUEUE_ITEM" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq" OWNED BY "AO_E8B6CC_MESSAGE_QUEUE_ITEM"."ID";


--
-- Name: AO_E8B6CC_MESSAGE_TAG; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_MESSAGE_TAG" (
  "ID" integer NOT NULL,
  "MESSAGE_ID" integer,
  "TAG" character varying(255)
);


ALTER TABLE "AO_E8B6CC_MESSAGE_TAG" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_MESSAGE_TAG_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_MESSAGE_TAG_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_MESSAGE_TAG_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_MESSAGE_TAG_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_MESSAGE_TAG_ID_seq" OWNED BY "AO_E8B6CC_MESSAGE_TAG"."ID";


--
-- Name: AO_E8B6CC_ORGANIZATION_MAPPING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_ORGANIZATION_MAPPING" (
  "ACCESS_TOKEN" character varying(255),
  "ADMIN_PASSWORD" character varying(255),
  "ADMIN_USERNAME" character varying(255),
  "AUTOLINK_NEW_REPOS" boolean,
  "DEFAULT_GROUPS_SLUGS" character varying(255),
  "DVCS_TYPE" character varying(255),
  "HOST_URL" character varying(255),
  "ID" integer NOT NULL,
  "NAME" character varying(255),
  "OAUTH_KEY" character varying(255),
  "OAUTH_SECRET" character varying(255),
  "SMARTCOMMITS_FOR_NEW_REPOS" boolean
);


ALTER TABLE "AO_E8B6CC_ORGANIZATION_MAPPING" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq" OWNED BY "AO_E8B6CC_ORGANIZATION_MAPPING"."ID";


--
-- Name: AO_E8B6CC_PROJECT_MAPPING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_PROJECT_MAPPING" (
  "ID" integer NOT NULL,
  "PASSWORD" character varying(255),
  "PROJECT_KEY" character varying(255),
  "REPOSITORY_URI" character varying(255),
  "USERNAME" character varying(255)
);


ALTER TABLE "AO_E8B6CC_PROJECT_MAPPING" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PROJECT_MAPPING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_PROJECT_MAPPING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_PROJECT_MAPPING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PROJECT_MAPPING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_PROJECT_MAPPING_ID_seq" OWNED BY "AO_E8B6CC_PROJECT_MAPPING"."ID";


--
-- Name: AO_E8B6CC_PROJECT_MAPPING_V2; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_PROJECT_MAPPING_V2" (
  "ACCESS_TOKEN" character varying(255),
  "ADMIN_PASSWORD" character varying(255),
  "ADMIN_USERNAME" character varying(255),
  "ID" integer NOT NULL,
  "LAST_COMMIT_DATE" timestamp without time zone,
  "PROJECT_KEY" character varying(255),
  "REPOSITORY_NAME" character varying(255),
  "REPOSITORY_TYPE" character varying(255),
  "REPOSITORY_URL" character varying(255)
);


ALTER TABLE "AO_E8B6CC_PROJECT_MAPPING_V2" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq" OWNED BY "AO_E8B6CC_PROJECT_MAPPING_V2"."ID";


--
-- Name: AO_E8B6CC_PR_ISSUE_KEY; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_PR_ISSUE_KEY" (
  "DOMAIN_ID" integer DEFAULT 0 NOT NULL,
  "ID" integer NOT NULL,
  "ISSUE_KEY" character varying(255),
  "PULL_REQUEST_ID" integer DEFAULT 0
);


ALTER TABLE "AO_E8B6CC_PR_ISSUE_KEY" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PR_ISSUE_KEY_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_PR_ISSUE_KEY_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_PR_ISSUE_KEY_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PR_ISSUE_KEY_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_PR_ISSUE_KEY_ID_seq" OWNED BY "AO_E8B6CC_PR_ISSUE_KEY"."ID";


--
-- Name: AO_E8B6CC_PR_PARTICIPANT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_PR_PARTICIPANT" (
  "APPROVED" boolean,
  "DOMAIN_ID" integer DEFAULT 0 NOT NULL,
  "ID" integer NOT NULL,
  "PULL_REQUEST_ID" integer,
  "ROLE" character varying(255),
  "USERNAME" character varying(255)
);


ALTER TABLE "AO_E8B6CC_PR_PARTICIPANT" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PR_PARTICIPANT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_PR_PARTICIPANT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_PR_PARTICIPANT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PR_PARTICIPANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_PR_PARTICIPANT_ID_seq" OWNED BY "AO_E8B6CC_PR_PARTICIPANT"."ID";


--
-- Name: AO_E8B6CC_PR_TO_COMMIT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_PR_TO_COMMIT" (
  "COMMIT_ID" integer NOT NULL,
  "DOMAIN_ID" integer DEFAULT 0 NOT NULL,
  "ID" integer NOT NULL,
  "REQUEST_ID" integer NOT NULL
);


ALTER TABLE "AO_E8B6CC_PR_TO_COMMIT" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PR_TO_COMMIT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_PR_TO_COMMIT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_PR_TO_COMMIT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PR_TO_COMMIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_PR_TO_COMMIT_ID_seq" OWNED BY "AO_E8B6CC_PR_TO_COMMIT"."ID";


--
-- Name: AO_E8B6CC_PULL_REQUEST; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_PULL_REQUEST" (
  "AUTHOR" character varying(255),
  "COMMENT_COUNT" integer DEFAULT 0,
  "CREATED_ON" timestamp without time zone,
  "DESTINATION_BRANCH" character varying(255),
  "DOMAIN_ID" integer DEFAULT 0 NOT NULL,
  "EXECUTED_BY" character varying(255),
  "ID" integer NOT NULL,
  "LAST_STATUS" character varying(255),
  "NAME" character varying(255),
  "REMOTE_ID" bigint,
  "SOURCE_BRANCH" character varying(255),
  "SOURCE_REPO" character varying(255),
  "TO_REPOSITORY_ID" integer DEFAULT 0,
  "UPDATED_ON" timestamp without time zone,
  "URL" character varying(255)
);


ALTER TABLE "AO_E8B6CC_PULL_REQUEST" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PULL_REQUEST_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_PULL_REQUEST_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_PULL_REQUEST_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_PULL_REQUEST_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_PULL_REQUEST_ID_seq" OWNED BY "AO_E8B6CC_PULL_REQUEST"."ID";


--
-- Name: AO_E8B6CC_REPOSITORY_MAPPING; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_REPOSITORY_MAPPING" (
  "ACTIVITY_LAST_SYNC" timestamp without time zone,
  "DELETED" boolean,
  "FORK" boolean,
  "FORK_OF_NAME" character varying(255),
  "FORK_OF_OWNER" character varying(255),
  "FORK_OF_SLUG" character varying(255),
  "ID" integer NOT NULL,
  "LAST_CHANGESET_NODE" character varying(255),
  "LAST_COMMIT_DATE" timestamp without time zone,
  "LINKED" boolean,
  "LOGO" text,
  "NAME" character varying(255),
  "ORGANIZATION_ID" integer DEFAULT 0,
  "SLUG" character varying(255),
  "SMARTCOMMITS_ENABLED" boolean,
  "UPDATE_LINK_AUTHORISED" boolean
);


ALTER TABLE "AO_E8B6CC_REPOSITORY_MAPPING" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_REPOSITORY_MAPPING_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_REPOSITORY_MAPPING_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_REPOSITORY_MAPPING_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_REPOSITORY_MAPPING_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_REPOSITORY_MAPPING_ID_seq" OWNED BY "AO_E8B6CC_REPOSITORY_MAPPING"."ID";


--
-- Name: AO_E8B6CC_REPO_TO_CHANGESET; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_REPO_TO_CHANGESET" (
  "CHANGESET_ID" integer,
  "ID" integer NOT NULL,
  "REPOSITORY_ID" integer
);


ALTER TABLE "AO_E8B6CC_REPO_TO_CHANGESET" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_REPO_TO_CHANGESET_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_REPO_TO_CHANGESET_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_REPO_TO_CHANGESET_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_REPO_TO_CHANGESET_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_REPO_TO_CHANGESET_ID_seq" OWNED BY "AO_E8B6CC_REPO_TO_CHANGESET"."ID";


--
-- Name: AO_E8B6CC_REPO_TO_PROJECT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_REPO_TO_PROJECT" (
  "ID" integer NOT NULL,
  "PROJECT_KEY" character varying(255),
  "REPOSITORY_ID" integer
);


ALTER TABLE "AO_E8B6CC_REPO_TO_PROJECT" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_REPO_TO_PROJECT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_REPO_TO_PROJECT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_REPO_TO_PROJECT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_REPO_TO_PROJECT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_REPO_TO_PROJECT_ID_seq" OWNED BY "AO_E8B6CC_REPO_TO_PROJECT"."ID";


--
-- Name: AO_E8B6CC_SYNC_AUDIT_LOG; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_SYNC_AUDIT_LOG" (
  "END_DATE" timestamp without time zone,
  "EXC_TRACE" text,
  "FIRST_REQUEST_DATE" timestamp without time zone,
  "FLIGHT_TIME_MS" integer DEFAULT 0,
  "ID" integer NOT NULL,
  "NUM_REQUESTS" integer DEFAULT 0,
  "REPO_ID" integer DEFAULT 0,
  "START_DATE" timestamp without time zone,
  "SYNC_STATUS" character varying(255),
  "SYNC_TYPE" character varying(255),
  "TOTAL_ERRORS" integer DEFAULT 0
);


ALTER TABLE "AO_E8B6CC_SYNC_AUDIT_LOG" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq" OWNED BY "AO_E8B6CC_SYNC_AUDIT_LOG"."ID";


--
-- Name: AO_E8B6CC_SYNC_EVENT; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE "AO_E8B6CC_SYNC_EVENT" (
  "EVENT_CLASS" text NOT NULL,
  "EVENT_DATE" timestamp without time zone NOT NULL,
  "EVENT_JSON" text NOT NULL,
  "ID" integer NOT NULL,
  "REPO_ID" integer DEFAULT 0 NOT NULL,
  "SCHEDULED_SYNC" boolean
);


ALTER TABLE "AO_E8B6CC_SYNC_EVENT" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_SYNC_EVENT_ID_seq; Type: SEQUENCE; Schema: public; Owner: jirauser2
--

CREATE SEQUENCE "AO_E8B6CC_SYNC_EVENT_ID_seq"
START WITH 1
INCREMENT BY 1
NO MINVALUE
NO MAXVALUE
CACHE 1;


ALTER TABLE "AO_E8B6CC_SYNC_EVENT_ID_seq" OWNER TO jirauser2;

--
-- Name: AO_E8B6CC_SYNC_EVENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: jirauser2
--

ALTER SEQUENCE "AO_E8B6CC_SYNC_EVENT_ID_seq" OWNED BY "AO_E8B6CC_SYNC_EVENT"."ID";


--
-- Name: app_user; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE app_user (
  id numeric(18,0) NOT NULL,
  user_key character varying(255),
  lower_user_name character varying(255)
);


ALTER TABLE app_user OWNER TO jirauser2;

--
-- Name: audit_changed_value; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE audit_changed_value (
  id numeric(18,0) NOT NULL,
  log_id numeric(18,0),
  name character varying(255),
  delta_from text,
  delta_to text
);


ALTER TABLE audit_changed_value OWNER TO jirauser2;

--
-- Name: audit_item; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE audit_item (
  id numeric(18,0) NOT NULL,
  log_id numeric(18,0),
  object_type character varying(60),
  object_id character varying(255),
  object_name character varying(255),
  object_parent_id character varying(255),
  object_parent_name character varying(255)
);


ALTER TABLE audit_item OWNER TO jirauser2;

--
-- Name: audit_log; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE audit_log (
  id numeric(18,0) NOT NULL,
  remote_address character varying(60),
  created timestamp with time zone,
  author_key character varying(255),
  summary character varying(255),
  category character varying(255),
  object_type character varying(60),
  object_id character varying(255),
  object_name character varying(255),
  object_parent_id character varying(255),
  object_parent_name character varying(255),
  author_type numeric(9,0),
  event_source_name character varying(255),
  description character varying(255),
  search_field text
);


ALTER TABLE audit_log OWNER TO jirauser2;

--
-- Name: avatar; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE avatar (
  id numeric(18,0) NOT NULL,
  filename character varying(255),
  contenttype character varying(255),
  avatartype character varying(60),
  owner character varying(255),
  systemavatar numeric(9,0)
);


ALTER TABLE avatar OWNER TO jirauser2;

--
-- Name: changegroup; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE changegroup (
  id numeric(18,0) NOT NULL,
  issueid numeric(18,0),
  author character varying(255),
  created timestamp with time zone
);


ALTER TABLE changegroup OWNER TO jirauser2;

--
-- Name: changeitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE changeitem (
  id numeric(18,0) NOT NULL,
  groupid numeric(18,0),
  fieldtype character varying(255),
  field character varying(255),
  oldvalue text,
  oldstring text,
  newvalue text,
  newstring text
);


ALTER TABLE changeitem OWNER TO jirauser2;

--
-- Name: clusteredjob; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE clusteredjob (
  id numeric(18,0) NOT NULL,
  job_id character varying(255),
  job_runner_key character varying(255),
  sched_type character(1),
  interval_millis numeric(18,0),
  first_run numeric(18,0),
  cron_expression character varying(255),
  time_zone character varying(60),
  next_run numeric(18,0),
  version numeric(18,0),
  parameters bytea
);


ALTER TABLE clusteredjob OWNER TO jirauser2;

--
-- Name: clusterlockstatus; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE clusterlockstatus (
  id numeric(18,0) NOT NULL,
  lock_name character varying(255),
  locked_by_node character varying(60),
  update_time numeric(18,0)
);


ALTER TABLE clusterlockstatus OWNER TO jirauser2;

--
-- Name: clustermessage; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE clustermessage (
  id numeric(18,0) NOT NULL,
  source_node character varying(60),
  destination_node character varying(60),
  claimed_by_node character varying(60),
  message character varying(255),
  message_time timestamp with time zone
);


ALTER TABLE clustermessage OWNER TO jirauser2;

--
-- Name: clusternode; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE clusternode (
  node_id character varying(60) NOT NULL,
  node_state character varying(60),
  "timestamp" numeric(18,0),
  ip character varying(60),
  cache_listener_port numeric(18,0)
);


ALTER TABLE clusternode OWNER TO jirauser2;

--
-- Name: clusternodeheartbeat; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE clusternodeheartbeat (
  node_id character varying(60) NOT NULL,
  heartbeat_time numeric(18,0),
  database_time numeric(18,0)
);


ALTER TABLE clusternodeheartbeat OWNER TO jirauser2;

--
-- Name: columnlayout; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE columnlayout (
  id numeric(18,0) NOT NULL,
  username character varying(255),
  searchrequest numeric(18,0)
);


ALTER TABLE columnlayout OWNER TO jirauser2;

--
-- Name: columnlayoutitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE columnlayoutitem (
  id numeric(18,0) NOT NULL,
  columnlayout numeric(18,0),
  fieldidentifier character varying(255),
  horizontalposition numeric(18,0)
);


ALTER TABLE columnlayoutitem OWNER TO jirauser2;

--
-- Name: component; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE component (
  id numeric(18,0) NOT NULL,
  project numeric(18,0),
  cname character varying(255),
  description text,
  url character varying(255),
  lead character varying(255),
  assigneetype numeric(18,0)
);


ALTER TABLE component OWNER TO jirauser2;

--
-- Name: configurationcontext; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE configurationcontext (
  id numeric(18,0) NOT NULL,
  projectcategory numeric(18,0),
  project numeric(18,0),
  customfield character varying(255),
  fieldconfigscheme numeric(18,0)
);


ALTER TABLE configurationcontext OWNER TO jirauser2;

--
-- Name: customfield; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE customfield (
  id numeric(18,0) NOT NULL,
  customfieldtypekey character varying(255),
  customfieldsearcherkey character varying(255),
  cfname character varying(255),
  description text,
  defaultvalue character varying(255),
  fieldtype numeric(18,0),
  project numeric(18,0),
  issuetype character varying(255)
);


ALTER TABLE customfield OWNER TO jirauser2;

--
-- Name: customfieldoption; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE customfieldoption (
  id numeric(18,0) NOT NULL,
  customfield numeric(18,0),
  customfieldconfig numeric(18,0),
  parentoptionid numeric(18,0),
  sequence numeric(18,0),
  customvalue character varying(255),
  optiontype character varying(60),
  disabled character varying(60)
);


ALTER TABLE customfieldoption OWNER TO jirauser2;

--
-- Name: customfieldvalue; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE customfieldvalue (
  id numeric(18,0) NOT NULL,
  issue numeric(18,0),
  customfield numeric(18,0),
  parentkey character varying(255),
  stringvalue character varying(255),
  numbervalue double precision,
  textvalue text,
  datevalue timestamp with time zone,
  valuetype character varying(255)
);


ALTER TABLE customfieldvalue OWNER TO jirauser2;

--
-- Name: cwd_application; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_application (
  id numeric(18,0) NOT NULL,
  application_name character varying(255),
  lower_application_name character varying(255),
  created_date timestamp with time zone,
  updated_date timestamp with time zone,
  active numeric(9,0),
  description character varying(255),
  application_type character varying(255),
  credential character varying(255)
);


ALTER TABLE cwd_application OWNER TO jirauser2;

--
-- Name: cwd_application_address; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_application_address (
  application_id numeric(18,0) NOT NULL,
  remote_address character varying(255) NOT NULL,
  encoded_address_binary character varying(255),
  remote_address_mask numeric(9,0)
);


ALTER TABLE cwd_application_address OWNER TO jirauser2;

--
-- Name: cwd_directory; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_directory (
  id numeric(18,0) NOT NULL,
  directory_name character varying(255),
  lower_directory_name character varying(255),
  created_date timestamp with time zone,
  updated_date timestamp with time zone,
  active numeric(9,0),
  description character varying(255),
  impl_class character varying(255),
  lower_impl_class character varying(255),
  directory_type character varying(60),
  directory_position numeric(18,0)
);


ALTER TABLE cwd_directory OWNER TO jirauser2;

--
-- Name: cwd_directory_attribute; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_directory_attribute (
  directory_id numeric(18,0) NOT NULL,
  attribute_name character varying(255) NOT NULL,
  attribute_value character varying(255)
);


ALTER TABLE cwd_directory_attribute OWNER TO jirauser2;

--
-- Name: cwd_directory_operation; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_directory_operation (
  directory_id numeric(18,0) NOT NULL,
  operation_type character varying(60) NOT NULL
);


ALTER TABLE cwd_directory_operation OWNER TO jirauser2;

--
-- Name: cwd_group; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_group (
  id numeric(18,0) NOT NULL,
  group_name character varying(255),
  lower_group_name character varying(255),
  active numeric(9,0),
  local numeric(9,0),
  created_date timestamp with time zone,
  updated_date timestamp with time zone,
  description character varying(255),
  lower_description character varying(255),
  group_type character varying(60),
  directory_id numeric(18,0)
);


ALTER TABLE cwd_group OWNER TO jirauser2;

--
-- Name: cwd_group_attributes; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_group_attributes (
  id numeric(18,0) NOT NULL,
  group_id numeric(18,0),
  directory_id numeric(18,0),
  attribute_name character varying(255),
  attribute_value character varying(255),
  lower_attribute_value character varying(255)
);


ALTER TABLE cwd_group_attributes OWNER TO jirauser2;

--
-- Name: cwd_membership; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_membership (
  id numeric(18,0) NOT NULL,
  parent_id numeric(18,0),
  child_id numeric(18,0),
  membership_type character varying(60),
  group_type character varying(60),
  parent_name character varying(255),
  lower_parent_name character varying(255),
  child_name character varying(255),
  lower_child_name character varying(255),
  directory_id numeric(18,0)
);


ALTER TABLE cwd_membership OWNER TO jirauser2;

--
-- Name: cwd_user; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_user (
  id numeric(18,0) NOT NULL,
  directory_id numeric(18,0),
  user_name character varying(255),
  lower_user_name character varying(255),
  active numeric(9,0),
  created_date timestamp with time zone,
  updated_date timestamp with time zone,
  first_name character varying(255),
  lower_first_name character varying(255),
  last_name character varying(255),
  lower_last_name character varying(255),
  display_name character varying(255),
  lower_display_name character varying(255),
  email_address character varying(255),
  lower_email_address character varying(255),
  credential character varying(255),
  deleted_externally numeric(9,0),
  external_id character varying(255)
);


ALTER TABLE cwd_user OWNER TO jirauser2;

--
-- Name: cwd_user_attributes; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE cwd_user_attributes (
  id numeric(18,0) NOT NULL,
  user_id numeric(18,0),
  directory_id numeric(18,0),
  attribute_name character varying(255),
  attribute_value character varying(255),
  lower_attribute_value character varying(255)
);


ALTER TABLE cwd_user_attributes OWNER TO jirauser2;

--
-- Name: draftworkflowscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE draftworkflowscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text,
  workflow_scheme_id numeric(18,0),
  last_modified_date timestamp with time zone,
  last_modified_user character varying(255)
);


ALTER TABLE draftworkflowscheme OWNER TO jirauser2;

--
-- Name: draftworkflowschemeentity; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE draftworkflowschemeentity (
  id numeric(18,0) NOT NULL,
  scheme numeric(18,0),
  workflow character varying(255),
  issuetype character varying(255)
);


ALTER TABLE draftworkflowschemeentity OWNER TO jirauser2;

--
-- Name: entity_property; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE entity_property (
  id numeric(18,0) NOT NULL,
  entity_name character varying(255),
  entity_id numeric(18,0),
  property_key character varying(255),
  created timestamp with time zone,
  updated timestamp with time zone,
  json_value text
);


ALTER TABLE entity_property OWNER TO jirauser2;

--
-- Name: entity_property_index_document; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE entity_property_index_document (
  id numeric(18,0) NOT NULL,
  plugin_key character varying(255),
  module_key character varying(255),
  entity_key character varying(255),
  updated timestamp with time zone,
  document text
);


ALTER TABLE entity_property_index_document OWNER TO jirauser2;

--
-- Name: external_entities; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE external_entities (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  entitytype character varying(255)
);


ALTER TABLE external_entities OWNER TO jirauser2;

--
-- Name: externalgadget; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE externalgadget (
  id numeric(18,0) NOT NULL,
  gadget_xml text
);


ALTER TABLE externalgadget OWNER TO jirauser2;

--
-- Name: favouriteassociations; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE favouriteassociations (
  id numeric(18,0) NOT NULL,
  username character varying(255),
  entitytype character varying(60),
  entityid numeric(18,0),
  sequence numeric(18,0)
);


ALTER TABLE favouriteassociations OWNER TO jirauser2;

--
-- Name: feature; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE feature (
  id numeric(18,0) NOT NULL,
  feature_name character varying(255),
  feature_type character varying(10),
  user_key character varying(255)
);


ALTER TABLE feature OWNER TO jirauser2;

--
-- Name: fieldconfigscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldconfigscheme (
  id numeric(18,0) NOT NULL,
  configname character varying(255),
  description text,
  fieldid character varying(60),
  customfield numeric(18,0)
);


ALTER TABLE fieldconfigscheme OWNER TO jirauser2;

--
-- Name: fieldconfigschemeissuetype; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldconfigschemeissuetype (
  id numeric(18,0) NOT NULL,
  issuetype character varying(255),
  fieldconfigscheme numeric(18,0),
  fieldconfiguration numeric(18,0)
);


ALTER TABLE fieldconfigschemeissuetype OWNER TO jirauser2;

--
-- Name: fieldconfiguration; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldconfiguration (
  id numeric(18,0) NOT NULL,
  configname character varying(255),
  description text,
  fieldid character varying(60),
  customfield numeric(18,0)
);


ALTER TABLE fieldconfiguration OWNER TO jirauser2;

--
-- Name: fieldlayout; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldlayout (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description character varying(255),
  layout_type character varying(255),
  layoutscheme numeric(18,0)
);


ALTER TABLE fieldlayout OWNER TO jirauser2;

--
-- Name: fieldlayoutitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldlayoutitem (
  id numeric(18,0) NOT NULL,
  fieldlayout numeric(18,0),
  fieldidentifier character varying(255),
  description text,
  verticalposition numeric(18,0),
  ishidden character varying(60),
  isrequired character varying(60),
  renderertype character varying(255)
);


ALTER TABLE fieldlayoutitem OWNER TO jirauser2;

--
-- Name: fieldlayoutscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldlayoutscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text
);


ALTER TABLE fieldlayoutscheme OWNER TO jirauser2;

--
-- Name: fieldlayoutschemeassociation; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldlayoutschemeassociation (
  id numeric(18,0) NOT NULL,
  issuetype character varying(255),
  project numeric(18,0),
  fieldlayoutscheme numeric(18,0)
);


ALTER TABLE fieldlayoutschemeassociation OWNER TO jirauser2;

--
-- Name: fieldlayoutschemeentity; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldlayoutschemeentity (
  id numeric(18,0) NOT NULL,
  scheme numeric(18,0),
  issuetype character varying(255),
  fieldlayout numeric(18,0)
);


ALTER TABLE fieldlayoutschemeentity OWNER TO jirauser2;

--
-- Name: fieldscreen; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldscreen (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description character varying(255)
);


ALTER TABLE fieldscreen OWNER TO jirauser2;

--
-- Name: fieldscreenlayoutitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldscreenlayoutitem (
  id numeric(18,0) NOT NULL,
  fieldidentifier character varying(255),
  sequence numeric(18,0),
  fieldscreentab numeric(18,0)
);


ALTER TABLE fieldscreenlayoutitem OWNER TO jirauser2;

--
-- Name: fieldscreenscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldscreenscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description character varying(255)
);


ALTER TABLE fieldscreenscheme OWNER TO jirauser2;

--
-- Name: fieldscreenschemeitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldscreenschemeitem (
  id numeric(18,0) NOT NULL,
  operation numeric(18,0),
  fieldscreen numeric(18,0),
  fieldscreenscheme numeric(18,0)
);


ALTER TABLE fieldscreenschemeitem OWNER TO jirauser2;

--
-- Name: fieldscreentab; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fieldscreentab (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description character varying(255),
  sequence numeric(18,0),
  fieldscreen numeric(18,0)
);


ALTER TABLE fieldscreentab OWNER TO jirauser2;

--
-- Name: fileattachment; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE fileattachment (
  id numeric(18,0) NOT NULL,
  issueid numeric(18,0),
  mimetype character varying(255),
  filename character varying(255),
  created timestamp with time zone,
  filesize numeric(18,0),
  author character varying(255),
  zip numeric(9,0),
  thumbnailable numeric(9,0)
);


ALTER TABLE fileattachment OWNER TO jirauser2;

--
-- Name: filtersubscription; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE filtersubscription (
  id numeric(18,0) NOT NULL,
  filter_i_d numeric(18,0),
  username character varying(60),
  groupname character varying(60),
  last_run timestamp with time zone,
  email_on_empty character varying(10)
);


ALTER TABLE filtersubscription OWNER TO jirauser2;

--
-- Name: gadgetuserpreference; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE gadgetuserpreference (
  id numeric(18,0) NOT NULL,
  portletconfiguration numeric(18,0),
  userprefkey character varying(255),
  userprefvalue text
);


ALTER TABLE gadgetuserpreference OWNER TO jirauser2;

--
-- Name: genericconfiguration; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE genericconfiguration (
  id numeric(18,0) NOT NULL,
  datatype character varying(60),
  datakey character varying(60),
  xmlvalue text
);


ALTER TABLE genericconfiguration OWNER TO jirauser2;

--
-- Name: globalpermissionentry; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE globalpermissionentry (
  id numeric(18,0) NOT NULL,
  permission character varying(255),
  group_id character varying(255)
);


ALTER TABLE globalpermissionentry OWNER TO jirauser2;

--
-- Name: groupbase; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE groupbase (
  id numeric(18,0) NOT NULL,
  groupname character varying(255)
);


ALTER TABLE groupbase OWNER TO jirauser2;

--
-- Name: issuelink; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuelink (
  id numeric(18,0) NOT NULL,
  linktype numeric(18,0),
  source numeric(18,0),
  destination numeric(18,0),
  sequence numeric(18,0)
);


ALTER TABLE issuelink OWNER TO jirauser2;

--
-- Name: issuelinktype; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuelinktype (
  id numeric(18,0) NOT NULL,
  linkname character varying(255),
  inward character varying(255),
  outward character varying(255),
  pstyle character varying(60)
);


ALTER TABLE issuelinktype OWNER TO jirauser2;

--
-- Name: issuesecurityscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuesecurityscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text,
  defaultlevel numeric(18,0)
);


ALTER TABLE issuesecurityscheme OWNER TO jirauser2;

--
-- Name: issuestatus; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuestatus (
  id character varying(60) NOT NULL,
  sequence numeric(18,0),
  pname character varying(60),
  description text,
  iconurl character varying(255),
  statuscategory numeric(18,0)
);


ALTER TABLE issuestatus OWNER TO jirauser2;

--
-- Name: issuetype; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuetype (
  id character varying(60) NOT NULL,
  sequence numeric(18,0),
  pname character varying(60),
  pstyle character varying(60),
  description text,
  iconurl character varying(255),
  avatar numeric(18,0)
);


ALTER TABLE issuetype OWNER TO jirauser2;

--
-- Name: issuetypescreenscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuetypescreenscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description character varying(255)
);


ALTER TABLE issuetypescreenscheme OWNER TO jirauser2;

--
-- Name: issuetypescreenschemeentity; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE issuetypescreenschemeentity (
  id numeric(18,0) NOT NULL,
  issuetype character varying(255),
  scheme numeric(18,0),
  fieldscreenscheme numeric(18,0)
);


ALTER TABLE issuetypescreenschemeentity OWNER TO jirauser2;

--
-- Name: jiraaction; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jiraaction (
  id numeric(18,0) NOT NULL,
  issueid numeric(18,0),
  author character varying(255),
  actiontype character varying(255),
  actionlevel character varying(255),
  rolelevel numeric(18,0),
  actionbody text,
  created timestamp with time zone,
  updateauthor character varying(255),
  updated timestamp with time zone,
  actionnum numeric(18,0)
);


ALTER TABLE jiraaction OWNER TO jirauser2;

--
-- Name: jiradraftworkflows; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jiradraftworkflows (
  id numeric(18,0) NOT NULL,
  parentname character varying(255),
  descriptor text
);


ALTER TABLE jiradraftworkflows OWNER TO jirauser2;

--
-- Name: jiraeventtype; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jiraeventtype (
  id numeric(18,0) NOT NULL,
  template_id numeric(18,0),
  name character varying(255),
  description text,
  event_type character varying(60)
);


ALTER TABLE jiraeventtype OWNER TO jirauser2;

--
-- Name: jiraissue; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jiraissue (
  id numeric(18,0) NOT NULL,
  pkey character varying(255),
  issuenum numeric(18,0),
  project numeric(18,0),
  reporter character varying(255),
  assignee character varying(255),
  creator character varying(255),
  issuetype character varying(255),
  summary character varying(255),
  description text,
  environment text,
  priority character varying(255),
  resolution character varying(255),
  issuestatus character varying(255),
  created timestamp with time zone,
  updated timestamp with time zone,
  duedate timestamp with time zone,
  resolutiondate timestamp with time zone,
  votes numeric(18,0),
  watches numeric(18,0),
  timeoriginalestimate numeric(18,0),
  timeestimate numeric(18,0),
  timespent numeric(18,0),
  workflow_id numeric(18,0),
  security numeric(18,0),
  fixfor numeric(18,0),
  component numeric(18,0)
);


ALTER TABLE jiraissue OWNER TO jirauser2;

--
-- Name: jiraperms; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jiraperms (
  id numeric(18,0) NOT NULL,
  permtype numeric(18,0),
  projectid numeric(18,0),
  groupname character varying(255)
);


ALTER TABLE jiraperms OWNER TO jirauser2;

--
-- Name: jiraworkflows; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jiraworkflows (
  id numeric(18,0) NOT NULL,
  workflowname character varying(255),
  creatorname character varying(255),
  descriptor text,
  islocked character varying(60)
);


ALTER TABLE jiraworkflows OWNER TO jirauser2;

--
-- Name: jquartz_blob_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_blob_triggers (
  sched_name character varying(120),
  trigger_name character varying(200) NOT NULL,
  trigger_group character varying(200) NOT NULL,
  blob_data bytea
);


ALTER TABLE jquartz_blob_triggers OWNER TO jirauser2;

--
-- Name: jquartz_calendars; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_calendars (
  sched_name character varying(120),
  calendar_name character varying(200) NOT NULL,
  calendar bytea
);


ALTER TABLE jquartz_calendars OWNER TO jirauser2;

--
-- Name: jquartz_cron_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_cron_triggers (
  sched_name character varying(120),
  trigger_name character varying(200) NOT NULL,
  trigger_group character varying(200) NOT NULL,
  cron_expression character varying(120),
  time_zone_id character varying(80)
);


ALTER TABLE jquartz_cron_triggers OWNER TO jirauser2;

--
-- Name: jquartz_fired_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_fired_triggers (
  sched_name character varying(120),
  entry_id character varying(95) NOT NULL,
  trigger_name character varying(200),
  trigger_group character varying(200),
  is_volatile boolean,
  instance_name character varying(200),
  fired_time numeric(18,0),
  sched_time numeric(18,0),
  priority numeric(9,0),
  state character varying(16),
  job_name character varying(200),
  job_group character varying(200),
  is_stateful boolean,
  is_nonconcurrent boolean,
  is_update_data boolean,
  requests_recovery boolean
);


ALTER TABLE jquartz_fired_triggers OWNER TO jirauser2;

--
-- Name: jquartz_job_details; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_job_details (
  sched_name character varying(120),
  job_name character varying(200) NOT NULL,
  job_group character varying(200) NOT NULL,
  description character varying(250),
  job_class_name character varying(250),
  is_durable boolean,
  is_volatile boolean,
  is_stateful boolean,
  is_nonconcurrent boolean,
  is_update_data boolean,
  requests_recovery boolean,
  job_data bytea
);


ALTER TABLE jquartz_job_details OWNER TO jirauser2;

--
-- Name: jquartz_job_listeners; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_job_listeners (
  job_name character varying(200) NOT NULL,
  job_group character varying(200) NOT NULL,
  job_listener character varying(200) NOT NULL
);


ALTER TABLE jquartz_job_listeners OWNER TO jirauser2;

--
-- Name: jquartz_locks; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_locks (
  sched_name character varying(120),
  lock_name character varying(40) NOT NULL
);


ALTER TABLE jquartz_locks OWNER TO jirauser2;

--
-- Name: jquartz_paused_trigger_grps; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_paused_trigger_grps (
  sched_name character varying(120),
  trigger_group character varying(200) NOT NULL
);


ALTER TABLE jquartz_paused_trigger_grps OWNER TO jirauser2;

--
-- Name: jquartz_scheduler_state; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_scheduler_state (
  sched_name character varying(120),
  instance_name character varying(200) NOT NULL,
  last_checkin_time numeric(18,0),
  checkin_interval numeric(18,0)
);


ALTER TABLE jquartz_scheduler_state OWNER TO jirauser2;

--
-- Name: jquartz_simple_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_simple_triggers (
  sched_name character varying(120),
  trigger_name character varying(200) NOT NULL,
  trigger_group character varying(200) NOT NULL,
  repeat_count numeric(18,0),
  repeat_interval numeric(18,0),
  times_triggered numeric(18,0)
);


ALTER TABLE jquartz_simple_triggers OWNER TO jirauser2;

--
-- Name: jquartz_simprop_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_simprop_triggers (
  sched_name character varying(120),
  trigger_name character varying(200) NOT NULL,
  trigger_group character varying(200) NOT NULL,
  str_prop_1 character varying(512),
  str_prop_2 character varying(512),
  str_prop_3 character varying(512),
  int_prop_1 numeric(9,0),
  int_prop_2 numeric(9,0),
  long_prop_1 numeric(18,0),
  long_prop_2 numeric(18,0),
  dec_prop_1 numeric(13,4),
  dec_prop_2 numeric(13,4),
  bool_prop_1 boolean,
  bool_prop_2 boolean
);


ALTER TABLE jquartz_simprop_triggers OWNER TO jirauser2;

--
-- Name: jquartz_trigger_listeners; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_trigger_listeners (
  trigger_name character varying(200),
  trigger_group character varying(200) NOT NULL,
  trigger_listener character varying(200) NOT NULL
);


ALTER TABLE jquartz_trigger_listeners OWNER TO jirauser2;

--
-- Name: jquartz_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE jquartz_triggers (
  sched_name character varying(120),
  trigger_name character varying(200) NOT NULL,
  trigger_group character varying(200) NOT NULL,
  job_name character varying(200),
  job_group character varying(200),
  is_volatile boolean,
  description character varying(250),
  next_fire_time numeric(18,0),
  prev_fire_time numeric(18,0),
  priority numeric(9,0),
  trigger_state character varying(16),
  trigger_type character varying(8),
  start_time numeric(18,0),
  end_time numeric(18,0),
  calendar_name character varying(200),
  misfire_instr numeric(4,0),
  job_data bytea
);


ALTER TABLE jquartz_triggers OWNER TO jirauser2;

--
-- Name: label; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE label (
  id numeric(18,0) NOT NULL,
  fieldid numeric(18,0),
  issue numeric(18,0),
  label character varying(255)
);


ALTER TABLE label OWNER TO jirauser2;

--
-- Name: licenserolesdefault; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE licenserolesdefault (
  id numeric(18,0) NOT NULL,
  license_role_name character varying(255)
);


ALTER TABLE licenserolesdefault OWNER TO jirauser2;

--
-- Name: licenserolesgroup; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE licenserolesgroup (
  id numeric(18,0) NOT NULL,
  license_role_name character varying(255),
  group_id character varying(255),
  primary_group character(1)
);


ALTER TABLE licenserolesgroup OWNER TO jirauser2;

--
-- Name: listenerconfig; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE listenerconfig (
  id numeric(18,0) NOT NULL,
  clazz character varying(255),
  listenername character varying(255)
);


ALTER TABLE listenerconfig OWNER TO jirauser2;

--
-- Name: mailserver; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE mailserver (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text,
  mailfrom character varying(255),
  prefix character varying(60),
  smtp_port character varying(60),
  protocol character varying(60),
  server_type character varying(60),
  servername character varying(255),
  jndilocation character varying(255),
  mailusername character varying(255),
  mailpassword character varying(255),
  istlsrequired character varying(60),
  timeout numeric(18,0),
  socks_port character varying(60),
  socks_host character varying(60)
);


ALTER TABLE mailserver OWNER TO jirauser2;

--
-- Name: managedconfigurationitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE managedconfigurationitem (
  id numeric(18,0) NOT NULL,
  item_id character varying(255),
  item_type character varying(255),
  managed character varying(10),
  access_level character varying(255),
  source character varying(255),
  description_key character varying(255)
);


ALTER TABLE managedconfigurationitem OWNER TO jirauser2;

--
-- Name: membershipbase; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE membershipbase (
  id numeric(18,0) NOT NULL,
  user_name character varying(255),
  group_name character varying(255)
);


ALTER TABLE membershipbase OWNER TO jirauser2;

--
-- Name: moved_issue_key; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE moved_issue_key (
  id numeric(18,0) NOT NULL,
  old_issue_key character varying(255),
  issue_id numeric(18,0)
);


ALTER TABLE moved_issue_key OWNER TO jirauser2;

--
-- Name: nodeassociation; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE nodeassociation (
  source_node_id numeric(18,0) NOT NULL,
  source_node_entity character varying(60) NOT NULL,
  sink_node_id numeric(18,0) NOT NULL,
  sink_node_entity character varying(60) NOT NULL,
  association_type character varying(60) NOT NULL,
  sequence numeric(9,0)
);


ALTER TABLE nodeassociation OWNER TO jirauser2;

--
-- Name: nodeindexcounter; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE nodeindexcounter (
  id numeric(18,0) NOT NULL,
  node_id character varying(60),
  sending_node_id character varying(60),
  index_operation_id numeric(18,0)
);


ALTER TABLE nodeindexcounter OWNER TO jirauser2;

--
-- Name: notification; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE notification (
  id numeric(18,0) NOT NULL,
  scheme numeric(18,0),
  event character varying(60),
  event_type_id numeric(18,0),
  template_id numeric(18,0),
  notif_type character varying(60),
  notif_parameter character varying(60)
);


ALTER TABLE notification OWNER TO jirauser2;

--
-- Name: notificationinstance; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE notificationinstance (
  id numeric(18,0) NOT NULL,
  notificationtype character varying(60),
  source numeric(18,0),
  emailaddress character varying(255),
  messageid character varying(255)
);


ALTER TABLE notificationinstance OWNER TO jirauser2;

--
-- Name: notificationscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE notificationscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text
);


ALTER TABLE notificationscheme OWNER TO jirauser2;

--
-- Name: oauthconsumer; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE oauthconsumer (
  id numeric(18,0) NOT NULL,
  created timestamp with time zone,
  consumername character varying(255),
  consumer_key character varying(255),
  consumerservice character varying(255),
  public_key text,
  private_key text,
  description text,
  callback text,
  signature_method character varying(60),
  shared_secret text
);


ALTER TABLE oauthconsumer OWNER TO jirauser2;

--
-- Name: oauthconsumertoken; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE oauthconsumertoken (
  id numeric(18,0) NOT NULL,
  created timestamp with time zone,
  token_key character varying(255),
  token character varying(255),
  token_secret character varying(255),
  token_type character varying(60),
  consumer_key character varying(255)
);


ALTER TABLE oauthconsumertoken OWNER TO jirauser2;

--
-- Name: oauthspconsumer; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE oauthspconsumer (
  id numeric(18,0) NOT NULL,
  created timestamp with time zone,
  consumer_key character varying(255),
  consumername character varying(255),
  public_key text,
  description text,
  callback text,
  two_l_o_allowed character varying(60),
  executing_two_l_o_user character varying(255),
  two_l_o_impersonation_allowed character varying(60),
  three_l_o_allowed character varying(60)
);


ALTER TABLE oauthspconsumer OWNER TO jirauser2;

--
-- Name: oauthsptoken; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE oauthsptoken (
  id numeric(18,0) NOT NULL,
  created timestamp with time zone,
  token character varying(255),
  token_secret character varying(255),
  token_type character varying(60),
  consumer_key character varying(255),
  username character varying(255),
  ttl numeric(18,0),
  spauth character varying(60),
  callback text,
  spverifier character varying(255),
  spversion character varying(60),
  session_handle character varying(255),
  session_creation_time timestamp with time zone,
  session_last_renewal_time timestamp with time zone,
  session_time_to_live timestamp with time zone
);


ALTER TABLE oauthsptoken OWNER TO jirauser2;

--
-- Name: optionconfiguration; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE optionconfiguration (
  id numeric(18,0) NOT NULL,
  fieldid character varying(60),
  optionid character varying(60),
  fieldconfig numeric(18,0),
  sequence numeric(18,0)
);


ALTER TABLE optionconfiguration OWNER TO jirauser2;

--
-- Name: os_currentstep; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE os_currentstep (
  id numeric(18,0) NOT NULL,
  entry_id numeric(18,0),
  step_id numeric(9,0),
  action_id numeric(9,0),
  owner character varying(60),
  start_date timestamp with time zone,
  due_date timestamp with time zone,
  finish_date timestamp with time zone,
  status character varying(60),
  caller character varying(60)
);


ALTER TABLE os_currentstep OWNER TO jirauser2;

--
-- Name: os_currentstep_prev; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE os_currentstep_prev (
  id numeric(18,0) NOT NULL,
  previous_id numeric(18,0) NOT NULL
);


ALTER TABLE os_currentstep_prev OWNER TO jirauser2;

--
-- Name: os_historystep; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE os_historystep (
  id numeric(18,0) NOT NULL,
  entry_id numeric(18,0),
  step_id numeric(9,0),
  action_id numeric(9,0),
  owner character varying(60),
  start_date timestamp with time zone,
  due_date timestamp with time zone,
  finish_date timestamp with time zone,
  status character varying(60),
  caller character varying(60)
);


ALTER TABLE os_historystep OWNER TO jirauser2;

--
-- Name: os_historystep_prev; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE os_historystep_prev (
  id numeric(18,0) NOT NULL,
  previous_id numeric(18,0) NOT NULL
);


ALTER TABLE os_historystep_prev OWNER TO jirauser2;

--
-- Name: os_wfentry; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE os_wfentry (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  initialized numeric(9,0),
  state numeric(9,0)
);


ALTER TABLE os_wfentry OWNER TO jirauser2;

--
-- Name: permissionscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE permissionscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text
);


ALTER TABLE permissionscheme OWNER TO jirauser2;

--
-- Name: pluginstate; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE pluginstate (
  pluginkey character varying(255) NOT NULL,
  pluginenabled character varying(60)
);


ALTER TABLE pluginstate OWNER TO jirauser2;

--
-- Name: pluginversion; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE pluginversion (
  id numeric(18,0) NOT NULL,
  pluginname character varying(255),
  pluginkey character varying(255),
  pluginversion character varying(255),
  created timestamp with time zone
);


ALTER TABLE pluginversion OWNER TO jirauser2;

--
-- Name: portalpage; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE portalpage (
  id numeric(18,0) NOT NULL,
  username character varying(255),
  pagename character varying(255),
  description character varying(255),
  sequence numeric(18,0),
  fav_count numeric(18,0),
  layout character varying(255),
  ppversion numeric(18,0)
);


ALTER TABLE portalpage OWNER TO jirauser2;

--
-- Name: portletconfiguration; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE portletconfiguration (
  id numeric(18,0) NOT NULL,
  portalpage numeric(18,0),
  portlet_id character varying(255),
  column_number numeric(9,0),
  positionseq numeric(9,0),
  gadget_xml text,
  color character varying(255),
  dashboard_module_complete_key text
);


ALTER TABLE portletconfiguration OWNER TO jirauser2;

--
-- Name: priority; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE priority (
  id character varying(60) NOT NULL,
  sequence numeric(18,0),
  pname character varying(60),
  description text,
  iconurl character varying(255),
  status_color character varying(60)
);


ALTER TABLE priority OWNER TO jirauser2;

--
-- Name: productlicense; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE productlicense (
  id numeric(18,0) NOT NULL,
  license text
);


ALTER TABLE productlicense OWNER TO jirauser2;

--
-- Name: project; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE project (
  id numeric(18,0) NOT NULL,
  pname character varying(255),
  url character varying(255),
  lead character varying(255),
  description text,
  pkey character varying(255),
  pcounter numeric(18,0),
  assigneetype numeric(18,0),
  avatar numeric(18,0),
  originalkey character varying(255),
  projecttype character varying(255)
);


ALTER TABLE project OWNER TO jirauser2;

--
-- Name: project_key; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE project_key (
  id numeric(18,0) NOT NULL,
  project_id numeric(18,0),
  project_key character varying(255)
);


ALTER TABLE project_key OWNER TO jirauser2;

--
-- Name: projectcategory; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE projectcategory (
  id numeric(18,0) NOT NULL,
  cname character varying(255),
  description text
);


ALTER TABLE projectcategory OWNER TO jirauser2;

--
-- Name: projectrole; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE projectrole (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text
);


ALTER TABLE projectrole OWNER TO jirauser2;

--
-- Name: projectroleactor; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE projectroleactor (
  id numeric(18,0) NOT NULL,
  pid numeric(18,0),
  projectroleid numeric(18,0),
  roletype character varying(255),
  roletypeparameter character varying(255)
);


ALTER TABLE projectroleactor OWNER TO jirauser2;

--
-- Name: projectversion; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE projectversion (
  id numeric(18,0) NOT NULL,
  project numeric(18,0),
  vname character varying(255),
  description text,
  sequence numeric(18,0),
  released character varying(10),
  archived character varying(10),
  url character varying(255),
  startdate timestamp with time zone,
  releasedate timestamp with time zone
);


ALTER TABLE projectversion OWNER TO jirauser2;

--
-- Name: propertydata; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertydata (
  id numeric(18,0) NOT NULL,
  propertyvalue oid
);


ALTER TABLE propertydata OWNER TO jirauser2;

--
-- Name: propertydate; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertydate (
  id numeric(18,0) NOT NULL,
  propertyvalue timestamp with time zone
);


ALTER TABLE propertydate OWNER TO jirauser2;

--
-- Name: propertydecimal; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertydecimal (
  id numeric(18,0) NOT NULL,
  propertyvalue double precision
);


ALTER TABLE propertydecimal OWNER TO jirauser2;

--
-- Name: propertyentry; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertyentry (
  id numeric(18,0) NOT NULL,
  entity_name character varying(255),
  entity_id numeric(18,0),
  property_key character varying(255),
  propertytype numeric(9,0)
);


ALTER TABLE propertyentry OWNER TO jirauser2;

--
-- Name: propertynumber; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertynumber (
  id numeric(18,0) NOT NULL,
  propertyvalue numeric(18,0)
);


ALTER TABLE propertynumber OWNER TO jirauser2;

--
-- Name: propertystring; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertystring (
  id numeric(18,0) NOT NULL,
  propertyvalue text
);


ALTER TABLE propertystring OWNER TO jirauser2;

--
-- Name: propertytext; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE propertytext (
  id numeric(18,0) NOT NULL,
  propertyvalue text
);


ALTER TABLE propertytext OWNER TO jirauser2;

--
-- Name: qrtz_calendars; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_calendars (
  id numeric(18,0),
  calendar_name character varying(255) NOT NULL,
  calendar text
);


ALTER TABLE qrtz_calendars OWNER TO jirauser2;

--
-- Name: qrtz_cron_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_cron_triggers (
  id numeric(18,0) NOT NULL,
  trigger_id numeric(18,0),
  cronexperssion character varying(255)
);


ALTER TABLE qrtz_cron_triggers OWNER TO jirauser2;

--
-- Name: qrtz_fired_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_fired_triggers (
  id numeric(18,0),
  entry_id character varying(255) NOT NULL,
  trigger_id numeric(18,0),
  trigger_listener character varying(255),
  fired_time timestamp with time zone,
  trigger_state character varying(255)
);


ALTER TABLE qrtz_fired_triggers OWNER TO jirauser2;

--
-- Name: qrtz_job_details; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_job_details (
  id numeric(18,0) NOT NULL,
  job_name character varying(255),
  job_group character varying(255),
  class_name character varying(255),
  is_durable character varying(60),
  is_stateful character varying(60),
  requests_recovery character varying(60),
  job_data character varying(255)
);


ALTER TABLE qrtz_job_details OWNER TO jirauser2;

--
-- Name: qrtz_job_listeners; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_job_listeners (
  id numeric(18,0) NOT NULL,
  job numeric(18,0),
  job_listener character varying(255)
);


ALTER TABLE qrtz_job_listeners OWNER TO jirauser2;

--
-- Name: qrtz_simple_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_simple_triggers (
  id numeric(18,0) NOT NULL,
  trigger_id numeric(18,0),
  repeat_count numeric(9,0),
  repeat_interval numeric(18,0),
  times_triggered numeric(9,0)
);


ALTER TABLE qrtz_simple_triggers OWNER TO jirauser2;

--
-- Name: qrtz_trigger_listeners; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_trigger_listeners (
  id numeric(18,0) NOT NULL,
  trigger_id numeric(18,0),
  trigger_listener character varying(255)
);


ALTER TABLE qrtz_trigger_listeners OWNER TO jirauser2;

--
-- Name: qrtz_triggers; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE qrtz_triggers (
  id numeric(18,0) NOT NULL,
  trigger_name character varying(255),
  trigger_group character varying(255),
  job numeric(18,0),
  next_fire timestamp with time zone,
  trigger_state character varying(255),
  trigger_type character varying(60),
  start_time timestamp with time zone,
  end_time timestamp with time zone,
  calendar_name character varying(255),
  misfire_instr numeric(9,0)
);


ALTER TABLE qrtz_triggers OWNER TO jirauser2;

--
-- Name: reindex_component; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE reindex_component (
  id numeric(18,0) NOT NULL,
  request_id numeric(18,0),
  affected_index character varying(60),
  entity_type character varying(60)
);


ALTER TABLE reindex_component OWNER TO jirauser2;

--
-- Name: reindex_request; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE reindex_request (
  id numeric(18,0) NOT NULL,
  type character varying(60),
  request_time timestamp with time zone,
  start_time timestamp with time zone,
  completion_time timestamp with time zone,
  status character varying(60),
  execution_node_id character varying(60)
);


ALTER TABLE reindex_request OWNER TO jirauser2;

--
-- Name: remembermetoken; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE remembermetoken (
  id numeric(18,0) NOT NULL,
  created timestamp with time zone,
  token character varying(255),
  username character varying(255)
);


ALTER TABLE remembermetoken OWNER TO jirauser2;

--
-- Name: remotelink; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE remotelink (
  id numeric(18,0) NOT NULL,
  issueid numeric(18,0),
  globalid character varying(255),
  title character varying(255),
  summary text,
  url text,
  iconurl text,
  icontitle text,
  relationship character varying(255),
  resolved character(1),
  statusname character varying(255),
  statusdescription text,
  statusiconurl text,
  statusicontitle text,
  statusiconlink text,
  statuscategorykey character varying(255),
  statuscategorycolorname character varying(255),
  applicationtype character varying(255),
  applicationname character varying(255)
);


ALTER TABLE remotelink OWNER TO jirauser2;

--
-- Name: replicatedindexoperation; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE replicatedindexoperation (
  id numeric(18,0) NOT NULL,
  index_time timestamp with time zone,
  node_id character varying(60),
  affected_index character varying(60),
  entity_type character varying(60),
  affected_ids text,
  operation character varying(60),
  filename character varying(255)
);


ALTER TABLE replicatedindexoperation OWNER TO jirauser2;

--
-- Name: resolution; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE resolution (
  id character varying(60) NOT NULL,
  sequence numeric(18,0),
  pname character varying(60),
  description text,
  iconurl character varying(255)
);


ALTER TABLE resolution OWNER TO jirauser2;

--
-- Name: rundetails; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE rundetails (
  id numeric(18,0) NOT NULL,
  job_id character varying(255),
  start_time timestamp with time zone,
  run_duration numeric(18,0),
  run_outcome character(1),
  info_message character varying(255)
);


ALTER TABLE rundetails OWNER TO jirauser2;

--
-- Name: schemeissuesecurities; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE schemeissuesecurities (
  id numeric(18,0) NOT NULL,
  scheme numeric(18,0),
  security numeric(18,0),
  sec_type character varying(255),
  sec_parameter character varying(255)
);


ALTER TABLE schemeissuesecurities OWNER TO jirauser2;

--
-- Name: schemeissuesecuritylevels; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE schemeissuesecuritylevels (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text,
  scheme numeric(18,0)
);


ALTER TABLE schemeissuesecuritylevels OWNER TO jirauser2;

--
-- Name: schemepermissions; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE schemepermissions (
  id numeric(18,0) NOT NULL,
  scheme numeric(18,0),
  permission numeric(18,0),
  perm_type character varying(255),
  perm_parameter character varying(255),
  permission_key character varying(255)
);


ALTER TABLE schemepermissions OWNER TO jirauser2;

--
-- Name: searchrequest; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE searchrequest (
  id numeric(18,0) NOT NULL,
  filtername character varying(255),
  authorname character varying(255),
  description text,
  username character varying(255),
  groupname character varying(255),
  projectid numeric(18,0),
  reqcontent text,
  fav_count numeric(18,0),
  filtername_lower character varying(255)
);


ALTER TABLE searchrequest OWNER TO jirauser2;

--
-- Name: sequence_value_item; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE sequence_value_item (
  seq_name character varying(60) NOT NULL,
  seq_id numeric(18,0)
);


ALTER TABLE sequence_value_item OWNER TO jirauser2;

--
-- Name: serviceconfig; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE serviceconfig (
  id numeric(18,0) NOT NULL,
  delaytime numeric(18,0),
  clazz character varying(255),
  servicename character varying(255),
  cron_expression character varying(255)
);


ALTER TABLE serviceconfig OWNER TO jirauser2;

--
-- Name: sharepermissions; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE sharepermissions (
  id numeric(18,0) NOT NULL,
  entityid numeric(18,0),
  entitytype character varying(60),
  sharetype character varying(10),
  param1 character varying(255),
  param2 character varying(60)
);


ALTER TABLE sharepermissions OWNER TO jirauser2;

--
-- Name: trackback_ping; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE trackback_ping (
  id numeric(18,0) NOT NULL,
  issue numeric(18,0),
  url character varying(255),
  title character varying(255),
  blogname character varying(255),
  excerpt character varying(255),
  created timestamp with time zone
);


ALTER TABLE trackback_ping OWNER TO jirauser2;

--
-- Name: trustedapp; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE trustedapp (
  id numeric(18,0) NOT NULL,
  application_id character varying(255),
  name character varying(255),
  public_key text,
  ip_match text,
  url_match text,
  timeout numeric(18,0),
  created timestamp with time zone,
  created_by character varying(255),
  updated timestamp with time zone,
  updated_by character varying(255)
);


ALTER TABLE trustedapp OWNER TO jirauser2;

--
-- Name: upgradehistory; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE upgradehistory (
  id numeric(18,0),
  upgradeclass character varying(255) NOT NULL,
  targetbuild character varying(255),
  status character varying(255),
  downgradetaskrequired character(1)
);


ALTER TABLE upgradehistory OWNER TO jirauser2;

--
-- Name: upgradeversionhistory; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE upgradeversionhistory (
  id numeric(18,0),
  timeperformed timestamp with time zone,
  targetbuild character varying(255) NOT NULL,
  targetversion character varying(255)
);


ALTER TABLE upgradeversionhistory OWNER TO jirauser2;

--
-- Name: userassociation; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE userassociation (
  source_name character varying(60) NOT NULL,
  sink_node_id numeric(18,0) NOT NULL,
  sink_node_entity character varying(60) NOT NULL,
  association_type character varying(60) NOT NULL,
  sequence numeric(9,0),
  created timestamp with time zone
);


ALTER TABLE userassociation OWNER TO jirauser2;

--
-- Name: userbase; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE userbase (
  id numeric(18,0) NOT NULL,
  username character varying(255),
  password_hash character varying(255)
);


ALTER TABLE userbase OWNER TO jirauser2;

--
-- Name: userhistoryitem; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE userhistoryitem (
  id numeric(18,0) NOT NULL,
  entitytype character varying(10),
  entityid character varying(60),
  username character varying(255),
  lastviewed numeric(18,0),
  data text
);


ALTER TABLE userhistoryitem OWNER TO jirauser2;

--
-- Name: userpickerfilter; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE userpickerfilter (
  id numeric(18,0) NOT NULL,
  customfield numeric(18,0),
  customfieldconfig numeric(18,0),
  enabled character varying(60)
);


ALTER TABLE userpickerfilter OWNER TO jirauser2;

--
-- Name: userpickerfiltergroup; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE userpickerfiltergroup (
  id numeric(18,0) NOT NULL,
  userpickerfilter numeric(18,0),
  groupname character varying(255)
);


ALTER TABLE userpickerfiltergroup OWNER TO jirauser2;

--
-- Name: userpickerfilterrole; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE userpickerfilterrole (
  id numeric(18,0) NOT NULL,
  userpickerfilter numeric(18,0),
  projectroleid numeric(18,0)
);


ALTER TABLE userpickerfilterrole OWNER TO jirauser2;

--
-- Name: versioncontrol; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE versioncontrol (
  id numeric(18,0) NOT NULL,
  vcsname character varying(255),
  vcsdescription character varying(255),
  vcstype character varying(255)
);


ALTER TABLE versioncontrol OWNER TO jirauser2;

--
-- Name: votehistory; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE votehistory (
  id numeric(18,0) NOT NULL,
  issueid numeric(18,0),
  votes numeric(18,0),
  "timestamp" timestamp with time zone
);


ALTER TABLE votehistory OWNER TO jirauser2;

--
-- Name: workflowscheme; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE workflowscheme (
  id numeric(18,0) NOT NULL,
  name character varying(255),
  description text
);


ALTER TABLE workflowscheme OWNER TO jirauser2;

--
-- Name: workflowschemeentity; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE workflowschemeentity (
  id numeric(18,0) NOT NULL,
  scheme numeric(18,0),
  workflow character varying(255),
  issuetype character varying(255)
);


ALTER TABLE workflowschemeentity OWNER TO jirauser2;

--
-- Name: worklog; Type: TABLE; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE TABLE worklog (
  id numeric(18,0) NOT NULL,
  issueid numeric(18,0),
  author character varying(255),
  grouplevel character varying(255),
  rolelevel numeric(18,0),
  worklogbody text,
  created timestamp with time zone,
  updateauthor character varying(255),
  updated timestamp with time zone,
  startdate timestamp with time zone,
  timeworked numeric(18,0)
);


ALTER TABLE worklog OWNER TO jirauser2;

--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_21D670_WHITELIST_RULES" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_21D670_WHITELIST_RULES_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_38321B_CUSTOM_CONTENT_LINK" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_38321B_CUSTOM_CONTENT_LINK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_3B1893_LOOP_DETECTION" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_3B1893_LOOP_DETECTION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_4AEACD_WEBHOOK_DAO" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_4AEACD_WEBHOOK_DAO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_550953_SHORTCUT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_550953_SHORTCUT_ID_seq"'::regclass);


--
-- Name: ACTIVITY_ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_ACTIVITY_ENTITY" ALTER COLUMN "ACTIVITY_ID" SET DEFAULT nextval('"AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_ACTOR_ENTITY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_563AEE_ACTOR_ENTITY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_MEDIA_LINK_ENTITY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_563AEE_MEDIA_LINK_ENTITY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_OBJECT_ENTITY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_563AEE_OBJECT_ENTITY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_TARGET_ENTITY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_563AEE_TARGET_ENTITY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_575BF5_PROVIDER_ISSUE" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_575BF5_PROVIDER_ISSUE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_587B34_PROJECT_CONFIG" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_587B34_PROJECT_CONFIG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_5FB9D7_AOHIP_CHAT_LINK" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_5FB9D7_AOHIP_CHAT_USER" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_5FB9D7_AOHIP_CHAT_USER_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_AUDITENTRY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_AUDITENTRY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_BOARDADMINS" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_BOARDADMINS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_CARDCOLOR" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_CARDCOLOR_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_CARDLAYOUT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_CARDLAYOUT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_COLUMN" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_COLUMN_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_COLUMNSTATUS" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_COLUMNSTATUS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_DETAILVIEWFIELD" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_DETAILVIEWFIELD_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_ESTIMATESTATISTIC" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_ESTIMATESTATISTIC_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_ISSUERANKING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_ISSUERANKING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_ISSUERANKINGLOG" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_ISSUERANKINGLOG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_LEXORANK" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_LEXORANK_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_LEXORANKBALANCER" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_LEXORANKBALANCER_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_NONWORKINGDAY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_NONWORKINGDAY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_QUICKFILTER" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_QUICKFILTER_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_RANKABLEOBJECT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_RANKABLEOBJECT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_RAPIDVIEW" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_RAPIDVIEW_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_SPRINT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_SPRINT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_STATSFIELD" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_STATSFIELD_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_SUBQUERY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_SUBQUERY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_SWIMLANE" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_SWIMLANE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_TRACKINGSTATISTIC" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_TRACKINGSTATISTIC_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_VERSION" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_VERSION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_WORKINGDAYS" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_60DB71_WORKINGDAYS_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_97EDAB_USERINVITATION" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_97EDAB_USERINVITATION_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_A0B856_WEB_HOOK_LISTENER_AO" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_A44657_HEALTH_CHECK_ENTITY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_A44657_HEALTH_CHECK_ENTITY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_B9A0F0_APPLIED_TEMPLATE" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_B9A0F0_APPLIED_TEMPLATE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_CFF990_AOTRANSITION_FAILURE" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_CFF990_AOTRANSITION_FAILURE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_DEB285_BLOG_AO" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_DEB285_BLOG_AO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_DEB285_COMMENT_AO" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_DEB285_COMMENT_AO_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_BRANCH" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_BRANCH_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_BRANCH_HEAD_MAPPING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_CHANGESET_MAPPING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_CHANGESET_MAPPING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_COMMIT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_COMMIT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_GIT_HUB_EVENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_GIT_HUB_EVENT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_MAPPING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_ISSUE_MAPPING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_MAPPING_V2" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_TO_BRANCH" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_TO_CHANGESET" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_MESSAGE_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE_QUEUE_ITEM" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE_TAG" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_MESSAGE_TAG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_ORGANIZATION_MAPPING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PROJECT_MAPPING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_PROJECT_MAPPING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PROJECT_MAPPING_V2" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PR_ISSUE_KEY" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_PR_ISSUE_KEY_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PR_PARTICIPANT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_PR_PARTICIPANT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PR_TO_COMMIT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_PR_TO_COMMIT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PULL_REQUEST" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_PULL_REQUEST_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_REPOSITORY_MAPPING" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_REPOSITORY_MAPPING_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_REPO_TO_CHANGESET" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_REPO_TO_CHANGESET_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_REPO_TO_PROJECT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_REPO_TO_PROJECT_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_SYNC_AUDIT_LOG" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq"'::regclass);


--
-- Name: ID; Type: DEFAULT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_SYNC_EVENT" ALTER COLUMN "ID" SET DEFAULT nextval('"AO_E8B6CC_SYNC_EVENT_ID_seq"'::regclass);


--
-- Data for Name: AO_21D670_WHITELIST_RULES; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO "AO_21D670_WHITELIST_RULES" VALUES (false, 'http://www.atlassian.com/*', 1, 'WILDCARD_EXPRESSION');


--
-- Name: AO_21D670_WHITELIST_RULES_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_21D670_WHITELIST_RULES_ID_seq"', 1, true);


--
-- Data for Name: AO_38321B_CUSTOM_CONTENT_LINK; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_38321B_CUSTOM_CONTENT_LINK_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_38321B_CUSTOM_CONTENT_LINK_ID_seq"', 1, false);


--
-- Data for Name: AO_3B1893_LOOP_DETECTION; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_3B1893_LOOP_DETECTION_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_3B1893_LOOP_DETECTION_ID_seq"', 1, false);


--
-- Data for Name: AO_4AEACD_WEBHOOK_DAO; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_4AEACD_WEBHOOK_DAO_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_4AEACD_WEBHOOK_DAO_ID_seq"', 1, false);


--
-- Data for Name: AO_550953_SHORTCUT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_550953_SHORTCUT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_550953_SHORTCUT_ID_seq"', 1, false);


--
-- Data for Name: AO_563AEE_ACTIVITY_ENTITY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_563AEE_ACTIVITY_ENTITY_ACTIVITY_ID_seq"', 1, false);


--
-- Data for Name: AO_563AEE_ACTOR_ENTITY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_563AEE_ACTOR_ENTITY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_563AEE_ACTOR_ENTITY_ID_seq"', 1, false);


--
-- Data for Name: AO_563AEE_MEDIA_LINK_ENTITY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_563AEE_MEDIA_LINK_ENTITY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_563AEE_MEDIA_LINK_ENTITY_ID_seq"', 1, false);


--
-- Data for Name: AO_563AEE_OBJECT_ENTITY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_563AEE_OBJECT_ENTITY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_563AEE_OBJECT_ENTITY_ID_seq"', 1, false);


--
-- Data for Name: AO_563AEE_TARGET_ENTITY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_563AEE_TARGET_ENTITY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_563AEE_TARGET_ENTITY_ID_seq"', 1, false);


--
-- Data for Name: AO_575BF5_PROVIDER_ISSUE; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_575BF5_PROVIDER_ISSUE_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_575BF5_PROVIDER_ISSUE_ID_seq"', 1, false);


--
-- Data for Name: AO_587B34_PROJECT_CONFIG; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_587B34_PROJECT_CONFIG_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_587B34_PROJECT_CONFIG_ID_seq"', 1, false);


--
-- Data for Name: AO_5FB9D7_AOHIP_CHAT_LINK; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_5FB9D7_AOHIP_CHAT_LINK_ID_seq"', 1, false);


--
-- Data for Name: AO_5FB9D7_AOHIP_CHAT_USER; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_5FB9D7_AOHIP_CHAT_USER_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_5FB9D7_AOHIP_CHAT_USER_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_AUDITENTRY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_AUDITENTRY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_AUDITENTRY_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_BOARDADMINS; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_BOARDADMINS_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_BOARDADMINS_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_CARDCOLOR; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_CARDCOLOR_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_CARDCOLOR_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_CARDLAYOUT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_CARDLAYOUT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_CARDLAYOUT_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_COLUMN; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: AO_60DB71_COLUMNSTATUS; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_COLUMNSTATUS_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_COLUMNSTATUS_ID_seq"', 1, false);


--
-- Name: AO_60DB71_COLUMN_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_COLUMN_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_DETAILVIEWFIELD; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_DETAILVIEWFIELD_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_DETAILVIEWFIELD_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_ESTIMATESTATISTIC; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_ESTIMATESTATISTIC_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_ESTIMATESTATISTIC_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_ISSUERANKING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: AO_60DB71_ISSUERANKINGLOG; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_ISSUERANKINGLOG_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_ISSUERANKINGLOG_ID_seq"', 1, false);


--
-- Name: AO_60DB71_ISSUERANKING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_ISSUERANKING_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_LEXORANK; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO "AO_60DB71_LEXORANK" VALUES (10000, 7, -9223372036854775808, NULL, NULL, '0|000000:', 0);
INSERT INTO "AO_60DB71_LEXORANK" VALUES (10000, 8, 9223372036854775807, NULL, NULL, '0|zzzzzz:', 2);


--
-- Data for Name: AO_60DB71_LEXORANKBALANCER; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_LEXORANKBALANCER_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_LEXORANKBALANCER_ID_seq"', 1, false);


--
-- Name: AO_60DB71_LEXORANK_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_LEXORANK_ID_seq"', 8, true);


--
-- Data for Name: AO_60DB71_NONWORKINGDAY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_NONWORKINGDAY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_NONWORKINGDAY_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_QUICKFILTER; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_QUICKFILTER_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_QUICKFILTER_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_RANKABLEOBJECT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_RANKABLEOBJECT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_RANKABLEOBJECT_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_RANK_ISSUE_LINK; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: AO_60DB71_RAPIDVIEW; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_RAPIDVIEW_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_RAPIDVIEW_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_SPRINT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: AO_60DB71_SPRINTMARKER; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_SPRINT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_SPRINT_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_STATSFIELD; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_STATSFIELD_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_STATSFIELD_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_SUBQUERY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_SUBQUERY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_SUBQUERY_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_SWIMLANE; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_SWIMLANE_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_SWIMLANE_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_TRACKINGSTATISTIC; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_TRACKINGSTATISTIC_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_TRACKINGSTATISTIC_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_VERSION; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_VERSION_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_VERSION_ID_seq"', 1, false);


--
-- Data for Name: AO_60DB71_WORKINGDAYS; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_60DB71_WORKINGDAYS_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_60DB71_WORKINGDAYS_ID_seq"', 1, false);


--
-- Data for Name: AO_97EDAB_USERINVITATION; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_97EDAB_USERINVITATION_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_97EDAB_USERINVITATION_ID_seq"', 1, false);


--
-- Data for Name: AO_A0B856_WEB_HOOK_LISTENER_AO; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_A0B856_WEB_HOOK_LISTENER_AO_ID_seq"', 1, false);


--
-- Data for Name: AO_A44657_HEALTH_CHECK_ENTITY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_A44657_HEALTH_CHECK_ENTITY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_A44657_HEALTH_CHECK_ENTITY_ID_seq"', 1, false);


--
-- Data for Name: AO_B9A0F0_APPLIED_TEMPLATE; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_B9A0F0_APPLIED_TEMPLATE_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_B9A0F0_APPLIED_TEMPLATE_ID_seq"', 1, false);


--
-- Data for Name: AO_CFF990_AOTRANSITION_FAILURE; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_CFF990_AOTRANSITION_FAILURE_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_CFF990_AOTRANSITION_FAILURE_ID_seq"', 1, false);


--
-- Data for Name: AO_DEB285_BLOG_AO; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_DEB285_BLOG_AO_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_DEB285_BLOG_AO_ID_seq"', 1, false);


--
-- Data for Name: AO_DEB285_COMMENT_AO; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_DEB285_COMMENT_AO_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_DEB285_COMMENT_AO_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_BRANCH; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: AO_E8B6CC_BRANCH_HEAD_MAPPING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_BRANCH_HEAD_MAPPING_ID_seq"', 1, false);


--
-- Name: AO_E8B6CC_BRANCH_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_BRANCH_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_CHANGESET_MAPPING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_CHANGESET_MAPPING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_CHANGESET_MAPPING_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_COMMIT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_COMMIT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_COMMIT_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_GIT_HUB_EVENT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_GIT_HUB_EVENT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_GIT_HUB_EVENT_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_ISSUE_MAPPING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_ISSUE_MAPPING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_ISSUE_MAPPING_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_ISSUE_MAPPING_V2; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_ISSUE_MAPPING_V2_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_ISSUE_TO_BRANCH; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_ISSUE_TO_BRANCH_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_ISSUE_TO_CHANGESET; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_ISSUE_TO_CHANGESET_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_MESSAGE; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_MESSAGE_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_MESSAGE_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_MESSAGE_QUEUE_ITEM; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_MESSAGE_QUEUE_ITEM_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_MESSAGE_TAG; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_MESSAGE_TAG_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_MESSAGE_TAG_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_ORGANIZATION_MAPPING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_ORGANIZATION_MAPPING_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_PROJECT_MAPPING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_PROJECT_MAPPING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_PROJECT_MAPPING_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_PROJECT_MAPPING_V2; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_PROJECT_MAPPING_V2_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_PR_ISSUE_KEY; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_PR_ISSUE_KEY_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_PR_ISSUE_KEY_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_PR_PARTICIPANT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_PR_PARTICIPANT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_PR_PARTICIPANT_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_PR_TO_COMMIT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_PR_TO_COMMIT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_PR_TO_COMMIT_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_PULL_REQUEST; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_PULL_REQUEST_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_PULL_REQUEST_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_REPOSITORY_MAPPING; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_REPOSITORY_MAPPING_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_REPOSITORY_MAPPING_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_REPO_TO_CHANGESET; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_REPO_TO_CHANGESET_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_REPO_TO_CHANGESET_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_REPO_TO_PROJECT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_REPO_TO_PROJECT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_REPO_TO_PROJECT_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_SYNC_AUDIT_LOG; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_SYNC_AUDIT_LOG_ID_seq"', 1, false);


--
-- Data for Name: AO_E8B6CC_SYNC_EVENT; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_E8B6CC_SYNC_EVENT_ID_seq; Type: SEQUENCE SET; Schema: public; Owner: jirauser2
--

SELECT pg_catalog.setval('"AO_E8B6CC_SYNC_EVENT_ID_seq"', 1, false);


--
-- Data for Name: app_user; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO app_user VALUES (10000, 'admin', 'admin');


--
-- Data for Name: audit_changed_value; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO audit_changed_value VALUES (10000, 10001, 'jira-administrators', 'USE', 'jira-core');
INSERT INTO audit_changed_value VALUES (10001, 10002, 'jira-administrators', 'USE', 'jira-software');
INSERT INTO audit_changed_value VALUES (10100, 10101, 'Permission', '', 'Bulk Change');
INSERT INTO audit_changed_value VALUES (10101, 10101, 'Group', '', 'jira-core-users');
INSERT INTO audit_changed_value VALUES (10102, 10102, 'Permission', '', 'Create Shared Objects');
INSERT INTO audit_changed_value VALUES (10103, 10102, 'Group', '', 'jira-core-users');
INSERT INTO audit_changed_value VALUES (10104, 10103, 'Permission', '', 'Manage Group Filter Subscriptions');
INSERT INTO audit_changed_value VALUES (10105, 10103, 'Group', '', 'jira-core-users');
INSERT INTO audit_changed_value VALUES (10106, 10104, 'Permission', '', 'Browse Users');
INSERT INTO audit_changed_value VALUES (10107, 10104, 'Group', '', 'jira-core-users');
INSERT INTO audit_changed_value VALUES (10108, 10105, 'Organisation', NULL, 'thefoo');
INSERT INTO audit_changed_value VALUES (10109, 10105, 'Date Purchased', NULL, '01/Jan/70');
INSERT INTO audit_changed_value VALUES (10110, 10105, 'License Type', NULL, 'Atlassian OnDemand');
INSERT INTO audit_changed_value VALUES (10111, 10105, 'Server ID', NULL, NULL);
INSERT INTO audit_changed_value VALUES (10112, 10105, 'Support Entitlement Number (SEN)', NULL, 'SEN-1000');
INSERT INTO audit_changed_value VALUES (10113, 10105, 'User Limit', NULL, 'Unlimited');
INSERT INTO audit_changed_value VALUES (10114, 10105, 'jira-software', NULL, '43');
INSERT INTO audit_changed_value VALUES (10115, 10105, 'jira-core', NULL, '43');
INSERT INTO audit_changed_value VALUES (10116, 10106, 'Username', NULL, 'admin');
INSERT INTO audit_changed_value VALUES (10117, 10106, 'Full name', NULL, 'admin');
INSERT INTO audit_changed_value VALUES (10118, 10106, 'Email', NULL, 'admin@example.com');
INSERT INTO audit_changed_value VALUES (10119, 10106, 'Active / Inactive', NULL, 'Active');
INSERT INTO audit_changed_value VALUES (10120, 10109, 'Permission', '', 'Bulk Change');
INSERT INTO audit_changed_value VALUES (10121, 10109, 'Group', '', 'jira-software-users');
INSERT INTO audit_changed_value VALUES (10122, 10110, 'Permission', '', 'Create Shared Objects');
INSERT INTO audit_changed_value VALUES (10123, 10110, 'Group', '', 'jira-software-users');
INSERT INTO audit_changed_value VALUES (10124, 10111, 'Permission', '', 'Manage Group Filter Subscriptions');
INSERT INTO audit_changed_value VALUES (10125, 10111, 'Group', '', 'jira-software-users');
INSERT INTO audit_changed_value VALUES (10126, 10112, 'Permission', '', 'Browse Users');
INSERT INTO audit_changed_value VALUES (10127, 10112, 'Group', '', 'jira-software-users');
INSERT INTO audit_changed_value VALUES (10128, 10115, 'Name', NULL, 'Rank');
INSERT INTO audit_changed_value VALUES (10129, 10115, 'Description', NULL, 'Global rank field for JIRA Software use only.');
INSERT INTO audit_changed_value VALUES (10130, 10115, 'Type', NULL, 'Global Rank');
INSERT INTO audit_changed_value VALUES (10131, 10116, 'Name', NULL, 'Epic Link');
INSERT INTO audit_changed_value VALUES (10132, 10116, 'Description', NULL, 'Choose an epic to assign this issue to.');
INSERT INTO audit_changed_value VALUES (10133, 10116, 'Type', NULL, 'Epic Link Relationship');
INSERT INTO audit_changed_value VALUES (10134, 10117, 'Name', NULL, 'Epic Status');
INSERT INTO audit_changed_value VALUES (10135, 10117, 'Description', NULL, 'Epic Status field for JIRA Software use only.');
INSERT INTO audit_changed_value VALUES (10136, 10117, 'Type', NULL, 'Status of Epic');
INSERT INTO audit_changed_value VALUES (10137, 10118, 'Name', NULL, 'Epic Name');
INSERT INTO audit_changed_value VALUES (10138, 10118, 'Description', NULL, 'Provide a short name to identify this epic.');
INSERT INTO audit_changed_value VALUES (10139, 10118, 'Type', NULL, 'Name of Epic');
INSERT INTO audit_changed_value VALUES (10140, 10119, 'Name', NULL, 'Epic Color');
INSERT INTO audit_changed_value VALUES (10141, 10119, 'Description', NULL, 'Epic Color field for JIRA Software use only.');
INSERT INTO audit_changed_value VALUES (10142, 10119, 'Type', NULL, 'Color of Epic');
INSERT INTO audit_changed_value VALUES (10143, 10120, 'Name', NULL, 'Sprint');
INSERT INTO audit_changed_value VALUES (10144, 10120, 'Description', NULL, 'JIRA Software sprint field');
INSERT INTO audit_changed_value VALUES (10145, 10120, 'Type', NULL, 'JIRA Software Sprint Field');
INSERT INTO audit_changed_value VALUES (10146, 10121, 'Name', NULL, 'Flagged');
INSERT INTO audit_changed_value VALUES (10147, 10121, 'Description', NULL, 'Allows to flag issues with impediments.');
INSERT INTO audit_changed_value VALUES (10148, 10121, 'Type', NULL, 'Checkboxes');
INSERT INTO audit_changed_value VALUES (10149, 10122, 'Name', NULL, 'Epic/Theme');
INSERT INTO audit_changed_value VALUES (10150, 10122, 'Description', NULL, 'Field that will help you regroup issues under an Epic or under a theme.');
INSERT INTO audit_changed_value VALUES (10151, 10122, 'Type', NULL, 'Labels');
INSERT INTO audit_changed_value VALUES (10152, 10123, 'Name', NULL, 'Story Points');
INSERT INTO audit_changed_value VALUES (10153, 10123, 'Description', NULL, 'Measurement of complexity and/or size of a requirement.');
INSERT INTO audit_changed_value VALUES (10154, 10123, 'Type', NULL, 'Number Field');
INSERT INTO audit_changed_value VALUES (10155, 10124, 'Name', NULL, 'Business Value');
INSERT INTO audit_changed_value VALUES (10156, 10124, 'Description', NULL, 'Measurement of business value of a requirement.');
INSERT INTO audit_changed_value VALUES (10157, 10124, 'Type', NULL, 'Number Field');


--
-- Data for Name: audit_item; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO audit_item VALUES (10000, 10107, 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory');
INSERT INTO audit_item VALUES (10001, 10113, 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory');
INSERT INTO audit_item VALUES (10002, 10114, 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory');


--
-- Data for Name: audit_log; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO audit_log VALUES (10000, NULL, '2015-08-03 13:28:14.242+10', NULL, 'Not moving license location', 'migration', 'LICENSE', '0', 'No change', '0', '', 1, 'Move6xLicenseTo70Store', 'No valid existing license present in data.', 'not moving license location jira.auditing.category.migration move6xlicenseto70store');
INSERT INTO audit_log VALUES (10001, NULL, '2015-08-03 13:28:14.248+10', NULL, 'Migrated groups to jira-core: 1', 'migration', 'APPLICATION_ROLE', '0', 'jira-core', '0', '', 1, 'UseBasedMigrationImpl', 'Group with USE permission migrated to a role to ensure continued access for associated users.', 'migrated groups to jira-core: 1 jira.auditing.category.migration usebasedmigrationimpl jira-administrators use jira-core');
INSERT INTO audit_log VALUES (10002, NULL, '2015-08-03 13:28:14.252+10', NULL, 'Migrated groups to jira-software: 1', 'migration', 'APPLICATION_ROLE', '0', 'jira-software', '0', '', 1, 'UseBasedMigrationImpl', 'Group with USE permission migrated to a role to ensure continued access for associated users.', 'migrated groups to jira-software: 1 jira.auditing.category.migration usebasedmigrationimpl jira-administrators use jira-software');
INSERT INTO audit_log VALUES (10100, '0:0:0:0:0:0:0:1', '2015-08-03 13:28:36.142+10', NULL, 'Group created', 'group management', 'GROUP', NULL, 'jira-core-users', '1', 'JIRA Internal Directory', 0, '', '', '0:0:0:0:0:0:0:1 group created management jira-core-users jira internal directory');
INSERT INTO audit_log VALUES (10101, '0:0:0:0:0:0:0:1', '2015-08-03 13:28:36.174+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions bulk change jira-core-users');
INSERT INTO audit_log VALUES (10102, '0:0:0:0:0:0:0:1', '2015-08-03 13:28:36.195+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions create shared objects jira-core-users');
INSERT INTO audit_log VALUES (10103, '0:0:0:0:0:0:0:1', '2015-08-03 13:28:36.199+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions manage group filter subscriptions jira-core-users');
INSERT INTO audit_log VALUES (10104, '0:0:0:0:0:0:0:1', '2015-08-03 13:28:36.201+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions browse users jira-core-users');
INSERT INTO audit_log VALUES (10105, '0:0:0:0:0:0:0:1', '2015-08-03 13:28:36.214+10', NULL, 'New license added', 'system', 'LICENSE', '0', 'SEN-1000', '0', 'License SEN', 0, '', '', '0:0:0:0:0:0:0:1 new license added system sen-1000 sen thefoo 01/jan/70 atlassian ondemand unlimited 43');
INSERT INTO audit_log VALUES (10106, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.856+10', NULL, 'User created', 'user management', 'USER', 'admin', 'admin', '1', 'JIRA Internal Directory', 0, '', '', '0:0:0:0:0:0:0:1 user created management admin jira internal directory admin@example.com active');
INSERT INTO audit_log VALUES (10107, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.885+10', NULL, 'User added to group', 'group management', 'GROUP', NULL, 'jira-administrators', '1', 'JIRA Internal Directory', 0, '', '', '0:0:0:0:0:0:0:1 user added to group management jira-administrators jira internal directory admin');
INSERT INTO audit_log VALUES (10108, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.9+10', NULL, 'Group created', 'group management', 'GROUP', NULL, 'jira-software-users', '1', 'JIRA Internal Directory', 0, '', '', '0:0:0:0:0:0:0:1 group created management jira-software-users jira internal directory');
INSERT INTO audit_log VALUES (10109, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.908+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions bulk change jira-software-users');
INSERT INTO audit_log VALUES (10110, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.911+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions create shared objects jira-software-users');
INSERT INTO audit_log VALUES (10111, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.913+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions manage group filter subscriptions jira-software-users');
INSERT INTO audit_log VALUES (10112, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.916+10', NULL, 'Global permission added', 'permissions', 'PERMISSIONS', NULL, 'Global Permissions', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 global permission added permissions browse users jira-software-users');
INSERT INTO audit_log VALUES (10113, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.935+10', NULL, 'User added to group', 'group management', 'GROUP', NULL, 'jira-software-users', '1', 'JIRA Internal Directory', 0, '', '', '0:0:0:0:0:0:0:1 user added to group management jira-software-users jira internal directory admin');
INSERT INTO audit_log VALUES (10114, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:36.939+10', NULL, 'User added to group', 'group management', 'GROUP', NULL, 'jira-core-users', '1', 'JIRA Internal Directory', 0, '', '', '0:0:0:0:0:0:0:1 user added to group management jira-core-users jira internal directory admin');
INSERT INTO audit_log VALUES (10115, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:58.671+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10000', 'Rank', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields rank global for jira software use only.');
INSERT INTO audit_log VALUES (10116, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:58.876+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10001', 'Epic Link', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields epic link choose an to assign this issue to. relationship');
INSERT INTO audit_log VALUES (10117, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:58.955+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10002', 'Epic Status', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields epic status for jira software use only. of');
INSERT INTO audit_log VALUES (10118, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:59.015+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10003', 'Epic Name', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields epic name provide a short to identify this epic. of');
INSERT INTO audit_log VALUES (10119, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:59.099+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10004', 'Epic Color', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields epic color for jira software use only. of');
INSERT INTO audit_log VALUES (10120, '0:0:0:0:0:0:0:1', '2015-08-03 13:29:59.154+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10005', 'Sprint', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields sprint jira software');
INSERT INTO audit_log VALUES (10121, '0:0:0:0:0:0:0:1', '2015-08-03 13:30:01.562+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10006', 'Flagged', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields flagged allows to flag issues with impediments. checkboxes');
INSERT INTO audit_log VALUES (10122, '0:0:0:0:0:0:0:1', '2015-08-03 13:30:01.6+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10007', 'Epic/Theme', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields epic/theme that will help you regroup issues under an epic or a theme. labels');
INSERT INTO audit_log VALUES (10123, '0:0:0:0:0:0:0:1', '2015-08-03 13:30:01.631+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10008', 'Story Points', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields story points measurement of complexity and/or size a requirement. number');
INSERT INTO audit_log VALUES (10124, '0:0:0:0:0:0:0:1', '2015-08-03 13:30:01.66+10', NULL, 'Custom field created', 'fields', 'CUSTOM_FIELD', 'customfield_10009', 'Business Value', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field created fields business value measurement of a requirement. number');
INSERT INTO audit_log VALUES (10125, '0:0:0:0:0:0:0:1', '2015-08-03 13:30:06.319+10', NULL, 'Custom field updated', 'fields', 'CUSTOM_FIELD', 'customfield_10001', 'Epic Link', NULL, NULL, 0, '', '', '0:0:0:0:0:0:0:1 custom field updated fields epic link');


--
-- Data for Name: avatar; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO avatar VALUES (10000, 'codegeist.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10002, 'jm_black.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10003, 'jm_brown.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10004, 'jm_orange.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10005, 'jm_red.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10006, 'jm_white.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10007, 'jm_yellow.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10008, 'monster.png', 'image/png', 'project', NULL, 1);
INSERT INTO avatar VALUES (10100, 'Avatar-1.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10101, 'Avatar-2.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10102, 'Avatar-3.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10103, 'Avatar-4.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10104, 'Avatar-5.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10105, 'Avatar-6.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10106, 'Avatar-7.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10107, 'Avatar-8.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10108, 'Avatar-9.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10109, 'Avatar-10.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10110, 'Avatar-11.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10111, 'Avatar-12.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10112, 'Avatar-13.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10113, 'Avatar-14.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10114, 'Avatar-15.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10115, 'Avatar-16.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10116, 'Avatar-17.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10117, 'Avatar-18.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10118, 'Avatar-19.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10119, 'Avatar-20.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10120, 'Avatar-21.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10121, 'Avatar-22.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10123, 'Avatar-unknown.png', 'image/png', 'user', NULL, 1);
INSERT INTO avatar VALUES (10318, 'task.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10316, 'subtask.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10315, 'story.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10310, 'improvement.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10314, 'sales.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10309, 'design_task.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10312, 'remove_feature.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10313, 'requirement.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10311, 'newfeature.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10308, 'exclamation.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10306, 'documentation.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10304, 'defect.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10307, 'epic.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10300, 'genericissue.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10303, 'bug.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10320, 'question.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10321, 'development_task.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10322, 'feedback.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10323, 'request_access.svg', 'image/svg+xml', 'issuetype', NULL, 1);
INSERT INTO avatar VALUES (10200, 'cloud.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10201, 'spanner.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10202, 'cd.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10001, 'bird.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10203, 'money.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10204, 'mouse-hand.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10010, 'koala.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10205, 'yeti.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10206, 'power.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10009, 'nature.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10207, 'refresh.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10011, 'rocket.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10208, 'phone.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10209, 'settings.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10210, 'storm.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10211, 'plane.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10324, 'default.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10325, 'code.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10326, 'coffee.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10122, 'Avatar-default.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10327, 'design.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10328, 'drill.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10329, 'food.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10330, 'notes.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10331, 'red-flag.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10332, 'science.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10333, 'support.svg', 'image/svg+xml', 'project', NULL, 1);
INSERT INTO avatar VALUES (10334, 'bull.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10335, 'cat.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10336, 'dog.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10337, 'female_1.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10338, 'female_2.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10339, 'female_3.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10340, 'female_4.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10341, 'ghost.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10342, 'male_1.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10343, 'male_2.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10344, 'male_3.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10345, 'male_4.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10346, 'male_5.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10347, 'male_6.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10348, 'male_8.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10349, 'owl.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10350, 'pirate.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10351, 'robot.svg', 'image/svg+xml', 'user', NULL, 1);
INSERT INTO avatar VALUES (10352, 'vampire.svg', 'image/svg+xml', 'user', NULL, 1);


--
-- Data for Name: changegroup; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: changeitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: clusteredjob; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO clusteredjob VALUES (10003, 'com.atlassian.jira.service.JiraService:10002', 'com.atlassian.jira.service.DefaultServiceManager', 'C', NULL, NULL, '0 0 10 * * ?', 'Australia/Sydney', 1438646400000, 1, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273757200025b42acf317f8060854e0020000787000000171aced000573720037636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c6542694d61702453657269616c697a6564466f726d000000000000000002000078720035636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c654d61702453657269616c697a6564466f726d00000000000000000200025b00046b6579737400135b4c6a6176612f6c616e672f4f626a6563743b5b000676616c75657371007e00027870757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c020000787000000001740033636f6d2e61746c61737369616e2e6a6972612e736572766963652e536572766963654d616e616765723a7365727669636549647571007e0004000000017372000e6a6176612e6c616e672e4c6f6e673b8be490cc8f23df0200014a000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b020000787000000000000027127800');
INSERT INTO clusteredjob VALUES (10102, 'com.atlassian.jira.service.JiraService:10001', 'com.atlassian.jira.service.DefaultServiceManager', 'C', NULL, NULL, '0 25 1/12 * * ?', NULL, 1438615500000, 1, '\xaced000573720037636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c6542694d61702453657269616c697a6564466f726d000000000000000002000078720035636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c654d61702453657269616c697a6564466f726d00000000000000000200025b00046b6579737400135b4c6a6176612f6c616e672f4f626a6563743b5b000676616c75657371007e00027870757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c020000787000000001740033636f6d2e61746c61737369616e2e6a6972612e736572766963652e536572766963654d616e616765723a7365727669636549647571007e0004000000017372000e6a6176612e6c616e672e4c6f6e673b8be490cc8f23df0200014a000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b02000078700000000000002711');
INSERT INTO clusteredjob VALUES (10101, 'data-provider-cleanup', 'com.atlassian.jira.plugin.devstatus.provider.DataProviderCleanupJob', 'I', 1800000, 1438572548811, NULL, NULL, 1438574358033, 2, NULL);
INSERT INTO clusteredjob VALUES (10103, 'CompatibilityPluginScheduler.JobId.LEXO_RANK_SCHEDULER_JOB', 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancePluginJob', 'I', 60000, 1438572601054, NULL, NULL, 1438572661062, 2, NULL);
INSERT INTO clusteredjob VALUES (10105, 'CompatibilityPluginScheduler.JobId.LocalPluginLicenseNotificationJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.LocalPluginLicenseNotificationJob-job-handler', 'I', 86400000, 1438572602349, NULL, NULL, 1438659002350, 2, NULL);
INSERT INTO clusteredjob VALUES (10106, 'CompatibilityPluginScheduler.JobId.RemotePluginLicenseNotificationJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.RemotePluginLicenseNotificationJob-job-handler', 'I', 86400000, 1438624864412, NULL, NULL, 1438624864412, 1, NULL);
INSERT INTO clusteredjob VALUES (10107, 'CompatibilityPluginScheduler.JobId.PluginRequestCheckJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.PluginRequestCheckJob-job-handler', 'I', 3600000, 1438572602395, NULL, NULL, 1438576202403, 2, NULL);
INSERT INTO clusteredjob VALUES (10108, 'CompatibilityPluginScheduler.JobId.PluginUpdateCheckJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.PluginUpdateCheckJob-job-handler', 'I', 86400000, 1438616831767, NULL, NULL, 1438616831767, 1, NULL);
INSERT INTO clusteredjob VALUES (10109, 'CompatibilityPluginScheduler.JobId.InstanceTopologyJob-job', 'CompatibilityPluginScheduler.JobRunnerKey.InstanceTopologyJob-job-handler', 'I', 86400000, 1438647742147, NULL, NULL, 1438647742147, 1, NULL);
INSERT INTO clusteredjob VALUES (10110, 'CompatibilityPluginScheduler.JobId.Service Provider Session Remover', 'CompatibilityPluginScheduler.JobRunnerKey.Service Provider Session Remover', 'I', 28800000, 1438601407960, NULL, NULL, 1438601407960, 1, NULL);
INSERT INTO clusteredjob VALUES (10112, 'CompatibilityPluginScheduler.JobId.com.atlassian.jira.plugins.dvcs.scheduler.DvcsScheduler:job', 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.jira.plugins.dvcs.scheduler.DvcsScheduler', 'I', 3600000, 1438575653778, NULL, NULL, 1438575653778, 1, NULL);
INSERT INTO clusteredjob VALUES (10111, 'CompatibilityPluginScheduler.JobId.bitbucket-accounts-reload', 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.jira.plugins.dvcs.ondemand.BitbucketAccountsReloadJobScheduler', 'I', 100000000000020000, 1438572622980, NULL, NULL, 100001438572642983, 2, NULL);


--
-- Data for Name: clusterlockstatus; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: clustermessage; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: clusternode; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: clusternodeheartbeat; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: columnlayout; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: columnlayoutitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: component; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: configurationcontext; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO configurationcontext VALUES (10000, NULL, NULL, 'issuetype', 10000);
INSERT INTO configurationcontext VALUES (10100, NULL, NULL, 'customfield_10000', 10100);
INSERT INTO configurationcontext VALUES (10101, NULL, NULL, 'customfield_10001', 10101);
INSERT INTO configurationcontext VALUES (10102, NULL, NULL, 'customfield_10005', 10102);
INSERT INTO configurationcontext VALUES (10103, NULL, NULL, 'customfield_10006', 10103);
INSERT INTO configurationcontext VALUES (10104, NULL, NULL, 'customfield_10007', 10104);


--
-- Data for Name: customfield; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO customfield VALUES (10000, 'com.pyxis.greenhopper.jira:gh-lexo-rank', 'com.pyxis.greenhopper.jira:gh-lexo-rank-searcher', 'Rank', 'Global rank field for JIRA Software use only.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10002, 'com.pyxis.greenhopper.jira:gh-epic-status', 'com.pyxis.greenhopper.jira:gh-epic-status-searcher', 'Epic Status', 'Epic Status field for JIRA Software use only.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10003, 'com.pyxis.greenhopper.jira:gh-epic-label', 'com.pyxis.greenhopper.jira:gh-epic-label-searcher', 'Epic Name', 'Provide a short name to identify this epic.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10004, 'com.pyxis.greenhopper.jira:gh-epic-color', 'com.pyxis.greenhopper.jira:gh-epic-color-searcher', 'Epic Color', 'Epic Color field for JIRA Software use only.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10005, 'com.pyxis.greenhopper.jira:gh-sprint', 'com.pyxis.greenhopper.jira:gh-sprint-searcher', 'Sprint', 'JIRA Software sprint field', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10006, 'com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes', 'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher', 'Flagged', 'Allows to flag issues with impediments.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10007, 'com.atlassian.jira.plugin.system.customfieldtypes:labels', 'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher', 'Epic/Theme', 'Field that will help you regroup issues under an Epic or under a theme.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10008, 'com.atlassian.jira.plugin.system.customfieldtypes:float', 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber', 'Story Points', 'Measurement of complexity and/or size of a requirement.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10009, 'com.atlassian.jira.plugin.system.customfieldtypes:float', 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber', 'Business Value', 'Measurement of business value of a requirement.', NULL, NULL, NULL, NULL);
INSERT INTO customfield VALUES (10001, 'com.pyxis.greenhopper.jira:gh-epic-link', 'com.pyxis.greenhopper.jira:gh-epic-link-searcher', 'Epic Link', 'Choose an epic to assign this issue to.', NULL, NULL, NULL, NULL);


--
-- Data for Name: customfieldoption; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO customfieldoption VALUES (10000, 10006, 10103, NULL, 0, 'Impediment', NULL, 'N');


--
-- Data for Name: customfieldvalue; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: cwd_application; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_application VALUES (1, 'crowd-embedded', 'crowd-embedded', '2013-02-28 11:57:51.302+11', '2013-02-28 11:57:51.302+11', 1, '', 'CROWD', 'X');


--
-- Data for Name: cwd_application_address; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: cwd_directory; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_directory VALUES (1, 'JIRA Internal Directory', 'jira internal directory', '2013-02-28 11:57:51.308+11', '2013-02-28 11:57:51.308+11', 1, 'JIRA default internal directory', 'com.atlassian.crowd.directory.InternalDirectory', 'com.atlassian.crowd.directory.internaldirectory', 'INTERNAL', 0);


--
-- Data for Name: cwd_directory_attribute; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_directory_attribute VALUES (1, 'user_encryption_method', 'atlassian-security');


--
-- Data for Name: cwd_directory_operation; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_directory_operation VALUES (1, 'CREATE_GROUP');
INSERT INTO cwd_directory_operation VALUES (1, 'CREATE_ROLE');
INSERT INTO cwd_directory_operation VALUES (1, 'CREATE_USER');
INSERT INTO cwd_directory_operation VALUES (1, 'DELETE_GROUP');
INSERT INTO cwd_directory_operation VALUES (1, 'DELETE_ROLE');
INSERT INTO cwd_directory_operation VALUES (1, 'DELETE_USER');
INSERT INTO cwd_directory_operation VALUES (1, 'UPDATE_GROUP');
INSERT INTO cwd_directory_operation VALUES (1, 'UPDATE_GROUP_ATTRIBUTE');
INSERT INTO cwd_directory_operation VALUES (1, 'UPDATE_ROLE');
INSERT INTO cwd_directory_operation VALUES (1, 'UPDATE_ROLE_ATTRIBUTE');
INSERT INTO cwd_directory_operation VALUES (1, 'UPDATE_USER');
INSERT INTO cwd_directory_operation VALUES (1, 'UPDATE_USER_ATTRIBUTE');


--
-- Data for Name: cwd_group; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_group VALUES (10000, 'jira-administrators', 'jira-administrators', 1, 0, '2013-02-28 11:57:51.326+11', '2013-02-28 11:57:51.326+11', '', NULL, 'GROUP', 1);
INSERT INTO cwd_group VALUES (10010, 'jira-core-users', 'jira-core-users', 1, 0, '2015-08-03 13:28:36.118+10', '2015-08-03 13:28:36.118+10', NULL, NULL, 'GROUP', 1);
INSERT INTO cwd_group VALUES (10011, 'jira-software-users', 'jira-software-users', 1, 0, '2015-08-03 13:29:36.899+10', '2015-08-03 13:29:36.899+10', NULL, NULL, 'GROUP', 1);


--
-- Data for Name: cwd_group_attributes; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: cwd_membership; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_membership VALUES (10000, 10000, 10000, 'GROUP_USER', NULL, 'jira-administrators', 'jira-administrators', 'admin', 'admin', 1);
INSERT INTO cwd_membership VALUES (10001, 10011, 10000, 'GROUP_USER', NULL, 'jira-software-users', 'jira-software-users', 'admin', 'admin', 1);
INSERT INTO cwd_membership VALUES (10002, 10010, 10000, 'GROUP_USER', NULL, 'jira-core-users', 'jira-core-users', 'admin', 'admin', 1);


--
-- Data for Name: cwd_user; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_user VALUES (10000, 1, 'admin', 'admin', 1, '2015-08-03 13:29:36.624+10', '2015-08-03 13:29:36.624+10', '', '', 'admin', 'admin', 'admin', 'admin', 'admin@example.com', 'admin@example.com', '{PKCS5S2}wG/rw+iKZmPDImVaAduGr0zvU0nG8qA/C2kNsiWH+y0KHKAHGDY6ctgEbRpNo7lZ', NULL, '6190c5c8-7530-47d5-919f-828f7eca9d5b');


--
-- Data for Name: cwd_user_attributes; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO cwd_user_attributes VALUES (10000, 10000, 1, 'passwordLastChanged', '1438572576629', '1438572576629');
INSERT INTO cwd_user_attributes VALUES (10001, 10000, 1, 'requiresPasswordChange', 'false', 'false');
INSERT INTO cwd_user_attributes VALUES (10002, 10000, 1, 'invalidPasswordAttempts', '0', '0');
INSERT INTO cwd_user_attributes VALUES (10003, 10000, 1, 'password.reset.request.expiry', '1438658976867', '1438658976867');
INSERT INTO cwd_user_attributes VALUES (10004, 10000, 1, 'password.reset.request.token', '192d948f0e1156364716c5b937bc9320db48d5f0', '192d948f0e1156364716c5b937bc9320db48d5f0');
INSERT INTO cwd_user_attributes VALUES (10005, 10000, 1, 'login.currentFailedCount', '0', '0');
INSERT INTO cwd_user_attributes VALUES (10006, 10000, 1, 'login.lastLoginMillis', '1438572608230', '1438572608230');
INSERT INTO cwd_user_attributes VALUES (10007, 10000, 1, 'login.count', '1', '1');


--
-- Data for Name: draftworkflowscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: draftworkflowschemeentity; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: entity_property; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: entity_property_index_document; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO entity_property_index_document VALUES (10000, 'com.atlassian.jira.plugins.jira-development-integration-plugin', 'jira-issue-fusion-jql', 'IssueProperty', '2015-08-03 13:29:17.734+10', '<?xml version="1.0" encoding="UTF-8"?>
<index-document-configuration entity-key="IssueProperty"><key property-key="development"><extract path="failingbuilds" type="NUMBER"/><extract path="openprs" type="NUMBER"/><extract path="prs" type="NUMBER"/><extract path="reviews" type="NUMBER"/><extract path="openreviews" type="NUMBER"/><extract path="commits" type="NUMBER"/></key></index-document-configuration>');


--
-- Data for Name: external_entities; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: externalgadget; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: favouriteassociations; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: feature; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO feature VALUES (10000, 'com.atlassian.jira.projects.ProjectCentricNavigation.Switch', 'site', '');
INSERT INTO feature VALUES (10001, 'com.atlassian.jira.projects.issuenavigator', 'site', '');


--
-- Data for Name: fieldconfigscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldconfigscheme VALUES (10100, 'Default Configuration Scheme for Rank', 'Default configuration scheme generated by JIRA', 'customfield_10000', NULL);
INSERT INTO fieldconfigscheme VALUES (10101, 'Default Configuration Scheme for Epic Link', 'Default configuration scheme generated by JIRA', 'customfield_10001', NULL);
INSERT INTO fieldconfigscheme VALUES (10102, 'Default Configuration Scheme for Sprint', 'Default configuration scheme generated by JIRA', 'customfield_10005', NULL);
INSERT INTO fieldconfigscheme VALUES (10103, 'Default Configuration Scheme for Flagged', 'Default configuration scheme generated by JIRA', 'customfield_10006', NULL);
INSERT INTO fieldconfigscheme VALUES (10104, 'Default Configuration Scheme for Epic/Theme', 'Default configuration scheme generated by JIRA', 'customfield_10007', NULL);
INSERT INTO fieldconfigscheme VALUES (10000, 'Default Issue Type Scheme', 'Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.', 'issuetype', NULL);


--
-- Data for Name: fieldconfigschemeissuetype; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldconfigschemeissuetype VALUES (10200, NULL, 10100, 10100);
INSERT INTO fieldconfigschemeissuetype VALUES (10201, NULL, 10101, 10101);
INSERT INTO fieldconfigschemeissuetype VALUES (10202, NULL, 10102, 10102);
INSERT INTO fieldconfigschemeissuetype VALUES (10203, NULL, 10103, 10103);
INSERT INTO fieldconfigschemeissuetype VALUES (10204, NULL, 10104, 10104);
INSERT INTO fieldconfigschemeissuetype VALUES (10206, NULL, 10000, 10000);


--
-- Data for Name: fieldconfiguration; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldconfiguration VALUES (10000, 'Default Configuration for Issue Type', 'Default configuration generated by JIRA', 'issuetype', NULL);
INSERT INTO fieldconfiguration VALUES (10100, 'Default Configuration for Rank', 'Default configuration generated by JIRA', 'customfield_10000', NULL);
INSERT INTO fieldconfiguration VALUES (10101, 'Default Configuration for Epic Link', 'Default configuration generated by JIRA', 'customfield_10001', NULL);
INSERT INTO fieldconfiguration VALUES (10102, 'Default Configuration for Sprint', 'Default configuration generated by JIRA', 'customfield_10005', NULL);
INSERT INTO fieldconfiguration VALUES (10103, 'Default Configuration for Flagged', 'Default configuration generated by JIRA', 'customfield_10006', NULL);
INSERT INTO fieldconfiguration VALUES (10104, 'Default Configuration for Epic/Theme', 'Default configuration generated by JIRA', 'customfield_10007', NULL);


--
-- Data for Name: fieldlayout; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldlayout VALUES (10000, 'Default Field Configuration', 'The default field configuration', 'default', NULL);


--
-- Data for Name: fieldlayoutitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldlayoutitem VALUES (10142, 10000, 'summary', NULL, NULL, 'false', 'true', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10143, 10000, 'issuetype', NULL, NULL, 'false', 'true', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10144, 10000, 'security', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10145, 10000, 'priority', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10146, 10000, 'duedate', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10147, 10000, 'components', NULL, NULL, 'false', 'false', 'frother-control-renderer');
INSERT INTO fieldlayoutitem VALUES (10148, 10000, 'versions', NULL, NULL, 'false', 'false', 'frother-control-renderer');
INSERT INTO fieldlayoutitem VALUES (10149, 10000, 'fixVersions', NULL, NULL, 'false', 'false', 'frother-control-renderer');
INSERT INTO fieldlayoutitem VALUES (10150, 10000, 'assignee', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10151, 10000, 'reporter', NULL, NULL, 'false', 'true', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10152, 10000, 'environment', 'For example operating system, software platform and/or hardware specifications (include as appropriate for the issue).', NULL, 'false', 'false', 'atlassian-wiki-renderer');
INSERT INTO fieldlayoutitem VALUES (10153, 10000, 'description', NULL, NULL, 'false', 'false', 'atlassian-wiki-renderer');
INSERT INTO fieldlayoutitem VALUES (10154, 10000, 'timetracking', 'An estimate of how much work remains until this issue will be resolved.<br>The format of this is '' *w *d *h *m '' (representing weeks, days, hours and minutes - where * can be any number)<br>Examples: 4d, 5h 30m, 60m and 3w.<br>', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10155, 10000, 'resolution', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10156, 10000, 'attachment', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10157, 10000, 'comment', NULL, NULL, 'false', 'false', 'atlassian-wiki-renderer');
INSERT INTO fieldlayoutitem VALUES (10158, 10000, 'labels', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10159, 10000, 'worklog', 'Allows work to be logged whilst creating, editing or transitioning issues.', NULL, 'false', 'false', 'atlassian-wiki-renderer');
INSERT INTO fieldlayoutitem VALUES (10160, 10000, 'issuelinks', NULL, NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10161, 10000, 'customfield_10000', 'Global rank field for JIRA Software use only.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10162, 10000, 'customfield_10001', 'Choose an epic to assign this issue to.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10163, 10000, 'customfield_10002', 'Epic Status field for JIRA Software use only.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10164, 10000, 'customfield_10003', 'Provide a short name to identify this epic.', NULL, 'false', 'true', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10165, 10000, 'customfield_10005', 'JIRA Software sprint field', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10166, 10000, 'customfield_10006', 'Allows to flag issues with impediments.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10167, 10000, 'customfield_10007', 'Field that will help you regroup issues under an Epic or under a theme.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10168, 10000, 'customfield_10008', 'Measurement of complexity and/or size of a requirement.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10169, 10000, 'customfield_10009', 'Measurement of business value of a requirement.', NULL, 'false', 'false', 'jira-text-renderer');
INSERT INTO fieldlayoutitem VALUES (10170, 10000, 'customfield_10004', 'Epic Color field for JIRA Software use only.', NULL, 'false', 'false', 'jira-text-renderer');


--
-- Data for Name: fieldlayoutscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: fieldlayoutschemeassociation; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: fieldlayoutschemeentity; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: fieldscreen; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldscreen VALUES (1, 'Default Screen', 'Allows to update all system fields.');
INSERT INTO fieldscreen VALUES (2, 'Workflow Screen', 'This screen is used in the workflow and enables you to assign issues');
INSERT INTO fieldscreen VALUES (3, 'Resolve Issue Screen', 'Allows to set resolution, change fix versions and assign an issue.');


--
-- Data for Name: fieldscreenlayoutitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldscreenlayoutitem VALUES (10000, 'summary', 0, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10001, 'issuetype', 1, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10002, 'security', 2, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10003, 'priority', 3, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10004, 'duedate', 4, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10005, 'components', 5, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10006, 'versions', 6, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10007, 'fixVersions', 7, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10008, 'assignee', 8, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10009, 'reporter', 9, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10010, 'environment', 10, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10011, 'description', 11, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10012, 'timetracking', 12, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10013, 'attachment', 13, 10000);
INSERT INTO fieldscreenlayoutitem VALUES (10014, 'assignee', 0, 10001);
INSERT INTO fieldscreenlayoutitem VALUES (10015, 'resolution', 0, 10002);
INSERT INTO fieldscreenlayoutitem VALUES (10016, 'fixVersions', 1, 10002);
INSERT INTO fieldscreenlayoutitem VALUES (10017, 'assignee', 2, 10002);
INSERT INTO fieldscreenlayoutitem VALUES (10018, 'worklog', 3, 10002);
INSERT INTO fieldscreenlayoutitem VALUES (10100, 'labels', 14, 10000);


--
-- Data for Name: fieldscreenscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldscreenscheme VALUES (1, 'Default Screen Scheme', 'Default Screen Scheme');


--
-- Data for Name: fieldscreenschemeitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldscreenschemeitem VALUES (10000, NULL, 1, 1);


--
-- Data for Name: fieldscreentab; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO fieldscreentab VALUES (10001, 'Field Tab', NULL, 0, 2);
INSERT INTO fieldscreentab VALUES (10002, 'Field Tab', NULL, 0, 3);
INSERT INTO fieldscreentab VALUES (10000, 'Field Tab', NULL, 0, 1);


--
-- Data for Name: fileattachment; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: filtersubscription; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: gadgetuserpreference; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO gadgetuserpreference VALUES (10000, 10002, 'isConfigured', 'true');
INSERT INTO gadgetuserpreference VALUES (10001, 10003, 'keys', '__all_projects__');
INSERT INTO gadgetuserpreference VALUES (10002, 10003, 'isConfigured', 'true');
INSERT INTO gadgetuserpreference VALUES (10003, 10003, 'title', 'Your Company JIRA');
INSERT INTO gadgetuserpreference VALUES (10004, 10003, 'numofentries', '5');


--
-- Data for Name: genericconfiguration; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO genericconfiguration VALUES (10000, 'DefaultValue', '10000', '<string>1</string>');


--
-- Data for Name: globalpermissionentry; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO globalpermissionentry VALUES (10000, 'ADMINISTER', 'jira-administrators');
INSERT INTO globalpermissionentry VALUES (10006, 'SYSTEM_ADMIN', 'jira-administrators');
INSERT INTO globalpermissionentry VALUES (10100, 'BULK_CHANGE', 'jira-core-users');
INSERT INTO globalpermissionentry VALUES (10101, 'CREATE_SHARED_OBJECTS', 'jira-core-users');
INSERT INTO globalpermissionentry VALUES (10102, 'MANAGE_GROUP_FILTER_SUBSCRIPTIONS', 'jira-core-users');
INSERT INTO globalpermissionentry VALUES (10103, 'USER_PICKER', 'jira-core-users');
INSERT INTO globalpermissionentry VALUES (10104, 'BULK_CHANGE', 'jira-software-users');
INSERT INTO globalpermissionentry VALUES (10105, 'CREATE_SHARED_OBJECTS', 'jira-software-users');
INSERT INTO globalpermissionentry VALUES (10106, 'MANAGE_GROUP_FILTER_SUBSCRIPTIONS', 'jira-software-users');
INSERT INTO globalpermissionentry VALUES (10107, 'USER_PICKER', 'jira-software-users');


--
-- Data for Name: groupbase; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: issuelink; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: issuelinktype; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO issuelinktype VALUES (10000, 'Blocks', 'is blocked by', 'blocks', NULL);
INSERT INTO issuelinktype VALUES (10001, 'Cloners', 'is cloned by', 'clones', NULL);
INSERT INTO issuelinktype VALUES (10002, 'Duplicate', 'is duplicated by', 'duplicates', NULL);
INSERT INTO issuelinktype VALUES (10003, 'Relates', 'relates to', 'relates to', NULL);
INSERT INTO issuelinktype VALUES (10100, 'jira_subtask_link', 'jira_subtask_inward', 'jira_subtask_outward', 'jira_subtask');
INSERT INTO issuelinktype VALUES (10200, 'Epic-Story Link', 'has Epic', 'is Epic of', 'jira_gh_epic_story');


--
-- Data for Name: issuesecurityscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: issuestatus; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO issuestatus VALUES ('4', 4, 'Reopened', 'This issue was once resolved, but the resolution was deemed incorrect. From here issues are either marked assigned or resolved.', '/images/icons/statuses/reopened.png', 2);
INSERT INTO issuestatus VALUES ('5', 5, 'Resolved', 'A resolution has been taken, and it is awaiting verification by reporter. From here issues are either reopened, or are closed.', '/images/icons/statuses/resolved.png', 3);
INSERT INTO issuestatus VALUES ('6', 6, 'Closed', 'The issue is considered finished, the resolution is correct. Issues which are closed can be reopened.', '/images/icons/statuses/closed.png', 3);
INSERT INTO issuestatus VALUES ('1', 1, 'Open', 'The issue is open and ready for the assignee to start work on it.', '/images/icons/statuses/open.png', 2);
INSERT INTO issuestatus VALUES ('3', 3, 'In Progress', 'This issue is being actively worked on at the moment by the assignee.', '/images/icons/statuses/inprogress.png', 4);


--
-- Data for Name: issuetype; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO issuetype VALUES ('10000', 1, 'Epic', NULL, 'Created by JIRA Software - do not edit or delete. Issue type for a big user story that needs to be broken down.', '/images/icons/ico_epic.png', NULL);
INSERT INTO issuetype VALUES ('10001', 2, 'Story', NULL, 'Created by JIRA Software - do not edit or delete. Issue type for a user story.', '/images/icons/ico_story.png', NULL);


--
-- Data for Name: issuetypescreenscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO issuetypescreenscheme VALUES (1, 'Default Issue Type Screen Scheme', 'The default issue type screen scheme');


--
-- Data for Name: issuetypescreenschemeentity; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO issuetypescreenschemeentity VALUES (10000, NULL, 1, 1);


--
-- Data for Name: jiraaction; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jiradraftworkflows; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jiraeventtype; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jiraeventtype VALUES (2, NULL, 'Issue Updated', 'This is the ''issue updated'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (3, NULL, 'Issue Assigned', 'This is the ''issue assigned'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (4, NULL, 'Issue Resolved', 'This is the ''issue resolved'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (5, NULL, 'Issue Closed', 'This is the ''issue closed'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (6, NULL, 'Issue Commented', 'This is the ''issue commented'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (7, NULL, 'Issue Reopened', 'This is the ''issue reopened'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (8, NULL, 'Issue Deleted', 'This is the ''issue deleted'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (9, NULL, 'Issue Moved', 'This is the ''issue moved'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (10, NULL, 'Work Logged On Issue', 'This is the ''work logged on issue'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (11, NULL, 'Work Started On Issue', 'This is the ''work started on issue'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (12, NULL, 'Work Stopped On Issue', 'This is the ''work stopped on issue'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (13, NULL, 'Generic Event', 'This is the ''generic event'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (14, NULL, 'Issue Comment Edited', 'This is the ''issue comment edited'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (15, NULL, 'Issue Worklog Updated', 'This is the ''issue worklog updated'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (16, NULL, 'Issue Worklog Deleted', 'This is the ''issue worklog deleted'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (17, NULL, 'Issue Comment Deleted', 'This is the ''issue comment deleted'' event.', 'jira.system.event.type');
INSERT INTO jiraeventtype VALUES (1, NULL, 'Issue Created', 'This is the ''issue created'' event.', 'jira.system.event.type');


--
-- Data for Name: jiraissue; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jiraperms; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jiraworkflows; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jiraworkflows VALUES (10000, 'classic default workflow', NULL, '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE workflow PUBLIC "-//OpenSymphony Group//DTD OSWorkflow 2.8//EN" "http://www.opensymphony.com/osworkflow/workflow_2_8.dtd">
<workflow>
  <meta name="jira.description">The classic JIRA default workflow</meta>
  <initial-actions>
    <action id="1" name="Create Issue">
      <meta name="opsbar-sequence">0</meta>
      <meta name="jira.i18n.title">common.forms.create</meta>
      <validators>
        <validator name="" type="class">
          <arg name="class.name">com.atlassian.jira.workflow.validator.PermissionValidator</arg>
          <arg name="permission">Create Issue</arg>
        </validator>
      </validators>
      <results>
        <unconditional-result old-status="Finished" status="Open" step="1">
          <post-functions>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueCreateFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
              <arg name="eventTypeId">1</arg>
            </function>
          </post-functions>
        </unconditional-result>
      </results>
    </action>
  </initial-actions>
  <common-actions>
    <action id="2" name="Close Issue" view="resolveissue">
      <meta name="opsbar-sequence">60</meta>
      <meta name="jira.i18n.submit">closeissue.close</meta>
      <meta name="jira.i18n.description">closeissue.desc</meta>
      <meta name="jira.i18n.title">closeissue.title</meta>
      <restrict-to>
        <conditions type="AND">
          <condition type="class">
            <arg name="class.name">com.atlassian.jira.workflow.condition.PermissionCondition</arg>
            <arg name="permission">Resolve Issue</arg>
          </condition>
          <condition type="class">
            <arg name="class.name">com.atlassian.jira.workflow.condition.PermissionCondition</arg>
            <arg name="permission">Close Issue</arg>
          </condition>
        </conditions>
      </restrict-to>
      <results>
        <unconditional-result old-status="Finished" status="Closed" step="6">
          <post-functions>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
              <arg name="eventTypeId">5</arg>
            </function>
          </post-functions>
        </unconditional-result>
      </results>
    </action>
    <action id="3" name="Reopen Issue" view="commentassign">
      <meta name="opsbar-sequence">80</meta>
      <meta name="jira.i18n.submit">issue.operations.reopen.issue</meta>
      <meta name="jira.i18n.description">issue.operations.reopen.description</meta>
      <meta name="jira.i18n.title">issue.operations.reopen.issue</meta>
      <restrict-to>
        <conditions>
          <condition type="class">
            <arg name="class.name">com.atlassian.jira.workflow.condition.PermissionCondition</arg>
            <arg name="permission">Resolve Issue</arg>
          </condition>
        </conditions>
      </restrict-to>
      <results>
        <unconditional-result old-status="Finished" status="Reopened" step="5">
          <post-functions>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction</arg>
              <arg name="field.value"></arg>
              <arg name="field.name">resolution</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
              <arg name="eventTypeId">7</arg>
            </function>
          </post-functions>
        </unconditional-result>
      </results>
    </action>
    <action id="4" name="Start Progress">
      <meta name="opsbar-sequence">20</meta>
      <meta name="jira.i18n.title">startprogress.title</meta>
      <restrict-to>
        <conditions>
          <condition type="class">
            <arg name="class.name">com.atlassian.jira.workflow.condition.AllowOnlyAssignee</arg>
          </condition>
        </conditions>
      </restrict-to>
      <results>
        <unconditional-result old-status="Finished" status="Underway" step="3">
          <post-functions>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction</arg>
              <arg name="field.value"></arg>
              <arg name="field.name">resolution</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
              <arg name="eventTypeId">11</arg>
            </function>
          </post-functions>
        </unconditional-result>
      </results>
    </action>
    <action id="5" name="Resolve Issue" view="resolveissue">
      <meta name="opsbar-sequence">40</meta>
      <meta name="jira.i18n.submit">resolveissue.resolve</meta>
      <meta name="jira.i18n.description">resolveissue.desc.line1</meta>
      <meta name="jira.i18n.title">resolveissue.title</meta>
      <restrict-to>
        <conditions>
          <condition type="class">
            <arg name="class.name">com.atlassian.jira.workflow.condition.PermissionCondition</arg>
            <arg name="permission">Resolve Issue</arg>
          </condition>
        </conditions>
      </restrict-to>
      <results>
        <unconditional-result old-status="Finished" status="Resolved" step="4">
          <post-functions>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>
            </function>
            <function type="class">
              <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
              <arg name="eventTypeId">4</arg>
            </function>
          </post-functions>
        </unconditional-result>
      </results>
    </action>
  </common-actions>
  <steps>
    <step id="1" name="Open">
      <meta name="jira.status.id">1</meta>
      <actions>
<common-action id="4" />
<common-action id="5" />
<common-action id="2" />
      </actions>
    </step>
    <step id="3" name="In Progress">
      <meta name="jira.status.id">3</meta>
      <actions>
<common-action id="5" />
<common-action id="2" />
        <action id="301" name="Stop Progress">
          <meta name="opsbar-sequence">20</meta>
          <meta name="jira.i18n.title">stopprogress.title</meta>
          <restrict-to>
            <conditions>
              <condition type="class">
                <arg name="class.name">com.atlassian.jira.workflow.condition.AllowOnlyAssignee</arg>
              </condition>
            </conditions>
          </restrict-to>
          <results>
            <unconditional-result old-status="Finished" status="Assigned" step="1">
              <post-functions>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction</arg>
                  <arg name="field.value"></arg>
                  <arg name="field.name">resolution</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
                  <arg name="eventTypeId">12</arg>
                </function>
              </post-functions>
            </unconditional-result>
          </results>
        </action>
      </actions>
    </step>
    <step id="4" name="Resolved">
      <meta name="jira.status.id">5</meta>
      <actions>
<common-action id="3" />
        <action id="701" name="Close Issue" view="commentassign">
          <meta name="opsbar-sequence">60</meta>
          <meta name="jira.i18n.submit">closeissue.close</meta>
          <meta name="jira.i18n.description">closeissue.desc</meta>
          <meta name="jira.i18n.title">closeissue.title</meta>
          <meta name="jira.description">Closing an issue indicates there is no more work to be done on it, and it has been verified as complete.</meta>
          <restrict-to>
            <conditions>
              <condition type="class">
                <arg name="class.name">com.atlassian.jira.workflow.condition.PermissionCondition</arg>
                <arg name="permission">Close Issue</arg>
              </condition>
            </conditions>
          </restrict-to>
          <results>
            <unconditional-result old-status="Finished" status="Closed" step="6">
              <post-functions>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.UpdateIssueStatusFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.misc.CreateCommentFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.GenerateChangeHistoryFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>
                </function>
                <function type="class">
                  <arg name="class.name">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>
                  <arg name="eventTypeId">5</arg>
                </function>
              </post-functions>
            </unconditional-result>
          </results>
        </action>
      </actions>
    </step>
    <step id="5" name="Reopened">
      <meta name="jira.status.id">4</meta>
      <actions>
<common-action id="5" />
<common-action id="2" />
<common-action id="4" />
      </actions>
    </step>
    <step id="6" name="Closed">
      <meta name="jira.status.id">6</meta>
      <meta name="jira.issue.editable">false</meta>
      <actions>
<common-action id="3" />
      </actions>
    </step>
  </steps>
</workflow>
', NULL);


--
-- Data for Name: jquartz_blob_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_calendars; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_cron_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jquartz_cron_triggers VALUES (NULL, 'com.atlassian.jira.service.JiraService:10002', 'SchedulerServiceTriggers', '0 0 10 * * ?', 'Australia/Sydney');
INSERT INTO jquartz_cron_triggers VALUES (NULL, 'com.atlassian.jira.service.JiraService:10001', 'SchedulerServiceTriggers', '0 25 1/12 * * ?', 'Australia/Sydney');


--
-- Data for Name: jquartz_fired_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_job_details; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jquartz_job_details VALUES (NULL, 'com.atlassian.jira.service.DefaultServiceManager', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'com.atlassian.jira.plugin.devstatus.provider.DataProviderCleanupJob', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancePluginJob', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.LocalPluginLicenseNotificationJob-job-handler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.RemotePluginLicenseNotificationJob-job-handler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.PluginRequestCheckJob-job-handler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.PluginUpdateCheckJob-job-handler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.InstanceTopologyJob-job-handler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.Service Provider Session Remover', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.jira.plugins.dvcs.ondemand.BitbucketAccountsReloadJobScheduler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');
INSERT INTO jquartz_job_details VALUES (NULL, 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.jira.plugins.dvcs.scheduler.DvcsScheduler', 'SchedulerServiceJobs', NULL, 'com.atlassian.scheduler.quartz1.Quartz1Job', false, false, false, NULL, NULL, false, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787000737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f40000000000010770800000010000000007800');


--
-- Data for Name: jquartz_job_listeners; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_locks; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jquartz_locks VALUES (NULL, 'TRIGGER_ACCESS');
INSERT INTO jquartz_locks VALUES (NULL, 'JOB_ACCESS');
INSERT INTO jquartz_locks VALUES (NULL, 'CALENDAR_ACCESS');
INSERT INTO jquartz_locks VALUES (NULL, 'STATE_ACCESS');
INSERT INTO jquartz_locks VALUES (NULL, 'MISFIRE_ACCESS');


--
-- Data for Name: jquartz_paused_trigger_grps; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_scheduler_state; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_simple_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jquartz_simple_triggers VALUES (NULL, 'data-provider-cleanup', 'SchedulerServiceTriggers', -1, 1800000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.LEXO_RANK_SCHEDULER_JOB', 'SchedulerServiceTriggers', -1, 60000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.LocalPluginLicenseNotificationJob-job', 'SchedulerServiceTriggers', -1, 86400000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.RemotePluginLicenseNotificationJob-job', 'SchedulerServiceTriggers', -1, 86400000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.PluginRequestCheckJob-job', 'SchedulerServiceTriggers', -1, 3600000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.PluginUpdateCheckJob-job', 'SchedulerServiceTriggers', -1, 86400000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.InstanceTopologyJob-job', 'SchedulerServiceTriggers', -1, 86400000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.Service Provider Session Remover', 'SchedulerServiceTriggers', -1, 28800000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.bitbucket-accounts-reload', 'SchedulerServiceTriggers', -1, 100000000000020000, 0);
INSERT INTO jquartz_simple_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.com.atlassian.jira.plugins.dvcs.scheduler.DvcsScheduler:job', 'SchedulerServiceTriggers', -1, 3600000, 0);


--
-- Data for Name: jquartz_simprop_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_trigger_listeners; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: jquartz_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO jquartz_triggers VALUES (NULL, 'com.atlassian.jira.service.JiraService:10002', 'SchedulerServiceTriggers', 'com.atlassian.jira.service.DefaultServiceManager', 'SchedulerServiceJobs', false, NULL, 1438646400000, -1, 5, 'WAITING', 'CRON', 1438572493000, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273757200025b42acf317f8060854e0020000787000000171aced000573720037636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c6542694d61702453657269616c697a6564466f726d000000000000000002000078720035636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c654d61702453657269616c697a6564466f726d00000000000000000200025b00046b6579737400135b4c6a6176612f6c616e672f4f626a6563743b5b000676616c75657371007e00027870757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c020000787000000001740033636f6d2e61746c61737369616e2e6a6972612e736572766963652e536572766963654d616e616765723a7365727669636549647571007e0004000000017372000e6a6176612e6c616e672e4c6f6e673b8be490cc8f23df0200014a000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b020000787000000000000027127800');
INSERT INTO jquartz_triggers VALUES (NULL, 'data-provider-cleanup', 'SchedulerServiceTriggers', 'com.atlassian.jira.plugin.devstatus.provider.DataProviderCleanupJob', 'SchedulerServiceJobs', false, NULL, 1438572548811, -1, 5, 'WAITING', 'SIMPLE', 1438572548811, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'com.atlassian.jira.service.JiraService:10001', 'SchedulerServiceTriggers', 'com.atlassian.jira.service.DefaultServiceManager', 'SchedulerServiceJobs', false, NULL, 1438615500000, -1, 5, 'WAITING', 'CRON', 1438572557000, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273757200025b42acf317f8060854e0020000787000000171aced000573720037636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c6542694d61702453657269616c697a6564466f726d000000000000000002000078720035636f6d2e676f6f676c652e636f6d6d6f6e2e636f6c6c6563742e496d6d757461626c654d61702453657269616c697a6564466f726d00000000000000000200025b00046b6579737400135b4c6a6176612f6c616e672f4f626a6563743b5b000676616c75657371007e00027870757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c020000787000000001740033636f6d2e61746c61737369616e2e6a6972612e736572766963652e536572766963654d616e616765723a7365727669636549647571007e0004000000017372000e6a6176612e6c616e672e4c6f6e673b8be490cc8f23df0200014a000576616c7565787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b020000787000000000000027117800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.LEXO_RANK_SCHEDULER_JOB', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.greenhopper.service.lexorank.balance.LexoRankBalancePluginJob', 'SchedulerServiceJobs', false, NULL, 1438572601054, -1, 5, 'WAITING', 'SIMPLE', 1438572601054, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.LocalPluginLicenseNotificationJob-job', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.LocalPluginLicenseNotificationJob-job-handler', 'SchedulerServiceJobs', false, NULL, 1438572602349, -1, 5, 'WAITING', 'SIMPLE', 1438572602349, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.RemotePluginLicenseNotificationJob-job', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.RemotePluginLicenseNotificationJob-job-handler', 'SchedulerServiceJobs', false, NULL, 1438624864412, -1, 5, 'WAITING', 'SIMPLE', 1438624864412, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.PluginRequestCheckJob-job', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.PluginRequestCheckJob-job-handler', 'SchedulerServiceJobs', false, NULL, 1438572602395, -1, 5, 'WAITING', 'SIMPLE', 1438572602395, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.PluginUpdateCheckJob-job', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.PluginUpdateCheckJob-job-handler', 'SchedulerServiceJobs', false, NULL, 1438616831767, -1, 5, 'WAITING', 'SIMPLE', 1438616831767, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.InstanceTopologyJob-job', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.InstanceTopologyJob-job-handler', 'SchedulerServiceJobs', false, NULL, 1438647742147, -1, 5, 'WAITING', 'SIMPLE', 1438647742147, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.Service Provider Session Remover', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.Service Provider Session Remover', 'SchedulerServiceJobs', false, NULL, 1438601407960, -1, 5, 'WAITING', 'SIMPLE', 1438601407960, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.bitbucket-accounts-reload', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.jira.plugins.dvcs.ondemand.BitbucketAccountsReloadJobScheduler', 'SchedulerServiceJobs', false, NULL, 1438572622980, -1, 5, 'WAITING', 'SIMPLE', 1438572622980, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');
INSERT INTO jquartz_triggers VALUES (NULL, 'CompatibilityPluginScheduler.JobId.com.atlassian.jira.plugins.dvcs.scheduler.DvcsScheduler:job', 'SchedulerServiceTriggers', 'CompatibilityPluginScheduler.JobRunnerKey.com.atlassian.jira.plugins.dvcs.scheduler.DvcsScheduler', 'SchedulerServiceJobs', false, NULL, 1438575653778, -1, 5, 'WAITING', 'SIMPLE', 1438575653778, 0, NULL, 0, '\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000174000a706172616d6574657273707800');


--
-- Data for Name: label; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: licenserolesdefault; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO licenserolesdefault VALUES (10000, 'jira-software');
INSERT INTO licenserolesdefault VALUES (10001, 'jira-core');


--
-- Data for Name: licenserolesgroup; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO licenserolesgroup VALUES (10000, 'jira-core', 'jira-administrators', 'N');
INSERT INTO licenserolesgroup VALUES (10001, 'jira-software', 'jira-administrators', 'N');
INSERT INTO licenserolesgroup VALUES (10100, 'jira-core', 'jira-core-users', 'Y');
INSERT INTO licenserolesgroup VALUES (10101, 'jira-software', 'jira-software-users', 'Y');


--
-- Data for Name: listenerconfig; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO listenerconfig VALUES (10000, 'com.atlassian.jira.event.listeners.mail.MailListener', 'Mail Listener');
INSERT INTO listenerconfig VALUES (10001, 'com.atlassian.jira.event.listeners.history.IssueAssignHistoryListener', 'Issue Assignment Listener');
INSERT INTO listenerconfig VALUES (10002, 'com.atlassian.jira.event.listeners.search.IssueIndexListener', 'Issue Index Listener');
INSERT INTO listenerconfig VALUES (10200, 'com.atlassian.jira.event.listeners.search.IssueIndexListener', 'Issue Index Listener');


--
-- Data for Name: mailserver; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: managedconfigurationitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO managedconfigurationitem VALUES (10000, 'customfield_10000', 'CUSTOM_FIELD', 'true', 'LOCKED', 'com.pyxis.greenhopper.jira:reference-select-locked', 'gh.customfield.locked.desc');
INSERT INTO managedconfigurationitem VALUES (10001, 'customfield_10001', 'CUSTOM_FIELD', 'true', 'LOCKED', 'com.pyxis.greenhopper.jira:reference-select-locked', 'gh.customfield.locked.desc');
INSERT INTO managedconfigurationitem VALUES (10002, 'customfield_10002', 'CUSTOM_FIELD', 'true', 'LOCKED', 'com.pyxis.greenhopper.jira:reference-select-locked', 'gh.customfield.locked.desc');
INSERT INTO managedconfigurationitem VALUES (10003, 'customfield_10003', 'CUSTOM_FIELD', 'true', 'LOCKED', 'com.pyxis.greenhopper.jira:reference-select-locked', 'gh.customfield.locked.desc');
INSERT INTO managedconfigurationitem VALUES (10004, 'customfield_10004', 'CUSTOM_FIELD', 'true', 'LOCKED', 'com.pyxis.greenhopper.jira:reference-select-locked', 'gh.customfield.locked.desc');
INSERT INTO managedconfigurationitem VALUES (10005, 'customfield_10005', 'CUSTOM_FIELD', 'true', 'LOCKED', 'com.pyxis.greenhopper.jira:reference-select-locked', 'gh.customfield.locked.desc');


--
-- Data for Name: membershipbase; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: moved_issue_key; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: nodeassociation; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: nodeindexcounter; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: notification; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO notification VALUES (10100, 10000, NULL, 14, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10101, 10000, NULL, 14, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10102, 10000, NULL, 14, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10103, 10000, NULL, 15, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10104, 10000, NULL, 15, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10105, 10000, NULL, 15, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10106, 10000, NULL, 16, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10107, 10000, NULL, 16, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10108, 10000, NULL, 16, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10000, 10000, NULL, 1, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10001, 10000, NULL, 1, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10002, 10000, NULL, 1, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10003, 10000, NULL, 2, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10004, 10000, NULL, 2, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10005, 10000, NULL, 2, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10006, 10000, NULL, 3, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10007, 10000, NULL, 3, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10008, 10000, NULL, 3, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10009, 10000, NULL, 4, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10010, 10000, NULL, 4, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10011, 10000, NULL, 4, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10012, 10000, NULL, 5, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10013, 10000, NULL, 5, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10014, 10000, NULL, 5, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10015, 10000, NULL, 6, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10016, 10000, NULL, 6, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10017, 10000, NULL, 6, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10018, 10000, NULL, 7, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10019, 10000, NULL, 7, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10020, 10000, NULL, 7, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10021, 10000, NULL, 8, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10022, 10000, NULL, 8, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10023, 10000, NULL, 8, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10024, 10000, NULL, 9, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10025, 10000, NULL, 9, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10026, 10000, NULL, 9, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10027, 10000, NULL, 10, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10028, 10000, NULL, 10, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10029, 10000, NULL, 10, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10030, 10000, NULL, 11, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10031, 10000, NULL, 11, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10032, 10000, NULL, 11, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10033, 10000, NULL, 12, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10034, 10000, NULL, 12, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10035, 10000, NULL, 12, NULL, 'All_Watchers', NULL);
INSERT INTO notification VALUES (10036, 10000, NULL, 13, NULL, 'Current_Assignee', NULL);
INSERT INTO notification VALUES (10037, 10000, NULL, 13, NULL, 'Current_Reporter', NULL);
INSERT INTO notification VALUES (10038, 10000, NULL, 13, NULL, 'All_Watchers', NULL);


--
-- Data for Name: notificationinstance; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: notificationscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO notificationscheme VALUES (10000, 'Default Notification Scheme', NULL);


--
-- Data for Name: oauthconsumer; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: oauthconsumertoken; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: oauthspconsumer; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: oauthsptoken; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: optionconfiguration; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO optionconfiguration VALUES (10201, 'issuetype', '10000', 10000, 0);
INSERT INTO optionconfiguration VALUES (10202, 'issuetype', '10001', 10000, 1);


--
-- Data for Name: os_currentstep; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: os_currentstep_prev; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: os_historystep; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: os_historystep_prev; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: os_wfentry; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: permissionscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO permissionscheme VALUES (0, 'Default Permission Scheme', 'This is the default Permission Scheme. Any new projects that are created will be assigned this scheme.');


--
-- Data for Name: pluginstate; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: pluginversion; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO pluginversion VALUES (10000, 'ActiveObjects Plugin - OSGi Bundle', 'com.atlassian.activeobjects.activeobjects-plugin', '1.0.0', '2015-08-03 13:29:12.577+10');
INSERT INTO pluginversion VALUES (10001, 'Atlassian Template Renderer API', 'com.atlassian.templaterenderer.api', '2.0.0', '2015-08-03 13:29:12.593+10');
INSERT INTO pluginversion VALUES (10002, 'Atlassian Template Renderer Velocity 1.6 Plugin', 'com.atlassian.templaterenderer.atlassian-template-renderer-velocity1.6-plugin', '2.0.0', '2015-08-03 13:29:12.602+10');
INSERT INTO pluginversion VALUES (10003, 'Atlassian REST - Module Types', 'com.atlassian.plugins.rest.atlassian-rest-module', '3.0.2', '2015-08-03 13:29:12.605+10');
INSERT INTO pluginversion VALUES (10004, 'Atlassian - Administration - Quick Search - JIRA', 'com.atlassian.administration.atlassian-admin-quicksearch-jira', '2.2.2', '2015-08-03 13:29:12.636+10');
INSERT INTO pluginversion VALUES (10005, 'Analytics Client Plugin', 'com.atlassian.analytics.analytics-client', '4.2.1', '2015-08-03 13:29:12.666+10');
INSERT INTO pluginversion VALUES (10006, 'Analytics Whitelist Plugin', 'com.atlassian.analytics.analytics-whitelist', '3.37', '2015-08-03 13:29:12.674+10');
INSERT INTO pluginversion VALUES (10007, 'JSON Library', 'com.atlassian.bundles.json-20070829.0.0.1', '20070829.0.0.1', '2015-08-03 13:29:12.681+10');
INSERT INTO pluginversion VALUES (10008, 'Atlassian OAuth Consumer SPI', 'com.atlassian.oauth.atlassian-oauth-consumer-spi', '2.0.1-f748404', '2015-08-03 13:29:12.691+10');
INSERT INTO pluginversion VALUES (10009, 'Atlassian OAuth Service Provider SPI', 'com.atlassian.oauth.atlassian-oauth-service-provider-spi', '2.0.1-f748404', '2015-08-03 13:29:12.693+10');
INSERT INTO pluginversion VALUES (10010, 'Applinks Product Plugin', 'com.atlassian.applinks.applinks-plugin', '5.0.0', '2015-08-03 13:29:12.783+10');
INSERT INTO pluginversion VALUES (10011, 'Applinks Basic Auth Product Plugin', 'com.atlassian.applinks.applinks-basicauth-plugin', '5.0.0', '2015-08-03 13:29:12.787+10');
INSERT INTO pluginversion VALUES (10012, 'Applinks CORS Product Plugin', 'com.atlassian.applinks.applinks-cors-plugin', '5.0.0', '2015-08-03 13:29:12.791+10');
INSERT INTO pluginversion VALUES (10013, 'Atlassian JIRA - Plugins - OAuth Consumer SPI', 'com.atlassian.jira.oauth.consumer', '7.0.0-SNAPSHOT', '2015-08-03 13:29:12.792+10');
INSERT INTO pluginversion VALUES (10014, 'Applinks OAuth Product Plugin', 'com.atlassian.applinks.applinks-oauth-plugin', '5.0.0', '2015-08-03 13:29:12.821+10');
INSERT INTO pluginversion VALUES (10015, 'Applinks Trusted Apps Product Plugin', 'com.atlassian.applinks.applinks-trustedapps-plugin', '5.0.0', '2015-08-03 13:29:12.83+10');
INSERT INTO pluginversion VALUES (10016, 'atlassian-failure-cache-plugin', 'com.atlassian.atlassian-failure-cache-plugin', '0.15', '2015-08-03 13:29:12.839+10');
INSERT INTO pluginversion VALUES (10017, 'Atlassian UI Plugin', 'com.atlassian.auiplugin', '5.7.31', '2015-08-03 13:29:12.852+10');
INSERT INTO pluginversion VALUES (10018, 'ICU4J', 'com.atlassian.bundles.icu4j-3.8.0.1', '3.8.0.1', '2015-08-03 13:29:12.854+10');
INSERT INTO pluginversion VALUES (10019, 'Atlassian JSON Schema Validator Bundle', 'com.atlassian.bundles.json-schema-validator-atlassian-bundle', '1.0.4', '2015-08-03 13:29:12.855+10');
INSERT INTO pluginversion VALUES (10020, 'Neko HTML', 'com.atlassian.bundles.nekohtml-1.9.12.1', '1.9.12.1', '2015-08-03 13:29:12.857+10');
INSERT INTO pluginversion VALUES (10021, 'Atlassian Embedded Crowd - Administration Plugin', 'com.atlassian.crowd.embedded.admin', '2.0.0-m4', '2015-08-03 13:29:12.884+10');
INSERT INTO pluginversion VALUES (10022, 'Atlassian REST API Browser', 'com.atlassian.labs.rest-api-browser', '3.0.12', '2015-08-03 13:29:12.917+10');
INSERT INTO pluginversion VALUES (10023, 'Atlassian Developer Toolbox', 'com.atlassian.devrel.developer-toolbox-plugin', '2.0.16', '2015-08-03 13:29:12.93+10');
INSERT INTO pluginversion VALUES (10024, 'Gadget Dashboard Plugin', 'com.atlassian.gadgets.dashboard', '3.11.6', '2015-08-03 13:29:12.971+10');
INSERT INTO pluginversion VALUES (10025, 'ROME, RSS and atOM utilitiEs for Java', 'rome.rome-1.0', '1.0', '2015-08-03 13:29:12.973+10');
INSERT INTO pluginversion VALUES (10026, 'Gadget Directory Plugin', 'com.atlassian.gadgets.directory', '3.11.6', '2015-08-03 13:29:12.998+10');
INSERT INTO pluginversion VALUES (10027, 'Embedded Gadgets Plugin', 'com.atlassian.gadgets.embedded', '3.11.6', '2015-08-03 13:29:13+10');
INSERT INTO pluginversion VALUES (10028, 'Atlassian Gadgets OAuth Service Provider Plugin', 'com.atlassian.gadgets.oauth.serviceprovider', '3.11.6', '2015-08-03 13:29:13.002+10');
INSERT INTO pluginversion VALUES (10029, 'Opensocial Plugin', 'com.atlassian.gadgets.opensocial', '3.11.6', '2015-08-03 13:29:13.011+10');
INSERT INTO pluginversion VALUES (10030, 'Gadget Spec Publisher Plugin', 'com.atlassian.gadgets.publisher', '3.11.6', '2015-08-03 13:29:13.042+10');
INSERT INTO pluginversion VALUES (10031, 'JIRA Workflow Designer Plugin', 'com.atlassian.jira.plugins.jira-workflow-designer', '7.0.4', '2015-08-03 13:29:13.071+10');
INSERT INTO pluginversion VALUES (10032, 'JIRA Workflow Sharing Plugin', 'com.atlassian.jira.plugins.workflow.sharing.jira-workflow-sharing-plugin', '2.0.2', '2015-08-03 13:29:13.103+10');
INSERT INTO pluginversion VALUES (10033, 'Project Templates Plugin', 'com.atlassian.jira.project-templates-plugin', '5.0.14', '2015-08-03 13:29:13.132+10');
INSERT INTO pluginversion VALUES (10034, 'jira-importers-plugin', 'com.atlassian.jira.plugins.jira-importers-plugin', '7.0.15', '2015-08-03 13:29:13.455+10');
INSERT INTO pluginversion VALUES (10035, 'Streams SPI', 'com.atlassian.streams.streams-spi-6.0.5', '6.0.5', '2015-08-03 13:29:13.456+10');
INSERT INTO pluginversion VALUES (10036, 'JIRA Projects Plugin', 'com.atlassian.jira.jira-projects-plugin', '3.0.22', '2015-08-03 13:29:13.569+10');
INSERT INTO pluginversion VALUES (10037, 'JIRA Core Project Templates Plugin', 'com.atlassian.jira-core-project-templates', '5.0.14', '2015-08-03 13:29:13.572+10');
INSERT INTO pluginversion VALUES (10038, 'Atlassian JIRA - Plugins - Pluggable Avatar Support', 'com.atlassian.jira.jira-pluggable-avatar-support', '7.0.0-SNAPSHOT', '2015-08-03 13:29:13.574+10');
INSERT INTO pluginversion VALUES (10039, 'Atlassian JIRA - Plugins - REST Plugin', 'com.atlassian.jira.rest', '7.0.0-SNAPSHOT', '2015-08-03 13:29:13.716+10');
INSERT INTO pluginversion VALUES (10040, 'Atlassian JIRA - Plugins - View Issue Panels', 'com.atlassian.jira.jira-view-issue-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:13.763+10');
INSERT INTO pluginversion VALUES (10041, 'Atlassian Navigation Links Plugin', 'com.atlassian.plugins.atlassian-nav-links-plugin', '4.0.0-m002', '2015-08-03 13:29:13.892+10');
INSERT INTO pluginversion VALUES (10042, 'Universal Plugin Manager - Role-Based Licensing Implementation Plugin', 'com.atlassian.upm.role-based-licensing-plugin', '2.19-rc7', '2015-08-03 13:29:13.896+10');
INSERT INTO pluginversion VALUES (10043, 'OSGi R4 Compendium Bundle', 'org.osgi.compendium-4.1.0', '4.1.0', '2015-08-03 13:29:13.897+10');
INSERT INTO pluginversion VALUES (10044, 'Atlassian Universal Plugin Manager Plugin', 'com.atlassian.upm.atlassian-universal-plugin-manager-plugin', '2.19-rc7', '2015-08-03 13:29:13.941+10');
INSERT INTO pluginversion VALUES (10045, 'Atlassian HealthCheck Common Module', 'com.atlassian.healthcheck.atlassian-healthcheck', '3.0.1', '2015-08-03 13:29:13.962+10');
INSERT INTO pluginversion VALUES (10046, 'Atlassian JIRA - Plugins - Common AppLinks Based Issue Link Plugin', 'com.atlassian.jira.jira-issue-link-applinks-common-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:13.982+10');
INSERT INTO pluginversion VALUES (10047, 'Atlassian JIRA - Plugins - Confluence Link', 'com.atlassian.jira.jira-issue-link-confluence-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.01+10');
INSERT INTO pluginversion VALUES (10048, 'scala-2.10-provider-plugin', 'com.atlassian.scala.plugins.scala-2.10-provider-plugin', '0.9', '2015-08-03 13:29:14.011+10');
INSERT INTO pluginversion VALUES (10049, 'jackson-module-scala-2.10-provider', 'com.atlassian.scala.plugins.jackson-module-scala-2.10-provider-plugin', '0.5', '2015-08-03 13:29:14.013+10');
INSERT INTO pluginversion VALUES (10050, 'jira-inline-issue-create-plugin', 'com.atlassian.jira.plugins.inline-create.jira-inline-issue-create-plugin', '1.1.3', '2015-08-03 13:29:14.038+10');
INSERT INTO pluginversion VALUES (10051, 'JIRA for Software Plugin', 'com.atlassian.jira.plugins.jira-software-plugin', '1.26', '2015-08-03 13:29:14.073+10');
INSERT INTO pluginversion VALUES (10052, 'Remote Link Aggregator Plugin', 'com.atlassian.plugins.remote-link-aggregator-plugin', '2.0.14', '2015-08-03 13:29:14.101+10');
INSERT INTO pluginversion VALUES (10053, 'JIRA Agile', 'com.pyxis.greenhopper.jira', '6.7.9-SNAPSHOT', '2015-08-03 13:29:14.295+10');
INSERT INTO pluginversion VALUES (10054, 'Atlassian GreenHopper Client Reference Plugin', 'com.atlassian.greenhopper.client', '6.7.9-SNAPSHOT', '2015-08-03 13:29:14.408+10');
INSERT INTO pluginversion VALUES (10055, 'JIRA Agile Dev Extensions', 'com.atlassian.greenhopper.devextensions', '6.7.9-SNAPSHOT', '2015-08-03 13:29:14.459+10');
INSERT INTO pluginversion VALUES (10056, 'HipChat Core Plugin', 'com.atlassian.hipchat.plugins.core', '0.10.0', '2015-08-03 13:29:14.479+10');
INSERT INTO pluginversion VALUES (10057, 'Atlassian HTTP Client, Apache HTTP components impl', 'com.atlassian.httpclient.atlassian-httpclient-plugin', '0.22.3', '2015-08-03 13:29:14.48+10');
INSERT INTO pluginversion VALUES (10058, 'JIRA Legacy Project Templates Plugin', 'com.atlassian.jira-legacy-project-templates', '5.0.14', '2015-08-03 13:29:14.483+10');
INSERT INTO pluginversion VALUES (10059, 'JIRA Issue Collector Plugin', 'com.atlassian.jira.collector.plugin.jira-issue-collector-plugin', '2.0.7', '2015-08-03 13:29:14.507+10');
INSERT INTO pluginversion VALUES (10060, 'JIRA TestKit Plugin', 'com.atlassian.jira.tests.jira-testkit-plugin', '5.0.34-comp71-11', '2015-08-03 13:29:14.53+10');
INSERT INTO pluginversion VALUES (10061, 'Atlassian JIRA - Plugins - DevMode - Func Test Plugin', 'com.atlassian.jira.dev.func-test-plugin', '6.0-for-greenhopper', '2015-08-03 13:29:14.562+10');
INSERT INTO pluginversion VALUES (10062, 'JIRA iCalendar Plugin', 'com.atlassian.jira.extra.jira-ical-feed', '1.4.5', '2015-08-03 13:29:14.583+10');
INSERT INTO pluginversion VALUES (10063, 'Atlassian Whitelist API Plugin', 'com.atlassian.plugins.atlassian-whitelist-api-plugin', '1.13', '2015-08-03 13:29:14.588+10');
INSERT INTO pluginversion VALUES (10064, 'Atlassian JIRA - Plugins - Gadgets Plugin', 'com.atlassian.jira.gadgets', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.63+10');
INSERT INTO pluginversion VALUES (10065, 'Atlassian JIRA - Plugins - ActiveObjects SPI', 'com.atlassian.jira.jira-activeobjects-spi-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.631+10');
INSERT INTO pluginversion VALUES (10066, 'Atlassian JIRA - Plugins - Admin Navigation Component', 'com.atlassian.jira.jira-admin-navigation-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.633+10');
INSERT INTO pluginversion VALUES (10067, 'Atlassian JIRA - Plugins - Analytics whitelist', 'com.atlassian.jira.jira-analytics-whitelist-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.634+10');
INSERT INTO pluginversion VALUES (10068, 'Atlassian JIRA - Plugins - Application Properties', 'com.atlassian.jira.jira-application-properties-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.635+10');
INSERT INTO pluginversion VALUES (10069, 'Atlassian JIRA - Plugins - Avatar Plugin', 'com.atlassian.jira.jira-avatar-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.637+10');
INSERT INTO pluginversion VALUES (10070, 'JIRA Base URL Plugin', 'com.atlassian.jira.jira-baseurl-plugin', '2.0', '2015-08-03 13:29:14.638+10');
INSERT INTO pluginversion VALUES (10071, 'Atlassian JIRA - Plugins - Header Plugin', 'com.atlassian.jira.jira-header-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.684+10');
INSERT INTO pluginversion VALUES (10072, 'Atlassian JIRA - Plugins - Invite User', 'com.atlassian.jira.jira-invite-user-plugin', '2.0.10', '2015-08-03 13:29:14.689+10');
INSERT INTO pluginversion VALUES (10073, 'Atlassian JIRA - Plugins - Remote JIRA Link', 'com.atlassian.jira.jira-issue-link-remote-jira-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.713+10');
INSERT INTO pluginversion VALUES (10074, 'Atlassian JIRA - Plugins - Issue Web Link', 'com.atlassian.jira.jira-issue-link-web-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.714+10');
INSERT INTO pluginversion VALUES (10075, 'jira-issue-nav-components', 'com.atlassian.jira.jira-issue-nav-components', '7.0.18', '2015-08-03 13:29:14.756+10');
INSERT INTO pluginversion VALUES (10076, 'Atlassian JIRA - Plugins - Issue Search', 'com.atlassian.jira.jira-issue-nav-plugin', '7.0.18', '2015-08-03 13:29:14.779+10');
INSERT INTO pluginversion VALUES (10077, 'English (United Kingdom) Language Pack', 'com.atlassian.jira.jira-languages.en_UK', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.78+10');
INSERT INTO pluginversion VALUES (10078, 'English (United States) Language Pack', 'com.atlassian.jira.jira-languages.en_US', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.782+10');
INSERT INTO pluginversion VALUES (10079, 'Atlassian LESS Transformer Plugin', 'com.atlassian.plugins.less-transformer-plugin', '3.0.1', '2015-08-03 13:29:14.786+10');
INSERT INTO pluginversion VALUES (10080, 'Atlassian JIRA - Plugins - LESS integration', 'com.atlassian.jira.jira-less-integration', '7.0.0-SNAPSHOT', '2015-08-03 13:29:14.796+10');
INSERT INTO pluginversion VALUES (10081, 'Atlassian JIRA - Plugins - Mail Plugin', 'com.atlassian.jira.jira-mail-plugin', '8.0.25', '2015-08-03 13:29:15.545+10');
INSERT INTO pluginversion VALUES (10082, 'JIRA Monitoring Plugin', 'com.atlassian.jira.jira-monitoring-plugin', '05.7.0', '2015-08-03 13:29:15.756+10');
INSERT INTO pluginversion VALUES (10083, 'Atlassian JIRA - Plugins - My JIRA Home', 'com.atlassian.jira.jira-my-home-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:15.781+10');
INSERT INTO pluginversion VALUES (10084, 'Atlassian JIRA - Plugins - Onboarding', 'com.atlassian.jira.jira-onboarding-assets-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:15.829+10');
INSERT INTO pluginversion VALUES (10085, 'Atlassian JIRA - Plugins - Post setup announcements plugin', 'com.atlassian.jira.jira-postsetup-announcements-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:15.855+10');
INSERT INTO pluginversion VALUES (10086, 'JIRA Project Config Plugin', 'com.atlassian.jira.jira-project-config-plugin', '8.1.20', '2015-08-03 13:29:15.997+10');
INSERT INTO pluginversion VALUES (10087, 'Issue Navigator for JIRA Projects', 'com.atlassian.jira.jira-projects-issue-navigator', '3.0.22', '2015-08-03 13:29:16.009+10');
INSERT INTO pluginversion VALUES (10088, 'Atlassian JIRA - Plugins - Quick Edit Plugin', 'com.atlassian.jira.jira-quick-edit-plugin', '3.0.17', '2015-08-03 13:29:16.038+10');
INSERT INTO pluginversion VALUES (10089, 'Atlassian JIRA - Plugins - Share Content Component', 'com.atlassian.jira.jira-share-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:16.064+10');
INSERT INTO pluginversion VALUES (10090, 'Atlassian Remote Event Common Plugin', 'com.atlassian.plugins.atlassian-remote-event-common-plugin', '1.0.5', '2015-08-03 13:29:16.086+10');
INSERT INTO pluginversion VALUES (10091, 'Atlassian JIRA - Plugins - Transition Trigger Plugin', 'com.atlassian.jira.plugins.jira-transition-triggers-plugin', '3.1.4', '2015-08-03 13:29:16.117+10');
INSERT INTO pluginversion VALUES (10092, 'Streams API', 'com.atlassian.streams.streams-api-6.0.5', '6.0.5', '2015-08-03 13:29:16.124+10');
INSERT INTO pluginversion VALUES (10093, 'JIRA DVCS Connector Plugin', 'com.atlassian.jira.plugins.jira-bitbucket-connector-plugin', '3.3.6', '2015-08-03 13:29:16.179+10');
INSERT INTO pluginversion VALUES (10094, 'Atlassian JIRA - Plugins - Development Integration Plugin', 'com.atlassian.jira.plugins.jira-development-integration-plugin', '3.3.2', '2015-08-03 13:29:16.301+10');
INSERT INTO pluginversion VALUES (10095, 'JIRA Bamboo Plugin', 'com.atlassian.jira.plugin.ext.bamboo', '7.3.26', '2015-08-03 13:29:16.351+10');
INSERT INTO pluginversion VALUES (10096, 'FishEye Plugin', 'com.atlassian.jirafisheyeplugin', '7.0.8', '2015-08-03 13:29:16.431+10');
INSERT INTO pluginversion VALUES (10097, 'JIRA Software Application', 'com.atlassian.jira.jira-software-application', '7.0-m001', '2015-08-03 13:29:16.438+10');
INSERT INTO pluginversion VALUES (10098, 'Atlassian JIRA - Plugins - Closure Template Renderer', 'com.atlassian.jira.jira-soy-plugin', '7.0.0-SNAPSHOT', '2015-08-03 13:29:16.445+10');
INSERT INTO pluginversion VALUES (10099, 'JIRA Time Zone Detection plugin', 'com.atlassian.jira.jira-tzdetect-plugin', '2.2', '2015-08-03 13:29:16.473+10');
INSERT INTO pluginversion VALUES (10100, 'Atlassian JIRA - Plugins - User Profile Plugin', 'com.atlassian.jira.jira-user-profile-plugin', '3.0.3', '2015-08-03 13:29:16.487+10');
INSERT INTO pluginversion VALUES (10101, 'Atlassian JIRA - Plugins - Look And Feel Logo Upload Plugin', 'com.atlassian.jira.lookandfeel', '7.0.0-SNAPSHOT', '2015-08-03 13:29:16.511+10');
INSERT INTO pluginversion VALUES (10102, 'JIRA Mobile', 'com.atlassian.jira.mobile', '3.0.3', '2015-08-03 13:29:16.536+10');
INSERT INTO pluginversion VALUES (10103, 'Atlassian JIRA - Plugins - OAuth Service Provider SPI', 'com.atlassian.jira.oauth.serviceprovider', '7.0.0-SNAPSHOT', '2015-08-03 13:29:16.537+10');
INSERT INTO pluginversion VALUES (10104, 'Comment Panel Plugin', 'com.atlassian.jira.plugin.system.comment-panel', '1.0', '2015-08-03 13:29:16.539+10');
INSERT INTO pluginversion VALUES (10105, 'Custom Field Types & Searchers', 'com.atlassian.jira.plugin.system.customfieldtypes', '1.0', '2015-08-03 13:29:16.541+10');
INSERT INTO pluginversion VALUES (10106, 'Issue Operations Plugin', 'com.atlassian.jira.plugin.system.issueoperations', '1.0', '2015-08-03 13:29:16.546+10');
INSERT INTO pluginversion VALUES (10107, 'Issue Tab Panels Plugin', 'com.atlassian.jira.plugin.system.issuetabpanels', '1.0', '2015-08-03 13:29:16.548+10');
INSERT INTO pluginversion VALUES (10108, 'Renderer Plugin', 'com.atlassian.jira.plugin.system.jirarenderers', '1.0', '2015-08-03 13:29:16.549+10');
INSERT INTO pluginversion VALUES (10109, 'Project Role Actors Plugin', 'com.atlassian.jira.plugin.system.projectroleactors', '1.0', '2015-08-03 13:29:16.551+10');
INSERT INTO pluginversion VALUES (10110, 'Wiki Renderer Macros Plugin', 'com.atlassian.jira.plugin.system.renderers.wiki.macros', '1.0', '2015-08-03 13:29:16.61+10');
INSERT INTO pluginversion VALUES (10111, 'Reports Plugin', 'com.atlassian.jira.plugin.system.reports', '1.0', '2015-08-03 13:29:16.612+10');
INSERT INTO pluginversion VALUES (10112, 'Workflow Plugin', 'com.atlassian.jira.plugin.system.workflow', '1.0', '2015-08-03 13:29:16.614+10');
INSERT INTO pluginversion VALUES (10113, 'JIRA Workflow Transition Tabs', 'com.atlassian.jira.plugin.system.workfloweditor.transition.tabs', '1.0', '2015-08-03 13:29:16.616+10');
INSERT INTO pluginversion VALUES (10114, 'Content Link Resolvers Plugin', 'com.atlassian.jira.plugin.wiki.contentlinkresolvers', '1.0', '2015-08-03 13:29:16.617+10');
INSERT INTO pluginversion VALUES (10115, 'Renderer Component Factories Plugin', 'com.atlassian.jira.plugin.wiki.renderercomponentfactories', '1.0', '2015-08-03 13:29:16.619+10');
INSERT INTO pluginversion VALUES (10116, 'Atlassian JIRA - Admin Helper Plugin', 'com.atlassian.jira.plugins.jira-admin-helper-plugin', '3.0.4', '2015-08-03 13:29:16.655+10');
INSERT INTO pluginversion VALUES (10117, 'JIRA Auditing Plugin', 'com.atlassian.jira.plugins.jira-auditing-plugin', '1.6.14', '2015-08-03 13:29:16.68+10');
INSERT INTO pluginversion VALUES (10118, 'JIRA browser metrics integration plugin', 'com.atlassian.jira.plugins.jira-browser-metrics', '1.3.0', '2015-08-03 13:29:16.683+10');
INSERT INTO pluginversion VALUES (10119, 'JIRA Drag and Drop Attachment Plugin', 'com.atlassian.jira.plugins.jira-dnd-attachment-plugin', '4.0.4', '2015-08-03 13:29:16.711+10');
INSERT INTO pluginversion VALUES (10120, 'Support Healthcheck Plugin', 'com.atlassian.support.healthcheck.support-healthcheck-plugin', '1.0.2', '2015-08-03 13:29:16.731+10');
INSERT INTO pluginversion VALUES (10121, 'Atlassian JIRA - Plugins - Healthcheck Plugin', 'com.atlassian.jira.plugins.jira-healthcheck-plugin', '2.0.2', '2015-08-03 13:29:16.736+10');
INSERT INTO pluginversion VALUES (10122, 'Asana Importers Plugin for JIM', 'com.atlassian.jira.plugins.jira-importers-asana-plugin', '1.0.1', '2015-08-03 13:29:16.738+10');
INSERT INTO pluginversion VALUES (10123, 'Bitbucket Importer Plugin for JIM', 'com.atlassian.jira.plugins.jira-importers-bitbucket-plugin', '1.0.13', '2015-08-03 13:29:16.759+10');
INSERT INTO pluginversion VALUES (10124, 'JIRA GitHub Issue Importer', 'com.atlassian.jira.plugins.jira-importers-github-plugin', '2.0.8', '2015-08-03 13:29:16.786+10');
INSERT INTO pluginversion VALUES (10125, 'Redmine Importers Plugin for JIM', 'com.atlassian.jira.plugins.jira-importers-redmine-plugin', '2.1.2', '2015-08-03 13:29:16.788+10');
INSERT INTO pluginversion VALUES (10126, 'JIRA Password Policy Plugin', 'com.atlassian.jira.plugins.jira-password-policy-plugin', '2.0.2', '2015-08-03 13:29:16.792+10');
INSERT INTO pluginversion VALUES (10127, 'wiki-editor', 'com.atlassian.jira.plugins.jira-wiki-editor', '1.6', '2015-08-03 13:29:16.794+10');
INSERT INTO pluginversion VALUES (10128, 'Atlassian WebHooks Plugin', 'com.atlassian.webhooks.atlassian-webhooks-plugin', '3.0.0', '2015-08-03 13:29:16.819+10');
INSERT INTO pluginversion VALUES (10129, 'JIRA WebHooks Plugin', 'com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin', '2.0.5', '2015-08-03 13:29:16.874+10');
INSERT INTO pluginversion VALUES (10130, 'Wallboard Plugin', 'com.atlassian.jirawallboard.atlassian-wallboard-plugin', '2.1.2', '2015-08-03 13:29:16.88+10');
INSERT INTO pluginversion VALUES (10131, 'Atlassian JWT Plugin', 'com.atlassian.jwt.jwt-plugin', '1.2.2', '2015-08-03 13:29:16.887+10');
INSERT INTO pluginversion VALUES (10132, 'Atlassian Bot Session Killer', 'com.atlassian.labs.atlassian-bot-killer', '1.7.9', '2015-08-03 13:29:16.895+10');
INSERT INTO pluginversion VALUES (10133, 'Atlassian Hipchat Integration Plugin Core', 'com.atlassian.plugins.base-hipchat-integration-plugin-api', '6.29.1', '2015-08-03 13:29:16.908+10');
INSERT INTO pluginversion VALUES (10151, 'jira-help-tips', 'com.atlassian.plugins.helptips.jira-help-tips', '1.0.3', '2015-08-03 13:29:17.24+10');
INSERT INTO pluginversion VALUES (10152, 'Issue Status Plugin', 'com.atlassian.plugins.issue-status-plugin', '1.1.7', '2015-08-03 13:29:17.241+10');
INSERT INTO pluginversion VALUES (10153, 'Attach Image for JIRA', 'com.atlassian.plugins.jira-html5-attach-images', '3.0.3', '2015-08-03 13:29:17.247+10');
INSERT INTO pluginversion VALUES (10154, 'Project Creation Plugin SPI for JIRA', 'com.atlassian.plugins.jira-project-creation', '2.0.2', '2015-08-03 13:29:17.248+10');
INSERT INTO pluginversion VALUES (10158, 'Pocketknife Feature Flags Plugin', 'com.atlassian.pocketknife.featureflags-plugin', '0.5.1', '2015-08-03 13:29:17.286+10');
INSERT INTO pluginversion VALUES (10159, 'Atlassian Pretty URLs Plugin', 'com.atlassian.prettyurls.atlassian-pretty-urls-plugin', '2.0.0', '2015-08-03 13:29:17.29+10');
INSERT INTO pluginversion VALUES (10160, 'Atlassian QUnit Plugin', 'com.atlassian.qunit.atlassian-qunit-plugin', '1.0.0-m5', '2015-08-03 13:29:17.292+10');
INSERT INTO pluginversion VALUES (10161, 'Atlassian JIRA - Plugins - SAL Plugin', 'com.atlassian.sal.jira', '7.0.0-SNAPSHOT', '2015-08-03 13:29:17.297+10');
INSERT INTO pluginversion VALUES (10162, 'scala-2.11-provider-plugin', 'com.atlassian.scala.plugins.scala-2.11-provider-plugin', '0.10', '2015-08-03 13:29:17.298+10');
INSERT INTO pluginversion VALUES (10163, 'Atlassian Soy - Plugin', 'com.atlassian.soy.soy-template-plugin', '4.0.5-m1-jira-1', '2015-08-03 13:29:17.307+10');
INSERT INTO pluginversion VALUES (10164, 'Streams Plugin', 'com.atlassian.streams', '6.0.5', '2015-08-03 13:29:17.338+10');
INSERT INTO pluginversion VALUES (10165, 'Streams Inline Actions Plugin', 'com.atlassian.streams.actions', '6.0.5', '2015-08-03 13:29:17.34+10');
INSERT INTO pluginversion VALUES (10166, 'Streams Core Plugin', 'com.atlassian.streams.core', '6.0.5', '2015-08-03 13:29:17.343+10');
INSERT INTO pluginversion VALUES (10167, 'JIRA Streams Inline Actions Plugin', 'com.atlassian.streams.jira.inlineactions', '6.0.5', '2015-08-03 13:29:17.345+10');
INSERT INTO pluginversion VALUES (10168, 'JIRA Activity Stream Plugin', 'com.atlassian.streams.streams-jira-plugin', '6.0.5', '2015-08-03 13:29:17.383+10');
INSERT INTO pluginversion VALUES (10169, 'Streams Third Party Provider Plugin', 'com.atlassian.streams.streams-thirdparty-plugin', '6.0.5', '2015-08-03 13:29:17.408+10');
INSERT INTO pluginversion VALUES (10170, 'Support Tools Plugin', 'com.atlassian.support.stp', '3.5.34', '2015-08-03 13:29:17.45+10');
INSERT INTO pluginversion VALUES (10171, 'Atlassian Application Manager plugin', 'com.atlassian.upm.upm-application-plugin', '2.19-rc7', '2015-08-03 13:29:17.475+10');
INSERT INTO pluginversion VALUES (10172, 'ROME: RSS/Atom syndication and publishing tools', 'com.springsource.com.sun.syndication-0.9.0', '0.9.0', '2015-08-03 13:29:17.477+10');
INSERT INTO pluginversion VALUES (10173, 'JDOM DOM Processor', 'com.springsource.org.jdom-1.0.0', '1.0.0', '2015-08-03 13:29:17.478+10');
INSERT INTO pluginversion VALUES (10174, 'Crowd REST API', 'crowd-rest-application-management', '1.0', '2015-08-03 13:29:17.518+10');
INSERT INTO pluginversion VALUES (10175, 'Crowd REST API', 'crowd-rest-plugin', '1.0', '2015-08-03 13:29:17.546+10');
INSERT INTO pluginversion VALUES (10176, 'Crowd System Password Encoders', 'crowd.system.passwordencoders', '1.0', '2015-08-03 13:29:17.549+10');
INSERT INTO pluginversion VALUES (10177, 'JIRA Footer', 'jira.footer', '1.0', '2015-08-03 13:29:17.55+10');
INSERT INTO pluginversion VALUES (10178, 'Help Paths Plugin', 'jira.help.paths', '1.0', '2015-08-03 13:29:17.552+10');
INSERT INTO pluginversion VALUES (10179, 'Issue Views Plugin', 'jira.issueviews', '1.0', '2015-08-03 13:29:17.553+10');
INSERT INTO pluginversion VALUES (10180, 'JQL Functions', 'jira.jql.function', '1.0', '2015-08-03 13:29:17.556+10');
INSERT INTO pluginversion VALUES (10181, 'Keyboard Shortcuts Plugin', 'jira.keyboard.shortcuts', '1.0', '2015-08-03 13:29:17.558+10');
INSERT INTO pluginversion VALUES (10182, 'JIRA Attachment Archive File Processors', 'jira.system.attachment.processors', '1.0', '2015-08-03 13:29:17.559+10');
INSERT INTO pluginversion VALUES (10183, 'JIRA Global Permissions', 'jira.system.global.permissions', '1.0', '2015-08-03 13:29:17.561+10');
INSERT INTO pluginversion VALUES (10184, 'JIRA Project Permissions', 'jira.system.project.permissions', '1.0', '2015-08-03 13:29:17.563+10');
INSERT INTO pluginversion VALUES (10185, 'Top Navigation Bar', 'jira.top.navigation.bar', '1.0', '2015-08-03 13:29:17.566+10');
INSERT INTO pluginversion VALUES (10186, 'JIRA Usage Hints', 'jira.usage.hints', '1.0', '2015-08-03 13:29:17.568+10');
INSERT INTO pluginversion VALUES (10187, 'User Format', 'jira.user.format', '1.0', '2015-08-03 13:29:17.57+10');
INSERT INTO pluginversion VALUES (10188, 'User Profile Panels', 'jira.user.profile.panels', '1.0', '2015-08-03 13:29:17.571+10');
INSERT INTO pluginversion VALUES (10189, 'Admin Menu Sections', 'jira.webfragments.admin', '1.0', '2015-08-03 13:29:17.587+10');
INSERT INTO pluginversion VALUES (10190, 'Browse Project Operations Sections', 'jira.webfragments.browse.project.links', '1.0', '2015-08-03 13:29:17.588+10');
INSERT INTO pluginversion VALUES (10191, 'Preset Filters Sections', 'jira.webfragments.preset.filters', '1.0', '2015-08-03 13:29:17.59+10');
INSERT INTO pluginversion VALUES (10192, 'User Navigation Bar Sections', 'jira.webfragments.user.navigation.bar', '1.0', '2015-08-03 13:29:17.592+10');
INSERT INTO pluginversion VALUES (10193, 'User Profile Links', 'jira.webfragments.user.profile.links', '1.0', '2015-08-03 13:29:17.593+10');
INSERT INTO pluginversion VALUES (10194, 'View Project Operations Sections', 'jira.webfragments.view.project.operations', '1.0', '2015-08-03 13:29:17.595+10');
INSERT INTO pluginversion VALUES (10195, 'Web Panel Plugin', 'jira.webpanels', '1.0', '2015-08-03 13:29:17.597+10');
INSERT INTO pluginversion VALUES (10196, 'Web Resources Plugin', 'jira.webresources', '1.0', '2015-08-03 13:29:17.602+10');
INSERT INTO pluginversion VALUES (10197, 'Apache Felix Web Management Console', 'org.apache.felix.webconsole-1.2.8', '1.2.8', '2015-08-03 13:29:17.604+10');
INSERT INTO pluginversion VALUES (10198, 'Apache HttpClient OSGi bundle', 'org.apache.httpcomponents.httpclient-4.2.5', '4.2.5', '2015-08-03 13:29:17.605+10');
INSERT INTO pluginversion VALUES (10199, 'Apache HttpCore OSGi bundle', 'org.apache.httpcomponents.httpcore-4.2.4', '4.2.4', '2015-08-03 13:29:17.607+10');
INSERT INTO pluginversion VALUES (10200, 'JIRA German (Germany) Language Pack', 'tac.jira.languages.de_DE', '6.4.6-v2r11248-2015-06-10', '2015-08-03 13:29:17.608+10');
INSERT INTO pluginversion VALUES (10201, 'JIRA Spanish (Spain) Language Pack', 'tac.jira.languages.es_ES', '6.4.6-v2r18310-2015-06-09', '2015-08-03 13:29:17.611+10');
INSERT INTO pluginversion VALUES (10202, 'JIRA French (France) Language Pack', 'tac.jira.languages.fr_FR', '6.4.6-v2r6814-2015-06-09', '2015-08-03 13:29:17.612+10');
INSERT INTO pluginversion VALUES (10203, 'JIRA Japanese (Japan) Language Pack', 'tac.jira.languages.ja_JP', '6.4.6-v2r21390-2015-06-09', '2015-08-03 13:29:17.614+10');
INSERT INTO pluginversion VALUES (10204, 'Atlassian Connect - Plugin', 'com.atlassian.plugins.atlassian-connect-plugin', '1.1.8', '2015-08-03 13:29:17.632+10');
INSERT INTO pluginversion VALUES (10205, 'Quick Reload - Stealing time back from Maven since 2013. Just press up arrow!', 'com.atlassian.labs.plugins.quickreload.reloader', '1.3', '2015-08-03 13:29:17.634+10');
INSERT INTO pluginversion VALUES (10134, 'Atlassian Hipchat Integration Plugin', 'com.atlassian.plugins.base-hipchat-integration-plugin', '6.29.1', '2015-08-03 13:29:16.963+10');
INSERT INTO pluginversion VALUES (10135, 'Project Creation Capability Product REST Plugin', 'com.atlassian.plugins.atlassian-project-creation-plugin', '2.0.2', '2015-08-03 13:29:17.006+10');
INSERT INTO pluginversion VALUES (10136, 'HipChat for JIRA', 'com.atlassian.labs.hipchat.hipchat-for-jira-plugin', '6.29.1', '2015-08-03 13:29:17.084+10');
INSERT INTO pluginversion VALUES (10137, 'httpservice-bridge', 'com.atlassian.labs.httpservice.bridge-0.6.2', '0.6.2', '2015-08-03 13:29:17.085+10');
INSERT INTO pluginversion VALUES (10138, 'Atlassian OAuth Admin Plugin', 'com.atlassian.oauth.admin', '2.0.1-f748404', '2015-08-03 13:29:17.087+10');
INSERT INTO pluginversion VALUES (10139, 'Atlassian OAuth Consumer Plugin', 'com.atlassian.oauth.consumer', '2.0.1-f748404', '2015-08-03 13:29:17.088+10');
INSERT INTO pluginversion VALUES (10140, 'Atlassian OAuth Service Provider Plugin', 'com.atlassian.oauth.serviceprovider', '2.0.1-f748404', '2015-08-03 13:29:17.093+10');
INSERT INTO pluginversion VALUES (10141, 'Apache Commons FileUpload Bundle', 'org.apache.commons.fileupload-1.2.1', '1.2.1', '2015-08-03 13:29:17.095+10');
INSERT INTO pluginversion VALUES (10142, 'Atlassian PDK Install Plugin', 'com.atlassian.pdkinstall', '0.6', '2015-08-03 13:29:17.097+10');
INSERT INTO pluginversion VALUES (10143, 'Atlassian Plugins - JavaScript libraries', 'com.atlassian.plugin.jslibs', '0.5.0', '2015-08-03 13:29:17.104+10');
INSERT INTO pluginversion VALUES (10144, 'Atlassian Awareness Capability', 'com.atlassian.plugins.atlassian-awareness-capability', '0.0.6', '2015-08-03 13:29:17.135+10');
INSERT INTO pluginversion VALUES (10145, 'Atlassian Plugins - Web Resources - Implementation Plugin', 'com.atlassian.plugins.atlassian-plugins-webresource-plugin', '3.3.1', '2015-08-03 13:29:17.137+10');
INSERT INTO pluginversion VALUES (10146, 'Atlassian Plugins - Web Resources REST', 'com.atlassian.plugins.atlassian-plugins-webresource-rest', '3.3.1', '2015-08-03 13:29:17.165+10');
INSERT INTO pluginversion VALUES (10147, 'Atlassian Remote Event Consumer Plugin', 'com.atlassian.plugins.atlassian-remote-event-consumer-plugin', '1.0.5', '2015-08-03 13:29:17.191+10');
INSERT INTO pluginversion VALUES (10148, 'Atlassian Whitelist UI Plugin', 'com.atlassian.plugins.atlassian-whitelist-ui-plugin', '1.13', '2015-08-03 13:29:17.212+10');
INSERT INTO pluginversion VALUES (10149, 'Atlassian Plugins - Avatar Plugin', 'com.atlassian.plugins.avatar', '1.3.2', '2015-08-03 13:29:17.213+10');
INSERT INTO pluginversion VALUES (10150, 'Atlassian browser metrics plugin', 'com.atlassian.plugins.browser.metrics.browser-metrics-plugin', '1.64', '2015-08-03 13:29:17.215+10');
INSERT INTO pluginversion VALUES (10155, 'JIRA Remote Link Aggregator Plugin', 'com.atlassian.plugins.jira-remote-link-aggregator-plugin', '2.0.14', '2015-08-03 13:29:17.25+10');
INSERT INTO pluginversion VALUES (10156, 'jquery', 'com.atlassian.plugins.jquery', '1.7.2', '2015-08-03 13:29:17.251+10');
INSERT INTO pluginversion VALUES (10157, 'plugin-data-editor', 'com.atlassian.plugins.plugin-data-editor', '1.2', '2015-08-03 13:29:17.28+10');


--
-- Data for Name: portalpage; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO portalpage VALUES (10000, NULL, 'System Dashboard', NULL, 0, 0, 'AA', 0);


--
-- Data for Name: portletconfiguration; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO portletconfiguration VALUES (10000, 10000, NULL, 0, 0, NULL, NULL, 'com.atlassian.jira.gadgets:introduction-dashboard-item');
INSERT INTO portletconfiguration VALUES (10002, 10000, NULL, 1, 0, 'rest/gadgets/1.0/g/com.atlassian.jira.gadgets:assigned-to-me-gadget/gadgets/assigned-to-me-gadget.xml', NULL, NULL);
INSERT INTO portletconfiguration VALUES (10003, 10000, NULL, 1, 1, 'rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml', NULL, NULL);


--
-- Data for Name: priority; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO priority VALUES ('1', 1, 'Highest', 'This problem will block progress.', '/images/icons/priorities/highest.png', '#d04437');
INSERT INTO priority VALUES ('2', 2, 'High', 'Serious problem that could block progress.', '/images/icons/priorities/high.png', '#f15C75');
INSERT INTO priority VALUES ('3', 3, 'Medium', 'Has the potential to affect progress.', '/images/icons/priorities/medium.png', '#f79232');
INSERT INTO priority VALUES ('4', 4, 'Low', 'Minor problem or easily worked around.', '/images/icons/priorities/low.png', '#707070');
INSERT INTO priority VALUES ('5', 5, 'Lowest', 'Trivial problem with little or no impact on progress.', '/images/icons/priorities/lowest.png', '#999999');


--
-- Data for Name: productlicense; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO productlicense VALUES (10000, 'AAAB5g0ODAoPeNqVlFFvmzAUhd/9K5D2DMIkWddKSE0TplUqSZRk2/MNXBJXxka2aZp/P8coHRTRtBI8AMf33vP5mG9/MfdSOHlR6NHvd+HkbkS9ZLO1z3RCnpmCoFIyrzMTnB/8TCoMprWRaxR4jI2qkTyxDIXG7anCBZQYz5Zpmqxnj9MnskkWsb19GobhRZe8Vkyd5mAwrgVnJTOYD3WCzLAXbNqA4aA1AxFkCsFIFavSvgAmObtvfZRlS2pQGyb2TQXXpF2y31XLwhzBdn5gnNuFK1RM5jGNyF4hioOsKlSBqMtfUtu5f2tUOh6PyKpW2QE65s4E/XDiR5Qs6nKHalk0cp+SOepMscowKeLpZVhvKeZYgsgJb0j9seqzIiLJC/AanLwArrEzzYVrzpwgWWyT9Wr9uEmGqPa8fcChbzUFJgwKEFnX7Y+xcxt2Zuu1mp33zo7ZRWTDAdqkMmcFQ6sbjyIa0tsRvZlQIkXusFzdsy5mO2p7kneh/aDMFZ59IjMpjI1VYsnwuJByB+oeX6GsOLo4umWfgO42p2ciU/KY92P7lV1/s9ar8o7KUu1BMN0kzRzQmiGbevc/rE7VxvrJ43SVvvM+fK5cXOjtTeiH1F4X5O5/81NK7wHUUNFhUP8AGGPJMjAsAhR1vWjAn9gPYhfZ2FJuNQBKf5xBdgIUAslLwkBw+a50Uox9mXwmVmHt+lU=X02n3');


--
-- Data for Name: project; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: project_key; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: projectcategory; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: projectrole; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO projectrole VALUES (10002, 'Administrators', 'A project role that represents administrators in a project');


--
-- Data for Name: projectroleactor; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO projectroleactor VALUES (10002, NULL, 10002, 'atlassian-group-role-actor', 'jira-administrators');


--
-- Data for Name: projectversion; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: propertydata; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: propertydate; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO propertydate VALUES (10239, '2015-08-03 13:30:06.014+10');


--
-- Data for Name: propertydecimal; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: propertyentry; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO propertyentry VALUES (1, 'jira.properties', 1, 'jira.version.patched', 5);
INSERT INTO propertyentry VALUES (3, 'jira.properties', 1, 'jira.avatar.default.id', 5);
INSERT INTO propertyentry VALUES (5, 'jira.properties', 1, 'jira.avatar.user.default.id', 5);
INSERT INTO propertyentry VALUES (6, 'jira.properties', 1, 'jira.avatar.user.anonymous.id', 5);
INSERT INTO propertyentry VALUES (7, 'jira.properties', 1, 'jira.scheme.default.issue.type', 5);
INSERT INTO propertyentry VALUES (9, 'jira.properties', 1, 'jira.whitelist.disabled', 1);
INSERT INTO propertyentry VALUES (10, 'jira.properties', 1, 'jira.whitelist.rules', 6);
INSERT INTO propertyentry VALUES (11, 'jira.properties', 1, 'jira.option.timetracking', 1);
INSERT INTO propertyentry VALUES (12, 'jira.properties', 1, 'jira.timetracking.estimates.legacy.behaviour', 1);
INSERT INTO propertyentry VALUES (13, 'jira.properties', 1, 'jira.version', 5);
INSERT INTO propertyentry VALUES (14, 'jira.properties', 1, 'jira.downgrade.minimum.version', 5);
INSERT INTO propertyentry VALUES (15, 'jira.properties', 1, 'jira.option.allowunassigned', 1);
INSERT INTO propertyentry VALUES (16, 'jira.properties', 1, 'jira.path.index.use.default.directory', 1);
INSERT INTO propertyentry VALUES (21, 'com.atlassian.jira.plugins.jira-workflow-designer', 1, 'jira.workflow.layout:8a6044147cf2c19c02d099279cfbfd47', 6);
INSERT INTO propertyentry VALUES (22, 'jira.properties', 1, 'jira.onboarding.app_user.id.threshold', 5);
INSERT INTO propertyentry VALUES (10101, 'jira.properties', 1, 'jira.webresource.superbatch.flushcounter', 5);
INSERT INTO propertyentry VALUES (10102, 'jira.properties', 1, 'jira.i18n.language.index', 5);
INSERT INTO propertyentry VALUES (10103, 'jira.properties', 1, 'jira.sid.key', 5);
INSERT INTO propertyentry VALUES (10106, 'jira.properties', 1, 'jira.avatar.issuetype.default.id', 5);
INSERT INTO propertyentry VALUES (10107, 'jira.properties', 1, 'jira.avatar.issuetype.subtask.default.id', 5);
INSERT INTO propertyentry VALUES (10109, 'jira.properties', 1, 'jira.webresource.flushcounter', 5);
INSERT INTO propertyentry VALUES (10112, 'vp.properties', 1, 'com.atlassian.servicedesk.renaissance.migration.type', 5);
INSERT INTO propertyentry VALUES (10113, 'jira.properties', 1, 'renaissanceMigrationDone', 1);
INSERT INTO propertyentry VALUES (10200, 'jira.properties', 1, 'jira.i18n.default.locale', 5);
INSERT INTO propertyentry VALUES (10201, 'jira.properties', 1, 'webwork.i18n.encoding', 5);
INSERT INTO propertyentry VALUES (10202, 'jira.properties', 1, 'jira.title', 5);
INSERT INTO propertyentry VALUES (10206, 'jira.properties', 1, 'dvcs.connector.bitbucket.url', 5);
INSERT INTO propertyentry VALUES (10207, 'jira.properties', 1, 'dvcs.connector.github.url', 5);
INSERT INTO propertyentry VALUES (10211, 'jira.properties', 1, 'AO_E8B6CC_#', 5);
INSERT INTO propertyentry VALUES (10212, 'jira.properties', 1, 'AO_4AEACD_#', 5);
INSERT INTO propertyentry VALUES (10213, 'jira.properties', 1, 'AO_550953_#', 5);
INSERT INTO propertyentry VALUES (10214, 'jira.properties', 1, 'jira.baseurl', 5);
INSERT INTO propertyentry VALUES (10215, 'jira.properties', 1, 'jira.mode', 5);
INSERT INTO propertyentry VALUES (10216, 'jira.properties', 1, 'jira.path.attachments', 5);
INSERT INTO propertyentry VALUES (10217, 'jira.properties', 1, 'jira.path.attachments.use.default.directory', 1);
INSERT INTO propertyentry VALUES (10218, 'jira.properties', 1, 'jira.option.allowattachments', 1);
INSERT INTO propertyentry VALUES (10219, 'ServiceConfig', 10001, 'USE_DEFAULT_DIRECTORY', 5);
INSERT INTO propertyentry VALUES (10220, 'jira.properties', 1, 'jira.path.backup', 5);
INSERT INTO propertyentry VALUES (10221, 'jira.properties', 1, 'org.apache.shindig.common.crypto.BlobCrypter:key', 5);
INSERT INTO propertyentry VALUES (10222, 'BambooServerProperties', 1, 'bamboo.config.version', 2);
INSERT INTO propertyentry VALUES (10223, 'GreenHopper.Run.History', 1, 'lastRunVersion', 6);
INSERT INTO propertyentry VALUES (10224, 'GreenHopper.Run.History', 2, '2015-08-03T13:29:10.873+10:00', 6);
INSERT INTO propertyentry VALUES (10225, 'jira.properties', 1, 'com.atlassian.jira.util.index.IndexingCounterManagerImpl.counterValue', 3);
INSERT INTO propertyentry VALUES (10226, 'jira.properties', 1, 'jira.setup', 5);
INSERT INTO propertyentry VALUES (10227, 'jira.properties', 1, 'jira.option.user.externalmanagement', 1);
INSERT INTO propertyentry VALUES (10228, 'jira.properties', 1, 'jira.option.voting', 1);
INSERT INTO propertyentry VALUES (10229, 'jira.properties', 1, 'jira.option.watching', 1);
INSERT INTO propertyentry VALUES (10230, 'jira.properties', 1, 'jira.option.issuelinking', 1);
INSERT INTO propertyentry VALUES (10231, 'jira.properties', 1, 'jira.option.emailvisible', 5);
INSERT INTO propertyentry VALUES (10232, 'jira.properties', 1, 'jira.option.allowsubtasks', 1);
INSERT INTO propertyentry VALUES (10233, 'fisheye-jira-plugin.properties', 1, 'FISH-375-fixed', 5);
INSERT INTO propertyentry VALUES (10234, 'fisheye-jira-plugin.properties', 1, 'fisheye.ual.migration.complete', 5);
INSERT INTO propertyentry VALUES (10235, 'fisheye-jira-plugin.properties', 1, 'fisheye.ual.crucible.enabled.property.fix.complete', 5);
INSERT INTO propertyentry VALUES (10236, 'GreenHopper.properties', 1, 'GreenHopper.LexoRank.Default.customfield.id', 3);
INSERT INTO propertyentry VALUES (10237, 'GreenHopper.properties', 1, 'GreenHopper.EpicLink.Default.customfield.id', 3);
INSERT INTO propertyentry VALUES (10238, 'admin.message.manager', 1, 'user', 5);
INSERT INTO propertyentry VALUES (10239, 'admin.message.manager', 1, 'time', 7);
INSERT INTO propertyentry VALUES (10240, 'com.atlassian.jira.user.flag.FlagDismissalServiceImpl', 1, 'com.atlassian.jira.flag.resets', 6);
INSERT INTO propertyentry VALUES (10241, 'admin.message.manager', 1, 'task', 5);
INSERT INTO propertyentry VALUES (10242, 'GreenHopper.properties', 1, 'GreenHopper.EpicStatus.Default.customfield.id', 3);
INSERT INTO propertyentry VALUES (10243, 'GreenHopper.properties', 1, 'GreenHopper.EpicLabel.Default.customfield.id', 3);
INSERT INTO propertyentry VALUES (10244, 'GreenHopper.properties', 1, 'GreenHopper.EpicColor.Default.customfield.id', 3);
INSERT INTO propertyentry VALUES (10245, 'GreenHopper.properties', 1, 'GreenHopper.Sprint.Default.customfield.id', 3);
INSERT INTO propertyentry VALUES (10246, 'GreenHopper.properties', 1, 'GreenHopper.Sprint.Index.Check.Necessary', 5);
INSERT INTO propertyentry VALUES (10247, 'GreenHopper.properties', 1, 'GreenHopper.JIRA60.Version.Migration', 1);
INSERT INTO propertyentry VALUES (10248, 'GreenHopper', 1, 'SCRUM_DEFAULT_TEMPLATE_CONFIGURATION', 6);
INSERT INTO propertyentry VALUES (10249, 'GreenHopper.properties', 1, 'GreenHopper.Epic.Default.linktype.id', 3);
INSERT INTO propertyentry VALUES (10250, 'jira.properties', 1, 'com.atlassian.streams.InlineActivityStream:loaded.from.jira.projects', 5);
INSERT INTO propertyentry VALUES (10256, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-plugin.request', 5);
INSERT INTO propertyentry VALUES (10260, 'jira.properties', 1, 'com.atlassian.sal.jira:build', 5);
INSERT INTO propertyentry VALUES (10262, 'jira.properties', 1, 'com.atlassian.plugins.atlassian-whitelist-api-plugin:whitelist.enabled', 5);
INSERT INTO propertyentry VALUES (10263, 'jira.properties', 1, 'com.atlassian.plugins.atlassian-whitelist-api-plugin:build', 5);
INSERT INTO propertyentry VALUES (10264, 'jira.properties', 1, 'com.atlassian.jira.gadgets:build', 5);
INSERT INTO propertyentry VALUES (10320, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.912+10:00', 6);
INSERT INTO propertyentry VALUES (10322, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.940+10:00', 6);
INSERT INTO propertyentry VALUES (10323, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.956+10:00', 6);
INSERT INTO propertyentry VALUES (10325, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.967+10:00', 6);
INSERT INTO propertyentry VALUES (10326, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.976+10:00', 6);
INSERT INTO propertyentry VALUES (10265, 'jira.properties', 1, 'com.atlassian.jira.plugins.jira-bitbucket-connector-plugin:build', 5);
INSERT INTO propertyentry VALUES (10274, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.051+10:00', 6);
INSERT INTO propertyentry VALUES (10275, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.054+10:00', 6);
INSERT INTO propertyentry VALUES (10276, 'GreenHopper.properties', 1, 'GreenHopper.Upgrade.Latest.Upgraded.Version', 3);
INSERT INTO propertyentry VALUES (10278, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.065+10:00', 6);
INSERT INTO propertyentry VALUES (10284, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.681+10:00', 6);
INSERT INTO propertyentry VALUES (10286, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.698+10:00', 6);
INSERT INTO propertyentry VALUES (10287, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.701+10:00', 6);
INSERT INTO propertyentry VALUES (10289, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.713+10:00', 6);
INSERT INTO propertyentry VALUES (10290, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.718+10:00', 6);
INSERT INTO propertyentry VALUES (10292, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.732+10:00', 6);
INSERT INTO propertyentry VALUES (10293, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.736+10:00', 6);
INSERT INTO propertyentry VALUES (10295, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.746+10:00', 6);
INSERT INTO propertyentry VALUES (10296, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.754+10:00', 6);
INSERT INTO propertyentry VALUES (10298, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.764+10:00', 6);
INSERT INTO propertyentry VALUES (10299, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.767+10:00', 6);
INSERT INTO propertyentry VALUES (10301, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.779+10:00', 6);
INSERT INTO propertyentry VALUES (10302, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.792+10:00', 6);
INSERT INTO propertyentry VALUES (10304, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.801+10:00', 6);
INSERT INTO propertyentry VALUES (10305, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.805+10:00', 6);
INSERT INTO propertyentry VALUES (10307, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.815+10:00', 6);
INSERT INTO propertyentry VALUES (10308, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.819+10:00', 6);
INSERT INTO propertyentry VALUES (10310, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.830+10:00', 6);
INSERT INTO propertyentry VALUES (10311, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.841+10:00', 6);
INSERT INTO propertyentry VALUES (10313, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.851+10:00', 6);
INSERT INTO propertyentry VALUES (10314, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.854+10:00', 6);
INSERT INTO propertyentry VALUES (10316, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.863+10:00', 6);
INSERT INTO propertyentry VALUES (10317, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:05.867+10:00', 6);
INSERT INTO propertyentry VALUES (10319, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.877+10:00', 6);
INSERT INTO propertyentry VALUES (10436, 'jira.properties', 1, 'com.atlassian.analytics.client.configuration..analytics_enabled', 5);
INSERT INTO propertyentry VALUES (10444, 'ApplicationUser', 10000, 'jira.onboarding.first.use.flow.completed', 1);
INSERT INTO propertyentry VALUES (10328, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:05.986+10:00', 6);
INSERT INTO propertyentry VALUES (10329, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.000+10:00', 6);
INSERT INTO propertyentry VALUES (10331, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.010+10:00', 6);
INSERT INTO propertyentry VALUES (10332, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.021+10:00', 6);
INSERT INTO propertyentry VALUES (10334, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.030+10:00', 6);
INSERT INTO propertyentry VALUES (10335, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.034+10:00', 6);
INSERT INTO propertyentry VALUES (10337, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.044+10:00', 6);
INSERT INTO propertyentry VALUES (10338, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.052+10:00', 6);
INSERT INTO propertyentry VALUES (10340, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.062+10:00', 6);
INSERT INTO propertyentry VALUES (10341, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.072+10:00', 6);
INSERT INTO propertyentry VALUES (10343, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.083+10:00', 6);
INSERT INTO propertyentry VALUES (10344, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.339+10:00', 6);
INSERT INTO propertyentry VALUES (10346, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.369+10:00', 6);
INSERT INTO propertyentry VALUES (10347, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.375+10:00', 6);
INSERT INTO propertyentry VALUES (10349, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.385+10:00', 6);
INSERT INTO propertyentry VALUES (10350, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.388+10:00', 6);
INSERT INTO propertyentry VALUES (10352, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.398+10:00', 6);
INSERT INTO propertyentry VALUES (10353, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-edition.mismatch', 5);
INSERT INTO propertyentry VALUES (10354, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-evaluation.expired', 5);
INSERT INTO propertyentry VALUES (10355, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-evaluation.nearlyexpired', 5);
INSERT INTO propertyentry VALUES (10356, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-maintenance.expired', 5);
INSERT INTO propertyentry VALUES (10357, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-maintenance.nearlyexpired', 5);
INSERT INTO propertyentry VALUES (10358, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.946+10:00', 6);
INSERT INTO propertyentry VALUES (10360, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.962+10:00', 6);
INSERT INTO propertyentry VALUES (10361, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.965+10:00', 6);
INSERT INTO propertyentry VALUES (10363, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.976+10:00', 6);
INSERT INTO propertyentry VALUES (10364, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:06.980+10:00', 6);
INSERT INTO propertyentry VALUES (10366, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:06.990+10:00', 6);
INSERT INTO propertyentry VALUES (10367, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.053+10:00', 6);
INSERT INTO propertyentry VALUES (10369, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.063+10:00', 6);
INSERT INTO propertyentry VALUES (10370, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.089+10:00', 6);
INSERT INTO propertyentry VALUES (10372, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.116+10:00', 6);
INSERT INTO propertyentry VALUES (10373, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.119+10:00', 6);
INSERT INTO propertyentry VALUES (10375, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.128+10:00', 6);
INSERT INTO propertyentry VALUES (10376, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.134+10:00', 6);
INSERT INTO propertyentry VALUES (10378, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.144+10:00', 6);
INSERT INTO propertyentry VALUES (10379, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.185+10:00', 6);
INSERT INTO propertyentry VALUES (10381, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.195+10:00', 6);
INSERT INTO propertyentry VALUES (10382, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.218+10:00', 6);
INSERT INTO propertyentry VALUES (10384, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.230+10:00', 6);
INSERT INTO propertyentry VALUES (10385, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.237+10:00', 6);
INSERT INTO propertyentry VALUES (10387, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.247+10:00', 6);
INSERT INTO propertyentry VALUES (10388, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.251+10:00', 6);
INSERT INTO propertyentry VALUES (10390, 'GreenHopper.UpgradeHistory', 1, '2015-08-03T13:30:07.261+10:00', 6);
INSERT INTO propertyentry VALUES (10391, 'GreenHopper.UpgradeHistory', 2, '2015-08-03T13:30:07.265+10:00', 6);
INSERT INTO propertyentry VALUES (10392, 'jira.properties', 1, 'com.pyxis.greenhopper.jira:build', 5);
INSERT INTO propertyentry VALUES (10394, 'jira.properties', 1, 'com.atlassian.crowd.embedded.admin:build', 5);
INSERT INTO propertyentry VALUES (10395, 'jira.properties', 1, 'com.atlassian.labs.hipchat.hipchat-for-jira-plugin:build', 5);
INSERT INTO propertyentry VALUES (10396, 'jira.properties', 1, 'com.atlassian.jira.plugin.ext.bamboo:build', 5);
INSERT INTO propertyentry VALUES (10398, 'jira.properties', 1, 'com.atlassian.jira.jira-mail-plugin:build', 5);
INSERT INTO propertyentry VALUES (10399, 'jira.properties', 1, 'com.atlassian.jira.plugins.jira-workflow-designer:build', 5);
INSERT INTO propertyentry VALUES (10400, 'jira.properties', 1, 'com.atlassian.plugins.custom_apps.hasCustomOrder', 5);
INSERT INTO propertyentry VALUES (10401, 'jira.properties', 1, 'com.atlassian.plugins.atlassian-nav-links-plugin:build', 5);
INSERT INTO propertyentry VALUES (10404, 'jira.properties', 1, 'com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin:build', 5);
INSERT INTO propertyentry VALUES (10405, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:isDefaultFavicon', 5);
INSERT INTO propertyentry VALUES (10406, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:usingCustomFavicon', 5);
INSERT INTO propertyentry VALUES (10407, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:customDefaultFaviconURL', 5);
INSERT INTO propertyentry VALUES (10408, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:customDefaultFaviconHiresURL', 5);
INSERT INTO propertyentry VALUES (10409, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:faviconWidth', 5);
INSERT INTO propertyentry VALUES (10410, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:faviconHeight', 5);
INSERT INTO propertyentry VALUES (10411, 'jira.properties', 1, 'jira.lf.favicon.url', 5);
INSERT INTO propertyentry VALUES (10412, 'jira.properties', 1, 'jira.lf.favicon.hires.url', 5);
INSERT INTO propertyentry VALUES (10413, 'jira.properties', 1, 'com.atlassian.jira.lookandfeel:build', 5);
INSERT INTO propertyentry VALUES (10415, 'jira.properties', 1, 'com.atlassian.upm.log.PluginSettingsAuditLogService:log:upm_audit_log_v3', 5);
INSERT INTO propertyentry VALUES (10417, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-plugin.request', 5);
INSERT INTO propertyentry VALUES (10419, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-evaluation.expired', 5);
INSERT INTO propertyentry VALUES (10420, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-evaluation.nearlyexpired', 5);
INSERT INTO propertyentry VALUES (10421, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-edition.mismatch', 5);
INSERT INTO propertyentry VALUES (10422, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-maintenance.expired', 5);
INSERT INTO propertyentry VALUES (10423, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-maintenance.nearlyexpired', 5);
INSERT INTO propertyentry VALUES (10424, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-new.licenses', 5);
INSERT INTO propertyentry VALUES (10425, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-updated.licenses', 5);
INSERT INTO propertyentry VALUES (10426, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-auto.updated.plugin', 5);
INSERT INTO propertyentry VALUES (10427, 'jira.properties', 1, 'com.atlassian.upm:notifications:dismissal-auto.updated.upm', 5);
INSERT INTO propertyentry VALUES (10428, 'jira.properties', 1, 'com.atlassian.upm.request.PluginSettingsPluginRequestStore:requests:requests_v2', 5);
INSERT INTO propertyentry VALUES (10432, 'jira.properties', 1, 'com.atlassian.upm.atlassian-universal-plugin-manager-plugin:build', 5);
INSERT INTO propertyentry VALUES (10433, 'jira.properties', 1, 'com.atlassian.jirawallboard.atlassian-wallboard-plugin:build', 5);
INSERT INTO propertyentry VALUES (10434, 'jira.properties', 1, 'com.atlassian.support.stp:build', 5);
INSERT INTO propertyentry VALUES (10435, 'jira.properties', 1, 'com.atlassian.jira.project-templates-plugin:build', 5);
INSERT INTO propertyentry VALUES (10437, 'jira.properties', 1, 'jira-header-plugin.studio-tab-migration-complete', 5);
INSERT INTO propertyentry VALUES (10438, 'jira.properties', 1, 'com.atlassian.analytics.client.configuration..policy_acknowledged', 5);
INSERT INTO propertyentry VALUES (10439, 'jira.properties', 1, 'com.atlassian.jira.onboarding.postsetup.AppPropertiesPostSetupAnnouncementStore.all', 6);
INSERT INTO propertyentry VALUES (10440, 'jira.properties', 1, 'com.atlassian.upm:notifications:notification-update', 5);
INSERT INTO propertyentry VALUES (10441, 'jira.properties', 1, 'post.migration.page.displayed', 1);
INSERT INTO propertyentry VALUES (10442, 'ApplicationUser', 10000, 'jira.onboarding.first.use.flow.started', 5);
INSERT INTO propertyentry VALUES (10443, 'ApplicationUser', 10000, 'jira.onboarding.first.use.flow.current.sequence', 5);
INSERT INTO propertyentry VALUES (10445, 'ApplicationUser', 10000, 'jira.onboarding.first.use.flow.resolved', 1);
INSERT INTO propertyentry VALUES (10446, 'ApplicationUser', 10000, 'newsletter.signup.first.view', 3);


--
-- Data for Name: propertynumber; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO propertynumber VALUES (9, 0);
INSERT INTO propertynumber VALUES (11, 1);
INSERT INTO propertynumber VALUES (12, 0);
INSERT INTO propertynumber VALUES (15, 1);
INSERT INTO propertynumber VALUES (16, 1);
INSERT INTO propertynumber VALUES (10113, 1);
INSERT INTO propertynumber VALUES (10217, 1);
INSERT INTO propertynumber VALUES (10218, 1);
INSERT INTO propertynumber VALUES (10222, 22);
INSERT INTO propertynumber VALUES (10225, 0);
INSERT INTO propertynumber VALUES (10227, 0);
INSERT INTO propertynumber VALUES (10228, 1);
INSERT INTO propertynumber VALUES (10229, 1);
INSERT INTO propertynumber VALUES (10230, 1);
INSERT INTO propertynumber VALUES (10232, 1);
INSERT INTO propertynumber VALUES (10236, 10000);
INSERT INTO propertynumber VALUES (10237, 10001);
INSERT INTO propertynumber VALUES (10242, 10002);
INSERT INTO propertynumber VALUES (10243, 10003);
INSERT INTO propertynumber VALUES (10244, 10004);
INSERT INTO propertynumber VALUES (10245, 10005);
INSERT INTO propertynumber VALUES (10247, 1);
INSERT INTO propertynumber VALUES (10249, 10200);
INSERT INTO propertynumber VALUES (10276, 48);
INSERT INTO propertynumber VALUES (10441, 1);
INSERT INTO propertynumber VALUES (10444, 1);
INSERT INTO propertynumber VALUES (10445, 1);
INSERT INTO propertynumber VALUES (10446, 1438572634038);


--
-- Data for Name: propertystring; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO propertystring VALUES (10221, 'XwLK2UEx+3YR4ixFIwLc/kLG0dqons4FIIC3AiKr83A=');
INSERT INTO propertystring VALUES (10101, '3');
INSERT INTO propertystring VALUES (10226, 'true');
INSERT INTO propertystring VALUES (10231, 'show');
INSERT INTO propertystring VALUES (10233, '1');
INSERT INTO propertystring VALUES (10234, '1');
INSERT INTO propertystring VALUES (10235, '1');
INSERT INTO propertystring VALUES (10238, '');
INSERT INTO propertystring VALUES (10422, '#java.util.List
');
INSERT INTO propertystring VALUES (10423, '#java.util.List
');
INSERT INTO propertystring VALUES (10424, '#java.util.List
');
INSERT INTO propertystring VALUES (10425, '#java.util.List
');
INSERT INTO propertystring VALUES (10246, 'true');
INSERT INTO propertystring VALUES (10250, 'true');
INSERT INTO propertystring VALUES (10256, '#java.util.List
');
INSERT INTO propertystring VALUES (5, '10122');
INSERT INTO propertystring VALUES (6, '10123');
INSERT INTO propertystring VALUES (7, '10000');
INSERT INTO propertystring VALUES (22, '0');
INSERT INTO propertystring VALUES (10102, 'english-moderate-stemming');
INSERT INTO propertystring VALUES (10103, 'B3B8-FFKS-GKRV-OXCL');
INSERT INTO propertystring VALUES (10260, '2');
INSERT INTO propertystring VALUES (10106, '10300');
INSERT INTO propertystring VALUES (10107, '10316');
INSERT INTO propertystring VALUES (10262, 'true');
INSERT INTO propertystring VALUES (10263, '4');
INSERT INTO propertystring VALUES (10264, '1');
INSERT INTO propertystring VALUES (10265, '2');
INSERT INTO propertystring VALUES (10426, '#java.util.List
');
INSERT INTO propertystring VALUES (10427, '#java.util.List
');
INSERT INTO propertystring VALUES (3, '10324');
INSERT INTO propertystring VALUES (10428, '#java.util.List
');
INSERT INTO propertystring VALUES (10109, 'b6b48b2829824b869586ac216d119363');
INSERT INTO propertystring VALUES (10112, 'none');
INSERT INTO propertystring VALUES (1, '70102');
INSERT INTO propertystring VALUES (13, '7.0.0-SNAPSHOT');
INSERT INTO propertystring VALUES (14, '6.4.8');
INSERT INTO propertystring VALUES (10200, 'en_US');
INSERT INTO propertystring VALUES (10201, 'UTF-8');
INSERT INTO propertystring VALUES (10202, 'Your Company JIRA');
INSERT INTO propertystring VALUES (10206, 'https://bitbucket.org');
INSERT INTO propertystring VALUES (10207, 'https://github.com');
INSERT INTO propertystring VALUES (10241, 'GreenHopper Epic Label Field Indexing');
INSERT INTO propertystring VALUES (10211, '15');
INSERT INTO propertystring VALUES (10212, '1');
INSERT INTO propertystring VALUES (10213, '1');
INSERT INTO propertystring VALUES (10214, 'http://localhost:2990/jira');
INSERT INTO propertystring VALUES (10215, 'private');
INSERT INTO propertystring VALUES (10216, '/Users/pdevasundaram/views/jira-agile/greenhopper/target/jira/home/data/attachments');
INSERT INTO propertystring VALUES (10219, 'true');
INSERT INTO propertystring VALUES (10220, '/Users/pdevasundaram/views/jira-agile/greenhopper/target/jira/home/export');
INSERT INTO propertystring VALUES (10353, '#java.util.List
');
INSERT INTO propertystring VALUES (10354, '#java.util.List
');
INSERT INTO propertystring VALUES (10355, '#java.util.List
');
INSERT INTO propertystring VALUES (10356, '#java.util.List
');
INSERT INTO propertystring VALUES (10357, '#java.util.List
');
INSERT INTO propertystring VALUES (10392, '48');
INSERT INTO propertystring VALUES (10394, '3');
INSERT INTO propertystring VALUES (10395, '1');
INSERT INTO propertystring VALUES (10396, '1');
INSERT INTO propertystring VALUES (10398, '2');
INSERT INTO propertystring VALUES (10399, '1');
INSERT INTO propertystring VALUES (10400, 'false');
INSERT INTO propertystring VALUES (10401, '1');
INSERT INTO propertystring VALUES (10404, '3');
INSERT INTO propertystring VALUES (10405, 'false');
INSERT INTO propertystring VALUES (10406, 'false');
INSERT INTO propertystring VALUES (10407, '/favicon.ico');
INSERT INTO propertystring VALUES (10408, '/images/64jira.png');
INSERT INTO propertystring VALUES (10409, '64');
INSERT INTO propertystring VALUES (10410, '64');
INSERT INTO propertystring VALUES (10411, '/favicon.ico');
INSERT INTO propertystring VALUES (10412, '/images/64jira.png');
INSERT INTO propertystring VALUES (10413, '1');
INSERT INTO propertystring VALUES (10415, '#java.util.List
');
INSERT INTO propertystring VALUES (10417, '#java.util.List
');
INSERT INTO propertystring VALUES (10419, '#java.util.List
');
INSERT INTO propertystring VALUES (10420, '#java.util.List
');
INSERT INTO propertystring VALUES (10421, '#java.util.List
');
INSERT INTO propertystring VALUES (10432, '5');
INSERT INTO propertystring VALUES (10433, '6086');
INSERT INTO propertystring VALUES (10434, '1');
INSERT INTO propertystring VALUES (10435, '2001');
INSERT INTO propertystring VALUES (10436, 'true');
INSERT INTO propertystring VALUES (10437, 'migrated');
INSERT INTO propertystring VALUES (10438, 'true');
INSERT INTO propertystring VALUES (10440, '#java.util.List
com.atlassian.labs.hipchat.hipchat-for-jira-plugin');
INSERT INTO propertystring VALUES (10442, 'agileFirstUseFlow');
INSERT INTO propertystring VALUES (10443, 'nextStep');


--
-- Data for Name: propertytext; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO propertytext VALUES (10, 'http://www.atlassian.com/*
');
INSERT INTO propertytext VALUES (21, '{
    "edgeMap": {
        "1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA": {
            "actionId": 5,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1806.5,
                    "y": 434.0
                },
                {
                    "positiveController": null,
                    "x": 1801.0,
                    "y": 115.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D",
            "endPoint": {
                "positiveController": null,
                "x": 1801.0,
                "y": 115.0
            },
            "endStepId": 4,
            "id": "1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA",
            "label": "Resolve Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1776.85,
                "y": 355.25
            },
            "lineType": "straight",
            "startNodeId": "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB",
            "startPoint": {
                "positiveController": null,
                "x": 1806.5,
                "y": 434.0
            },
            "startStepId": 5
        },
        "3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230": {
            "actionId": 2,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1469.5,
                    "y": 113.0
                },
                {
                    "positiveController": null,
                    "x": 1614.0,
                    "y": 226.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34",
            "endPoint": {
                "positiveController": null,
                "x": 1614.0,
                "y": 226.0
            },
            "endStepId": 6,
            "id": "3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230",
            "label": "Close Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1492.25,
                "y": 154.25
            },
            "lineType": "straight",
            "startNodeId": "778534F4-7595-88B6-45E1-4D19CD518712",
            "startPoint": {
                "positiveController": null,
                "x": 1469.5,
                "y": 113.0
            },
            "startStepId": 1
        },
        "483797F1-1BF4-5E0F-86C6-4D19CE6023A2": {
            "actionId": 5,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1469.5,
                    "y": 113.0
                },
                {
                    "positiveController": null,
                    "x": 1763.0,
                    "y": 113.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D",
            "endPoint": {
                "positiveController": null,
                "x": 1763.0,
                "y": 113.0
            },
            "endStepId": 4,
            "id": "483797F1-1BF4-5E0F-86C6-4D19CE6023A2",
            "label": "Resolve Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1551.0,
                "y": 104.0
            },
            "lineType": "straight",
            "startNodeId": "778534F4-7595-88B6-45E1-4D19CD518712",
            "startPoint": {
                "positiveController": null,
                "x": 1469.5,
                "y": 113.0
            },
            "startStepId": 1
        },
        "517D7F32-20FB-309E-8639-4D19CE2ACB54": {
            "actionId": 5,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1434.0,
                    "y": 435.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1435.0,
                    "y": 490.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1947.0,
                    "y": 494.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1950.0,
                    "y": 118.0
                },
                {
                    "positiveController": null,
                    "x": 1763.0,
                    "y": 113.0
                }
            ],
            "controlPoints": [
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1435.0,
                    "y": 490.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1947.0,
                    "y": 494.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1950.0,
                    "y": 118.0
                }
            ],
            "endNodeId": "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D",
            "endPoint": {
                "positiveController": null,
                "x": 1763.0,
                "y": 113.0
            },
            "endStepId": 4,
            "id": "517D7F32-20FB-309E-8639-4D19CE2ACB54",
            "label": "Resolve Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1631.25,
                "y": 479.5
            },
            "lineType": "poly",
            "startNodeId": "0740FFFA-2AA1-C90A-38ED-4D19CD61899B",
            "startPoint": {
                "positiveController": null,
                "x": 1434.0,
                "y": 435.0
            },
            "startStepId": 3
        },
        "58BD4605-5FB9-84EA-6952-4D19CE7B454B": {
            "actionId": 1,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1470.0,
                    "y": 16.0
                },
                {
                    "positiveController": null,
                    "x": 1469.5,
                    "y": 113.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "778534F4-7595-88B6-45E1-4D19CD518712",
            "endPoint": {
                "positiveController": null,
                "x": 1469.5,
                "y": 113.0
            },
            "endStepId": 1,
            "id": "58BD4605-5FB9-84EA-6952-4D19CE7B454B",
            "label": "Create Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1475.5,
                "y": 48.5
            },
            "lineType": "straight",
            "startNodeId": "15174530-AE75-04E0-1D9D-4D19CD200835",
            "startPoint": {
                "positiveController": null,
                "x": 1470.0,
                "y": 16.0
            },
            "startStepId": 1
        },
        "92D3DEFD-13AC-06A7-E5D8-4D19CE537791": {
            "actionId": 4,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1439.5,
                    "y": 116.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1393.0,
                    "y": 116.0
                },
                {
                    "positiveController": null,
                    "x": 1390.0,
                    "y": 434.0
                }
            ],
            "controlPoints": [
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1393.0,
                    "y": 116.0
                }
            ],
            "endNodeId": "0740FFFA-2AA1-C90A-38ED-4D19CD61899B",
            "endPoint": {
                "positiveController": null,
                "x": 1390.0,
                "y": 434.0
            },
            "endStepId": 3,
            "id": "92D3DEFD-13AC-06A7-E5D8-4D19CE537791",
            "label": "Start Progress",
            "labelPoint": {
                "positiveController": null,
                "x": 1323.65,
                "y": 193.75
            },
            "lineType": "poly",
            "startNodeId": "778534F4-7595-88B6-45E1-4D19CD518712",
            "startPoint": {
                "positiveController": null,
                "x": 1439.5,
                "y": 116.0
            },
            "startStepId": 1
        },
        "C049EE11-C5BB-F93B-36C3-4D19CDF12B8F": {
            "actionId": 3,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1677.0,
                    "y": 227.0
                },
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1767.05,
                    "y": 230.05
                },
                {
                    "positiveController": null,
                    "x": 1773.5,
                    "y": 425.0
                }
            ],
            "controlPoints": [
                {
                    "positiveController": {
                        "positiveController": null,
                        "x": 0.0,
                        "y": 0.0
                    },
                    "x": 1767.05,
                    "y": 230.05
                }
            ],
            "endNodeId": "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB",
            "endPoint": {
                "positiveController": null,
                "x": 1773.5,
                "y": 425.0
            },
            "endStepId": 5,
            "id": "C049EE11-C5BB-F93B-36C3-4D19CDF12B8F",
            "label": "Reopen Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1703.85,
                "y": 218.5
            },
            "lineType": "poly",
            "startNodeId": "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34",
            "startPoint": {
                "positiveController": null,
                "x": 1677.0,
                "y": 227.0
            },
            "startStepId": 6
        },
        "C9EA1792-2332-8B56-A04D-4D19CD725367": {
            "actionId": 301,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1465.0,
                    "y": 436.0
                },
                {
                    "positiveController": null,
                    "x": 1469.5,
                    "y": 113.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "778534F4-7595-88B6-45E1-4D19CD518712",
            "endPoint": {
                "positiveController": null,
                "x": 1469.5,
                "y": 113.0
            },
            "endStepId": 1,
            "id": "C9EA1792-2332-8B56-A04D-4D19CD725367",
            "label": "Stop Progress",
            "labelPoint": {
                "positiveController": null,
                "x": 1407.8,
                "y": 308.5
            },
            "lineType": "straight",
            "startNodeId": "0740FFFA-2AA1-C90A-38ED-4D19CD61899B",
            "startPoint": {
                "positiveController": null,
                "x": 1465.0,
                "y": 436.0
            },
            "startStepId": 3
        },
        "CAF37138-6321-E03A-8E41-4D19CDD7DC78": {
            "actionId": 2,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1764.5,
                    "y": 430.0
                },
                {
                    "positiveController": null,
                    "x": 1614.0,
                    "y": 226.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34",
            "endPoint": {
                "positiveController": null,
                "x": 1614.0,
                "y": 226.0
            },
            "endStepId": 6,
            "id": "CAF37138-6321-E03A-8E41-4D19CDD7DC78",
            "label": "Close Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1677.65,
                "y": 365.0
            },
            "lineType": "straight",
            "startNodeId": "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB",
            "startPoint": {
                "positiveController": null,
                "x": 1764.5,
                "y": 430.0
            },
            "startStepId": 5
        },
        "E1F8462A-8B0A-87EA-4F70-4D19CE423C83": {
            "actionId": 2,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1488.0,
                    "y": 430.0
                },
                {
                    "positiveController": null,
                    "x": 1614.0,
                    "y": 226.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34",
            "endPoint": {
                "positiveController": null,
                "x": 1614.0,
                "y": 226.0
            },
            "endStepId": 6,
            "id": "E1F8462A-8B0A-87EA-4F70-4D19CE423C83",
            "label": "Close Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1492.0,
                "y": 345.0
            },
            "lineType": "straight",
            "startNodeId": "0740FFFA-2AA1-C90A-38ED-4D19CD61899B",
            "startPoint": {
                "positiveController": null,
                "x": 1488.0,
                "y": 430.0
            },
            "startStepId": 3
        },
        "E27D8EB8-8E49-430B-8FCB-4D19CE127171": {
            "actionId": 3,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1840.0,
                    "y": 130.0
                },
                {
                    "positiveController": null,
                    "x": 1846.5,
                    "y": 428.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB",
            "endPoint": {
                "positiveController": null,
                "x": 1846.5,
                "y": 428.0
            },
            "endStepId": 5,
            "id": "E27D8EB8-8E49-430B-8FCB-4D19CE127171",
            "label": "Reopen Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1814.05,
                "y": 169.5
            },
            "lineType": "straight",
            "startNodeId": "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D",
            "startPoint": {
                "positiveController": null,
                "x": 1840.0,
                "y": 130.0
            },
            "startStepId": 4
        },
        "F79E742D-A9E4-0124-D7D4-4D19CDE48C9C": {
            "actionId": 4,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1806.5,
                    "y": 434.0
                },
                {
                    "positiveController": null,
                    "x": 1434.0,
                    "y": 435.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "0740FFFA-2AA1-C90A-38ED-4D19CD61899B",
            "endPoint": {
                "positiveController": null,
                "x": 1434.0,
                "y": 435.0
            },
            "endStepId": 3,
            "id": "F79E742D-A9E4-0124-D7D4-4D19CDE48C9C",
            "label": "Start Progress",
            "labelPoint": {
                "positiveController": null,
                "x": 1607.25,
                "y": 423.5
            },
            "lineType": "straight",
            "startNodeId": "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB",
            "startPoint": {
                "positiveController": null,
                "x": 1806.5,
                "y": 434.0
            },
            "startStepId": 5
        },
        "FD6BA267-475B-70B3-8AA4-4D19CE00BCD1": {
            "actionId": 701,
            "allPoints": [
                {
                    "positiveController": null,
                    "x": 1763.0,
                    "y": 113.0
                },
                {
                    "positiveController": null,
                    "x": 1614.0,
                    "y": 226.0
                }
            ],
            "controlPoints": [],
            "endNodeId": "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34",
            "endPoint": {
                "positiveController": null,
                "x": 1614.0,
                "y": 226.0
            },
            "endStepId": 6,
            "id": "FD6BA267-475B-70B3-8AA4-4D19CE00BCD1",
            "label": "Close Issue",
            "labelPoint": {
                "positiveController": null,
                "x": 1635.75,
                "y": 152.25
            },
            "lineType": "straight",
            "startNodeId": "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D",
            "startPoint": {
                "positiveController": null,
                "x": 1763.0,
                "y": 113.0
            },
            "startStepId": 4
        }
    },
    "nodeMap": {
        "0740FFFA-2AA1-C90A-38ED-4D19CD61899B": {
            "id": "0740FFFA-2AA1-C90A-38ED-4D19CD61899B",
            "inLinkIds": [
                "F79E742D-A9E4-0124-D7D4-4D19CDE48C9C",
                "92D3DEFD-13AC-06A7-E5D8-4D19CE537791"
            ],
            "isInitialAction": false,
            "label": "In Progress",
            "outLinkIds": [
                "C9EA1792-2332-8B56-A04D-4D19CD725367",
                "517D7F32-20FB-309E-8639-4D19CE2ACB54",
                "E1F8462A-8B0A-87EA-4F70-4D19CE423C83"
            ],
            "rect": {
                "height": 45.0,
                "positiveController": null,
                "width": 146.0,
                "x": 1373.0,
                "y": 419.0
            },
            "stepId": 3
        },
        "15174530-AE75-04E0-1D9D-4D19CD200835": {
            "id": "15174530-AE75-04E0-1D9D-4D19CD200835",
            "inLinkIds": [],
            "isInitialAction": true,
            "label": "Create Issue",
            "outLinkIds": [
                "58BD4605-5FB9-84EA-6952-4D19CE7B454B"
            ],
            "rect": {
                "height": 45.0,
                "positiveController": null,
                "width": 157.0,
                "x": 1405.0,
                "y": 0.0
            },
            "stepId": 1
        },
        "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34": {
            "id": "1C846CFB-4F0D-2F40-D0AE-4D19CDAF5D34",
            "inLinkIds": [
                "CAF37138-6321-E03A-8E41-4D19CDD7DC78",
                "E1F8462A-8B0A-87EA-4F70-4D19CE423C83",
                "FD6BA267-475B-70B3-8AA4-4D19CE00BCD1",
                "3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230"
            ],
            "isInitialAction": false,
            "label": "Closed",
            "outLinkIds": [
                "C049EE11-C5BB-F93B-36C3-4D19CDF12B8F"
            ],
            "rect": {
                "height": 45.0,
                "positiveController": null,
                "width": 120.0,
                "x": 1569.0,
                "y": 210.0
            },
            "stepId": 6
        },
        "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D": {
            "id": "6DA64EEB-08FE-2870-C90C-4D19CDA2F72D",
            "inLinkIds": [
                "517D7F32-20FB-309E-8639-4D19CE2ACB54",
                "1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA",
                "483797F1-1BF4-5E0F-86C6-4D19CE6023A2"
            ],
            "isInitialAction": false,
            "label": "Resolved",
            "outLinkIds": [
                "FD6BA267-475B-70B3-8AA4-4D19CE00BCD1",
                "E27D8EB8-8E49-430B-8FCB-4D19CE127171"
            ],
            "rect": {
                "height": 44.0,
                "positiveController": null,
                "width": 137.0,
                "x": 1709.0,
                "y": 97.0
            },
            "stepId": 4
        },
        "778534F4-7595-88B6-45E1-4D19CD518712": {
            "id": "778534F4-7595-88B6-45E1-4D19CD518712",
            "inLinkIds": [
                "C9EA1792-2332-8B56-A04D-4D19CD725367",
                "58BD4605-5FB9-84EA-6952-4D19CE7B454B"
            ],
            "isInitialAction": false,
            "label": "Open",
            "outLinkIds": [
                "92D3DEFD-13AC-06A7-E5D8-4D19CE537791",
                "483797F1-1BF4-5E0F-86C6-4D19CE6023A2",
                "3DF7CEC8-9FBC-C0D0-AFB1-4D19CE6EA230"
            ],
            "rect": {
                "height": 45.0,
                "positiveController": null,
                "width": 106.0,
                "x": 1429.5,
                "y": 97.0
            },
            "stepId": 1
        },
        "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB": {
            "id": "A8B1A431-AC3A-6DCD-BFF0-4D19CDBCAADB",
            "inLinkIds": [
                "E27D8EB8-8E49-430B-8FCB-4D19CE127171",
                "C049EE11-C5BB-F93B-36C3-4D19CDF12B8F"
            ],
            "isInitialAction": false,
            "label": "Reopened",
            "outLinkIds": [
                "1DEDB66F-FE5C-EDFD-54D0-4D19CDC8CECA",
                "CAF37138-6321-E03A-8E41-4D19CDD7DC78",
                "F79E742D-A9E4-0124-D7D4-4D19CDE48C9C"
            ],
            "rect": {
                "height": 45.0,
                "positiveController": null,
                "width": 142.0,
                "x": 1749.5,
                "y": 418.0
            },
            "stepId": 5
        }
    },
    "rootIds": [
        "15174530-AE75-04E0-1D9D-4D19CD200835"
    ],
    "width": 1136
}
');
INSERT INTO propertytext VALUES (10223, '<map>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:29:10.860+10:00</string>
  </entry>
  <entry>
    <string>buildDate</string>
    <string>2015-08-03T13:25:34.017+10:00</string>
  </entry>
  <entry>
    <string>latestUpgradeTaskRun</string>
    <string>0</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10224, '<map>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:29:10.860+10:00</string>
  </entry>
  <entry>
    <string>buildDate</string>
    <string>2015-08-03T13:25:34.017+10:00</string>
  </entry>
  <entry>
    <string>latestUpgradeTaskRun</string>
    <string>0</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10320, '<map>
  <entry>
    <string>timeTaken</string>
    <string>33</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.912+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>25</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10322, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.940+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>26</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10323, '<map>
  <entry>
    <string>timeTaken</string>
    <string>13</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.956+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>26</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10325, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.967+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>27</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10326, '<map>
  <entry>
    <string>timeTaken</string>
    <string>6</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.976+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>27</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10328, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.986+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>29</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10329, '<map>
  <entry>
    <string>timeTaken</string>
    <string>11</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.000+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>29</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10248, '<map>
  <entry>
    <string>gh.issue.flaggingfield</string>
    <string>customfield_10006</string>
  </entry>
  <entry>
    <string>gh.issue.labelfield</string>
    <string>customfield_10007</string>
  </entry>
  <entry>
    <string>gh.issue.story</string>
    <string>10001</string>
  </entry>
  <entry>
    <string>gh.issue.storypoints</string>
    <string>customfield_10008</string>
  </entry>
  <entry>
    <string>gh.issue.businessvalues</string>
    <string>customfield_10009</string>
  </entry>
  <entry>
    <string>gh.issue.epic</string>
    <string>10000</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10240, '{"com.atlassian.jira.reindex.required":1438572606017}');
INSERT INTO propertytext VALUES (10274, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.051+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>12</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10275, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.054+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>12</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10278, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.065+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>13</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10284, '<map>
  <entry>
    <string>timeTaken</string>
    <string>613</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.681+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>13</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10286, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.698+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>14</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10287, '<map>
  <entry>
    <string>timeTaken</string>
    <string>0</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.701+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>14</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10289, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.713+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>15</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10290, '<map>
  <entry>
    <string>timeTaken</string>
    <string>2</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.718+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>15</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10292, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.732+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>16</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10293, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.736+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>16</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10295, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.746+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>17</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10296, '<map>
  <entry>
    <string>timeTaken</string>
    <string>6</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.754+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>17</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10298, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.764+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>18</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10299, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.767+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>18</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10301, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.779+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>19</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10302, '<map>
  <entry>
    <string>timeTaken</string>
    <string>10</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.792+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>19</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10304, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.801+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>20</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10305, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.805+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>20</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10307, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.815+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>21</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10308, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.819+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>21</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10310, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.830+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>22</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10311, '<map>
  <entry>
    <string>timeTaken</string>
    <string>8</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.841+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>22</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10313, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.851+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>23</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10314, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.854+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>23</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10316, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.863+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>24</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10317, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.867+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>24</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10319, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:05.877+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>25</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10331, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.010+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>30</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10332, '<map>
  <entry>
    <string>timeTaken</string>
    <string>9</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.021+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>30</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10334, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.030+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>31</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10335, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.034+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>31</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10337, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.044+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>32</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10338, '<map>
  <entry>
    <string>timeTaken</string>
    <string>5</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.052+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>32</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10340, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.062+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>33</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10341, '<map>
  <entry>
    <string>timeTaken</string>
    <string>7</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.072+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>33</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10343, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.083+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>34</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10344, '<map>
  <entry>
    <string>timeTaken</string>
    <string>254</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.339+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>34</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10346, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.369+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>35</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10347, '<map>
  <entry>
    <string>timeTaken</string>
    <string>3</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.375+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>35</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10349, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.385+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>36</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10350, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.388+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>36</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10352, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.398+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>37</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10358, '<map>
  <entry>
    <string>timeTaken</string>
    <string>545</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.946+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>37</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10360, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.962+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>38</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10361, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.965+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>38</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10363, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.976+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>39</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10364, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.979+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>39</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10366, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:06.990+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>40</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10367, '<map>
  <entry>
    <string>timeTaken</string>
    <string>60</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.053+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>40</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10369, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.063+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>41</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10370, '<map>
  <entry>
    <string>timeTaken</string>
    <string>23</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.089+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>41</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10372, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.116+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>42</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10373, '<map>
  <entry>
    <string>timeTaken</string>
    <string>0</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.119+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>42</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10375, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.128+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>43</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10376, '<map>
  <entry>
    <string>timeTaken</string>
    <string>4</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.134+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>43</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10378, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.144+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>44</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10379, '<map>
  <entry>
    <string>timeTaken</string>
    <string>38</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.184+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>44</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10381, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.195+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>45</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10382, '<map>
  <entry>
    <string>timeTaken</string>
    <string>21</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.218+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>45</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10384, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.230+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>46</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10385, '<map>
  <entry>
    <string>timeTaken</string>
    <string>5</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.237+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>46</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10387, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.247+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>47</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10388, '<map>
  <entry>
    <string>timeTaken</string>
    <string>1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.251+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>47</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10390, '<map>
  <entry>
    <string>timeTaken</string>
    <string>-1</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.261+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>48</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10391, '<map>
  <entry>
    <string>timeTaken</string>
    <string>2</string>
  </entry>
  <entry>
    <string>pluginVersion</string>
    <string>6.7.9-SNAPSHOT</string>
  </entry>
  <entry>
    <string>ranOn</string>
    <string>2015-08-03T13:30:07.265+10:00</string>
  </entry>
  <entry>
    <string>buildNumber</string>
    <string>48</string>
  </entry>
  <entry>
    <string>changeSet</string>
    <string>null</string>
  </entry>
</map>');
INSERT INTO propertytext VALUES (10439, 'database.setup=FULLFILLED;admin.account.setup=FULLFILLED;app.properties.setup=FULLFILLED;create.user.mail.properties.setup=AWAITS;mail.properties.setup=AWAITS');


--
-- Data for Name: qrtz_calendars; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_cron_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_fired_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_job_details; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_job_listeners; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_simple_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_trigger_listeners; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: qrtz_triggers; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: reindex_component; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO reindex_component VALUES (10000, 10000, 'WORKLOG', 'NONE');
INSERT INTO reindex_component VALUES (10001, 10001, 'WORKLOG', 'NONE');
INSERT INTO reindex_component VALUES (10002, 10002, 'ISSUE', 'NONE');
INSERT INTO reindex_component VALUES (10003, 10003, 'ISSUE', 'NONE');
INSERT INTO reindex_component VALUES (10004, 10004, 'WORKLOG', 'NONE');


--
-- Data for Name: reindex_request; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO reindex_request VALUES (10000, 'DELAYED', '2015-08-03 13:28:13.818+10', NULL, NULL, 'PENDING', NULL);
INSERT INTO reindex_request VALUES (10001, 'DELAYED', '2015-08-03 13:28:13.833+10', NULL, NULL, 'PENDING', NULL);
INSERT INTO reindex_request VALUES (10002, 'DELAYED', '2015-08-03 13:28:13.845+10', NULL, NULL, 'PENDING', NULL);
INSERT INTO reindex_request VALUES (10003, 'DELAYED', '2015-08-03 13:28:13.849+10', NULL, NULL, 'PENDING', NULL);
INSERT INTO reindex_request VALUES (10004, 'DELAYED', '2015-08-03 13:28:13.926+10', NULL, NULL, 'PENDING', NULL);


--
-- Data for Name: remembermetoken; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: remotelink; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: replicatedindexoperation; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: resolution; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: rundetails; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO rundetails VALUES (10002, 'com.atlassian.jira.cache.monitor.CacheStatisticsMonitor', '2015-08-03 13:28:14.341+10', 38, 'S', '');
INSERT INTO rundetails VALUES (10003, 'com.atlassian.jira.service.JiraService:10001', '2015-08-03 13:28:27.645+10', 7397, 'S', '');
INSERT INTO rundetails VALUES (10004, 'com.atlassian.jira.user.UserHistoryDatabaseCompactor', '2015-08-03 13:29:18.033+10', 1, 'S', '');
INSERT INTO rundetails VALUES (10005, 'data-provider-cleanup', '2015-08-03 13:29:18.033+10', 1219, 'S', '');
INSERT INTO rundetails VALUES (10006, 'com.atlassian.jira.service.JiraService:10000', '2015-08-03 13:30:00.004+10', 2, 'S', '');
INSERT INTO rundetails VALUES (10007, 'CompatibilityPluginScheduler.JobId.LEXO_RANK_SCHEDULER_JOB', '2015-08-03 13:30:01.062+10', 10, 'S', '');
INSERT INTO rundetails VALUES (10008, 'JiraPluginScheduler:LEXO_RANK_STATS_COLLECTOR_JOB', '2015-08-03 13:30:01.081+10', 1, 'S', '');
INSERT INTO rundetails VALUES (10009, 'CompatibilityPluginScheduler.JobId.BundledUpdateCheckJob-job', '2015-08-03 13:30:02.34+10', 32, 'S', '');
INSERT INTO rundetails VALUES (10010, 'CompatibilityPluginScheduler.JobId.PluginRequestCheckJob-job', '2015-08-03 13:30:02.403+10', 28, 'S', '');
INSERT INTO rundetails VALUES (10011, 'CompatibilityPluginScheduler.JobId.LocalPluginLicenseNotificationJob-job', '2015-08-03 13:30:02.35+10', 82, 'S', '');
INSERT INTO rundetails VALUES (10012, 'JiraPluginScheduler:com.atlassian.jira.plugin.ext.bamboo.service.PlanStatusUpdateServiceImpl:job', '2015-08-03 13:30:04.86+10', 0, 'S', '');
INSERT INTO rundetails VALUES (10013, 'CompatibilityPluginScheduler.JobId.bitbucket-accounts-reload', '2015-08-03 13:30:22.983+10', 3, 'S', '');


--
-- Data for Name: schemeissuesecurities; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: schemeissuesecuritylevels; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: schemepermissions; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO schemepermissions VALUES (10101, NULL, 44, 'group', 'jira-administrators', NULL);
INSERT INTO schemepermissions VALUES (10000, NULL, 0, 'group', 'jira-administrators', NULL);
INSERT INTO schemepermissions VALUES (10016, 0, 25, 'applicationRole', '', 'MOVE_ISSUES');
INSERT INTO schemepermissions VALUES (10017, 0, 28, 'applicationRole', '', 'SCHEDULE_ISSUES');
INSERT INTO schemepermissions VALUES (10018, 0, 30, 'projectrole', '10002', 'MODIFY_REPORTER');
INSERT INTO schemepermissions VALUES (10019, 0, 20, 'applicationRole', '', 'WORK_ON_ISSUES');
INSERT INTO schemepermissions VALUES (10020, 0, 43, 'projectrole', '10002', 'DELETE_ALL_WORKLOGS');
INSERT INTO schemepermissions VALUES (10021, 0, 42, 'applicationRole', '', 'DELETE_OWN_WORKLOGS');
INSERT INTO schemepermissions VALUES (10022, 0, 41, 'projectrole', '10002', 'EDIT_ALL_WORKLOGS');
INSERT INTO schemepermissions VALUES (10023, 0, 40, 'applicationRole', '', 'EDIT_OWN_WORKLOGS');
INSERT INTO schemepermissions VALUES (10024, 0, 31, 'applicationRole', '', 'VIEW_VOTERS_AND_WATCHERS');
INSERT INTO schemepermissions VALUES (10025, 0, 32, 'projectrole', '10002', 'MANAGE_WATCHERS');
INSERT INTO schemepermissions VALUES (10026, 0, 34, 'projectrole', '10002', 'EDIT_ALL_COMMENTS');
INSERT INTO schemepermissions VALUES (10027, 0, 35, 'applicationRole', '', 'EDIT_OWN_COMMENTS');
INSERT INTO schemepermissions VALUES (10028, 0, 36, 'projectrole', '10002', 'DELETE_ALL_COMMENTS');
INSERT INTO schemepermissions VALUES (10029, 0, 37, 'applicationRole', '', 'DELETE_OWN_COMMENTS');
INSERT INTO schemepermissions VALUES (10030, 0, 38, 'projectrole', '10002', 'DELETE_ALL_ATTACHMENTS');
INSERT INTO schemepermissions VALUES (10031, 0, 39, 'applicationRole', '', 'DELETE_OWN_ATTACHMENTS');
INSERT INTO schemepermissions VALUES (10033, 0, 29, 'applicationRole', '', 'VIEW_DEV_TOOLS');
INSERT INTO schemepermissions VALUES (10200, 0, 45, 'applicationRole', '', 'VIEW_READONLY_WORKFLOW');
INSERT INTO schemepermissions VALUES (10300, 0, 46, 'applicationRole', '', 'TRANSITION_ISSUES');
INSERT INTO schemepermissions VALUES (10004, 0, 23, 'projectrole', '10002', 'ADMINISTER_PROJECTS');
INSERT INTO schemepermissions VALUES (10005, 0, 10, 'applicationRole', '', 'BROWSE_PROJECTS');
INSERT INTO schemepermissions VALUES (10006, 0, 11, 'applicationRole', '', 'CREATE_ISSUES');
INSERT INTO schemepermissions VALUES (10007, 0, 15, 'applicationRole', '', 'ADD_COMMENTS');
INSERT INTO schemepermissions VALUES (10008, 0, 19, 'applicationRole', '', 'CREATE_ATTACHMENTS');
INSERT INTO schemepermissions VALUES (10009, 0, 13, 'applicationRole', '', 'ASSIGN_ISSUES');
INSERT INTO schemepermissions VALUES (10010, 0, 17, 'applicationRole', '', 'ASSIGNABLE_USER');
INSERT INTO schemepermissions VALUES (10011, 0, 14, 'applicationRole', '', 'RESOLVE_ISSUES');
INSERT INTO schemepermissions VALUES (10012, 0, 21, 'applicationRole', '', 'LINK_ISSUES');
INSERT INTO schemepermissions VALUES (10013, 0, 12, 'applicationRole', '', 'EDIT_ISSUES');
INSERT INTO schemepermissions VALUES (10014, 0, 16, 'projectrole', '10002', 'DELETE_ISSUES');
INSERT INTO schemepermissions VALUES (10015, 0, 18, 'applicationRole', '', 'CLOSE_ISSUES');


--
-- Data for Name: searchrequest; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: sequence_value_item; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO sequence_value_item VALUES ('EventType', 10000);
INSERT INTO sequence_value_item VALUES ('FieldLayout', 10100);
INSERT INTO sequence_value_item VALUES ('FieldScreen', 10000);
INSERT INTO sequence_value_item VALUES ('FieldScreenLayoutItem', 10200);
INSERT INTO sequence_value_item VALUES ('FieldScreenScheme', 10000);
INSERT INTO sequence_value_item VALUES ('FieldScreenSchemeItem', 10100);
INSERT INTO sequence_value_item VALUES ('FieldScreenTab', 10100);
INSERT INTO sequence_value_item VALUES ('GadgetUserPreference', 10100);
INSERT INTO sequence_value_item VALUES ('GenericConfiguration', 10100);
INSERT INTO sequence_value_item VALUES ('IssueTypeScreenSchemeEntity', 10100);
INSERT INTO sequence_value_item VALUES ('Notification', 10200);
INSERT INTO sequence_value_item VALUES ('NotificationScheme', 10100);
INSERT INTO sequence_value_item VALUES ('OAuthConsumer', 10100);
INSERT INTO sequence_value_item VALUES ('PortalPage', 10100);
INSERT INTO sequence_value_item VALUES ('PortletConfiguration', 10100);
INSERT INTO sequence_value_item VALUES ('Priority', 10000);
INSERT INTO sequence_value_item VALUES ('ProjectRole', 10100);
INSERT INTO sequence_value_item VALUES ('ProjectRoleActor', 10100);
INSERT INTO sequence_value_item VALUES ('Resolution', 10000);
INSERT INTO sequence_value_item VALUES ('SchemePermissions', 10400);
INSERT INTO sequence_value_item VALUES ('ServiceConfig', 10200);
INSERT INTO sequence_value_item VALUES ('SharePermissions', 10100);
INSERT INTO sequence_value_item VALUES ('Status', 10000);
INSERT INTO sequence_value_item VALUES ('Workflow', 10100);
INSERT INTO sequence_value_item VALUES ('WorkflowScheme', 10100);
INSERT INTO sequence_value_item VALUES ('WorkflowSchemeEntity', 10100);
INSERT INTO sequence_value_item VALUES ('Avatar', 10400);
INSERT INTO sequence_value_item VALUES ('UpgradeHistory', 10100);
INSERT INTO sequence_value_item VALUES ('ReindexRequest', 10100);
INSERT INTO sequence_value_item VALUES ('ReindexComponent', 10100);
INSERT INTO sequence_value_item VALUES ('Feature', 10100);
INSERT INTO sequence_value_item VALUES ('UpgradeVersionHistory', 10100);
INSERT INTO sequence_value_item VALUES ('RunDetails', 10100);
INSERT INTO sequence_value_item VALUES ('ListenerConfig', 10300);
INSERT INTO sequence_value_item VALUES ('ClusteredJob', 10200);
INSERT INTO sequence_value_item VALUES ('ProductLicense', 10100);
INSERT INTO sequence_value_item VALUES ('Group', 10110);
INSERT INTO sequence_value_item VALUES ('AuditLog', 10200);
INSERT INTO sequence_value_item VALUES ('LicenseRoleGroup', 10200);
INSERT INTO sequence_value_item VALUES ('GlobalPermissionEntry', 10200);
INSERT INTO sequence_value_item VALUES ('AuditChangedValue', 10200);
INSERT INTO sequence_value_item VALUES ('PluginVersion', 10300);
INSERT INTO sequence_value_item VALUES ('EntityPropertyIndexDocument', 10100);
INSERT INTO sequence_value_item VALUES ('ApplicationUser', 10100);
INSERT INTO sequence_value_item VALUES ('User', 10100);
INSERT INTO sequence_value_item VALUES ('UserAttribute', 10100);
INSERT INTO sequence_value_item VALUES ('Membership', 10100);
INSERT INTO sequence_value_item VALUES ('AuditItem', 10100);
INSERT INTO sequence_value_item VALUES ('LicenseRoleDefault', 10100);
INSERT INTO sequence_value_item VALUES ('FieldLayoutItem', 10200);
INSERT INTO sequence_value_item VALUES ('CustomField', 10100);
INSERT INTO sequence_value_item VALUES ('FieldConfiguration', 10200);
INSERT INTO sequence_value_item VALUES ('FieldConfigScheme', 10200);
INSERT INTO sequence_value_item VALUES ('FieldConfigSchemeIssueType', 10300);
INSERT INTO sequence_value_item VALUES ('ConfigurationContext', 10200);
INSERT INTO sequence_value_item VALUES ('ManagedConfigurationItem', 10100);
INSERT INTO sequence_value_item VALUES ('CustomFieldOption', 10100);
INSERT INTO sequence_value_item VALUES ('IssueType', 10100);
INSERT INTO sequence_value_item VALUES ('OptionConfiguration', 10300);
INSERT INTO sequence_value_item VALUES ('IssueLinkType', 10300);
INSERT INTO sequence_value_item VALUES ('OSPropertyEntry', 10500);
INSERT INTO sequence_value_item VALUES ('UserHistoryItem', 10100);


--
-- Data for Name: serviceconfig; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO serviceconfig VALUES (10000, 60000, 'com.atlassian.jira.service.services.mail.MailQueueService', 'Mail Queue Service', '0 * * * * ?');
INSERT INTO serviceconfig VALUES (10002, 86400000, 'com.atlassian.jira.service.services.auditing.AuditLogCleaningService', 'Audit log cleaning service', '0 0 10 * * ?');
INSERT INTO serviceconfig VALUES (10001, 43200000, 'com.atlassian.jira.service.services.export.ExportService', 'Backup Service', '0 25 1/12 * * ?');


--
-- Data for Name: sharepermissions; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO sharepermissions VALUES (10000, 10000, 'PortalPage', 'global', NULL, NULL);


--
-- Data for Name: trackback_ping; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: trustedapp; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: upgradehistory; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO upgradehistory VALUES (10000, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6322', '6322', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10001, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6323', '6323', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10002, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6325', '6325', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10003, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6326', '6326', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10004, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6327', '6327', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10005, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6328', '6328', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10006, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64001', '64001', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10007, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64002', '64002', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10008, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64003', '64003', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10009, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64004', '64004', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10010, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64005', '64005', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10011, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64006', '64006', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10012, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64007', '64007', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10013, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64008', '64008', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10014, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64009', '64009', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10015, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64011', '64011', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10016, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64012', '64012', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10017, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64014', '64014', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10018, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64015', '64015', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10019, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build64016', '64016', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10020, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build65001', '65001', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10021, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70007', '70007', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10022, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70010', '70010', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10023, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70011', '70011', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10024, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70013', '70013', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10025, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70023', '70023', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10026, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70024', '70024', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10027, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70025', '70025', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10028, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70026', '70026', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10029, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70100', '70100', 'complete', 'Y');
INSERT INTO upgradehistory VALUES (10030, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70101', '70101', 'complete', 'N');
INSERT INTO upgradehistory VALUES (10031, 'com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70102', '70102', 'complete', 'N');


--
-- Data for Name: upgradeversionhistory; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO upgradeversionhistory VALUES (10000, '2015-08-03 13:28:14.292+10', '70102', '7.0.0-SNAPSHOT');


--
-- Data for Name: userassociation; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: userbase; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: userhistoryitem; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO userhistoryitem VALUES (10000, 'Dashboard', '10000', 'admin', 1438572633887, NULL);


--
-- Data for Name: userpickerfilter; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: userpickerfiltergroup; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: userpickerfilterrole; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: versioncontrol; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: votehistory; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Data for Name: workflowscheme; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO workflowscheme VALUES (10000, 'classic', 'classic');


--
-- Data for Name: workflowschemeentity; Type: TABLE DATA; Schema: public; Owner: jirauser2
--

INSERT INTO workflowschemeentity VALUES (10000, 10000, 'classic default workflow', '0');


--
-- Data for Name: worklog; Type: TABLE DATA; Schema: public; Owner: jirauser2
--



--
-- Name: AO_21D670_WHITELIST_RULES_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_21D670_WHITELIST_RULES"
ADD CONSTRAINT "AO_21D670_WHITELIST_RULES_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_38321B_CUSTOM_CONTENT_LINK_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_38321B_CUSTOM_CONTENT_LINK"
ADD CONSTRAINT "AO_38321B_CUSTOM_CONTENT_LINK_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_3B1893_LOOP_DETECTION_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_3B1893_LOOP_DETECTION"
ADD CONSTRAINT "AO_3B1893_LOOP_DETECTION_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_4AEACD_WEBHOOK_DAO_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_4AEACD_WEBHOOK_DAO"
ADD CONSTRAINT "AO_4AEACD_WEBHOOK_DAO_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_550953_SHORTCUT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_550953_SHORTCUT"
ADD CONSTRAINT "AO_550953_SHORTCUT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_563AEE_ACTIVITY_ENTITY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_563AEE_ACTIVITY_ENTITY"
ADD CONSTRAINT "AO_563AEE_ACTIVITY_ENTITY_pkey" PRIMARY KEY ("ACTIVITY_ID");


--
-- Name: AO_563AEE_ACTOR_ENTITY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_563AEE_ACTOR_ENTITY"
ADD CONSTRAINT "AO_563AEE_ACTOR_ENTITY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_563AEE_MEDIA_LINK_ENTITY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_563AEE_MEDIA_LINK_ENTITY"
ADD CONSTRAINT "AO_563AEE_MEDIA_LINK_ENTITY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_563AEE_OBJECT_ENTITY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_563AEE_OBJECT_ENTITY"
ADD CONSTRAINT "AO_563AEE_OBJECT_ENTITY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_563AEE_TARGET_ENTITY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_563AEE_TARGET_ENTITY"
ADD CONSTRAINT "AO_563AEE_TARGET_ENTITY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_575BF5_PROVIDER_ISSUE_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_575BF5_PROVIDER_ISSUE"
ADD CONSTRAINT "AO_575BF5_PROVIDER_ISSUE_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_587B34_PROJECT_CONFIG_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_587B34_PROJECT_CONFIG"
ADD CONSTRAINT "AO_587B34_PROJECT_CONFIG_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_5FB9D7_AOHIP_CHAT_LINK_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_5FB9D7_AOHIP_CHAT_LINK"
ADD CONSTRAINT "AO_5FB9D7_AOHIP_CHAT_LINK_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_5FB9D7_AOHIP_CHAT_USER_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_5FB9D7_AOHIP_CHAT_USER"
ADD CONSTRAINT "AO_5FB9D7_AOHIP_CHAT_USER_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_AUDITENTRY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_AUDITENTRY"
ADD CONSTRAINT "AO_60DB71_AUDITENTRY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_BOARDADMINS_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_BOARDADMINS"
ADD CONSTRAINT "AO_60DB71_BOARDADMINS_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_CARDCOLOR_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_CARDCOLOR"
ADD CONSTRAINT "AO_60DB71_CARDCOLOR_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_CARDLAYOUT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_CARDLAYOUT"
ADD CONSTRAINT "AO_60DB71_CARDLAYOUT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_COLUMNSTATUS_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_COLUMNSTATUS"
ADD CONSTRAINT "AO_60DB71_COLUMNSTATUS_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_COLUMN_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_COLUMN"
ADD CONSTRAINT "AO_60DB71_COLUMN_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_DETAILVIEWFIELD_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_DETAILVIEWFIELD"
ADD CONSTRAINT "AO_60DB71_DETAILVIEWFIELD_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_ESTIMATESTATISTIC_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_ESTIMATESTATISTIC"
ADD CONSTRAINT "AO_60DB71_ESTIMATESTATISTIC_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_ISSUERANKINGLOG_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_ISSUERANKINGLOG"
ADD CONSTRAINT "AO_60DB71_ISSUERANKINGLOG_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_ISSUERANKING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_ISSUERANKING"
ADD CONSTRAINT "AO_60DB71_ISSUERANKING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_LEXORANKBALANCER_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_LEXORANKBALANCER"
ADD CONSTRAINT "AO_60DB71_LEXORANKBALANCER_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_LEXORANK_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_LEXORANK"
ADD CONSTRAINT "AO_60DB71_LEXORANK_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_NONWORKINGDAY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_NONWORKINGDAY"
ADD CONSTRAINT "AO_60DB71_NONWORKINGDAY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_QUICKFILTER_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_QUICKFILTER"
ADD CONSTRAINT "AO_60DB71_QUICKFILTER_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_RANKABLEOBJECT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_RANKABLEOBJECT"
ADD CONSTRAINT "AO_60DB71_RANKABLEOBJECT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_RANK_ISSUE_LINK_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_RANK_ISSUE_LINK"
ADD CONSTRAINT "AO_60DB71_RANK_ISSUE_LINK_pkey" PRIMARY KEY ("ISSUE_ID");


--
-- Name: AO_60DB71_RAPIDVIEW_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_RAPIDVIEW"
ADD CONSTRAINT "AO_60DB71_RAPIDVIEW_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_SPRINTMARKER_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_SPRINTMARKER"
ADD CONSTRAINT "AO_60DB71_SPRINTMARKER_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_SPRINT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_SPRINT"
ADD CONSTRAINT "AO_60DB71_SPRINT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_STATSFIELD_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_STATSFIELD"
ADD CONSTRAINT "AO_60DB71_STATSFIELD_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_SUBQUERY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_SUBQUERY"
ADD CONSTRAINT "AO_60DB71_SUBQUERY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_SWIMLANE_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_SWIMLANE"
ADD CONSTRAINT "AO_60DB71_SWIMLANE_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_TRACKINGSTATISTIC_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_TRACKINGSTATISTIC"
ADD CONSTRAINT "AO_60DB71_TRACKINGSTATISTIC_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_VERSION_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_VERSION"
ADD CONSTRAINT "AO_60DB71_VERSION_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_60DB71_WORKINGDAYS_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_60DB71_WORKINGDAYS"
ADD CONSTRAINT "AO_60DB71_WORKINGDAYS_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_97EDAB_USERINVITATION_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_97EDAB_USERINVITATION"
ADD CONSTRAINT "AO_97EDAB_USERINVITATION_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_A0B856_WEB_HOOK_LISTENER_AO_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_A0B856_WEB_HOOK_LISTENER_AO"
ADD CONSTRAINT "AO_A0B856_WEB_HOOK_LISTENER_AO_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_A44657_HEALTH_CHECK_ENTITY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_A44657_HEALTH_CHECK_ENTITY"
ADD CONSTRAINT "AO_A44657_HEALTH_CHECK_ENTITY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_B9A0F0_APPLIED_TEMPLATE_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_B9A0F0_APPLIED_TEMPLATE"
ADD CONSTRAINT "AO_B9A0F0_APPLIED_TEMPLATE_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_CFF990_AOTRANSITION_FAILURE_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_CFF990_AOTRANSITION_FAILURE"
ADD CONSTRAINT "AO_CFF990_AOTRANSITION_FAILURE_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_DEB285_BLOG_AO_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_DEB285_BLOG_AO"
ADD CONSTRAINT "AO_DEB285_BLOG_AO_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_DEB285_COMMENT_AO_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_DEB285_COMMENT_AO"
ADD CONSTRAINT "AO_DEB285_COMMENT_AO_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_BRANCH_HEAD_MAPPING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_BRANCH_HEAD_MAPPING"
ADD CONSTRAINT "AO_E8B6CC_BRANCH_HEAD_MAPPING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_BRANCH_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_BRANCH"
ADD CONSTRAINT "AO_E8B6CC_BRANCH_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_CHANGESET_MAPPING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_CHANGESET_MAPPING"
ADD CONSTRAINT "AO_E8B6CC_CHANGESET_MAPPING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_COMMIT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_COMMIT"
ADD CONSTRAINT "AO_E8B6CC_COMMIT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_GIT_HUB_EVENT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_GIT_HUB_EVENT"
ADD CONSTRAINT "AO_E8B6CC_GIT_HUB_EVENT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_ISSUE_MAPPING_V2_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_MAPPING_V2"
ADD CONSTRAINT "AO_E8B6CC_ISSUE_MAPPING_V2_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_ISSUE_MAPPING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_MAPPING"
ADD CONSTRAINT "AO_E8B6CC_ISSUE_MAPPING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_ISSUE_TO_BRANCH_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_TO_BRANCH"
ADD CONSTRAINT "AO_E8B6CC_ISSUE_TO_BRANCH_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_ISSUE_TO_CHANGESET_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_TO_CHANGESET"
ADD CONSTRAINT "AO_E8B6CC_ISSUE_TO_CHANGESET_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_MESSAGE_QUEUE_ITEM_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE_QUEUE_ITEM"
ADD CONSTRAINT "AO_E8B6CC_MESSAGE_QUEUE_ITEM_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_MESSAGE_TAG_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE_TAG"
ADD CONSTRAINT "AO_E8B6CC_MESSAGE_TAG_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_MESSAGE_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE"
ADD CONSTRAINT "AO_E8B6CC_MESSAGE_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_ORGANIZATION_MAPPING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_ORGANIZATION_MAPPING"
ADD CONSTRAINT "AO_E8B6CC_ORGANIZATION_MAPPING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_PROJECT_MAPPING_V2_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_PROJECT_MAPPING_V2"
ADD CONSTRAINT "AO_E8B6CC_PROJECT_MAPPING_V2_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_PROJECT_MAPPING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_PROJECT_MAPPING"
ADD CONSTRAINT "AO_E8B6CC_PROJECT_MAPPING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_PR_ISSUE_KEY_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_PR_ISSUE_KEY"
ADD CONSTRAINT "AO_E8B6CC_PR_ISSUE_KEY_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_PR_PARTICIPANT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_PR_PARTICIPANT"
ADD CONSTRAINT "AO_E8B6CC_PR_PARTICIPANT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_PR_TO_COMMIT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_PR_TO_COMMIT"
ADD CONSTRAINT "AO_E8B6CC_PR_TO_COMMIT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_PULL_REQUEST_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_PULL_REQUEST"
ADD CONSTRAINT "AO_E8B6CC_PULL_REQUEST_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_REPOSITORY_MAPPING_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_REPOSITORY_MAPPING"
ADD CONSTRAINT "AO_E8B6CC_REPOSITORY_MAPPING_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_REPO_TO_CHANGESET_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_REPO_TO_CHANGESET"
ADD CONSTRAINT "AO_E8B6CC_REPO_TO_CHANGESET_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_REPO_TO_PROJECT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_REPO_TO_PROJECT"
ADD CONSTRAINT "AO_E8B6CC_REPO_TO_PROJECT_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_SYNC_AUDIT_LOG_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_SYNC_AUDIT_LOG"
ADD CONSTRAINT "AO_E8B6CC_SYNC_AUDIT_LOG_pkey" PRIMARY KEY ("ID");


--
-- Name: AO_E8B6CC_SYNC_EVENT_pkey; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_E8B6CC_SYNC_EVENT"
ADD CONSTRAINT "AO_E8B6CC_SYNC_EVENT_pkey" PRIMARY KEY ("ID");


--
-- Name: pk_app_user; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY app_user
ADD CONSTRAINT pk_app_user PRIMARY KEY (id);


--
-- Name: pk_audit_changed_value; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY audit_changed_value
ADD CONSTRAINT pk_audit_changed_value PRIMARY KEY (id);


--
-- Name: pk_audit_item; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY audit_item
ADD CONSTRAINT pk_audit_item PRIMARY KEY (id);


--
-- Name: pk_audit_log; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY audit_log
ADD CONSTRAINT pk_audit_log PRIMARY KEY (id);


--
-- Name: pk_avatar; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY avatar
ADD CONSTRAINT pk_avatar PRIMARY KEY (id);


--
-- Name: pk_changegroup; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY changegroup
ADD CONSTRAINT pk_changegroup PRIMARY KEY (id);


--
-- Name: pk_changeitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY changeitem
ADD CONSTRAINT pk_changeitem PRIMARY KEY (id);


--
-- Name: pk_clusteredjob; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY clusteredjob
ADD CONSTRAINT pk_clusteredjob PRIMARY KEY (id);


--
-- Name: pk_clusterlockstatus; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY clusterlockstatus
ADD CONSTRAINT pk_clusterlockstatus PRIMARY KEY (id);


--
-- Name: pk_clustermessage; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY clustermessage
ADD CONSTRAINT pk_clustermessage PRIMARY KEY (id);


--
-- Name: pk_clusternode; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY clusternode
ADD CONSTRAINT pk_clusternode PRIMARY KEY (node_id);


--
-- Name: pk_clusternodeheartbeat; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY clusternodeheartbeat
ADD CONSTRAINT pk_clusternodeheartbeat PRIMARY KEY (node_id);


--
-- Name: pk_columnlayout; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY columnlayout
ADD CONSTRAINT pk_columnlayout PRIMARY KEY (id);


--
-- Name: pk_columnlayoutitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY columnlayoutitem
ADD CONSTRAINT pk_columnlayoutitem PRIMARY KEY (id);


--
-- Name: pk_component; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY component
ADD CONSTRAINT pk_component PRIMARY KEY (id);


--
-- Name: pk_configurationcontext; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY configurationcontext
ADD CONSTRAINT pk_configurationcontext PRIMARY KEY (id);


--
-- Name: pk_customfield; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY customfield
ADD CONSTRAINT pk_customfield PRIMARY KEY (id);


--
-- Name: pk_customfieldoption; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY customfieldoption
ADD CONSTRAINT pk_customfieldoption PRIMARY KEY (id);


--
-- Name: pk_customfieldvalue; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY customfieldvalue
ADD CONSTRAINT pk_customfieldvalue PRIMARY KEY (id);


--
-- Name: pk_cwd_application; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_application
ADD CONSTRAINT pk_cwd_application PRIMARY KEY (id);


--
-- Name: pk_cwd_application_address; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_application_address
ADD CONSTRAINT pk_cwd_application_address PRIMARY KEY (application_id, remote_address);


--
-- Name: pk_cwd_directory; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_directory
ADD CONSTRAINT pk_cwd_directory PRIMARY KEY (id);


--
-- Name: pk_cwd_directory_attribute; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_directory_attribute
ADD CONSTRAINT pk_cwd_directory_attribute PRIMARY KEY (directory_id, attribute_name);


--
-- Name: pk_cwd_directory_operation; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_directory_operation
ADD CONSTRAINT pk_cwd_directory_operation PRIMARY KEY (directory_id, operation_type);


--
-- Name: pk_cwd_group; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_group
ADD CONSTRAINT pk_cwd_group PRIMARY KEY (id);


--
-- Name: pk_cwd_group_attributes; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_group_attributes
ADD CONSTRAINT pk_cwd_group_attributes PRIMARY KEY (id);


--
-- Name: pk_cwd_membership; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_membership
ADD CONSTRAINT pk_cwd_membership PRIMARY KEY (id);


--
-- Name: pk_cwd_user; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_user
ADD CONSTRAINT pk_cwd_user PRIMARY KEY (id);


--
-- Name: pk_cwd_user_attributes; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY cwd_user_attributes
ADD CONSTRAINT pk_cwd_user_attributes PRIMARY KEY (id);


--
-- Name: pk_draftworkflowscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY draftworkflowscheme
ADD CONSTRAINT pk_draftworkflowscheme PRIMARY KEY (id);


--
-- Name: pk_draftworkflowschemeentity; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY draftworkflowschemeentity
ADD CONSTRAINT pk_draftworkflowschemeentity PRIMARY KEY (id);


--
-- Name: pk_entity_property; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY entity_property
ADD CONSTRAINT pk_entity_property PRIMARY KEY (id);


--
-- Name: pk_entity_property_index_docum; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY entity_property_index_document
ADD CONSTRAINT pk_entity_property_index_docum PRIMARY KEY (id);


--
-- Name: pk_external_entities; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY external_entities
ADD CONSTRAINT pk_external_entities PRIMARY KEY (id);


--
-- Name: pk_externalgadget; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY externalgadget
ADD CONSTRAINT pk_externalgadget PRIMARY KEY (id);


--
-- Name: pk_favouriteassociations; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY favouriteassociations
ADD CONSTRAINT pk_favouriteassociations PRIMARY KEY (id);


--
-- Name: pk_feature; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY feature
ADD CONSTRAINT pk_feature PRIMARY KEY (id);


--
-- Name: pk_fieldconfigscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldconfigscheme
ADD CONSTRAINT pk_fieldconfigscheme PRIMARY KEY (id);


--
-- Name: pk_fieldconfigschemeissuetype; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldconfigschemeissuetype
ADD CONSTRAINT pk_fieldconfigschemeissuetype PRIMARY KEY (id);


--
-- Name: pk_fieldconfiguration; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldconfiguration
ADD CONSTRAINT pk_fieldconfiguration PRIMARY KEY (id);


--
-- Name: pk_fieldlayout; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldlayout
ADD CONSTRAINT pk_fieldlayout PRIMARY KEY (id);


--
-- Name: pk_fieldlayoutitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldlayoutitem
ADD CONSTRAINT pk_fieldlayoutitem PRIMARY KEY (id);


--
-- Name: pk_fieldlayoutscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldlayoutscheme
ADD CONSTRAINT pk_fieldlayoutscheme PRIMARY KEY (id);


--
-- Name: pk_fieldlayoutschemeassociatio; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldlayoutschemeassociation
ADD CONSTRAINT pk_fieldlayoutschemeassociatio PRIMARY KEY (id);


--
-- Name: pk_fieldlayoutschemeentity; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldlayoutschemeentity
ADD CONSTRAINT pk_fieldlayoutschemeentity PRIMARY KEY (id);


--
-- Name: pk_fieldscreen; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldscreen
ADD CONSTRAINT pk_fieldscreen PRIMARY KEY (id);


--
-- Name: pk_fieldscreenlayoutitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldscreenlayoutitem
ADD CONSTRAINT pk_fieldscreenlayoutitem PRIMARY KEY (id);


--
-- Name: pk_fieldscreenscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldscreenscheme
ADD CONSTRAINT pk_fieldscreenscheme PRIMARY KEY (id);


--
-- Name: pk_fieldscreenschemeitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldscreenschemeitem
ADD CONSTRAINT pk_fieldscreenschemeitem PRIMARY KEY (id);


--
-- Name: pk_fieldscreentab; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fieldscreentab
ADD CONSTRAINT pk_fieldscreentab PRIMARY KEY (id);


--
-- Name: pk_fileattachment; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY fileattachment
ADD CONSTRAINT pk_fileattachment PRIMARY KEY (id);


--
-- Name: pk_filtersubscription; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY filtersubscription
ADD CONSTRAINT pk_filtersubscription PRIMARY KEY (id);


--
-- Name: pk_gadgetuserpreference; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY gadgetuserpreference
ADD CONSTRAINT pk_gadgetuserpreference PRIMARY KEY (id);


--
-- Name: pk_genericconfiguration; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY genericconfiguration
ADD CONSTRAINT pk_genericconfiguration PRIMARY KEY (id);


--
-- Name: pk_globalpermissionentry; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY globalpermissionentry
ADD CONSTRAINT pk_globalpermissionentry PRIMARY KEY (id);


--
-- Name: pk_groupbase; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY groupbase
ADD CONSTRAINT pk_groupbase PRIMARY KEY (id);


--
-- Name: pk_issuelink; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuelink
ADD CONSTRAINT pk_issuelink PRIMARY KEY (id);


--
-- Name: pk_issuelinktype; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuelinktype
ADD CONSTRAINT pk_issuelinktype PRIMARY KEY (id);


--
-- Name: pk_issuesecurityscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuesecurityscheme
ADD CONSTRAINT pk_issuesecurityscheme PRIMARY KEY (id);


--
-- Name: pk_issuestatus; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuestatus
ADD CONSTRAINT pk_issuestatus PRIMARY KEY (id);


--
-- Name: pk_issuetype; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuetype
ADD CONSTRAINT pk_issuetype PRIMARY KEY (id);


--
-- Name: pk_issuetypescreenscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuetypescreenscheme
ADD CONSTRAINT pk_issuetypescreenscheme PRIMARY KEY (id);


--
-- Name: pk_issuetypescreenschemeentity; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY issuetypescreenschemeentity
ADD CONSTRAINT pk_issuetypescreenschemeentity PRIMARY KEY (id);


--
-- Name: pk_jiraaction; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jiraaction
ADD CONSTRAINT pk_jiraaction PRIMARY KEY (id);


--
-- Name: pk_jiradraftworkflows; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jiradraftworkflows
ADD CONSTRAINT pk_jiradraftworkflows PRIMARY KEY (id);


--
-- Name: pk_jiraeventtype; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jiraeventtype
ADD CONSTRAINT pk_jiraeventtype PRIMARY KEY (id);


--
-- Name: pk_jiraissue; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jiraissue
ADD CONSTRAINT pk_jiraissue PRIMARY KEY (id);


--
-- Name: pk_jiraperms; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jiraperms
ADD CONSTRAINT pk_jiraperms PRIMARY KEY (id);


--
-- Name: pk_jiraworkflows; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jiraworkflows
ADD CONSTRAINT pk_jiraworkflows PRIMARY KEY (id);


--
-- Name: pk_jquartz_blob_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_blob_triggers
ADD CONSTRAINT pk_jquartz_blob_triggers PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: pk_jquartz_calendars; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_calendars
ADD CONSTRAINT pk_jquartz_calendars PRIMARY KEY (calendar_name);


--
-- Name: pk_jquartz_cron_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_cron_triggers
ADD CONSTRAINT pk_jquartz_cron_triggers PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: pk_jquartz_fired_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_fired_triggers
ADD CONSTRAINT pk_jquartz_fired_triggers PRIMARY KEY (entry_id);


--
-- Name: pk_jquartz_job_details; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_job_details
ADD CONSTRAINT pk_jquartz_job_details PRIMARY KEY (job_name, job_group);


--
-- Name: pk_jquartz_job_listeners; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_job_listeners
ADD CONSTRAINT pk_jquartz_job_listeners PRIMARY KEY (job_name, job_group, job_listener);


--
-- Name: pk_jquartz_locks; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_locks
ADD CONSTRAINT pk_jquartz_locks PRIMARY KEY (lock_name);


--
-- Name: pk_jquartz_paused_trigger_grps; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_paused_trigger_grps
ADD CONSTRAINT pk_jquartz_paused_trigger_grps PRIMARY KEY (trigger_group);


--
-- Name: pk_jquartz_scheduler_state; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_scheduler_state
ADD CONSTRAINT pk_jquartz_scheduler_state PRIMARY KEY (instance_name);


--
-- Name: pk_jquartz_simple_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_simple_triggers
ADD CONSTRAINT pk_jquartz_simple_triggers PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: pk_jquartz_simprop_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_simprop_triggers
ADD CONSTRAINT pk_jquartz_simprop_triggers PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: pk_jquartz_trigger_listeners; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_trigger_listeners
ADD CONSTRAINT pk_jquartz_trigger_listeners PRIMARY KEY (trigger_group, trigger_listener);


--
-- Name: pk_jquartz_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY jquartz_triggers
ADD CONSTRAINT pk_jquartz_triggers PRIMARY KEY (trigger_name, trigger_group);


--
-- Name: pk_label; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY label
ADD CONSTRAINT pk_label PRIMARY KEY (id);


--
-- Name: pk_licenserolesdefault; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY licenserolesdefault
ADD CONSTRAINT pk_licenserolesdefault PRIMARY KEY (id);


--
-- Name: pk_licenserolesgroup; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY licenserolesgroup
ADD CONSTRAINT pk_licenserolesgroup PRIMARY KEY (id);


--
-- Name: pk_listenerconfig; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY listenerconfig
ADD CONSTRAINT pk_listenerconfig PRIMARY KEY (id);


--
-- Name: pk_mailserver; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY mailserver
ADD CONSTRAINT pk_mailserver PRIMARY KEY (id);


--
-- Name: pk_managedconfigurationitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY managedconfigurationitem
ADD CONSTRAINT pk_managedconfigurationitem PRIMARY KEY (id);


--
-- Name: pk_membershipbase; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY membershipbase
ADD CONSTRAINT pk_membershipbase PRIMARY KEY (id);


--
-- Name: pk_moved_issue_key; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY moved_issue_key
ADD CONSTRAINT pk_moved_issue_key PRIMARY KEY (id);


--
-- Name: pk_nodeassociation; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY nodeassociation
ADD CONSTRAINT pk_nodeassociation PRIMARY KEY (source_node_id, source_node_entity, sink_node_id, sink_node_entity, association_type);


--
-- Name: pk_nodeindexcounter; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY nodeindexcounter
ADD CONSTRAINT pk_nodeindexcounter PRIMARY KEY (id);


--
-- Name: pk_notification; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY notification
ADD CONSTRAINT pk_notification PRIMARY KEY (id);


--
-- Name: pk_notificationinstance; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY notificationinstance
ADD CONSTRAINT pk_notificationinstance PRIMARY KEY (id);


--
-- Name: pk_notificationscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY notificationscheme
ADD CONSTRAINT pk_notificationscheme PRIMARY KEY (id);


--
-- Name: pk_oauthconsumer; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY oauthconsumer
ADD CONSTRAINT pk_oauthconsumer PRIMARY KEY (id);


--
-- Name: pk_oauthconsumertoken; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY oauthconsumertoken
ADD CONSTRAINT pk_oauthconsumertoken PRIMARY KEY (id);


--
-- Name: pk_oauthspconsumer; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY oauthspconsumer
ADD CONSTRAINT pk_oauthspconsumer PRIMARY KEY (id);


--
-- Name: pk_oauthsptoken; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY oauthsptoken
ADD CONSTRAINT pk_oauthsptoken PRIMARY KEY (id);


--
-- Name: pk_optionconfiguration; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY optionconfiguration
ADD CONSTRAINT pk_optionconfiguration PRIMARY KEY (id);


--
-- Name: pk_os_currentstep; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY os_currentstep
ADD CONSTRAINT pk_os_currentstep PRIMARY KEY (id);


--
-- Name: pk_os_currentstep_prev; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY os_currentstep_prev
ADD CONSTRAINT pk_os_currentstep_prev PRIMARY KEY (id, previous_id);


--
-- Name: pk_os_historystep; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY os_historystep
ADD CONSTRAINT pk_os_historystep PRIMARY KEY (id);


--
-- Name: pk_os_historystep_prev; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY os_historystep_prev
ADD CONSTRAINT pk_os_historystep_prev PRIMARY KEY (id, previous_id);


--
-- Name: pk_os_wfentry; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY os_wfentry
ADD CONSTRAINT pk_os_wfentry PRIMARY KEY (id);


--
-- Name: pk_permissionscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY permissionscheme
ADD CONSTRAINT pk_permissionscheme PRIMARY KEY (id);


--
-- Name: pk_pluginstate; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY pluginstate
ADD CONSTRAINT pk_pluginstate PRIMARY KEY (pluginkey);


--
-- Name: pk_pluginversion; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY pluginversion
ADD CONSTRAINT pk_pluginversion PRIMARY KEY (id);


--
-- Name: pk_portalpage; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY portalpage
ADD CONSTRAINT pk_portalpage PRIMARY KEY (id);


--
-- Name: pk_portletconfiguration; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY portletconfiguration
ADD CONSTRAINT pk_portletconfiguration PRIMARY KEY (id);


--
-- Name: pk_priority; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY priority
ADD CONSTRAINT pk_priority PRIMARY KEY (id);


--
-- Name: pk_productlicense; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY productlicense
ADD CONSTRAINT pk_productlicense PRIMARY KEY (id);


--
-- Name: pk_project; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY project
ADD CONSTRAINT pk_project PRIMARY KEY (id);


--
-- Name: pk_project_key; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY project_key
ADD CONSTRAINT pk_project_key PRIMARY KEY (id);


--
-- Name: pk_projectcategory; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY projectcategory
ADD CONSTRAINT pk_projectcategory PRIMARY KEY (id);


--
-- Name: pk_projectrole; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY projectrole
ADD CONSTRAINT pk_projectrole PRIMARY KEY (id);


--
-- Name: pk_projectroleactor; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY projectroleactor
ADD CONSTRAINT pk_projectroleactor PRIMARY KEY (id);


--
-- Name: pk_projectversion; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY projectversion
ADD CONSTRAINT pk_projectversion PRIMARY KEY (id);


--
-- Name: pk_propertydata; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertydata
ADD CONSTRAINT pk_propertydata PRIMARY KEY (id);


--
-- Name: pk_propertydate; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertydate
ADD CONSTRAINT pk_propertydate PRIMARY KEY (id);


--
-- Name: pk_propertydecimal; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertydecimal
ADD CONSTRAINT pk_propertydecimal PRIMARY KEY (id);


--
-- Name: pk_propertyentry; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertyentry
ADD CONSTRAINT pk_propertyentry PRIMARY KEY (id);


--
-- Name: pk_propertynumber; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertynumber
ADD CONSTRAINT pk_propertynumber PRIMARY KEY (id);


--
-- Name: pk_propertystring; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertystring
ADD CONSTRAINT pk_propertystring PRIMARY KEY (id);


--
-- Name: pk_propertytext; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY propertytext
ADD CONSTRAINT pk_propertytext PRIMARY KEY (id);


--
-- Name: pk_qrtz_calendars; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_calendars
ADD CONSTRAINT pk_qrtz_calendars PRIMARY KEY (calendar_name);


--
-- Name: pk_qrtz_cron_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_cron_triggers
ADD CONSTRAINT pk_qrtz_cron_triggers PRIMARY KEY (id);


--
-- Name: pk_qrtz_fired_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_fired_triggers
ADD CONSTRAINT pk_qrtz_fired_triggers PRIMARY KEY (entry_id);


--
-- Name: pk_qrtz_job_details; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_job_details
ADD CONSTRAINT pk_qrtz_job_details PRIMARY KEY (id);


--
-- Name: pk_qrtz_job_listeners; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_job_listeners
ADD CONSTRAINT pk_qrtz_job_listeners PRIMARY KEY (id);


--
-- Name: pk_qrtz_simple_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_simple_triggers
ADD CONSTRAINT pk_qrtz_simple_triggers PRIMARY KEY (id);


--
-- Name: pk_qrtz_trigger_listeners; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_trigger_listeners
ADD CONSTRAINT pk_qrtz_trigger_listeners PRIMARY KEY (id);


--
-- Name: pk_qrtz_triggers; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY qrtz_triggers
ADD CONSTRAINT pk_qrtz_triggers PRIMARY KEY (id);


--
-- Name: pk_reindex_component; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY reindex_component
ADD CONSTRAINT pk_reindex_component PRIMARY KEY (id);


--
-- Name: pk_reindex_request; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY reindex_request
ADD CONSTRAINT pk_reindex_request PRIMARY KEY (id);


--
-- Name: pk_remembermetoken; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY remembermetoken
ADD CONSTRAINT pk_remembermetoken PRIMARY KEY (id);


--
-- Name: pk_remotelink; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY remotelink
ADD CONSTRAINT pk_remotelink PRIMARY KEY (id);


--
-- Name: pk_replicatedindexoperation; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY replicatedindexoperation
ADD CONSTRAINT pk_replicatedindexoperation PRIMARY KEY (id);


--
-- Name: pk_resolution; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY resolution
ADD CONSTRAINT pk_resolution PRIMARY KEY (id);


--
-- Name: pk_rundetails; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY rundetails
ADD CONSTRAINT pk_rundetails PRIMARY KEY (id);


--
-- Name: pk_schemeissuesecurities; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY schemeissuesecurities
ADD CONSTRAINT pk_schemeissuesecurities PRIMARY KEY (id);


--
-- Name: pk_schemeissuesecuritylevels; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY schemeissuesecuritylevels
ADD CONSTRAINT pk_schemeissuesecuritylevels PRIMARY KEY (id);


--
-- Name: pk_schemepermissions; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY schemepermissions
ADD CONSTRAINT pk_schemepermissions PRIMARY KEY (id);


--
-- Name: pk_searchrequest; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY searchrequest
ADD CONSTRAINT pk_searchrequest PRIMARY KEY (id);


--
-- Name: pk_sequence_value_item; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY sequence_value_item
ADD CONSTRAINT pk_sequence_value_item PRIMARY KEY (seq_name);


--
-- Name: pk_serviceconfig; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY serviceconfig
ADD CONSTRAINT pk_serviceconfig PRIMARY KEY (id);


--
-- Name: pk_sharepermissions; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY sharepermissions
ADD CONSTRAINT pk_sharepermissions PRIMARY KEY (id);


--
-- Name: pk_trackback_ping; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY trackback_ping
ADD CONSTRAINT pk_trackback_ping PRIMARY KEY (id);


--
-- Name: pk_trustedapp; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY trustedapp
ADD CONSTRAINT pk_trustedapp PRIMARY KEY (id);


--
-- Name: pk_upgradehistory; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY upgradehistory
ADD CONSTRAINT pk_upgradehistory PRIMARY KEY (upgradeclass);


--
-- Name: pk_upgradeversionhistory; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY upgradeversionhistory
ADD CONSTRAINT pk_upgradeversionhistory PRIMARY KEY (targetbuild);


--
-- Name: pk_userassociation; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY userassociation
ADD CONSTRAINT pk_userassociation PRIMARY KEY (source_name, sink_node_id, sink_node_entity, association_type);


--
-- Name: pk_userbase; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY userbase
ADD CONSTRAINT pk_userbase PRIMARY KEY (id);


--
-- Name: pk_userhistoryitem; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY userhistoryitem
ADD CONSTRAINT pk_userhistoryitem PRIMARY KEY (id);


--
-- Name: pk_userpickerfilter; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY userpickerfilter
ADD CONSTRAINT pk_userpickerfilter PRIMARY KEY (id);


--
-- Name: pk_userpickerfiltergroup; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY userpickerfiltergroup
ADD CONSTRAINT pk_userpickerfiltergroup PRIMARY KEY (id);


--
-- Name: pk_userpickerfilterrole; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY userpickerfilterrole
ADD CONSTRAINT pk_userpickerfilterrole PRIMARY KEY (id);


--
-- Name: pk_versioncontrol; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY versioncontrol
ADD CONSTRAINT pk_versioncontrol PRIMARY KEY (id);


--
-- Name: pk_votehistory; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY votehistory
ADD CONSTRAINT pk_votehistory PRIMARY KEY (id);


--
-- Name: pk_workflowscheme; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY workflowscheme
ADD CONSTRAINT pk_workflowscheme PRIMARY KEY (id);


--
-- Name: pk_workflowschemeentity; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY workflowschemeentity
ADD CONSTRAINT pk_workflowschemeentity PRIMARY KEY (id);


--
-- Name: pk_worklog; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY worklog
ADD CONSTRAINT pk_worklog PRIMARY KEY (id);


--
-- Name: u_ao_587b34_project2070954277; Type: CONSTRAINT; Schema: public; Owner: jirauser2; Tablespace:
--

ALTER TABLE ONLY "AO_587B34_PROJECT_CONFIG"
ADD CONSTRAINT u_ao_587b34_project2070954277 UNIQUE ("NAME_UNIQUE_CONSTRAINT");


--
-- Name: action_author_created; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX action_author_created ON jiraaction USING btree (author, created);


--
-- Name: action_issue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX action_issue ON jiraaction USING btree (issueid);


--
-- Name: attach_issue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX attach_issue ON fileattachment USING btree (issueid);


--
-- Name: avatar_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX avatar_index ON avatar USING btree (avatartype, owner);


--
-- Name: cf_cfoption; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX cf_cfoption ON customfieldoption USING btree (customfield);


--
-- Name: cf_userpickerfiltergroup; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX cf_userpickerfiltergroup ON userpickerfiltergroup USING btree (userpickerfilter);


--
-- Name: cf_userpickerfilterrole; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX cf_userpickerfilterrole ON userpickerfilterrole USING btree (userpickerfilter);


--
-- Name: cfvalue_issue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX cfvalue_issue ON customfieldvalue USING btree (issue, customfield);


--
-- Name: chggroup_author_created; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX chggroup_author_created ON changegroup USING btree (author, created);


--
-- Name: chggroup_issue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX chggroup_issue ON changegroup USING btree (issueid);


--
-- Name: chgitem_chggrp; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX chgitem_chggrp ON changeitem USING btree (groupid);


--
-- Name: chgitem_field; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX chgitem_field ON changeitem USING btree (field);


--
-- Name: cl_searchrequest; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX cl_searchrequest ON columnlayout USING btree (searchrequest);


--
-- Name: cl_username; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX cl_username ON columnlayout USING btree (username);


--
-- Name: cluster_lock_name_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX cluster_lock_name_idx ON clusterlockstatus USING btree (lock_name);


--
-- Name: clusteredjob_jobid_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX clusteredjob_jobid_idx ON clusteredjob USING btree (job_id);


--
-- Name: clusteredjob_jrk_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX clusteredjob_jrk_idx ON clusteredjob USING btree (job_runner_key);


--
-- Name: clusteredjob_nextrun_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX clusteredjob_nextrun_idx ON clusteredjob USING btree (next_run);


--
-- Name: confcontext; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX confcontext ON configurationcontext USING btree (projectcategory, project, customfield);


--
-- Name: confcontextfieldconfigscheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX confcontextfieldconfigscheme ON configurationcontext USING btree (fieldconfigscheme);


--
-- Name: confcontextprojectkey; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX confcontextprojectkey ON configurationcontext USING btree (project, customfield);


--
-- Name: draft_workflow_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX draft_workflow_scheme ON draftworkflowschemeentity USING btree (scheme);


--
-- Name: draft_workflow_scheme_parent; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX draft_workflow_scheme_parent ON draftworkflowscheme USING btree (workflow_scheme_id);


--
-- Name: entityproperty_entity; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX entityproperty_entity ON entity_property USING btree (entity_name, entity_id);


--
-- Name: entityproperty_key; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX entityproperty_key ON entity_property USING btree (property_key);


--
-- Name: entpropindexdoc_module; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX entpropindexdoc_module ON entity_property_index_document USING btree (plugin_key, module_key);


--
-- Name: ext_entity_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX ext_entity_name ON external_entities USING btree (name);


--
-- Name: favourite_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX favourite_index ON favouriteassociations USING btree (username, entitytype, entityid);


--
-- Name: fc_fieldid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fc_fieldid ON fieldconfiguration USING btree (fieldid);


--
-- Name: fcs_fieldid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fcs_fieldid ON fieldconfigscheme USING btree (fieldid);


--
-- Name: fcs_issuetype; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fcs_issuetype ON fieldconfigschemeissuetype USING btree (issuetype);


--
-- Name: fcs_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fcs_scheme ON fieldconfigschemeissuetype USING btree (fieldconfigscheme);


--
-- Name: feature_id_userkey; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX feature_id_userkey ON feature USING btree (id, user_key);


--
-- Name: fieldid_fieldconf; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldid_fieldconf ON optionconfiguration USING btree (fieldid, fieldconfig);


--
-- Name: fieldid_optionid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldid_optionid ON optionconfiguration USING btree (fieldid, optionid);


--
-- Name: fieldlayout_layout; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldlayout_layout ON fieldlayoutschemeentity USING btree (fieldlayout);


--
-- Name: fieldlayout_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldlayout_scheme ON fieldlayoutschemeentity USING btree (scheme);


--
-- Name: fieldscitem_tab; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldscitem_tab ON fieldscreenlayoutitem USING btree (fieldscreentab);


--
-- Name: fieldscreen_field; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldscreen_field ON fieldscreenlayoutitem USING btree (fieldidentifier);


--
-- Name: fieldscreen_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldscreen_scheme ON issuetypescreenschemeentity USING btree (fieldscreenscheme);


--
-- Name: fieldscreen_tab; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fieldscreen_tab ON fieldscreentab USING btree (fieldscreen);


--
-- Name: fl_scheme_assoc; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX fl_scheme_assoc ON fieldlayoutschemeassociation USING btree (project, issuetype);


--
-- Name: historystep_entryid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX historystep_entryid ON os_historystep USING btree (entry_id);


--
-- Name: idx_all_project_ids; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_all_project_ids ON project_key USING btree (project_id);


--
-- Name: idx_all_project_keys; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX idx_all_project_keys ON project_key USING btree (project_key);


--
-- Name: idx_audit_item_log_id2; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_audit_item_log_id2 ON audit_item USING btree (log_id);


--
-- Name: idx_audit_log_created; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_audit_log_created ON audit_log USING btree (created);


--
-- Name: idx_changed_value_log_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_changed_value_log_id ON audit_changed_value USING btree (log_id);


--
-- Name: idx_cli_fieldidentifier; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_cli_fieldidentifier ON columnlayoutitem USING btree (fieldidentifier);


--
-- Name: idx_component_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_component_name ON component USING btree (cname);


--
-- Name: idx_component_project; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_component_project ON component USING btree (project);


--
-- Name: idx_directory_active; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_directory_active ON cwd_directory USING btree (active);


--
-- Name: idx_directory_impl; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_directory_impl ON cwd_directory USING btree (lower_impl_class);


--
-- Name: idx_directory_type; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_directory_type ON cwd_directory USING btree (directory_type);


--
-- Name: idx_display_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_display_name ON cwd_user USING btree (lower_display_name);


--
-- Name: idx_email_address; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_email_address ON cwd_user USING btree (lower_email_address);


--
-- Name: idx_first_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_first_name ON cwd_user USING btree (lower_first_name);


--
-- Name: idx_fli_fieldidentifier; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_fli_fieldidentifier ON fieldlayoutitem USING btree (fieldidentifier);


--
-- Name: idx_group_active; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_group_active ON cwd_group USING btree (lower_group_name, active);


--
-- Name: idx_group_attr_dir_name_lval; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_group_attr_dir_name_lval ON cwd_group_attributes USING btree (directory_id, attribute_name, lower_attribute_value);


--
-- Name: idx_group_dir_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_group_dir_id ON cwd_group USING btree (directory_id);


--
-- Name: idx_last_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_last_name ON cwd_user USING btree (lower_last_name);


--
-- Name: idx_mem_dir_child; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_mem_dir_child ON cwd_membership USING btree (lower_child_name, membership_type, directory_id);


--
-- Name: idx_mem_dir_parent; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_mem_dir_parent ON cwd_membership USING btree (lower_parent_name, membership_type, directory_id);


--
-- Name: idx_mem_dir_parent_child; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_mem_dir_parent_child ON cwd_membership USING btree (lower_parent_name, lower_child_name, membership_type, directory_id);


--
-- Name: idx_old_issue_key; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX idx_old_issue_key ON moved_issue_key USING btree (old_issue_key);


--
-- Name: idx_project_category_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_project_category_name ON projectcategory USING btree (cname);


--
-- Name: idx_project_key; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX idx_project_key ON project USING btree (pkey);


--
-- Name: idx_qrtz_ft_inst_job_req_rcvry; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_ft_inst_job_req_rcvry ON jquartz_fired_triggers USING btree (sched_name, instance_name, requests_recovery);


--
-- Name: idx_qrtz_ft_j_g; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_ft_j_g ON jquartz_fired_triggers USING btree (sched_name, job_name, job_group);


--
-- Name: idx_qrtz_ft_jg; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_ft_jg ON jquartz_fired_triggers USING btree (sched_name, job_group);


--
-- Name: idx_qrtz_ft_t_g; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_ft_t_g ON jquartz_fired_triggers USING btree (sched_name, trigger_name, trigger_group);


--
-- Name: idx_qrtz_ft_tg; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_ft_tg ON jquartz_fired_triggers USING btree (sched_name, trigger_group);


--
-- Name: idx_qrtz_ft_trig_inst_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_ft_trig_inst_name ON jquartz_fired_triggers USING btree (sched_name, instance_name);


--
-- Name: idx_qrtz_j_g; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_j_g ON jquartz_triggers USING btree (sched_name, trigger_group);


--
-- Name: idx_qrtz_j_grp; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_j_grp ON jquartz_job_details USING btree (sched_name, job_group);


--
-- Name: idx_qrtz_j_req_recovery; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_j_req_recovery ON jquartz_job_details USING btree (sched_name, requests_recovery);


--
-- Name: idx_qrtz_j_state; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_j_state ON jquartz_triggers USING btree (sched_name, trigger_state);


--
-- Name: idx_qrtz_t_c; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_c ON jquartz_triggers USING btree (sched_name, calendar_name);


--
-- Name: idx_qrtz_t_j; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_j ON jquartz_triggers USING btree (sched_name, job_name, job_group);


--
-- Name: idx_qrtz_t_jg; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_jg ON jquartz_triggers USING btree (sched_name, job_group);


--
-- Name: idx_qrtz_t_n_g_state; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_n_g_state ON jquartz_triggers USING btree (sched_name, trigger_group, trigger_state);


--
-- Name: idx_qrtz_t_n_state; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_n_state ON jquartz_triggers USING btree (sched_name, trigger_name, trigger_group, trigger_state);


--
-- Name: idx_qrtz_t_next_fire_time; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_next_fire_time ON jquartz_triggers USING btree (sched_name, next_fire_time);


--
-- Name: idx_qrtz_t_nft_misfire; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_nft_misfire ON jquartz_triggers USING btree (sched_name, misfire_instr, next_fire_time);


--
-- Name: idx_qrtz_t_nft_st; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_nft_st ON jquartz_triggers USING btree (sched_name, trigger_state, next_fire_time);


--
-- Name: idx_qrtz_t_nft_st_misfire; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_nft_st_misfire ON jquartz_triggers USING btree (sched_name, misfire_instr, next_fire_time, trigger_state);


--
-- Name: idx_qrtz_t_nft_st_misfire_grp; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_qrtz_t_nft_st_misfire_grp ON jquartz_triggers USING btree (sched_name, misfire_instr, next_fire_time, trigger_group, trigger_state);


--
-- Name: idx_reindex_component_req_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_reindex_component_req_id ON reindex_component USING btree (request_id);


--
-- Name: idx_user_attr_dir_name_lval; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_user_attr_dir_name_lval ON cwd_user_attributes USING btree (directory_id, attribute_name, lower_attribute_value);


--
-- Name: idx_version_project; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_version_project ON projectversion USING btree (project);


--
-- Name: idx_version_sequence; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX idx_version_sequence ON projectversion USING btree (sequence);


--
-- Name: index_ao_38321b_cus1828044926; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_38321b_cus1828044926 ON "AO_38321B_CUSTOM_CONTENT_LINK" USING btree ("CONTENT_KEY");


--
-- Name: index_ao_550953_sho1778115994; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_550953_sho1778115994 ON "AO_550953_SHORTCUT" USING btree ("PROJECT_ID");


--
-- Name: index_ao_563aee_act1642652291; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_563aee_act1642652291 ON "AO_563AEE_ACTIVITY_ENTITY" USING btree ("OBJECT_ID");


--
-- Name: index_ao_563aee_act1978295567; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_563aee_act1978295567 ON "AO_563AEE_ACTIVITY_ENTITY" USING btree ("TARGET_ID");


--
-- Name: index_ao_563aee_act972488439; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_563aee_act972488439 ON "AO_563AEE_ACTIVITY_ENTITY" USING btree ("ICON_ID");


--
-- Name: index_ao_563aee_act995325379; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_563aee_act995325379 ON "AO_563AEE_ACTIVITY_ENTITY" USING btree ("ACTOR_ID");


--
-- Name: index_ao_563aee_obj696886343; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_563aee_obj696886343 ON "AO_563AEE_OBJECT_ENTITY" USING btree ("IMAGE_ID");


--
-- Name: index_ao_563aee_tar521440921; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_563aee_tar521440921 ON "AO_563AEE_TARGET_ENTITY" USING btree ("IMAGE_ID");


--
-- Name: index_ao_575bf5_pro1117502689; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_575bf5_pro1117502689 ON "AO_575BF5_PROVIDER_ISSUE" USING btree ("STALE_AFTER");


--
-- Name: index_ao_575bf5_pro1348521624; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_575bf5_pro1348521624 ON "AO_575BF5_PROVIDER_ISSUE" USING btree ("PROVIDER_SOURCE_ID");


--
-- Name: index_ao_575bf5_pro741170824; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_575bf5_pro741170824 ON "AO_575BF5_PROVIDER_ISSUE" USING btree ("ISSUE_ID");


--
-- Name: index_ao_587b34_pro1732672724; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_587b34_pro1732672724 ON "AO_587B34_PROJECT_CONFIG" USING btree ("ROOM_ID");


--
-- Name: index_ao_587b34_pro193829489; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_587b34_pro193829489 ON "AO_587B34_PROJECT_CONFIG" USING btree ("CONFIGURATION_GROUP_ID");


--
-- Name: index_ao_587b34_pro2093917684; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_587b34_pro2093917684 ON "AO_587B34_PROJECT_CONFIG" USING btree ("PROJECT_ID");


--
-- Name: index_ao_587b34_pro2115480362; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_587b34_pro2115480362 ON "AO_587B34_PROJECT_CONFIG" USING btree ("NAME");


--
-- Name: index_ao_5fb9d7_aoh1981563178; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_5fb9d7_aoh1981563178 ON "AO_5FB9D7_AOHIP_CHAT_USER" USING btree ("USER_KEY");


--
-- Name: index_ao_5fb9d7_aoh49772492; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_5fb9d7_aoh49772492 ON "AO_5FB9D7_AOHIP_CHAT_USER" USING btree ("HIP_CHAT_LINK_ID");


--
-- Name: index_ao_60db71_aud137736645; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_aud137736645 ON "AO_60DB71_AUDITENTRY" USING btree ("ENTITY_CLASS");


--
-- Name: index_ao_60db71_aud1756477597; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_aud1756477597 ON "AO_60DB71_AUDITENTRY" USING btree ("CATEGORY");


--
-- Name: index_ao_60db71_aud604788536; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_aud604788536 ON "AO_60DB71_AUDITENTRY" USING btree ("ENTITY_ID");


--
-- Name: index_ao_60db71_boa2110227660; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_boa2110227660 ON "AO_60DB71_BOARDADMINS" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_car149237770; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_car149237770 ON "AO_60DB71_CARDLAYOUT" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_car2031978979; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_car2031978979 ON "AO_60DB71_CARDCOLOR" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_col1856623434; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_col1856623434 ON "AO_60DB71_COLUMNSTATUS" USING btree ("COLUMN_ID");


--
-- Name: index_ao_60db71_col2098611346; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_col2098611346 ON "AO_60DB71_COLUMN" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_det878495474; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_det878495474 ON "AO_60DB71_DETAILVIEWFIELD" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_est1680565966; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_est1680565966 ON "AO_60DB71_ESTIMATESTATISTIC" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_iss1616896230; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_iss1616896230 ON "AO_60DB71_ISSUERANKING" USING btree ("ISSUE_ID");


--
-- Name: index_ao_60db71_iss1786461035; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_iss1786461035 ON "AO_60DB71_ISSUERANKING" USING btree ("CUSTOM_FIELD_ID");


--
-- Name: index_ao_60db71_lex1632828616; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_lex1632828616 ON "AO_60DB71_LEXORANK" USING btree ("LOCK_HASH");


--
-- Name: index_ao_60db71_lex604083109; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_lex604083109 ON "AO_60DB71_LEXORANK" USING btree ("ISSUE_ID");


--
-- Name: index_ao_60db71_lexorank_rank; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_lexorank_rank ON "AO_60DB71_LEXORANK" USING btree ("RANK");


--
-- Name: index_ao_60db71_non1145824037; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_non1145824037 ON "AO_60DB71_NONWORKINGDAY" USING btree ("WORKING_DAYS_ID");


--
-- Name: index_ao_60db71_qui432573905; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_qui432573905 ON "AO_60DB71_QUICKFILTER" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_spr1457658269; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_spr1457658269 ON "AO_60DB71_SPRINT" USING btree ("SEQUENCE");


--
-- Name: index_ao_60db71_sta1907922871; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_sta1907922871 ON "AO_60DB71_STATSFIELD" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_sub730851836; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_sub730851836 ON "AO_60DB71_SUBQUERY" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_swi1429284592; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_swi1429284592 ON "AO_60DB71_SWIMLANE" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_tra1711190333; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_tra1711190333 ON "AO_60DB71_TRACKINGSTATISTIC" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_60db71_wor1205491794; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_60db71_wor1205491794 ON "AO_60DB71_WORKINGDAYS" USING btree ("RAPID_VIEW_ID");


--
-- Name: index_ao_deb285_com782863884; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_deb285_com782863884 ON "AO_DEB285_COMMENT_AO" USING btree ("BLOG_ID");


--
-- Name: index_ao_e8b6cc_bra1368852151; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_bra1368852151 ON "AO_E8B6CC_BRANCH_HEAD_MAPPING" USING btree ("REPOSITORY_ID");


--
-- Name: index_ao_e8b6cc_bra405461593; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_bra405461593 ON "AO_E8B6CC_BRANCH" USING btree ("REPOSITORY_ID");


--
-- Name: index_ao_e8b6cc_cha1086340152; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_cha1086340152 ON "AO_E8B6CC_CHANGESET_MAPPING" USING btree ("SMARTCOMMIT_AVAILABLE");


--
-- Name: index_ao_e8b6cc_cha1483243924; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_cha1483243924 ON "AO_E8B6CC_CHANGESET_MAPPING" USING btree ("NODE");


--
-- Name: index_ao_e8b6cc_cha509722037; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_cha509722037 ON "AO_E8B6CC_CHANGESET_MAPPING" USING btree ("RAW_NODE");


--
-- Name: index_ao_e8b6cc_cha897886051; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_cha897886051 ON "AO_E8B6CC_CHANGESET_MAPPING" USING btree ("AUTHOR");


--
-- Name: index_ao_e8b6cc_com1308336834; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_com1308336834 ON "AO_E8B6CC_COMMIT" USING btree ("DOMAIN_ID");


--
-- Name: index_ao_e8b6cc_commit_node; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_commit_node ON "AO_E8B6CC_COMMIT" USING btree ("NODE");


--
-- Name: index_ao_e8b6cc_git1120895454; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_git1120895454 ON "AO_E8B6CC_GIT_HUB_EVENT" USING btree ("GIT_HUB_ID");


--
-- Name: index_ao_e8b6cc_git1804640320; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_git1804640320 ON "AO_E8B6CC_GIT_HUB_EVENT" USING btree ("REPOSITORY_ID");


--
-- Name: index_ao_e8b6cc_iss1229805759; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_iss1229805759 ON "AO_E8B6CC_ISSUE_TO_CHANGESET" USING btree ("CHANGESET_ID");


--
-- Name: index_ao_e8b6cc_iss1325927291; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_iss1325927291 ON "AO_E8B6CC_ISSUE_TO_BRANCH" USING btree ("BRANCH_ID");


--
-- Name: index_ao_e8b6cc_iss353204826; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_iss353204826 ON "AO_E8B6CC_ISSUE_TO_BRANCH" USING btree ("ISSUE_KEY");


--
-- Name: index_ao_e8b6cc_iss417950110; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_iss417950110 ON "AO_E8B6CC_ISSUE_TO_CHANGESET" USING btree ("ISSUE_KEY");


--
-- Name: index_ao_e8b6cc_iss648895902; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_iss648895902 ON "AO_E8B6CC_ISSUE_TO_CHANGESET" USING btree ("PROJECT_KEY");


--
-- Name: index_ao_e8b6cc_mes1247039512; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_mes1247039512 ON "AO_E8B6CC_MESSAGE" USING btree ("ADDRESS");


--
-- Name: index_ao_e8b6cc_mes1391090780; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_mes1391090780 ON "AO_E8B6CC_MESSAGE_TAG" USING btree ("MESSAGE_ID");


--
-- Name: index_ao_e8b6cc_mes1648007831; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_mes1648007831 ON "AO_E8B6CC_MESSAGE_TAG" USING btree ("TAG");


--
-- Name: index_ao_e8b6cc_mes344532677; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_mes344532677 ON "AO_E8B6CC_MESSAGE_QUEUE_ITEM" USING btree ("MESSAGE_ID");


--
-- Name: index_ao_e8b6cc_mes59146529; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_mes59146529 ON "AO_E8B6CC_MESSAGE_QUEUE_ITEM" USING btree ("STATE");


--
-- Name: index_ao_e8b6cc_mes60959905; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_mes60959905 ON "AO_E8B6CC_MESSAGE_QUEUE_ITEM" USING btree ("QUEUE");


--
-- Name: index_ao_e8b6cc_org1513110290; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_org1513110290 ON "AO_E8B6CC_ORGANIZATION_MAPPING" USING btree ("DVCS_TYPE");


--
-- Name: index_ao_e8b6cc_pr_1045528152; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_1045528152 ON "AO_E8B6CC_PR_TO_COMMIT" USING btree ("REQUEST_ID");


--
-- Name: index_ao_e8b6cc_pr_1105917040; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_1105917040 ON "AO_E8B6CC_PR_PARTICIPANT" USING btree ("PULL_REQUEST_ID");


--
-- Name: index_ao_e8b6cc_pr_1458633226; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_1458633226 ON "AO_E8B6CC_PR_TO_COMMIT" USING btree ("COMMIT_ID");


--
-- Name: index_ao_e8b6cc_pr_1639282617; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_1639282617 ON "AO_E8B6CC_PR_ISSUE_KEY" USING btree ("DOMAIN_ID");


--
-- Name: index_ao_e8b6cc_pr_2106805302; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_2106805302 ON "AO_E8B6CC_PR_ISSUE_KEY" USING btree ("ISSUE_KEY");


--
-- Name: index_ao_e8b6cc_pr_281193494; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_281193494 ON "AO_E8B6CC_PR_ISSUE_KEY" USING btree ("PULL_REQUEST_ID");


--
-- Name: index_ao_e8b6cc_pr_685151049; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_685151049 ON "AO_E8B6CC_PR_TO_COMMIT" USING btree ("DOMAIN_ID");


--
-- Name: index_ao_e8b6cc_pr_758084799; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pr_758084799 ON "AO_E8B6CC_PR_PARTICIPANT" USING btree ("DOMAIN_ID");


--
-- Name: index_ao_e8b6cc_pul1230717024; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pul1230717024 ON "AO_E8B6CC_PULL_REQUEST" USING btree ("DOMAIN_ID");


--
-- Name: index_ao_e8b6cc_pul1448445182; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pul1448445182 ON "AO_E8B6CC_PULL_REQUEST" USING btree ("TO_REPOSITORY_ID");


--
-- Name: index_ao_e8b6cc_pul602811170; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_pul602811170 ON "AO_E8B6CC_PULL_REQUEST" USING btree ("REMOTE_ID");


--
-- Name: index_ao_e8b6cc_rep1082901832; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_rep1082901832 ON "AO_E8B6CC_REPO_TO_CHANGESET" USING btree ("REPOSITORY_ID");


--
-- Name: index_ao_e8b6cc_rep1928770529; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_rep1928770529 ON "AO_E8B6CC_REPO_TO_PROJECT" USING btree ("REPOSITORY_ID");


--
-- Name: index_ao_e8b6cc_rep702725269; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_rep702725269 ON "AO_E8B6CC_REPOSITORY_MAPPING" USING btree ("ORGANIZATION_ID");


--
-- Name: index_ao_e8b6cc_rep922992576; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_rep922992576 ON "AO_E8B6CC_REPO_TO_CHANGESET" USING btree ("CHANGESET_ID");


--
-- Name: index_ao_e8b6cc_rep93578901; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_rep93578901 ON "AO_E8B6CC_REPOSITORY_MAPPING" USING btree ("LINKED");


--
-- Name: index_ao_e8b6cc_syn203792807; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_syn203792807 ON "AO_E8B6CC_SYNC_AUDIT_LOG" USING btree ("REPO_ID");


--
-- Name: index_ao_e8b6cc_syn493078035; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX index_ao_e8b6cc_syn493078035 ON "AO_E8B6CC_SYNC_EVENT" USING btree ("REPO_ID");


--
-- Name: issue_assignee; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issue_assignee ON jiraissue USING btree (assignee);


--
-- Name: issue_proj_num; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issue_proj_num ON jiraissue USING btree (issuenum, project);


--
-- Name: issue_proj_status; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issue_proj_status ON jiraissue USING btree (project, issuestatus);


--
-- Name: issue_reporter; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issue_reporter ON jiraissue USING btree (reporter);


--
-- Name: issue_updated; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issue_updated ON jiraissue USING btree (updated);


--
-- Name: issue_workflow; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issue_workflow ON jiraissue USING btree (workflow_id);


--
-- Name: issuelink_dest; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issuelink_dest ON issuelink USING btree (destination);


--
-- Name: issuelink_src; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issuelink_src ON issuelink USING btree (source);


--
-- Name: issuelink_type; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX issuelink_type ON issuelink USING btree (linktype);


--
-- Name: label_fieldissue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX label_fieldissue ON label USING btree (issue, fieldid);


--
-- Name: label_fieldissuelabel; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX label_fieldissuelabel ON label USING btree (issue, fieldid, label);


--
-- Name: label_issue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX label_issue ON label USING btree (issue);


--
-- Name: label_label; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX label_label ON label USING btree (label);


--
-- Name: licenseroledefault_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX licenseroledefault_index ON licenserolesdefault USING btree (license_role_name);


--
-- Name: licenserolegroup_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX licenserolegroup_index ON licenserolesgroup USING btree (license_role_name, group_id);


--
-- Name: linktypename; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX linktypename ON issuelinktype USING btree (linkname);


--
-- Name: linktypestyle; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX linktypestyle ON issuelinktype USING btree (pstyle);


--
-- Name: managedconfigitem_id_type_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX managedconfigitem_id_type_idx ON managedconfigurationitem USING btree (item_id, item_type);


--
-- Name: mshipbase_group; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX mshipbase_group ON membershipbase USING btree (group_name);


--
-- Name: mshipbase_user; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX mshipbase_user ON membershipbase USING btree (user_name);


--
-- Name: node_id_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX node_id_idx ON nodeindexcounter USING btree (node_id, sending_node_id);


--
-- Name: node_operation_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX node_operation_idx ON replicatedindexoperation USING btree (node_id, affected_index, operation, index_time);


--
-- Name: node_sink; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX node_sink ON nodeassociation USING btree (sink_node_id, sink_node_entity);


--
-- Name: node_source; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX node_source ON nodeassociation USING btree (source_node_id, source_node_entity);


--
-- Name: notif_source; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX notif_source ON notificationinstance USING btree (source);


--
-- Name: ntfctn_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX ntfctn_scheme ON notification USING btree (scheme);


--
-- Name: oauth_consumer_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX oauth_consumer_index ON oauthconsumer USING btree (consumer_key);


--
-- Name: oauth_consumer_service_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX oauth_consumer_service_index ON oauthconsumer USING btree (consumerservice);


--
-- Name: oauth_consumer_token_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX oauth_consumer_token_index ON oauthconsumertoken USING btree (token);


--
-- Name: oauth_consumer_token_key_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX oauth_consumer_token_key_index ON oauthconsumertoken USING btree (token_key);


--
-- Name: oauth_sp_consumer_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX oauth_sp_consumer_index ON oauthspconsumer USING btree (consumer_key);


--
-- Name: oauth_sp_consumer_key_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX oauth_sp_consumer_key_index ON oauthsptoken USING btree (consumer_key);


--
-- Name: oauth_sp_token_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX oauth_sp_token_index ON oauthsptoken USING btree (token);


--
-- Name: osgroup_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX osgroup_name ON groupbase USING btree (groupname);


--
-- Name: osproperty_all; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX osproperty_all ON propertyentry USING btree (entity_id);


--
-- Name: osproperty_entityname; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX osproperty_entityname ON propertyentry USING btree (entity_name);


--
-- Name: osproperty_propertykey; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX osproperty_propertykey ON propertyentry USING btree (property_key);


--
-- Name: osuser_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX osuser_name ON userbase USING btree (username);


--
-- Name: ppage_username; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX ppage_username ON portalpage USING btree (username);


--
-- Name: prmssn_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX prmssn_scheme ON schemepermissions USING btree (scheme);


--
-- Name: remembermetoken_username_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX remembermetoken_username_index ON remembermetoken USING btree (username);


--
-- Name: remotelink_globalid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX remotelink_globalid ON remotelink USING btree (globalid);


--
-- Name: remotelink_issueid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX remotelink_issueid ON remotelink USING btree (issueid, globalid);


--
-- Name: role_player_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX role_player_idx ON projectroleactor USING btree (projectroleid, pid);


--
-- Name: rundetails_jobid_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX rundetails_jobid_idx ON rundetails USING btree (job_id);


--
-- Name: rundetails_starttime_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX rundetails_starttime_idx ON rundetails USING btree (start_time);


--
-- Name: screenitem_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX screenitem_scheme ON fieldscreenschemeitem USING btree (fieldscreenscheme);


--
-- Name: searchrequest_filternamelower; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX searchrequest_filternamelower ON searchrequest USING btree (filtername_lower);


--
-- Name: sec_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX sec_scheme ON schemeissuesecurities USING btree (scheme);


--
-- Name: sec_security; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX sec_security ON schemeissuesecurities USING btree (security);


--
-- Name: share_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX share_index ON sharepermissions USING btree (entityid, entitytype);


--
-- Name: source_destination_node_idx; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX source_destination_node_idx ON clustermessage USING btree (source_node, destination_node);


--
-- Name: sr_author; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX sr_author ON searchrequest USING btree (authorname);


--
-- Name: subscrpt_user; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX subscrpt_user ON filtersubscription USING btree (filter_i_d, username);


--
-- Name: subscrptn_group; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX subscrptn_group ON filtersubscription USING btree (filter_i_d, groupname);


--
-- Name: trustedapp_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX trustedapp_id ON trustedapp USING btree (application_id);


--
-- Name: type_key; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX type_key ON genericconfiguration USING btree (datatype, datakey);


--
-- Name: uh_type_user_entity; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uh_type_user_entity ON userhistoryitem USING btree (entitytype, username, entityid);


--
-- Name: uk_application_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_application_name ON cwd_application USING btree (lower_application_name);


--
-- Name: uk_directory_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX uk_directory_name ON cwd_directory USING btree (lower_directory_name);


--
-- Name: uk_group_attr_name_lval; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_group_attr_name_lval ON cwd_group_attributes USING btree (group_id, attribute_name, lower_attribute_value);


--
-- Name: uk_group_name_dir_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_group_name_dir_id ON cwd_group USING btree (lower_group_name, directory_id);


--
-- Name: uk_lower_user_name; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_lower_user_name ON app_user USING btree (lower_user_name);


--
-- Name: uk_mem_parent_child_type; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_mem_parent_child_type ON cwd_membership USING btree (parent_id, child_id, membership_type);


--
-- Name: uk_user_attr_name_lval; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX uk_user_attr_name_lval ON cwd_user_attributes USING btree (user_id, attribute_name);


--
-- Name: uk_user_externalid_dir_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX uk_user_externalid_dir_id ON cwd_user USING btree (external_id, directory_id);


--
-- Name: uk_user_key; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_user_key ON app_user USING btree (user_key);


--
-- Name: uk_user_name_dir_id; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE UNIQUE INDEX uk_user_name_dir_id ON cwd_user USING btree (lower_user_name, directory_id);


--
-- Name: upf_customfield; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX upf_customfield ON userpickerfilter USING btree (customfield);


--
-- Name: upf_fieldconfigid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX upf_fieldconfigid ON userpickerfilter USING btree (customfieldconfig);


--
-- Name: user_sink; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX user_sink ON userassociation USING btree (sink_node_id, sink_node_entity);


--
-- Name: user_source; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX user_source ON userassociation USING btree (source_name);


--
-- Name: userpref_portletconfiguration; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX userpref_portletconfiguration ON gadgetuserpreference USING btree (portletconfiguration);


--
-- Name: votehistory_issue_index; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX votehistory_issue_index ON votehistory USING btree (issueid);


--
-- Name: wf_entryid; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX wf_entryid ON os_currentstep USING btree (entry_id);


--
-- Name: workflow_scheme; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX workflow_scheme ON workflowschemeentity USING btree (scheme);


--
-- Name: worklog_author; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX worklog_author ON worklog USING btree (author);


--
-- Name: worklog_issue; Type: INDEX; Schema: public; Owner: jirauser2; Tablespace:
--

CREATE INDEX worklog_issue ON worklog USING btree (issueid);


--
-- Name: fk_ao_563aee_activity_entity_actor_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_ACTIVITY_ENTITY"
ADD CONSTRAINT fk_ao_563aee_activity_entity_actor_id FOREIGN KEY ("ACTOR_ID") REFERENCES "AO_563AEE_ACTOR_ENTITY"("ID");


--
-- Name: fk_ao_563aee_activity_entity_icon_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_ACTIVITY_ENTITY"
ADD CONSTRAINT fk_ao_563aee_activity_entity_icon_id FOREIGN KEY ("ICON_ID") REFERENCES "AO_563AEE_MEDIA_LINK_ENTITY"("ID");


--
-- Name: fk_ao_563aee_activity_entity_object_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_ACTIVITY_ENTITY"
ADD CONSTRAINT fk_ao_563aee_activity_entity_object_id FOREIGN KEY ("OBJECT_ID") REFERENCES "AO_563AEE_OBJECT_ENTITY"("ID");


--
-- Name: fk_ao_563aee_activity_entity_target_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_ACTIVITY_ENTITY"
ADD CONSTRAINT fk_ao_563aee_activity_entity_target_id FOREIGN KEY ("TARGET_ID") REFERENCES "AO_563AEE_TARGET_ENTITY"("ID");


--
-- Name: fk_ao_563aee_object_entity_image_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_OBJECT_ENTITY"
ADD CONSTRAINT fk_ao_563aee_object_entity_image_id FOREIGN KEY ("IMAGE_ID") REFERENCES "AO_563AEE_MEDIA_LINK_ENTITY"("ID");


--
-- Name: fk_ao_563aee_target_entity_image_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_563AEE_TARGET_ENTITY"
ADD CONSTRAINT fk_ao_563aee_target_entity_image_id FOREIGN KEY ("IMAGE_ID") REFERENCES "AO_563AEE_MEDIA_LINK_ENTITY"("ID");


--
-- Name: fk_ao_5fb9d7_aohip_chat_user_hip_chat_link_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_5FB9D7_AOHIP_CHAT_USER"
ADD CONSTRAINT fk_ao_5fb9d7_aohip_chat_user_hip_chat_link_id FOREIGN KEY ("HIP_CHAT_LINK_ID") REFERENCES "AO_5FB9D7_AOHIP_CHAT_LINK"("ID");


--
-- Name: fk_ao_60db71_boardadmins_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_BOARDADMINS"
ADD CONSTRAINT fk_ao_60db71_boardadmins_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_cardcolor_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_CARDCOLOR"
ADD CONSTRAINT fk_ao_60db71_cardcolor_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_cardlayout_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_CARDLAYOUT"
ADD CONSTRAINT fk_ao_60db71_cardlayout_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_column_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_COLUMN"
ADD CONSTRAINT fk_ao_60db71_column_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_columnstatus_column_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_COLUMNSTATUS"
ADD CONSTRAINT fk_ao_60db71_columnstatus_column_id FOREIGN KEY ("COLUMN_ID") REFERENCES "AO_60DB71_COLUMN"("ID");


--
-- Name: fk_ao_60db71_detailviewfield_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_DETAILVIEWFIELD"
ADD CONSTRAINT fk_ao_60db71_detailviewfield_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_estimatestatistic_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_ESTIMATESTATISTIC"
ADD CONSTRAINT fk_ao_60db71_estimatestatistic_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_nonworkingday_working_days_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_NONWORKINGDAY"
ADD CONSTRAINT fk_ao_60db71_nonworkingday_working_days_id FOREIGN KEY ("WORKING_DAYS_ID") REFERENCES "AO_60DB71_WORKINGDAYS"("ID");


--
-- Name: fk_ao_60db71_quickfilter_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_QUICKFILTER"
ADD CONSTRAINT fk_ao_60db71_quickfilter_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_statsfield_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_STATSFIELD"
ADD CONSTRAINT fk_ao_60db71_statsfield_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_subquery_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_SUBQUERY"
ADD CONSTRAINT fk_ao_60db71_subquery_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_swimlane_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_SWIMLANE"
ADD CONSTRAINT fk_ao_60db71_swimlane_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_trackingstatistic_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_TRACKINGSTATISTIC"
ADD CONSTRAINT fk_ao_60db71_trackingstatistic_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_60db71_workingdays_rapid_view_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_60DB71_WORKINGDAYS"
ADD CONSTRAINT fk_ao_60db71_workingdays_rapid_view_id FOREIGN KEY ("RAPID_VIEW_ID") REFERENCES "AO_60DB71_RAPIDVIEW"("ID");


--
-- Name: fk_ao_deb285_comment_ao_blog_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_DEB285_COMMENT_AO"
ADD CONSTRAINT fk_ao_deb285_comment_ao_blog_id FOREIGN KEY ("BLOG_ID") REFERENCES "AO_DEB285_BLOG_AO"("ID");


--
-- Name: fk_ao_e8b6cc_branch_repository_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_BRANCH"
ADD CONSTRAINT fk_ao_e8b6cc_branch_repository_id FOREIGN KEY ("REPOSITORY_ID") REFERENCES "AO_E8B6CC_REPOSITORY_MAPPING"("ID");


--
-- Name: fk_ao_e8b6cc_git_hub_event_repository_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_GIT_HUB_EVENT"
ADD CONSTRAINT fk_ao_e8b6cc_git_hub_event_repository_id FOREIGN KEY ("REPOSITORY_ID") REFERENCES "AO_E8B6CC_REPOSITORY_MAPPING"("ID");


--
-- Name: fk_ao_e8b6cc_issue_to_branch_branch_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_ISSUE_TO_BRANCH"
ADD CONSTRAINT fk_ao_e8b6cc_issue_to_branch_branch_id FOREIGN KEY ("BRANCH_ID") REFERENCES "AO_E8B6CC_BRANCH"("ID");


--
-- Name: fk_ao_e8b6cc_message_queue_item_message_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE_QUEUE_ITEM"
ADD CONSTRAINT fk_ao_e8b6cc_message_queue_item_message_id FOREIGN KEY ("MESSAGE_ID") REFERENCES "AO_E8B6CC_MESSAGE"("ID");


--
-- Name: fk_ao_e8b6cc_message_tag_message_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_MESSAGE_TAG"
ADD CONSTRAINT fk_ao_e8b6cc_message_tag_message_id FOREIGN KEY ("MESSAGE_ID") REFERENCES "AO_E8B6CC_MESSAGE"("ID");


--
-- Name: fk_ao_e8b6cc_pr_participant_pull_request_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PR_PARTICIPANT"
ADD CONSTRAINT fk_ao_e8b6cc_pr_participant_pull_request_id FOREIGN KEY ("PULL_REQUEST_ID") REFERENCES "AO_E8B6CC_PULL_REQUEST"("ID");


--
-- Name: fk_ao_e8b6cc_pr_to_commit_commit_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PR_TO_COMMIT"
ADD CONSTRAINT fk_ao_e8b6cc_pr_to_commit_commit_id FOREIGN KEY ("COMMIT_ID") REFERENCES "AO_E8B6CC_COMMIT"("ID");


--
-- Name: fk_ao_e8b6cc_pr_to_commit_request_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_PR_TO_COMMIT"
ADD CONSTRAINT fk_ao_e8b6cc_pr_to_commit_request_id FOREIGN KEY ("REQUEST_ID") REFERENCES "AO_E8B6CC_PULL_REQUEST"("ID");


--
-- Name: fk_ao_e8b6cc_repo_to_project_repository_id; Type: FK CONSTRAINT; Schema: public; Owner: jirauser2
--

ALTER TABLE ONLY "AO_E8B6CC_REPO_TO_PROJECT"
ADD CONSTRAINT fk_ao_e8b6cc_repo_to_project_repository_id FOREIGN KEY ("REPOSITORY_ID") REFERENCES "AO_E8B6CC_REPOSITORY_MAPPING"("ID");


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

