jiraDevelopmentIntegrationPluginJsonp(["smart-commits"],{

/***/ "./js/smartcommits/smart-commits-config-analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    'use strict';

    var analytics = __webpack_require__("./js/util/analytics.js");

    /**
     * fires a devstatus event
     * @param name event name
     * @param data represents event properties
     */
    function fireEvent(name, data) {
        var eventName = 'jira.devstatus.' + name;
        analytics.sendEvent(eventName, data);
    }

    return {
        /**
         * fire event when config smart commits dialog is opened
         * @param context dialog context, either edit existing applink or new created one
         */
        fireOpenSmartCommitConfigDialogEvent: function fireOpenSmartCommitConfigDialogEvent(context) {
            fireEvent('smartcommits.open.config.dialog', { context: context });
        },

        /**
         * fire event when user saves smart commit configuration
         * @param context dialog context, either edit existing applink or new created one
         * @param value {@code true} when smart commits is enabled, {@code false} otherwise
         * @param saveResult {@code true} in case result saved successfully, {@code false} otherwise
         */
        fireSaveSmartCommitConfigSettingEvent: function fireSaveSmartCommitConfigSettingEvent(context, value, saveResult) {
            fireEvent('smartcommits.config.save.setting', {
                context: context,
                value: value,
                saveResult: saveResult
            });
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/smartcommits/smart-commits-config-controller.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(5);
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    'use strict';

    var ConfigModel = __webpack_require__("./js/smartcommits/smart-commits-config-model.js");
    var ConfigView = __webpack_require__("./js/smartcommits/smart-commits-config-view.js");
    var ErrorHelper = __webpack_require__("./js/smartcommits/smart-commits-error-helper.js");

    var formatter = __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')");

    var DIALOG_CONTEXT = {
        EXISTING_APPLINK: 'existing.applink.context',
        NEW_APPLINK: 'new.applink.context'
    };

    function Controller() {
        function createView(context, title, template, contentTemplate, errorTemplate, model) {
            return new ConfigView({
                context: context,
                title: title,
                model: model,
                template: template,
                contentTemplate: contentTemplate,
                errorTemplate: errorTemplate
            });
        }

        this.openConfig = function (id) {
            var self = this;
            var contentTemplate = JIRA.Templates.SmartCommits.configDialogForExistingApplink;
            var title = formatter.I18n.getText('devstatus.smartcommits.config.dialog.title');
            self.model = new ConfigModel({ applinkId: id });
            self.view = createView(DIALOG_CONTEXT.EXISTING_APPLINK, title, JIRA.Templates.SmartCommits.loading, contentTemplate, JIRA.Templates.SmartCommits.showError, self.model);
            // show dialog with loading spinner while fetching model
            self.view.render();
            self.model.fetch({
                success: function success() {
                    self.view.showContent();
                },
                error: function error(model, response) {
                    self.model.setError(ErrorHelper.getErrorFromResponse(response));
                    self.view.showContent();
                }
            });
        };

        this.openConfigForNewApplink = function (id, typeName) {
            var self = this;
            var contentTemplate = JIRA.Templates.SmartCommits.configDialogForNewApplink;
            var title = formatter.I18n.getText('devstatus.smartcommits.config.applink.created.dialog.title', typeName);
            // we need to skip remote server with new applink to show the dialog quickly as we do not show loading spinner
            self.model = new ConfigModel({
                applinkId: id,
                skipRemoteCheckForSmartCommit: true
            });

            self.view = createView(DIALOG_CONTEXT.NEW_APPLINK, title, JIRA.Templates.SmartCommits.loading, contentTemplate, JIRA.Templates.SmartCommits.showError, self.model);
            self.model.fetch({
                success: function success() {
                    // only show the dialog with capable smart commits
                    if (self.model.isSmartCommitCapable()) {
                        self.model.setSmartCommitLocallyEnabled(true);
                        self.view.render();
                        self.view.showContent();
                    }
                }
                // we do not need to do anything with error no dialog will be displayed
            });
        };
    }
    return new Controller();
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/smartcommits/smart-commits-config-model.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    var Backbone = __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')");
    var Strings = __webpack_require__("./js/util/Strings.js");
    var Helpers = __webpack_require__("./js/util/Helpers.js");

    return Backbone.Model.extend({
        idAttribute: 'applinkId',

        properties: ['applinkId'],

        defaults: {
            skipRemoteCheckForSmartCommit: false
        },

        initialize: function initialize(data) {
            this.applinkId = data.applinkId;
        },

        url: function url() {
            return Strings.format('{0}/rest/smart-commits/1.0/config/{1}', Helpers.getContextPath(), this.getApplinkId());
        },

        isSmartCommitLocallyEnabled: function isSmartCommitLocallyEnabled() {
            return this.get('smartCommitLocallyEnabled');
        },

        getApplinkId: function getApplinkId() {
            return this.get('applinkId');
        },

        setSmartCommitLocallyEnabled: function setSmartCommitLocallyEnabled(enabled) {
            this.set('smartCommitLocallyEnabled', !!enabled);
        },

        isSmartCommitCapable: function isSmartCommitCapable() {
            return this.get('smartCommitCapable');
        },

        setError: function setError(error) {
            if (error) {
                this.set({ error: error }, { silent: true });
            }
        },

        isRemoteCheckSkiped: function isRemoteCheckSkiped() {
            return this.get('skipRemoteCheckForSmartCommit');
        },

        // override sync method to change url and force correct HTTP method
        // PUT -> to enable
        // DELETE -> to disable
        sync: function sync(method, model, options) {
            if (method === 'update') {
                options.url = this.url() + '/enableLocally';
                if (!this.isSmartCommitLocallyEnabled()) {
                    method = 'delete';
                }
            } else if (method === 'read' && this.isRemoteCheckSkiped()) {
                options.url = this.url() + '?skipRemoteCheck=true';
            }
            return Backbone.sync.apply(this, [method, model, options]);
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/smartcommits/smart-commits-config-view.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (require) {
    var $ = __webpack_require__("jira.webresources:jquery/require('jquery')");
    var _ = __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')");
    var Backbone = __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')");
    var dialog2 = __webpack_require__("./js/util/Dialog2.js");
    var ErrorHelper = __webpack_require__("./js/smartcommits/smart-commits-error-helper.js");
    var SmartCommitConfigAnalytics = __webpack_require__("./js/smartcommits/smart-commits-config-analytics.js");

    var SET_SMART_COMMIT_ENABLE_EVENT = 'setEnabled';
    var CANCEL_DIALOG_EVENT = 'cancel';

    // private view to bind to dialog dom elements
    var DialogContentView = Backbone.View.extend({
        el: '#smart-commits-config-dialog',

        checkboxSelector: '#enable-smart-commits',

        notificationDivSelector: '#notifications',

        allInputSelector: '.input',

        spinner: '.smartcommits-loading',

        events: {
            'click #smart-config-set-button': 'click',
            'click #cancel-button': 'cancel'
        },

        initialize: function initialize(options) {
            this.template = options.template;
            this.errorTemplate = options.errorTemplate;
        },

        click: function click() {
            this.trigger(SET_SMART_COMMIT_ENABLE_EVENT, !!this.checkbox.attr('checked'));
        },

        showError: function showError(error) {
            this.notificationDiv.html(this.errorTemplate(error));
        },

        disable: function disable() {
            this.inputs.prop('disabled', true);
        },

        enable: function enable() {
            this.inputs.prop('disabled', false);
        },

        cancel: function cancel() {
            this.trigger(CANCEL_DIALOG_EVENT);
        },

        render: function render() {
            this.$el.html(this.template(this.model.toJSON()));
            this.bindDomElements();
        },

        bindDomElements: function bindDomElements() {
            this.checkbox = this.$el.find(this.checkboxSelector);
            this.notificationDiv = this.$el.find(this.notificationDivSelector);
            this.inputs = this.$el.find(this.allInputSelector);
        },

        showLoadingSpinner: function showLoadingSpinner() {
            this.$el.find(this.spinner).spin('large');
        }
    });

    // a wrapper to dialog2
    return Backbone.View.extend({
        initialize: function initialize(options) {
            this.template = options.template;
            this.errorTemplate = options.errorTemplate;
            this.contentTemplate = options.contentTemplate;
            this.context = options.context;

            this.dialog = dialog2(this.template({ dialogTitle: options.title }));
            this.dialog.on('show', this.onDialogShow.bind(this));
            this.dialog.on('hide', this.cleanup.bind(this));
        },

        render: function render() {
            this.dialog.show();
            SmartCommitConfigAnalytics.fireOpenSmartCommitConfigDialogEvent(this.context);
        },

        save: function save(enabled) {
            // save
            var self = this;
            this.model.setSmartCommitLocallyEnabled(enabled);

            this.dialogContentView.disable();
            this.model.save(null, {
                success: self.handlingSavingSuccess.bind(self),
                error: self.handleSavingError.bind(self)
            });
        },

        cleanup: function cleanup() {
            // stop listening to any event
            this.stopListening();
            // remove the dialog from dom
            this.dialogContentView.remove();
            // remove the view from dom
            this.remove();
        },

        onDialogShow: function onDialogShow(e) {
            this.dialogContentView = new DialogContentView({
                model: this.model,
                template: this.contentTemplate,
                errorTemplate: this.errorTemplate
            });
            this.dialogContentView.on(SET_SMART_COMMIT_ENABLE_EVENT, this.save, this);
            this.dialogContentView.on(CANCEL_DIALOG_EVENT, this.cancel, this);
            this.dialogContentView.showLoadingSpinner();
        },

        showContent: function showContent() {
            this.dialogContentView.render();
        },

        handleSavingError: function handleSavingError(model, response, options) {
            this.dialogContentView.showError(ErrorHelper.getErrorFromResponse(response));
            this.dialogContentView.enable();
            SmartCommitConfigAnalytics.fireSaveSmartCommitConfigSettingEvent(this.context, model.isSmartCommitLocallyEnabled(), false);
        },

        handlingSavingSuccess: function handlingSavingSuccess(model, response, options) {
            this.dialog.remove();
            SmartCommitConfigAnalytics.fireSaveSmartCommitConfigSettingEvent(this.context, model.isSmartCommitLocallyEnabled(), true);
        },

        cancel: function cancel() {
            this.dialog.remove();
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/smartcommits/smart-commits-config.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var Backbone = __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')");
var jQuery = __webpack_require__("jira.webresources:jquery/require('jquery')");
// custom modules
var controller = __webpack_require__("./js/smartcommits/smart-commits-config-controller.js");

var AppRouter = Backbone.Router.extend({
    routes: {
        'smart-commits/:applicationId': 'configSmartCommit'
    },

    initialize: function initialize(attributes) {
        this.controller = attributes.controller;
    },

    configSmartCommit: function configSmartCommit(id) {
        // override the # in order to prevent opening the dialog when clicking back
        this.navigate(null, { trigger: false, replace: true });
        this.controller.openConfig(id);
    }
});

new AppRouter({
    controller: controller
});

jQuery(function () {
    Backbone.history.start();
    var createdApplinkId = jQuery('body').data('created-applink-id');
    if (createdApplinkId) {
        // event fired before devstatus can register listener
        var createdApplinkTypeName = jQuery('body').data('created-applink-type-name');
        controller.openConfigForNewApplink(createdApplinkId, createdApplinkTypeName);
    } else {
        // this event is fired by applinks plugin
        jQuery(document).on('applinks.event.created', function (e, applink) {
            if (applink) {
                controller.openConfigForNewApplink(applink.id, applink.typeName);
            }
        });
    }
});

/***/ }),

/***/ "./js/smartcommits/smart-commits-error-helper.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter) {
    var HTTP_STATUS_CODES = {
        UNAUTHOIRZED_401: 401,
        NOT_FOUND_404: 404,
        BAD_REQUEST_400: 400,
        SERVICE_UNAVAILABLE: 503
    };

    function getErrorFromResponse(response) {
        var UNKNOWN_ERROR = {
            title: formatter.I18n.getText('devstatus.smartcommits.config.dialog.error.unknown.error.title'),
            desc: formatter.I18n.getText('devstatus.smartcommits.config.dialog.error.unknown.error.desc')
        };

        if (response && response.status >= 0) {
            var error = {};
            switch (response.status) {
                case HTTP_STATUS_CODES.UNAUTHOIRZED_401:
                    error.title = formatter.I18n.getText('devstatus.smartcommits.config.dialog.error.unauthorized.title');
                    error.desc = formatter.I18n.getText('devstatus.smartcommits.config.dialog.error.unauthorized.desc');
                    break;
                case HTTP_STATUS_CODES.NOT_FOUND_404: // there is a problem with application link id either invalid or not found
                case HTTP_STATUS_CODES.BAD_REQUEST_400:
                    error.title = formatter.I18n.getText('devstatus.smartcommits.config.dialog.error.applink.missing.title');
                    error.desc = formatter.I18n.getText('devstatus.smartcommits.config.dialog.error.applink.missing.desc');
                    break;
                case HTTP_STATUS_CODES.SERVICE_UNAVAILABLE:
                default:
                    return UNKNOWN_ERROR;
            }
            return error;
        }
        return UNKNOWN_ERROR;
    }

    return {
        getErrorFromResponse: getErrorFromResponse
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Dialog2.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    'use strict';

    return AJS.dialog2;
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/EventPublisher.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    'use strict';

    return {
        trigger: AJS.trigger
    };
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Helpers.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    'use strict';

    /**
     * Return a function to mark a string object as sanitised so that soy doesn't escape it.
     *
     * We can remove this and just use soydata.VERY_UNSAFE.ordainSanitizedHtml once we only support JIRA >= 7
     *
     * @returns a function to sanitise a string for unescaped usage in a soy template.
     */

    var sanitiserFunction = function sanitiserFunction() {
        if (soydata.VERY_UNSAFE) {
            return soydata.VERY_UNSAFE.ordainSanitizedHtml;
        } else {
            return function (stringToMarkAsSafe) {
                return new soydata.SanitizedHtml(stringToMarkAsSafe);
            };
        }
    };

    return {
        getContextPath: wrmContextPath,

        /**
         * Make a copy of object with all String properties of this new object marked as sanitised html,
         * so that soy doesn't try to escape them if we use the strings in a soy template context.
         *
         * DO NOT sanitise strings to be used in a soy template unless you know they are safe.
         *
         * @param object {Object} has some string properties that we want to sanitise so that soy doesn't escape them
         * @return object {Object} a copy of object with the string properties marked as sanitised
         */
        copyAndMarkStringPropertiesAsSanitised: function copyAndMarkStringPropertiesAsSanitised(object) {
            var sanitiserFn = sanitiserFunction();
            var sanitisedObject = Array.isArray(object) ? [] : {};
            _.each(_.keys(object), function (key) {
                var val = object[key];
                if (val) {
                    if (typeof val === 'string') {
                        sanitisedObject[key] = sanitiserFn(val);
                    } else if ((typeof val === 'undefined' ? 'undefined' : _typeof(val)) === 'object') {
                        if (_.keys(val).length > 0) {
                            sanitisedObject[key] = copyAndMarkStringPropertiesAsSanitised(val);
                        }
                    } else {
                        sanitisedObject[key] = val;
                    }
                }
            });
            return sanitisedObject;
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Strings.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter) {
    'use strict';

    return {
        format: formatter.format
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/util/EventPublisher.js"), exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (eventPublisher, exports) {
    'use strict';

    /**
     * fires an analytics event
     * @param name of event
     * @param data data to be send with it
     */

    exports.sendEvent = function (name) {
        var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        eventPublisher.trigger('analyticsEvent', {
            name: name,
            data: data
        });
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 5:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ "jira.webresources:ajs-backbone-amd-shim/require('backbone')":
/***/ (function(module, exports) {

module.exports = require('backbone');

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:jira-formatter/require('jira/util/formatter')":
/***/ (function(module, exports) {

module.exports = require('jira/util/formatter');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ })

},["./js/smartcommits/smart-commits-config.js"]);
//# sourceMappingURL=smart-commits.846b898d3d1b3d4480e0.js.map