jiraDevelopmentIntegrationPluginJsonp(["releasereport"],{

/***/ "./js/component/tooltip.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (_, jquery) {
    'use strict';

    var TOOLTIP_MARGIN = 20;

    /**
     * Tipsy leaves its tooltip element around even if the element it is attached to
     * is removed from the document or becomes hidden.
     * This function checks at a short interval whether the tooltip should be hidden to prevent "detached" tooltips.
     * @param tipsyObject
     */
    function hideTipsyWhenDetached(tipsyObject) {
        var CHECK_INTERVAL = 250;

        setTimeout(function () {
            // If the tipsy isn't visible any more we stop checking as well
            if (tipsyObject.$tip.is(':visible')) {
                if (tipsyObject.$element.is(':visible')) {
                    hideTipsyWhenDetached(tipsyObject);
                } else {
                    tipsyObject.hide();
                }
            }
        }, CHECK_INTERVAL);
    }

    /**
     * Show the tipsy, with our special behaviour
     * @param tipsyObject
     */
    function showTipsy(tipsyObject) {
        if (tipsyObject) {
            tipsyObject.show();
            if (tipsyObject.$tip) {
                // If title is empty there is no tip element even after calling show
                hideTipsyWhenDetached(tipsyObject);
            }
        }
    }

    var tooltip = {};

    /**
     * Initialise tooltip
     * @param {Object} options
     * @param {string|Node} options.selector the element(s) to show tooltips for
     * @param {string|Node} [options.context] if specified, use event delegation on this element
     */
    tooltip.tipsify = function (options) {
        options = _.extend({}, options, {
            trigger: 'manual',
            title: 'data-tooltip'
        });

        // return if no selector defined
        if (!options.selector) {
            return;
        }

        jquery(options.context).on({
            mouseenter: function mouseenter() {
                // Re-init the tooltip and show it immediately
                var tipsy = jquery(this).tooltip(options).tipsy(true);
                showTipsy(tipsy);
            },
            mouseleave: function mouseleave() {
                // Check if tipsy is still present to be safe
                var tipsy = jquery(this).tipsy(true);
                if (tipsy) {
                    tipsy.hide();
                }
            }
        }, options.selector);
    };

    return tooltip;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/aui-expander-twiddler.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (jquery, _) {
    'use strict';

    function twiddleExpander() {
        var $text = jquery('#version-description-text');
        var $expander = jquery('#description-text-content .aui-expander-reveal-text');
        if ($text) {
            // Worked with LiangLiang to figure out how to do this calculation.
            // The height of wrapped, untruncated text is 2 + fontsize + lineheight * (lines - 1)
            // We were unable to figure out where the '2' comes from, except that it is associated with the first line.
            var rawfs = $text.css('font-size');
            var rawlh = $text.css('line-height');
            // This if statement is required to avoid spurious QUnit failures. It appears that QUnit does not fully
            // initialise the DOM before its test, unlike the behaviour while in a browser. The result is that these
            // css properties may not be defined.
            if (rawlh && rawfs) {
                var fontsize = Number(rawfs.replace('px', ''));
                var lineheight = Number(rawlh.replace('px', ''));

                // Here we show the expander if the span is > 2 lines long when wrapped.
                if ($text.height() > 2 + fontsize + lineheight) {
                    $expander.show();
                } else {
                    $expander.hide();
                }
            }
        }
    }

    return {
        register: function register() {
            // Perform twiddle onLoad and every 100ms while resizing
            jquery(twiddleExpander);
            jquery(window).resize(_.throttle(twiddleExpander, 100, { trailing: true }));
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/dev-status-dialog-bridge.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(4);

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (_) {
    'use strict';

    var fusionDialogFactoryPerType = {
        repository: _createDetailDialogCommit,
        pullrequest: _createDetailDialogPullRequest,
        branch: _createDetailDialogBranch,
        build: _createDetailDialogBuild,
        review: _createDetailDialogReview,
        'deployment-environment': _createDetailDialogDeployment
    };

    function _getDetailDialogParameters(commonParams, specificParams) {
        return _.extend({
            issueKey: commonParams.issueKey,
            issueId: commonParams.issueId,
            tabs: commonParams.devSummary.byInstanceType,
            dataType: commonParams.dataType,
            showContactAdminForm: commonParams.showContactAdminForm,
            count: commonParams.devSummary.overall.count
        }, specificParams);
    }

    function _createDetailDialogCommit(params) {
        return new Promise(function (resolve) {
            __webpack_require__.e/* require */(2).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/dialog/DetailDialogCommitView.js")]; (function (JIRADevStatusDetailDialogCommitView) {
                var view = new JIRADevStatusDetailDialogCommitView(_getDetailDialogParameters(params, {
                    id: 'devstatus-commit-detail-dialog'
                }));
                resolve(view);
            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
        });
    }

    function _createDetailDialogPullRequest(params) {
        return new Promise(function (resolve) {
            __webpack_require__.e/* require */(3).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/dialog/DetailDialogPullRequestView.js")]; (function (JIRADevStatusDetailDialogPullRequestView) {
                var view = new JIRADevStatusDetailDialogPullRequestView(_getDetailDialogParameters(params, {
                    id: 'devstatus-pullrequest-detail-dialog',
                    reviewersThreshold: 2
                }));
                resolve(view);
            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
        });
    }

    function _createDetailDialogBranch(params) {
        // Note: analyticIssueData parameter is ommited when calling JIRA.DevStatus.DetailDialogBranchView() because
        // isAssignee/isAssignable properties are expensive to obtain per issue for the release reports.
        return new Promise(function (resolve) {
            __webpack_require__.e/* require */(6).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/dialog/DetailDialogBranchView.js")]; (function (JIRADevStatusDetailDialogBranchView) {
                var view = new JIRADevStatusDetailDialogBranchView(_getDetailDialogParameters(params, {
                    id: 'devstatus-branch-detail-dialog'
                }));
                resolve(view);
            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
        });
    }

    function _createDetailDialogBuild(params) {
        return new Promise(function (resolve) {
            __webpack_require__.e/* require */(5).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/dialog/build/DetailDialogBuildView.js")]; (function (JIRADevStatusDetailDialogBuildView) {
                var view = new JIRADevStatusDetailDialogBuildView(_getDetailDialogParameters(params, {
                    id: 'devstatus-build-detail-dialog'
                }));
                resolve(view);
            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
        });
    }

    function _createDetailDialogReview(params) {
        return new Promise(function (resolve) {
            __webpack_require__.e/* require */(1).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/dialog/DetailDialogReviewView.js")]; (function (JIRADevStatusDetailDialogReviewView) {
                var view = new JIRADevStatusDetailDialogReviewView(_getDetailDialogParameters(params, {
                    id: 'devstatus-review-detail-dialog',
                    reviewersThreshold: 2
                }));
                resolve(view);
            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
        });
    }

    function _createDetailDialogDeployment(params) {
        return new Promise(function (resolve) {
            __webpack_require__.e/* require */(4).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/dialog/deployment/DetailDialogDeploymentView.js")]; (function (JIRADevStatusDetailDialogDeploymentView) {
                var view = new JIRADevStatusDetailDialogDeploymentView(_getDetailDialogParameters(params, {
                    id: 'devstatus-deployment-detail-dialog'
                }));
                resolve(view);
            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
        });
    }

    function showDialog(issueKey, issueId, devSummary, dataType, showContactAdminForm) {
        var self = this;

        var createDialogView = fusionDialogFactoryPerType[dataType];
        var params = {
            issueKey: issueKey,
            issueId: issueId,
            devSummary: devSummary,
            dataType: dataType,
            showContactAdminForm: showContactAdminForm
        };
        createDialogView(params).then(function (dialogView) {
            self.devStatusDialogView = dialogView;
            dialogView.show();
        });
    }

    return {
        showDialog: showDialog
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/dev-summary-refresh-analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/releasereport/release-report-metadata.js"), __webpack_require__("./js/util/analytics.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (RRMetadata, analytics) {
    'use strict';

    function generateRequestId() {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (str) {
            var rand = Math.floor(Math.random() * 16);
            var result = str == 'x' ? rand : rand & 0x3 | 0x8;
            return result.toString(16);
        });
    }

    function backgroundRefreshForAnalytics(refreshPromise) {
        var versionId = RRMetadata.getVersionId();

        var requestId = generateRequestId();
        analytics.sendEvent('jira.devsummary.background-refresh.bulk.start', {
            versionId: versionId,
            requestId: requestId
        });
        refreshPromise.always(function (data) {
            data.versionId = versionId;
            data.requestId = requestId;
            analytics.sendEvent('jira.devsummary.background-refresh.bulk.end', data);
        });
    }

    function fireUserPermissionsEvent(staleIssueCount) {
        var data = {
            versionId: RRMetadata.getVersionId(),
            totalIssueCount: RRMetadata.getTotalIssueCount(),
            staleIssueCount: staleIssueCount
        };

        analytics.sendEvent('jira.devsummary.background-refresh.bulk.userpermissions', data);
    }

    return {
        startAnalytics: backgroundRefreshForAnalytics,
        fireUserPermissionsEvent: fireUserPermissionsEvent
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/dev-summary-refresh-ui.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(0);
__webpack_require__(1);

/**
 * This lib is for handling the UI components for different states of background refresh {@link: DevSummaryRefresh}
 *
 * It will trigger the refresh, and the refresh will return a [promise]{@link external:jQuery.DeferredObject}
 * Basically, we need to handle
 *  'done', 'fail' and 'progress' from this promise
 *
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("com.atlassian.auiplugin:aui-flag/require('aui/flag')"), __webpack_require__("./js/releasereport/dev-summary-refresh.js"), __webpack_require__("./js/util/Helpers.js"), __webpack_require__("./js/releasereport/release-report-metadata.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (logger, formatter, jquery, Backbone, _, flag, DevSummaryRefresh, Helper, RRMetadata) {
    'use strict';

    var ANIMATION_CONSTS = {
        TRANSIT_DURATION_OUT: 800,
        TRANSIT_DURATION_IN: 1200,
        MAX_SPEED_FOR_PROGRESS_BAR: 5,
        MIN_FINISHING_SPEED_FOR_PROGRESS_BAR: 2,
        UNIT_INTERVAL: 50,
        MESSAGE_STAY_DURATION: 2200,
        MIN_PROGRESSBAR_DURATION: 1000
    };

    var EVENTS = {
        PROGRESS_MESSAGE_CHANGED: 'progress-message-changed',
        PERCENT_REACHED: 'percent-reached',
        FLAG_MESSAGE_SHOWN: 'flag-message-shown',
        FLAG_MESSAGE_TOO_MANY: 'error-too-many-issue',
        FLAG_MESSAGE_TIMEOUT: 'error-timeout',
        FLAG_MESSAGE_GENERIC_CLIENT_ERROR: 'generic-client-error',
        FLAG_MESSAGE_DEV_SUMMARY_STALE: 'error-dev-summary-stale'
    };

    // adding context path to the key to make sure that there is no namespace conflict
    var RELEASE_REPORT_BACKGROUND_REFRESH_ERROR_SEEN_KEY = 'release_report_background_refresh_error_seen' + Helper.getContextPath();

    var URL_BROKEN_PROVIDERS = Helper.getContextPath() + '/rest/dev-status/1.0/issue/broken-providers';

    var MAX_LOCAL_STORAGE_ENTRIES = 200;

    /**
    *  All states will be refreshed based on the promise object coming from dev-summary-refresh, hence no linked Model.
    *
    * @type {Backbone.View} this is the progress view object to manipulate the progress status displaying after
    * the version status lozenge
    *
    */
    var RefreshProgress = Backbone.View.extend({
        initialize: function initialize(options) {
            this.$progressEl = options.$progressEl;
            this.templates = options.templates;
            this.refreshPromise = options.refreshPromise;
            _.bindAll(this, '_done', '_progress', '_error');

            this.reportKey = RRMetadata.getProjectKey() + '-' + RRMetadata.getVersionId();

            this.render();
        },
        render: function render() {
            var self = this;
            self._percentageInfo = null;
            return this;
        },
        _isTransit: false,
        _nextMessage: null,
        _hideTimer: null,
        /**
        * When we drop IE9 we can migrate this code to use CSS3 transitions instead of jQuery.animate.
        *
        * @param messageHtml {string} the string to be shown inside the progress wrapper. in HTML.
        * @param opts {object} 'autoHideDelay' | 'showDelay' | 'showStartCallback' | 'showEndCallback'
        */
        transit: function transit(messageHtml, opts) {
            var self = this;
            var opacity;
            opts = opts || {};

            clearTimeout(self._hideTimer);

            // if we are transiting to progress, then messageHtml corresponds to the progress bar, which is rendered
            // in a separate progress element rather than the primary view element, since the progress bar is hidden
            // within an inline dialog
            var $el = opts.transitToProgress ? self.$progressEl : self.$el;

            // check the opacity of the indicator
            if (!$el.is(':visible')) {
                $el.show().css('opacity', 0);
                opacity = 0;
            } else {
                opacity = Number($el.css('opacity'));
                opacity = isNaN(opacity) ? 1 : opacity;
            }

            if (!messageHtml && messageHtml !== '') {
                $el.stop().animate({
                    opacity: 0
                }, ANIMATION_CONSTS.TRANSIT_DURATION_OUT * opacity, 'linear');
                return;
            }

            if (self._isTransiting) {
                self._nextMessage = _.extend({}, opts, {
                    messageHtml: messageHtml
                });
                return;
            }
            self._isTransiting = true;

            var startTransit = function startTransit() {
                // let's hide it first to make the UI smooth
                $el.stop().animate({
                    opacity: 0
                }, ANIMATION_CONSTS.TRANSIT_DURATION_OUT * opacity, 'linear', function () {
                    // and then we replace the content
                    $el.html(messageHtml);

                    if (opts.transitToProgress) {
                        // fill the primary element with a sync icon and message, since the progress bar
                        // will be rendered in an inline dialog that shows up on hover
                        self.$el.append(JIRA.Templates.ReleaseReport.backgroundRefreshSyncMessage({}));
                        self.$('.message').animate({ opacity: 1 }, ANIMATION_CONSTS.TRANSIT_DURATION_IN, 'linear');
                    } else {
                        // if we just transitioned away from the sync icon and message then we need to disable
                        // the progress bar inline dialog
                        self.$('.message').remove();
                    }

                    // we need this setTimeout to make any transition work
                    setTimeout(function () {
                        opts.showStartCallback && opts.showStartCallback();
                    });

                    // and show the text gracefully
                    $el.animate({
                        opacity: 1
                    }, ANIMATION_CONSTS.TRANSIT_DURATION_IN, 'linear', function () {
                        // if we have a pending message to show, GO!
                        self._isTransiting = false;
                        self.trigger(EVENTS.PROGRESS_MESSAGE_CHANGED, messageHtml);
                        if (self._nextMessage) {
                            self.transit(self._nextMessage.messageHtml, self._nextMessage);
                            self._nextMessage = null;
                        }

                        // we need this setTimeout to make any transition work
                        setTimeout(function () {
                            opts.showEndCallback && opts.showEndCallback();
                        });

                        if (opts.autoHideDelay) {
                            self._hideTimer = setTimeout(function () {
                                $el.animate({ opacity: 0 }, ANIMATION_CONSTS.TRANSIT_DURATION_OUT, function () {
                                    $el.hide();
                                });
                            }, opts.autoHideDelay);
                        }
                    });
                });
            };

            // check if there is a show delay
            if (opts.showDelay) {
                self._hideTimer = setTimeout(function () {
                    startTransit();
                }, opts.showDelay);
            } else {
                startTransit();
            }
        },
        /**
        * We trigger the refresh from here, and it needs to check if the flag is turned on or not.
        */
        refresh: function refresh() {
            var self = this;
            self._status = 'init';

            self.refreshPromise.progress(self._progress).done(self._done).fail(self._error);
        },

        _percentageInfo: null,
        _percentageTimer: null,
        _setProgressWidth: function _setProgressWidth(percent) {
            var self = this;
            self._progressPercent = percent;

            var $progressInner = self.$progressEl.find('.progress-bar-inner');

            var currPercent = $progressInner.data('percent');
            currPercent = currPercent || 0;

            // avoid double setting the percentage info
            if (!self._percentageInfo || self._percentageInfo.percent < percent || !percent) {
                // calculating the speed
                if (!self._percentageInfo || !percent) {
                    self._percentageInfo = {
                        time: new Date().getTime(),
                        percent: percent,
                        speed: 0
                    };
                } else {
                    var newInfo = {
                        time: new Date().getTime(),
                        percent: percent
                    };
                    var oldInfo = self._percentageInfo;
                    if (percent !== 100) {
                        newInfo.speed = (newInfo.percent - oldInfo.percent) / (newInfo.time - oldInfo.time) * ANIMATION_CONSTS.UNIT_INTERVAL;
                        if (oldInfo.speed) {
                            newInfo.speed = newInfo.speed * 2 / 3 + oldInfo.speed / 3;
                        }
                    } else {
                        newInfo.speed = (newInfo.percent - currPercent) / ANIMATION_CONSTS.MIN_PROGRESSBAR_DURATION * ANIMATION_CONSTS.UNIT_INTERVAL;
                        newInfo.speed = newInfo.speed < ANIMATION_CONSTS.MIN_FINISHING_SPEED_FOR_PROGRESS_BAR ? ANIMATION_CONSTS.MIN_FINISHING_SPEED_FOR_PROGRESS_BAR : newInfo.speed;
                    }
                    newInfo.speed = newInfo.speed > ANIMATION_CONSTS.MAX_SPEED_FOR_PROGRESS_BAR ? ANIMATION_CONSTS.MAX_SPEED_FOR_PROGRESS_BAR : newInfo.speed;

                    self._percentageInfo = newInfo;
                }
            }

            if (!$progressInner.length) {
                return;
            }

            clearInterval(self._percentageTimer);
            self._percentageTimer = setInterval(function () {
                currPercent += self._percentageInfo.speed;
                if (currPercent >= percent) {
                    currPercent = percent;
                    clearInterval(self._percentageTimer);
                    self.trigger(EVENTS.PERCENT_REACHED, percent);
                }

                $progressInner.width(currPercent + '%').data('percent', currPercent);
            }, ANIMATION_CONSTS.UNIT_INTERVAL);
        },

        _status: 'init',
        /**
        *
        * @param data {object} 'devSummaryChanged' (refresh finished with changes)
        */
        _done: function _done(data) {
            var self = this;

            var showEndCallBack = function showEndCallBack(message, showDelay, callback) {
                self.transit(message, {
                    showDelay: showDelay,
                    autoHideDelay: ANIMATION_CONSTS.MESSAGE_STAY_DURATION,
                    showStartCallback: function showStartCallback() {
                        callback && callback();
                    }
                });
            };

            if (self._status !== 'done') {
                if (data.devSummaryChanged) {
                    self._setProgressWidth(100);
                    showEndCallBack('', ANIMATION_CONSTS.TRANSIT_DURATION_IN, function () {
                        flag({
                            body: self.templates.dataChanged(),
                            close: 'manual',
                            title: ''
                        });
                        jquery('.aui-flag .reload-tab').click(function () {
                            location.reload();
                        });
                        self.trigger(EVENTS.FLAG_MESSAGE_SHOWN);
                    });
                } else {
                    if (self._status === 'progress') {
                        self._setProgressWidth(100);
                        showEndCallBack(self.templates.noChange(), ANIMATION_CONSTS.TRANSIT_DURATION_IN);
                    } else {
                        showEndCallBack(self.templates.noChange());
                    }
                }

                self.clearErrorsSeenForVersion();
            }
            self._status = 'done';
        },
        _progressPercent: 0,
        _progress: function _progress(progressData) {
            var self = this;

            if (!progressData.percent) {
                self.time = new Date().getTime();
            }

            if (self._status !== 'progress') {
                self.transit(self.templates.progress({
                    numOfIssues: progressData.total
                }), {
                    showStartCallback: function showStartCallback() {
                        self._setProgressWidth(self._progressPercent);
                    },
                    transitToProgress: true
                });
            }
            self._status = 'progress';
            self._setProgressWidth(progressData.percent);
        },
        _error: function _error(errorData) {
            var self = this;

            if (errorData.error === DevSummaryRefresh.ERRORS.TOO_MANY_ISSUES) {
                var MSG_TOO_MANY_ISSUES = formatter.I18n.getText('releasereport.background.refresh.error.too-many-issues');
                this.showFlagForUnseenError(errorData.error, MSG_TOO_MANY_ISSUES, EVENTS.FLAG_MESSAGE_TOO_MANY);
                this.showInlineDialog(MSG_TOO_MANY_ISSUES);
            } else if (errorData.error === DevSummaryRefresh.ERRORS.TIMEOUT) {
                var MSG_TIMEOUT = formatter.I18n.getText('releasereport.background.refresh.error.time-out');
                this.showFlagForUnseenError(errorData.error, MSG_TIMEOUT, EVENTS.FLAG_MESSAGE_TIMEOUT);
                this.showInlineDialog(MSG_TIMEOUT);
            } else if (errorData.error === DevSummaryRefresh.ERRORS.CLIENT_ERROR) {
                var MSG_CLIENT_ERROR = formatter.I18n.getText('releasereport.background.refresh.error.client-error');
                this.showFlagForUnseenError(errorData.error, MSG_CLIENT_ERROR, EVENTS.FLAG_MESSAGE_GENERIC_CLIENT_ERROR);
                this.showInlineDialog(MSG_CLIENT_ERROR);
            } else if (errorData.error === DevSummaryRefresh.ERRORS.DEV_SUMMARY_STALE) {
                var errorSeen = self.isErrorSeenForVersion(this.getStorageKey(errorData.error));
                self._setProgressWidth(100);

                self.transit(self.templates.devSummaryStale(), {
                    showDelay: ANIMATION_CONSTS.TRANSIT_DURATION_IN,
                    showStartCallback: function showStartCallback() {
                        jquery('#inline-dialog-dev-summary-stale-message').remove();
                        var MSG_STALE_TITLE = formatter.I18n.getText('releasereport.background.refresh.error.dev-summary.stale.title');

                        if (!errorSeen) {
                            self.retrieveBrokenProviders(function (response) {
                                self.showFlagForUnseenError(errorData.error, self.renderStaleMessage('', response), EVENTS.FLAG_MESSAGE_DEV_SUMMARY_STALE);
                            });
                        }

                        self.$('.background-refresh-dev-summary-stale').append(JIRA.Templates.ReleaseReport.inlineDialog({
                            alignment: 'bottom right',
                            id: 'background-refresh-stale-dialog',
                            isHover: false
                        }));

                        var inlineDialog = self.$('.background-refresh-dev-summary-stale aui-inline-dialog').get(0);
                        inlineDialog.addEventListener('aui-layer-show', function (e) {
                            var $inlineDialog = jquery(inlineDialog);
                            $inlineDialog.find('.contents').html(self.templates.staleMessageLoading());
                            $inlineDialog.find('.contents .request-spinner').spin({
                                left: 0,
                                top: 0
                            });

                            self.retrieveBrokenProviders(function (response) {
                                $inlineDialog.find('.contents').html(self.renderStaleMessage(MSG_STALE_TITLE, response));
                            });
                        });
                    }
                });
            }
        },
        _updateLocalStorage: function _updateLocalStorage(errorsSeen) {
            try {
                // again don't be blocked by any potential problem
                localStorage.setItem(RELEASE_REPORT_BACKGROUND_REFRESH_ERROR_SEEN_KEY, JSON.stringify(errorsSeen || {}));
            } catch (ex) {}
        },
        renderStaleMessage: function renderStaleMessage(title, response) {
            return this.templates.staleMessage({
                title: title,
                errorInstances: response,
                showContactAdminForm: RRMetadata.shouldShowContactAdminForm()
            });
        },
        cachedBrokenProviderResponse: null,
        retrieveBrokenProviders: function retrieveBrokenProviders(callbackFunction) {
            var self = this;
            var getBrokenProvidersAJAX = function getBrokenProvidersAJAX() {
                var callbackFunctionWrapper = function callbackFunctionWrapper(response) {
                    self.cachedBrokenProviderResponse = response;
                    callbackFunction(response);
                };
                jquery.get(URL_BROKEN_PROVIDERS, {
                    versionId: RRMetadata.getVersionId()
                }).done(callbackFunctionWrapper).fail(function () {
                    callbackFunctionWrapper([]);
                });
            };
            if (!this.cachedBrokenProviderResponse) {
                getBrokenProvidersAJAX();
            } else {
                callbackFunction(self.cachedBrokenProviderResponse);
            }
        },
        showFlagForUnseenError: function showFlagForUnseenError(errorId, errorMsg, eventToTrigger) {
            var STORAGE_KEY = this.getStorageKey(errorId);
            var errorSeen = this.isErrorSeenForVersion(STORAGE_KEY);

            if (!errorSeen) {
                this.showFlagForError(errorMsg, eventToTrigger);
                this.setErrorSeenForVersion(STORAGE_KEY, true);
            }
        },
        showFlagForError: function showFlagForError(errorMsg, eventToTrigger) {
            flag({
                title: formatter.I18n.getText('releasereport.background.refresh.error.dev-summary.stale.title'),
                type: 'warning',
                close: 'auto',
                body: errorMsg
            });
            this.trigger(EVENTS.FLAG_MESSAGE_SHOWN);
            this.trigger(eventToTrigger);
        },
        getStorageKey: function getStorageKey(errorId) {
            return errorId + '-' + this.reportKey;
        },
        showInlineDialog: function showInlineDialog(errorMsg) {
            var self = this;
            self.transit(self.templates.devSummaryStale(), {
                showDelay: ANIMATION_CONSTS.TRANSIT_DURATION_IN,
                showStartCallback: function showStartCallback() {
                    jquery('#background-refresh-stale-dialog').remove();

                    self.$('.background-refresh-dev-summary-stale').append(JIRA.Templates.ReleaseReport.inlineDialog({
                        alignment: 'bottom right',
                        id: 'background-refresh-stale-dialog',
                        isHover: false
                    }));

                    var inlineDialog = self.$('.background-refresh-dev-summary-stale aui-inline-dialog').get(0);
                    inlineDialog.addEventListener('aui-layer-show', function (e) {
                        var $inlineDialog = jquery(inlineDialog);
                        $inlineDialog.find('.contents').html(self.templates.inlineDialogMessage({
                            message: errorMsg
                        }));
                    });
                }
            });
        },
        isErrorSeenForVersion: function isErrorSeenForVersion(key) {
            try {
                var errorsSeen = this.getErrorsSeenForAllVersions() || {};
                return errorsSeen[key];
            } catch (ex) {}
            // return empty data set so that we won't be affected when any error occurs or data is empty
            return false;
        },
        getErrorsSeenForAllVersions: function getErrorsSeenForAllVersions() {
            try {
                return JSON.parse(localStorage.getItem(RELEASE_REPORT_BACKGROUND_REFRESH_ERROR_SEEN_KEY));
            } catch (ex) {
                return undefined;
            }
        },
        /**
        * @param key error key from DevSummaryRefresh.ERRORS, e.g. DevSummaryRefresh.ERRORS.TIMEOUT
        * @param seen boolean indicating if error has been seen
        */
        setErrorSeenForVersion: function setErrorSeenForVersion(key, seen) {
            var errorsSeen = this.getErrorsSeenForAllVersions() || {};

            if (_.size(errorsSeen) >= MAX_LOCAL_STORAGE_ENTRIES) {
                localStorage.removeItem(RELEASE_REPORT_BACKGROUND_REFRESH_ERROR_SEEN_KEY);
                errorsSeen = {};
            }

            errorsSeen[key] = seen;
            this._updateLocalStorage(errorsSeen);
        },
        /**
        * Clear errors seens for current version.
        */
        clearErrorsSeenForVersion: function clearErrorsSeenForVersion() {
            try {
                var errorsSeen = this.getErrorsSeenForAllVersions();
                if (!errorsSeen) {
                    return;
                }

                var self = this;

                _.each(DevSummaryRefresh.ERRORS, function (value) {
                    delete errorsSeen[self.getStorageKey(value)];
                });

                this._updateLocalStorage(errorsSeen);
            } catch (ex) {
                logger.log('Failed to clear version errors state in localStorage');
                logger.log(ex);
            }
        }
    });

    /**
     *
     * @param options:
     *  'refreshPromise' that holds the promise for dev summary refresh plugin
     *  'reportKey' which is a combination of ${projectID}_${versionID}_release-report
     */
    var setupDevSummaryRefreshUI = function setupDevSummaryRefreshUI(options) {
        options = options || {};

        var uiRefreshCallback = function uiRefreshCallback(refreshPromise) {
            if (refreshPromise) {
                options = _.extend({}, {
                    el: jquery('.background-refresh-sync-wrapper')[0],
                    $progressEl: jquery('#background-refresh-progress-dialog .contents'),
                    templates: {
                        progress: JIRA.Templates.ReleaseReport.backgroundRefreshProgress,
                        noChange: JIRA.Templates.ReleaseReport.backgroundRefreshSuccessNoChange,
                        dataChanged: JIRA.Templates.ReleaseReport.backgroundRefreshSuccessHasChange,
                        devSummaryStaleFlag: JIRA.Templates.ReleaseReport.backgroundRefreshDevSummaryStaleFlag,
                        devSummaryStale: JIRA.Templates.ReleaseReport.backgroundRefreshDevSummaryStale,
                        staleMessage: JIRA.Templates.DevStatus.connectionAndConfigErrorsMessages,
                        staleMessageLoading: JIRA.Templates.ReleaseReport.backgroundRefreshDevSummaryStaleMessageLoading,
                        inlineDialogMessage: JIRA.Templates.ReleaseReport.backgroundRefreshInlineDialogMessage
                    },
                    refreshPromise: refreshPromise
                }, options);
                var refreshProgress = new RefreshProgress(options);

                refreshProgress.refresh();
            }
            return refreshProgress;
        };

        if (options.refreshPromise) {
            // this is for qunit test to setup the refresh ui for testing
            _.extend(ANIMATION_CONSTS, options.ANIMATION_CONSTS);
            return uiRefreshCallback(options.refreshPromise);
        } else {
            DevSummaryRefresh.refresh(uiRefreshCallback);
        }
    };

    return {
        refresh: setupDevSummaryRefreshUI,
        EVENTS: EVENTS,
        ANIMATION_CONSTS: ANIMATION_CONSTS,
        RELEASE_REPORT_BACKGROUND_REFRESH_ERROR_SEEN_KEY: RELEASE_REPORT_BACKGROUND_REFRESH_ERROR_SEEN_KEY,
        MAX_LOCAL_STORAGE_ENTRIES: MAX_LOCAL_STORAGE_ENTRIES
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/dev-summary-refresh.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-data/require('wrm/data')"), __webpack_require__("./js/util/Helpers.js"), __webpack_require__("./js/releasereport/dev-summary-refresh-analytics.js"), __webpack_require__("./js/releasereport/release-report-metadata.js"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmData, Helpers, DevSummaryRefreshAnalytics, RRMetadata, _, jquery) {
    'use strict';

    var refresh = undefined;
    var startTime = undefined;

    var searchUrl = Helpers.getContextPath() + '/rest/dev-status/1.0/issue/stale-issues';
    var bulkSummaryRefreshUrl = Helpers.getContextPath() + '/rest/dev-status/1.0/issue/bulksummary';

    var ERRORS = {
        TOO_MANY_ISSUES: 'too-many',
        TIMEOUT: 'timeout',
        CLIENT_ERROR: 'client-error',
        DEV_SUMMARY_STALE: 'dev-summary-stale'
    };

    /**
    * Retrieve issueIds to refresh for the given version
    *
    * @param {long} versionId The version ID to retrieve stale issues for
    * @returns {*} {error:} or list of issue ids
    */
    function fetchIssueIdsToRefresh(versionId) {
        var maxStaleIssuesToRetrieve = getMetadata('maxStaleIssuesToRetrieve');
        var searchRequest = jquery.ajax({
            type: 'GET',
            url: searchUrl,
            data: {
                versionId: versionId,
                maxResults: maxStaleIssuesToRetrieve
            },
            contentType: 'application/json; charset=utf-8'
        });

        return searchRequest.pipe(function (issueIds) {
            if (issueIds.length >= maxStaleIssuesToRetrieve) {
                return { error: ERRORS.TOO_MANY_ISSUES };
            }
            return issueIds;
        }).fail(failAtRequest);
    }

    /**
    * Performs the background refresh of the provided issue IDs, returning a Promise that resolves on
    * completion of the refresh
    *
    * @param devSummaryRefresh The refresh request data
    * @param devSummaryRefresh.issueIds list of issue ids for this refresh operation
    * @param devSummaryRefresh.maxIssuesRefreshed The maximum number of issues to refresh in each refresh request
    * @param devSummaryRefresh.index The index into the partitioned issue id list for the next refresh request
    * @param devSummaryRefresh.devSummaryChanged Records whether the dev summary changed for one or more issues
    * @param devSummaryRefresh.devSummaryStale Records whether the dev summary is stale for one or more issues
    * @param devSummaryRefresh.numChangedIssues The number of issues that have changed so far during the refresh
    *
    * @returns {Promise} The promise for the completion of the dev summary refresh
    */
    function refreshDevSummaryForIssueIds(devSummaryRefresh) {
        var maxIssuesRefreshed = devSummaryRefresh.maxIssuesRefreshed;
        var allIssueIdsToRefresh = devSummaryRefresh.issueIds;

        var subsetToRefresh = allIssueIdsToRefresh.slice(devSummaryRefresh.index * maxIssuesRefreshed, (devSummaryRefresh.index + 1) * maxIssuesRefreshed);

        if (_.isEmpty(subsetToRefresh)) {
            if (devSummaryRefresh.devSummaryStale) {
                failRefresh(ERRORS.DEV_SUMMARY_STALE);
            } else {
                succeedRefresh({
                    devSummaryStale: devSummaryRefresh.devSummaryStale,
                    devSummaryChanged: devSummaryRefresh.devSummaryChanged,
                    numChangedIssues: devSummaryRefresh.numChangedIssues,
                    issuesRefreshed: allIssueIdsToRefresh.length,
                    timeElapsed: new Date() - startTime,
                    result: 'success'
                });
            }
            return;
        }

        var queryParams = '?issueId=' + _.reduce(subsetToRefresh, function (memo, issueId) {
            return memo + '&issueId=' + issueId;
        });

        refresh.notify({
            percent: Math.floor(devSummaryRefresh.index * maxIssuesRefreshed / allIssueIdsToRefresh.length * 100),
            total: moreStaleIssuesThanTotalIssues(allIssueIdsToRefresh) ? null : allIssueIdsToRefresh.length
        });

        jquery.ajax(bulkSummaryRefreshUrl + queryParams, {
            type: 'GET',
            timeout: 30000 // Explicit 30 second timeout, don't rely on global AJAX settings.
        }).done(function (data) {
            // Problem of background refresh related to devtool provider will be detected here when it is not in
            // Background refresh pause mode
            // NOTE: When in background refresh pause mode, you should check some data coming from the page load, or
            // anywhere disabling the background refresh.
            devSummaryRefresh.devSummaryChanged = devSummaryRefresh.devSummaryChanged || !!data.changed;
            devSummaryRefresh.devSummaryStale = devSummaryRefresh.devSummaryStale || !!data.devSummaryStale;
            devSummaryRefresh.index += 1;
            devSummaryRefresh.numChangedIssues += data.changedIssues == null ? 0 : data.changedIssues.length;

            return refreshDevSummaryForIssueIds(devSummaryRefresh);
        }).fail(failAtRequest);
    }

    var metadataCache = {};

    /**
    * Returns a metadata item added to the DOM by BackgroundRefreshMetadataProvider.java.
    *
    * @param key the bare key of the desired metadata item
    * @returns a correctly typed value, e.g. boolean, number, etc
    */
    function getMetadata(key) {
        // We cache the values because WRM.data.claim only returns the value once
        if (metadataCache.hasOwnProperty(key)) {
            return metadataCache[key];
        }
        var value = wrmData.claim('com.atlassian.jira.plugins.jira-development-integration-plugin:' + key);
        metadataCache[key] = value;
        return value;
    }

    /**
    * Refresh the dev summary for the issues on the page with potentially stale dev summary.
    *
    * If a refresh is currently in progress, this function will return the same promise.
    *
    * Progress will be reported and can be listened to through .progress().
    *
    * @return a jQuery Promise for the refresh operation.
    */
    function refreshDevSummary(uiRefreshCallback) {
        var backgroundRefreshEnabled = getMetadata('backgroundRefreshEnabled');
        var maxIssuesToRefresh = getMetadata('maxIssuesToRefresh');
        var staleQuery = getMetadata('staleQuery');
        var versionId = RRMetadata.getVersionId();

        if (backgroundRefreshEnabled) {
            var startRefresh = function startRefresh() {
                if (_.isUndefined(refresh)) {
                    refresh = jquery.Deferred();
                    startTime = new Date();

                    // start analytics
                    DevSummaryRefreshAnalytics.startAnalytics(refresh);

                    // This is getting the request from /search
                    fetchIssueIdsToRefresh(versionId).done(function (result) {
                        if (result.error) {
                            failRefresh(result.error);
                        } else {
                            if (moreStaleIssuesThanTotalIssues(result)) {
                                DevSummaryRefreshAnalytics.fireUserPermissionsEvent(result.length);
                            }
                            refreshDevSummaryForIssueIds({
                                issueIds: result,
                                maxIssuesRefreshed: maxIssuesToRefresh,
                                index: 0,
                                numChangedIssues: 0
                            });
                        }
                    });
                }
                uiRefreshCallback && uiRefreshCallback(refresh);
            };

            startRefresh();
        } else {
            uiRefreshCallback && uiRefreshCallback(false);
        }
    }

    function moreStaleIssuesThanTotalIssues(staleIssues) {
        return staleIssues != null && staleIssues.length > RRMetadata.getTotalIssueCount();
    }

    function succeedRefresh(result) {
        refresh.resolve(result);
        refresh = undefined;
    }

    function failAtRequest(jqXHR, textStatus, errorThrown) {
        failRefresh(textStatus == 'timeout' ? ERRORS.TIMEOUT : ERRORS.CLIENT_ERROR);
    }

    function failRefresh(error) {
        var data = {
            timeElapsed: new Date() - startTime,
            result: error,
            error: error
        };

        refresh.reject(data);
        refresh = undefined;
    }

    return {
        ERRORS: ERRORS,
        refresh: refreshDevSummary
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/index.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var jquery = __webpack_require__("jira.webresources:jquery/require('jquery')");
var tooltip = __webpack_require__("./js/component/tooltip.js");
var widthAdjuster = __webpack_require__("./js/releasereport/width-adjuster.js");

var TabModel = __webpack_require__("./js/releasereport/tab-model.js");
var TabView = __webpack_require__("./js/releasereport/tab-view.js");
var ProgressView = __webpack_require__("./js/releasereport/progress-view.js");
var devSummaryRefreshUI = __webpack_require__("./js/releasereport/dev-summary-refresh-ui.js");
var auiExpanderTwiddler = __webpack_require__("./js/releasereport/aui-expander-twiddler.js");

jquery(function () {
    // initialize release report tab view
    var tabModel = new TabModel({});

    // #project-tab isn't removed from the DOM when navigating to different sections of the project version page,
    // so our events won't need to be rebound if we bind them using delegation with this as the container.
    var projectTabSelector = '#project-tab';
    if (jquery(projectTabSelector).length === 0) {
        // Viewing the standalone release report
        projectTabSelector = '#release-report';
    }

    var progressView = new ProgressView({
        model: tabModel,
        el: projectTabSelector
    });

    new TabView({
        model: tabModel,
        el: projectTabSelector,
        progressView: progressView
    });

    // initialize dev summary refresh
    devSummaryRefreshUI.refresh();

    // initialize aui expander twiddler (what is this?)
    auiExpanderTwiddler.register();

    // initialize release report tooltip
    var context = '#release-report';

    tooltip.tipsify({
        selector: '.author-avatar-wrapper',
        context: context
    });
    tooltip.tipsify({
        selector: '.fusion-widget-tooltip',
        context: context,
        html: true,
        gravity: 'ne' // this helps to keep the arrows pointing to the correct location
    });
});

// set up width adjuster
widthAdjuster.bindWidthAdjustmentToWindowResize();

/***/ }),

/***/ "./js/releasereport/manage-warnings-model.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/util/Strings.js"), __webpack_require__("./js/util/Helpers.js"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (Strings, Helpers, backbone, _) {
    'use strict';

    return backbone.Model.extend({
        // The view's render method passes these model properties (via JSON) to the
        // same-named params of the ManageWarningCategories.manage Soy template.
        properties: ['warningCategories', 'dataProviders'],

        initialize: function initialize(data) {
            this.projectKey = data.projectKey;
            this.versionId = data.versionId;
        },

        /**
        * Set the warning category enabled state.
        * @param warningCategory
        * @param enabled
        */
        setEnabledState: function setEnabledState(warningCategory, enabled) {
            var warningCategories = this.get('warningCategories');
            var newWarningCategories = [];

            for (var i = 0; i < warningCategories.length; i++) {
                newWarningCategories[i] = _.clone(warningCategories[i]);
                if (newWarningCategories[i].key === warningCategory) {
                    newWarningCategories[i].disabled = !enabled;
                }
            }
            this.set('warningCategories', newWarningCategories);
        },

        url: function url() {
            return Strings.format('{0}/rest/release-report/1.0/warnings/config?projectKey={1}&versionId={2}', Helpers.getContextPath(), this.get('projectKey'), this.get('versionId'));
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/manage-warnings-module.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/releasereport/manage-warnings-model.js"), __webpack_require__("./js/releasereport/manage-warnings-view.js"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (ManageWarningsModel, ManageWarningsView, jquery) {
    'use strict';

    return {
        show: function show(tabView) {
            var $metadataHolder = jquery('#release-report-tabs-section');

            this.model = new ManageWarningsModel({
                projectKey: $metadataHolder.data('project-key'),
                versionId: $metadataHolder.data('version-id')
            });

            // The element gets set to the dialog after it is popped
            this.view = new ManageWarningsView({
                model: this.model,
                id: 'manage-warnings-aui-dialog',
                tabView: tabView
            });

            this.view.show();
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/manage-warnings-view.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(2);
__webpack_require__(11);

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("com.atlassian.auiplugin:aui-flag/require('aui/flag')"), __webpack_require__("./js/util/Login.js"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("./js/releasereport/release-report-analytics.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter, Flag, Login, backbone, _, jquery, ReleaseReportAnalytics) {
    'use strict';

    var view = backbone.View.extend({
        frameTemplate: JIRA.Templates.DevStatus.DetailDialogFrame.frame,

        events: {
            'change input:checkbox': 'checked'
        },

        initialize: function initialize(options) {
            var that = this;
            this.tabView = options.tabView;

            this.model.on('request', this._showLoadingIndicator, this);
            this.model.on('change', this.render, this);

            this._initDialog();
            this.model.fetch({
                success: function success() {
                    that.originalWarningCategories = _.clone(that.model.get('warningCategories'));
                }
            });
        },

        render: function render() {
            this._hideLoadingIndicator();
            this._getContentDiv().empty().append(JIRA.Templates.ReleaseReport.ManageWarningCategories.manage(this.model.toJSON()));

            return this;
        },

        checked: function checked(ev) {
            this.model.setEnabledState(ev.target.name.substr('checkbox:'.length), ev.target.checked);
        },

        show: function show() {
            this.dialog.show();
        },

        _showLoadingIndicator: function _showLoadingIndicator() {
            var $content = this._getContentDiv();
            $content._removeClass('ready');
            $content.addClass('loading');
            var loadingIndicator = $content.find('.status-loading');
            loadingIndicator.spin('large');
            loadingIndicator.find('.spinner').css('left', '50%');

            loadingIndicator.show();
        },

        _hideLoadingIndicator: function _hideLoadingIndicator() {
            var $content = this._getContentDiv();
            $content.addClass('ready');
            var loadingIndicator = $content.find('.status-loading');
            if (loadingIndicator) {
                $content.removeClass('loading');
                loadingIndicator.hide();
                loadingIndicator.spinStop();
            }
        },

        _getContentDiv: function _getContentDiv() {
            return this.$el.find('.manage-warning-categories-dialog').find('.dialog-panel-body');
        },

        _initDialog: function _initDialog() {
            var instance = this;

            this.dialog = new AJS.Dialog({
                id: this.options.id,
                width: 800,
                closeOnOutsideClick: false
            });

            this.$el = this.dialog.popup.element;

            this.dialog.addPage('manage-warning-categories-dialog');
            this.dialog.addPanel('bar', '', 'content');
            this.dialog.addHeader(formatter.I18n.getText('releasereport.warnings.manage'));
            this.dialog.addButton(formatter.I18n.getText('common.words.save'), _.bind(function (event) {
                this.submit();
            }, this), 'aui-button aui-button-primary manage-warnings-submit');

            // button-panel-button messes with primary button styles
            var $submitButton = this.$el.find('.button-panel-button').removeClass('button-panel-button');

            this.dialog.addCancel(formatter.I18n.getText('common.words.cancel'), _.bind(function (event) {
                this.close();
            }, this));

            this._getContentDiv().empty().append(JIRA.Templates.ReleaseReport.ManageWarningCategories.manage({ warningCategories: [], dataProviders: '' }));
        },

        close: function close() {
            this.dialog.remove();
        },

        triggerAnalytics: function triggerAnalytics() {
            // compare old x current state
            var zipped = _.zip(this.originalWarningCategories, this.model.get('warningCategories'));
            var dataProviders = jquery('.js-releasereport-data-providers').data('providers');

            _.each(zipped, function (pair) {
                if (pair[0].disabled !== pair[1].disabled && pair[0].analyticsKey != null) {
                    ReleaseReportAnalytics.triggerWarningCategoryVisibilityToggled(pair[1].analyticsKey, pair[1].disabled, dataProviders);
                }
            });
        },

        submit: function submit() {
            var that = this;
            this.model.save().fail(function (xhr) {
                if (Login.redirectIfUserChanged(xhr)) {
                    return; // No error handling required - redirecting
                }

                var title;
                var body;
                if (xhr.status === 404) {
                    title = formatter.I18n.getText('releasereport.error.not.found.title');
                    body = formatter.I18n.getText('releasereport.error.not.found');
                } else if (xhr.status === 403) {
                    title = formatter.I18n.getText('releasereport.error.forbidden.title');
                    body = formatter.I18n.getText('releasereport.error.forbidden');
                } else {
                    title = formatter.I18n.getText('releasereport.error.server.failure.title');
                    body = formatter.I18n.getText('releasereport.error.server.failure');
                }

                Flag({
                    type: 'error',
                    title: title,
                    body: body
                });
            }).success(function (xhr) {
                that.triggerAnalytics();
            }).always(function () {
                that.close();
                that.tabView.refreshTab('com.atlassian.jira.plugins.jira-development-integration-plugin:release-report-warnings', that.model.projectKey, that.model.versionId);
            });
        }
    });

    return view;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/progress-view.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(0);
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:aui-core-amd-shim/require('aui/inline-dialog')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (backbone, _, jquery, InlineDialog) {
    'use strict';

    var _inlineDialogs = [];
    var PREFIX_DIALOG = 'progress-dialog-';

    function _dimensionsOf(el) {
        var $el = jquery(el);
        var offset = jquery.extend({ left: 0, top: 0 }, $el.offset());
        return {
            left: offset.left,
            top: offset.top,
            width: $el.outerWidth(),
            height: $el.outerHeight()
        };
    }

    return backbone.View.extend({
        initialize: function initialize() {
            this.listenTo(this.model, 'fetchTabContentSucceeded', this.render);
        },

        render: function render(result) {
            var progressBars = JIRA.Templates.ReleaseReport.progressBars({
                issueCount: result.totalIssueCount,
                statusCategoryCounts: result.statusCategoryCounts
            });

            this._getProgressBarContainer().empty().append(progressBars);

            this.setupInlineDialog(result.statusCategoryCounts);
        },

        getInlineDialogs: function getInlineDialogs() {
            return _inlineDialogs;
        },

        setupInlineDialog: function setupInlineDialog(statusCategoryCounts) {
            _.each(_inlineDialogs, function (dialog) {
                dialog.remove();
            });

            this.$el.find('.release-progress .status-category').each(function () {
                var $progressBlock = jquery(this);
                var index = $progressBlock.data('index');

                // Note: if there are no issues in the Version then no inline dialog is required.
                if (index !== -1) {
                    var categoryCount = statusCategoryCounts[index];

                    var dialog = InlineDialog($progressBlock, PREFIX_DIALOG + categoryCount.name.split(/\s+/g).join('_'), function (content, trigger, showPopup) {
                        content.html(JIRA.Templates.ReleaseReport.progressInlineDialog({
                            categoryName: categoryCount.name,
                            colourName: categoryCount.colour,
                            statuses: categoryCount.statuses
                        }));
                        showPopup();
                    }, {
                        onHover: true,
                        hideDelay: 2000,
                        showDelay: 500,
                        calculatePositions: function calculateNorthSouthPositions(popup, targetPosition, mousePosition, opts) {
                            var offsetY = jquery.isFunction(opts.offsetY) ? opts.offsetY(popup, targetPosition, mousePosition, opts) : opts.offsetY;

                            var viewportDimensions = _dimensionsOf(window);
                            var targetDimensions = _dimensionsOf(targetPosition.target);
                            var popupDimensions = _dimensionsOf(popup);
                            var arrowDimensions = _dimensionsOf(popup.find('.aui-inline-dialog-arrow'));

                            var SCREEN_PADDING = 10; //determines how close to the edge the dialog needs to be before it is considered offscreen

                            // Set popup's position (within the viewport)
                            popupDimensions.top = targetDimensions.top + targetDimensions.height + ~~offsetY;
                            popupDimensions.left = mousePosition.x - 20;

                            // Calculate if the popup would render off the side of the viewport
                            var diff = viewportDimensions.width - (popupDimensions.left + popupDimensions.width + SCREEN_PADDING);
                            arrowDimensions.top = -(arrowDimensions.height / 2);

                            // Check if the popup should show up relative to the mouse
                            if (diff < 0) {
                                popupDimensions.right = SCREEN_PADDING;
                                popupDimensions.left = 'auto';
                                arrowDimensions.left = mousePosition.x - (viewportDimensions.width - popupDimensions.width);
                            } else {
                                arrowDimensions.left = mousePosition.x - popupDimensions.left;
                            }

                            return {
                                gravity: 'n',
                                displayAbove: false,
                                popupCss: {
                                    left: popupDimensions.left,
                                    top: popupDimensions.top,
                                    right: popupDimensions.right
                                },
                                arrowCss: {
                                    left: arrowDimensions.left,
                                    top: arrowDimensions.top,
                                    right: arrowDimensions.right
                                }
                            };
                        }
                    });
                    _inlineDialogs.push(dialog);
                }
            });
        },

        _getProgressBarContainer: function _getProgressBarContainer() {
            // we don't keep a reference to this as the element is removed when we go to a different section of the
            // old project version page
            return this.$el.find('.status-category-blocks');
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/release-report-analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/util/analytics.js"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (analytics, _, $) {
    'use strict';

    var ANALYTICS_PREFIX = 'jira.project.versions.version-detail';

    var devTypeAliases = {
        repository: 'commit',
        'deployment-environment': 'deployment'
    };

    var eventNames = {
        FusionWidgetClick: 'devstatus.widget.click',
        WarningCategoryShown: '@tabId.@warningCategoryId.shown', // e.g. warnings-tab.unreviewed.shown
        IssueClick: '@id.issue.clicked', // @id = <tabId>[.warning category id], e.g. warnings-tab.openreviews.issue.clicked
        ReleaseNotesLinkClick: 'release-notes',
        ToggleWarningVisibilityClick: 'warnings-tab.@warningCategoryId.@enabled'
    };

    function createProvidersMap(providersList) {
        var providersMap = {
            bitbucket: 0,
            stash: 0,
            github: 0,
            githube: 0,
            fecru: 0,
            bamboo: 0
        };

        _.each(providersList, function (provider) {
            providersMap[provider] = 1;
        });

        return providersMap;
    }

    function processFusionWidget(counters, $devSummary, devType) {
        var latestDevSummary = $devSummary.cachedValue.summary[devType];

        if (latestDevSummary && latestDevSummary.overall.count > 0) {
            var devTypeAlias = getDevTypeAlias(devType);
            incrementCountForDevType(devTypeAlias, counters);

            if (latestDevSummary.byInstanceType) {
                processInstanceType(devTypeAlias, latestDevSummary.byInstanceType, counters);
            }
        }
        return counters;
    }

    function processInstanceType(devType, instanceTypes, counters) {
        // iterates thru the map of instanceTypes for the devType
        _.each(instanceTypes, function (details, instanceType) {
            incrementCountForDevType(devType + '-' + instanceType, counters);
        });
    }

    function incrementCountForDevType(key, counters) {
        counters[key] = (counters[key] || 0) + 1;
    }

    function getDevTypeAlias(devType) {
        var alias = devTypeAliases[devType];
        return alias ? alias : devType;
    }

    /**
    * Process a given table row for an issue, updating the counters for each devType and devType-instanceType.
    *
    * @param counters          current Map of counters to be updated
    * @param tr                table row for the given issue
    * @param devTypesForIssue  Two-dimensional array to inform if a given issue-id has a dev type data
    * @returns                 Map of counters for each devType and devType-instanceType, e.g.
    *                              { pullrequest: 1, pullrequest-stash: 1, commit: 1, commit-fecru: 1 }
    */
    function processRow(counters, tr, devTypesForIssue) {
        $(tr).find('td.development a.fusion-widget').each(function (index, element) {
            // Note: Do not use jquery.data() to get the attributes because it is slow in IE
            var devSummaryJson = element.getAttribute('data-dev-summary');
            var issueId = element.getAttribute('data-issue-id');
            var devSummary = devSummaryJson ? JSON.parse(devSummaryJson) : null;

            var devTypes = devTypesForIssue[issueId];
            if (devTypes) {
                _.each(devTypes, function (found, devType) {
                    counters = processFusionWidget(counters, devSummary, devType);
                });
            }
        });
        return counters;
    }

    /**
    * Count issues per dev type.
    *
    * @param $tableRowsEl      Table rows (TR) for the issues within the tab
    * @param $widgets          fusion widgets within the tab
    * @returns                 Map of counters for each devType and devType-instanceType
    */
    function countIssuesPerDevType($tableRowsEl, $widgets) {
        var devTypesForIssue = {};

        $widgets.each(function () {
            var id = this.getAttribute('data-issue-id');
            var type = this.getAttribute('data-dev-type');
            if (!id) {
                return;
            }
            if (!devTypesForIssue[id]) {
                devTypesForIssue[id] = {};
            }
            devTypesForIssue[id][type] = true;
        });

        return _.reduce($tableRowsEl, function (counters, tr) {
            return processRow(counters, tr, devTypesForIssue);
        }, {});
    }

    /**
    * Trigger analytics event for warnings tab only.
    *
    * @param eventName event name for the tab being shown
    * @param eventAttributes basic attributes with version info
    */
    function triggerWarningTabAnalytics(eventName, eventAttributes) {
        triggerEventWithPrefix(eventName, eventAttributes);
    }

    /**
    * Trigger analytics event for each warning category.
    * Group issue count per dev type and add the totals as attributes.
    *
    * @param tabEventId        event name for the tab being shown, e.g. warnings-tab
    * @parma warningCategoryEventId warning category analytics name, e.g. openreviews
    * @param eventAttributes   basic attributes with version info
    * @param $tableRowsEl      Table rows (TR) for the issues within the warning category
    * @param $widgets          fusion widgets within the warning category
    */
    function triggerWarningCategoryAnalytics(tabEventId, warningCategoryEventId, eventAttributes, $tableRowsEl, $widgets) {
        var counters = $tableRowsEl ? countIssuesPerDevType($tableRowsEl, $widgets) : {};
        var mergedAttributes = _.extend(_.clone(eventAttributes), counters);

        var eventName = eventNames.WarningCategoryShown.replace('@tabId', tabEventId).replace('@warningCategoryId', warningCategoryEventId);

        triggerEventWithPrefix(eventName, mergedAttributes);
    }

    /**
    * Trigger analytics event for a given tab being shown, apart from warning categories.
    * Group issue count per dev type and add the totals as attributes.
    *
    * @param eventName         event name for the tab being shown
    * @param eventAttributes   basic attributes with version info
    * @param $tableRowsEl      Table rows (TR) for the issues within the tab
    * @param $widgets          fusion widgets within the tab
    */
    function triggerIssueTabAnalytics(eventName, eventAttributes, $tableRowsEl, $widgets) {
        var counters = $tableRowsEl ? countIssuesPerDevType($tableRowsEl, $widgets) : {};
        var mergedAttributes = _.extend(_.clone(eventAttributes), counters);
        triggerEventWithPrefix(eventName, mergedAttributes);
    }

    /**
    * Trigger analytics when a fusion widget is clicked.
    *
    * @param location some issue tab id or warnings tab/warning category id, e.g. 'done-issues-tab', 'warnings-tab.openreviews'
    * @param devType dev type, e.g. repository, review, pullrequest, etc
    */
    function triggerFusionWidgetClicked(location, devType) {
        var devTypeAlias = getDevTypeAlias(devType);

        triggerEventWithPrefix(eventNames.FusionWidgetClick, {
            activity: devTypeAlias,
            location: location
        });
    }

    /**
    * Trigger analytics when the visibility of the warnings for a category are toggled
    *
    * @param warningCategoryId      Which category is being shown
    * @param disabledState           Whether the toggling resulted in them being hidden
    * @param dataProviders          The data providers currently in use in a comma separated string e.g "bitbucket,stash"
    */
    function triggerWarningCategoryVisibilityToggled(warningCategoryId, disabledState, dataProviders) {
        var dataProviderList = dataProviders.split(',');

        var eventName = eventNames.ToggleWarningVisibilityClick.replace('@enabled', disabledState ? 'disabled' : 'enabled').replace('@warningCategoryId', warningCategoryId);

        triggerEventWithPrefix(eventName, createProvidersMap(dataProviderList));
    }

    /**
    * Trigger analytics when an issue key or summary is clicked.
    *
    * @param tabAnalyticsId                analytics id for the tab, e.g. 'warnings-tab', 'done-issues-tab'
    * @param warningCategoryAnalyticsId    analytics id for the warning category, e.g. 'openreviews'
    * @param eventAttributes               attributes for the event
    */
    function triggerIssueClickAnalytics(tabAnalyticsId, warningCategoryAnalyticsId, eventAttributes) {
        var eventId = tabAnalyticsId;
        if (warningCategoryAnalyticsId && warningCategoryAnalyticsId != '') {
            eventId = eventId + '.' + warningCategoryAnalyticsId;
        }
        var eventName = eventNames.IssueClick.replace('@id', eventId);
        triggerEventWithPrefix(eventName, eventAttributes);
    }

    /**
    * Trigger analytics when release notes link is clicked.
    *
    * @param eventAttributes   attributes for the event
    */
    function triggerReleaseNotesLinkAnalytics(eventAttributes) {
        triggerEventWithPrefix(eventNames.ReleaseNotesLinkClick, eventAttributes);
    }

    /**
    * Publish an analytics event to the server, adding a release report prefix to the event name.
    *
    * @param eventName
    * @param eventAttributes
    */
    function triggerEventWithPrefix(eventName, eventAttributes) {
        triggerEvent(ANALYTICS_PREFIX + '.' + eventName, eventAttributes);
    }

    function triggerEvent(eventName, eventAttributes) {
        analytics.sendEvent(eventName, eventAttributes);
    }

    return {
        triggerIssueClickAnalytics: triggerIssueClickAnalytics,
        triggerReleaseNotesLinkAnalytics: triggerReleaseNotesLinkAnalytics,
        triggerIssueTabAnalytics: triggerIssueTabAnalytics,
        triggerWarningTabAnalytics: triggerWarningTabAnalytics,
        triggerWarningCategoryAnalytics: triggerWarningCategoryAnalytics,
        triggerFusionWidgetClicked: triggerFusionWidgetClicked,
        triggerWarningCategoryVisibilityToggled: triggerWarningCategoryVisibilityToggled,
        triggerEvent: triggerEventWithPrefix,
        ANALYTICS_PREFIX: ANALYTICS_PREFIX
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/release-report-metadata.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * Module for fetching metadata about the release report.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (jquery) {
    'use strict';

    var $rrMetadata;

    function getMetadataElem() {
        if (!$rrMetadata) {
            $rrMetadata = jquery('.release-report-metadata');
        }
        return $rrMetadata;
    }

    return {
        getProjectKey: function getProjectKey() {
            return getMetadataElem().data('project-key');
        },

        getVersionId: function getVersionId() {
            return getMetadataElem().data('version-id');
        },

        getStatusCategoryCounts: function getStatusCategoryCounts() {
            return getMetadataElem().data('status-category-counts');
        },

        shouldShowContactAdminForm: function shouldShowContactAdminForm() {
            return getMetadataElem().data('show-contact-admin-form') === 'true';
        },

        getTotalIssueCount: function getTotalIssueCount() {
            return getMetadataElem().data('issue-count');
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/tab-model.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/util/Strings.js"), __webpack_require__("./js/util/Helpers.js"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (Strings, Helpers, backbone, jquery) {
    'use strict';

    var model = backbone.Model.extend({
        properties: ['selectedTab', 'projectKey', 'versionId'],

        namedEvents: [
        // events related to detailed data rest call
        'fetchTabContentRequested', 'fetchTabContentFailed', 'fetchTabContentSucceeded'],

        shouldUpdateData: function shouldUpdateData(selectedTab) {
            return this.get('selectedTab') != selectedTab;
        },

        /**
        * Updates the data from the back-end.
        */
        updateData: function updateData(selectedTab, projectKey, versionId) {
            var self = this;
            this.set('selectedTab', selectedTab);
            this.set('projectKey', projectKey);
            this.set('versionId', versionId);

            var jqXhr = jquery.ajax({
                url: this._getTabContentUrl(),
                type: 'GET',
                data: {
                    selectedTab: this.get('selectedTab')
                }
            });

            this._setPendingUpdate(jqXhr);

            jqXhr.done(function (result) {
                self.trigger('fetchTabContentSucceeded', result);
            });

            jqXhr.fail(function (xhr, status) {
                if (status !== 'abort') {
                    self.trigger('fetchTabContentFailed', xhr);
                }
            });
        },

        _getTabContentUrl: function _getTabContentUrl() {
            return Strings.format('{0}/rest/release-report/1.0/tab/content/{1}/{2}', Helpers.getContextPath(), this.get('projectKey'), this.get('versionId'));
        },

        /**
        * Ensures only one pending model update is active at a time.
        */
        _setPendingUpdate: function _setPendingUpdate(jqXhr) {
            if (this._updateDeferred && this._updateDeferred.state() === 'pending') {
                this._updateDeferred.abort();
            }
            this._updateDeferred = jqXhr;
        }
    });

    return model;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/tab-view.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(0);
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:aui-core-amd-shim/require('aui/message')"), __webpack_require__("./js/util/Login.js"), __webpack_require__("./js/releasereport/release-report-metadata.js"), __webpack_require__("./js/releasereport/manage-warnings-module.js"), __webpack_require__("./js/releasereport/dev-status-dialog-bridge.js"), __webpack_require__("./js/releasereport/width-adjuster.js"), __webpack_require__("./js/releasereport/release-report-analytics.js"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter, Messages, Login, RRMetadata, ManageWarningsModule, DevStatusDialogBridge, WidthAdjuster, ReleaseReportAnalytics, backbone, _, jquery) {
    'use strict';

    var view = backbone.View.extend({
        events: {
            'click .release-report-link': '_updateTabContent',
            'click .release-report-warning-category .issue-key': '_publishAnalyticsOnIssueClick',
            'click .release-report-warning-category .issue-summary': '_publishAnalyticsOnIssueClick',
            'click #release-report-notes-link': '_publishAnalyticsOnVersionNotesClick',
            'click .fusion-widget': '_showDevStatusDialog',
            'click .release-report-manage-warnings': '_showManageWarningsDialog'
        },

        initialize: function initialize(options) {
            this.progressView = options.progressView;

            this._initFetchHandlers();
            this._initTabs();
        },

        render: function render() {},

        _renderLoadingState: function _renderLoadingState() {
            var $tabElement = this._getTabBody();
            var $spinnerContainer = jquery('<div class="release-report-tab-spinner-container"></div>');
            // Fix the height of the tab body to its current height to prevent "jumping" due to the page height temporarily changing
            $tabElement.height($tabElement.height());
            $tabElement.html($spinnerContainer);
            $spinnerContainer.spin('large');
        },

        _destroyLoadingState: function _destroyLoadingState() {
            // Unfix the height of the tab body when the spinner is removed
            this._getTabBody().css('height', '');
        },

        _initFetchHandlers: function _initFetchHandlers() {
            this.listenTo(this.model, 'fetchTabContentSucceeded', this._handleTabContentSucceeded);
            this.listenTo(this.model, 'fetchTabContentFailed', this._handleTabContentFetchFailed);
        },

        _handleTabContentSucceeded: function _handleTabContentSucceeded(result) {
            this._destroyLoadingState();

            var $selectedTabBody = this._getTabBody();
            $selectedTabBody.html(result.tabContent);

            var $tabHeaders = this._getTabHeaders();
            $tabHeaders.empty().append(JIRA.Templates.ReleaseReport.tabHeaders({
                releaseTabs: result.releaseTabs,
                showEnableWarningsLink: result.showEnableWarningsLink
            }));

            // adjust the page width if the table content is spilling out to the right
            WidthAdjuster.adjust();

            this._triggerTabAnalytics();
        },

        _handleTabContentFetchFailed: function _handleTabContentFetchFailed(xhr) {
            if (Login.redirectIfUserChanged(xhr)) {
                return; // No error handling required - redirecting
            }

            this._destroyLoadingState();

            var title;
            var body;
            if (xhr.status === 404) {
                title = formatter.I18n.getText('releasereport.error.not.found.title');
                body = formatter.I18n.getText('releasereport.error.not.found');
            } else if (xhr.status === 403) {
                title = formatter.I18n.getText('releasereport.error.forbidden.title');
                body = formatter.I18n.getText('releasereport.error.forbidden');
            } else {
                title = formatter.I18n.getText('releasereport.error.server.failure.title');
                body = formatter.I18n.getText('releasereport.error.server.failure');
            }

            var $tabElement = this._getTabBody();
            $tabElement.empty();

            Messages.error('#' + $tabElement.attr('id'), {
                title: title,
                body: body,
                closeable: false
            });
        },

        _updateTabContent: function _updateTabContent(e) {
            e.preventDefault();

            var $target = jquery(e.currentTarget);
            var $tab = $target.closest('.release-report-tab');
            var selectedTab = $target.attr('id');

            var $tabsSection = $target.closest('#release-report-tabs-section');
            var projectKey = $tabsSection.attr('data-project-key');
            var versionId = $tabsSection.attr('data-version-id');

            if (this.model.shouldUpdateData(selectedTab)) {
                // Select the tab
                $tab.addClass('active-tab').siblings().removeClass('active-tab');

                this.refreshTab(selectedTab, projectKey, versionId);
            }
        },

        _initTabs: function _initTabs(e) {
            var statusCategoryCounts = RRMetadata.getStatusCategoryCounts();
            this.progressView.setupInlineDialog(statusCategoryCounts);
            this._triggerTabAnalytics();
        },

        _triggerTabAnalytics: function _triggerTabAnalytics() {
            var $selectedTabEl = this._getSelectedTab();
            var onTabLoadAnalyticsEvent = $selectedTabEl.data('analytics-on-tab-load');

            if (onTabLoadAnalyticsEvent) {
                var warningsTab = $selectedTabEl.data('is-warnings-tab');
                var tabCount = $selectedTabEl.data('tab-count');
                var attributes = _.extend(this._getVersionDetails(), {
                    totalTabItems: tabCount
                });

                if (warningsTab === true) {
                    ReleaseReportAnalytics.triggerWarningTabAnalytics(onTabLoadAnalyticsEvent, attributes);
                    this._triggerAnalyticsForWarningCategories(onTabLoadAnalyticsEvent, attributes);
                } else {
                    var el$ = this._getEl$();
                    var $tableRowsEl = el$.find('#release-report-tab-body-content').find('.release-report-issues').children();
                    var $widgets = el$.find('#release-report-tab-body-content').find('.fusion-widget');
                    ReleaseReportAnalytics.triggerIssueTabAnalytics(onTabLoadAnalyticsEvent, attributes, $tableRowsEl, $widgets);
                }
            }
        },

        _triggerAnalyticsForWarningCategories: function _triggerAnalyticsForWarningCategories(tabAnalyticsId, attributes) {
            var $warningCategories = jquery('#release-report-tab-body-content').find('.release-report-warning-category');

            $warningCategories.each(function () {
                var $warningCategory = jquery(this);
                var warningCategoryAnalyticsId = $warningCategory.data('analytics-key');
                var $tableRowsEl = $warningCategory.find('.release-report-issues').children();
                var $widgets = $warningCategory.find('.fusion-widget');

                if (warningCategoryAnalyticsId) {
                    ReleaseReportAnalytics.triggerWarningCategoryAnalytics(tabAnalyticsId, warningCategoryAnalyticsId, attributes, $tableRowsEl, $widgets);
                }
            });
        },

        _getEl$: function _getEl$() {
            return jquery(this.el);
        },

        _getTabBody: function _getTabBody() {
            return this.$('#release-report-tab-body-content');
        },

        _getTabHeaders: function _getTabHeaders() {
            return this.$('#release-report-tabs-section > nav.release-report-tab-header');
        },

        _getSelectedTab: function _getSelectedTab() {
            return this._getTabHeaders().find('.active-tab');
        },

        _publishAnalyticsOnIssueClick: function _publishAnalyticsOnIssueClick(e) {
            var $target = jquery(e.currentTarget);
            var $selectedTabEl = this._getSelectedTab();
            var $warningCategorySection = $target.closest('.release-report-warning-category');
            var $reportsTabSection = $selectedTabEl.closest('#release-report-tabs-section');

            var tabAnalyticsId = $selectedTabEl.data('analytics-on-tab-load');
            var warningCategoryAnalyticsId = $warningCategorySection.data('analytics-key');

            var eventAttrs = {
                versionId: $reportsTabSection.data('version-id'),
                projectKey: $reportsTabSection.data('project-key'), // dev info
                issueKeyLink: $target.attr('href') // dev info
            };

            if (warningCategoryAnalyticsId) {
                ReleaseReportAnalytics.triggerIssueClickAnalytics(tabAnalyticsId, warningCategoryAnalyticsId, eventAttrs);
            }
        },

        _publishAnalyticsOnVersionNotesClick: function _publishAnalyticsOnVersionNotesClick(e) {
            ReleaseReportAnalytics.triggerReleaseNotesLinkAnalytics(this._getVersionDetails());
        },

        _showDevStatusDialog: function _showDevStatusDialog(e) {
            var $target = jquery(e.currentTarget);
            var $fusionWidget = $target.closest('tr').find('td.development a.fusion-widget');
            var issueId = parseInt($target.data('issue-id'));
            var issueKey = $fusionWidget.data('issue-key');
            var devSummary = $fusionWidget.data('dev-summary');
            var dataType = $target.data('dev-type');
            var showContactAdminForm = RRMetadata.shouldShowContactAdminForm();

            var latestDevSummary = devSummary.cachedValue.summary[dataType];

            var $selectedTabEl = this._getSelectedTab();
            var warningsTab = $selectedTabEl.data('is-warnings-tab');
            var analyticsEventName = $selectedTabEl.data('analytics-on-tab-load');

            if (warningsTab === true) {
                var $warningCategory = $target.closest('.release-report-warning-category');
                analyticsEventName = analyticsEventName + '.' + $warningCategory.data('analytics-key');
            }

            // fire fusion widget click analytics before showing the detailed dialog
            ReleaseReportAnalytics.triggerFusionWidgetClicked(analyticsEventName, dataType);
            DevStatusDialogBridge.showDialog(issueKey, issueId, latestDevSummary, dataType, showContactAdminForm);
        },

        _showManageWarningsDialog: function _showManageWarningsDialog(e) {
            ManageWarningsModule.show(this);
        },

        refreshTab: function refreshTab(selectedTab, projectKey, versionId) {
            this._renderLoadingState();
            this.model.updateData(selectedTab, projectKey, versionId);
        },

        _getVersionDetails: function _getVersionDetails() {
            var $reportsTabSection = this.$('#release-report-tabs-section');

            return {
                versionId: $reportsTabSection.data('version-id'),
                projectKey: $reportsTabSection.data('project-key'), // dev info
                status: $reportsTabSection.data('version-status').toLowerCase(),
                overdue: $reportsTabSection.data('overdue'),
                daysRemaining: $reportsTabSection.data('days-remaining')
            };
        }
    });

    return view;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/releasereport/width-adjuster.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * This module provides a fix for the contents of the release report table spilling out of the page to the right.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (jquery, _) {
    'use strict';

    // the amount of time to delay when we pass our adjustment function to _.debounce()

    var DELAY_MILLIS = 500;

    // the amount of pixels to add to the width adjustment so that the table margin in the release report looks correct
    var MARGIN_PIXELS = 30;

    return {
        /**
         * If the width of the body element is less than the width of the document then increase the body width
         * so that it is equal to the width of the document plus some margin.
         *
         * We use debounce() to avoid constant updates to the UI as the browser is being re-sized, since
         * bindWidthAdjustmentToWindowResize() binds adjust() to the browser re-size event.
         */
        adjust: _.debounce(function () {
            if (jquery('body').width() < jquery(document).width()) {
                jquery('body').css('min-width', jquery(document).width() + MARGIN_PIXELS);
            }
        }, DELAY_MILLIS),

        /**
         * Bind an action to adjust the width of the release report page when there is a browser resize event.
         *
         * We also call adjust() immediately once the page is ready in case we need to adjust the width before
         * any browser resize event happens.
         */
        bindWidthAdjustmentToWindowResize: function bindWidthAdjustmentToWindowResize() {
            var that = this;
            jquery(function () {
                that.adjust();
                jquery(window).resize(that.adjust);
            });
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/DevStatusNavigation.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * This is an attempt to avoid direct interaction with the 'window' object in Javascript land.
 * This also includes all interactions with objects such as 'location' or 'document', because they are simply a reference
 *    from 'window.location' and 'window.document' respectively.
 *
 * There are 2 main reasons for doing this:
 * 1. To allow the JS code to be QUnit testable. 'window' object is not mock-able, hence does not respond well
 *    when testing modules that refresh or navigate away from the page.
 * 2. To avoid the incident where important JS events are not run when the browser navigates away from the current page.
 *    This will allow the currently queue-ed up events to be completed first before the browser trashes the Javascript state
 *    and navigates away.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    return {
        getUrl: function getUrl() {
            return window.location.href;
        },
        reload: function reload() {
            _.defer(function () {
                window.location.reload();
            });
        },
        navigate: function navigate(url) {
            _.defer(function () {
                window.location = url;
            });
        },
        redirectToLogin: function redirectToLogin() {
            this.navigate(wrmContextPath() + '/login.jsp?permissionViolation=true&os_destination=' + encodeURIComponent(window.location.href));
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/EventPublisher.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    'use strict';

    return {
        trigger: AJS.trigger
    };
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Helpers.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    'use strict';

    /**
     * Return a function to mark a string object as sanitised so that soy doesn't escape it.
     *
     * We can remove this and just use soydata.VERY_UNSAFE.ordainSanitizedHtml once we only support JIRA >= 7
     *
     * @returns a function to sanitise a string for unescaped usage in a soy template.
     */

    var sanitiserFunction = function sanitiserFunction() {
        if (soydata.VERY_UNSAFE) {
            return soydata.VERY_UNSAFE.ordainSanitizedHtml;
        } else {
            return function (stringToMarkAsSafe) {
                return new soydata.SanitizedHtml(stringToMarkAsSafe);
            };
        }
    };

    return {
        getContextPath: wrmContextPath,

        /**
         * Make a copy of object with all String properties of this new object marked as sanitised html,
         * so that soy doesn't try to escape them if we use the strings in a soy template context.
         *
         * DO NOT sanitise strings to be used in a soy template unless you know they are safe.
         *
         * @param object {Object} has some string properties that we want to sanitise so that soy doesn't escape them
         * @return object {Object} a copy of object with the string properties marked as sanitised
         */
        copyAndMarkStringPropertiesAsSanitised: function copyAndMarkStringPropertiesAsSanitised(object) {
            var sanitiserFn = sanitiserFunction();
            var sanitisedObject = Array.isArray(object) ? [] : {};
            _.each(_.keys(object), function (key) {
                var val = object[key];
                if (val) {
                    if (typeof val === 'string') {
                        sanitisedObject[key] = sanitiserFn(val);
                    } else if ((typeof val === 'undefined' ? 'undefined' : _typeof(val)) === 'object') {
                        if (_.keys(val).length > 0) {
                            sanitisedObject[key] = copyAndMarkStringPropertiesAsSanitised(val);
                        }
                    } else {
                        sanitisedObject[key] = val;
                    }
                }
            });
            return sanitisedObject;
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Login.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:util-lite/require('jira/util/users/logged-in-user')"), __webpack_require__("./js/util/DevStatusNavigation.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (User, Navigate) {
    'use strict';

    return {
        /**
        * Given an xhr, reloads the page or redirects to login page based on the response user name.
        *   - If the logged in user has changed, reload the page.
        *   - If the user was logged in but got logged out, redirect to login page.
        *
        * @param xhr
        * @returns {boolean} indicating if either a redirect or reload was issued
        */
        redirectIfUserChanged: function redirectIfUserChanged(xhr) {
            var responseUserName = xhr.getResponseHeader('X-AUSERNAME');

            if (!User.isAnonymous() && responseUserName === 'anonymous') {
                Navigate.redirectToLogin();
                return true;
            }

            if (responseUserName !== (User.username() || 'anonymous')) {
                Navigate.reload();
                return true;
            }

            return false;
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Strings.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter) {
    'use strict';

    return {
        format: formatter.format
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/util/EventPublisher.js"), exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (eventPublisher, exports) {
    'use strict';

    /**
     * fires an analytics event
     * @param name of event
     * @param data data to be send with it
     */

    exports.sendEvent = function (name) {
        var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        eventPublisher.trigger('analyticsEvent', {
            name: name,
            data: data
        });
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 0:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 1:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 11:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 2:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 4:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ "com.atlassian.auiplugin:aui-flag/require('aui/flag')":
/***/ (function(module, exports) {

module.exports = require('aui/flag');

/***/ }),

/***/ "jira.webresources:ajs-backbone-amd-shim/require('backbone')":
/***/ (function(module, exports) {

module.exports = require('backbone');

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:aui-core-amd-shim/require('aui/inline-dialog')":
/***/ (function(module, exports) {

module.exports = require('aui/inline-dialog');

/***/ }),

/***/ "jira.webresources:aui-core-amd-shim/require('aui/message')":
/***/ (function(module, exports) {

module.exports = require('aui/message');

/***/ }),

/***/ "jira.webresources:jira-formatter/require('jira/util/formatter')":
/***/ (function(module, exports) {

module.exports = require('jira/util/formatter');

/***/ }),

/***/ "jira.webresources:jira-logger/require('jira/util/logger')":
/***/ (function(module, exports) {

module.exports = require('jira/util/logger');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:util-lite/require('jira/util/users/logged-in-user')":
/***/ (function(module, exports) {

module.exports = require('jira/util/users/logged-in-user');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ }),

/***/ "jira.webresources:wrm-data/require('wrm/data')":
/***/ (function(module, exports) {

module.exports = require('wrm/data');

/***/ })

},["./js/releasereport/index.js"]);
//# sourceMappingURL=releasereport.16c4d2c166489c1ead04.js.map