jiraDevelopmentIntegrationPluginJsonp(["devstatus-view-issue"],{

/***/ "./js/util/DevStatusNavigation.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * This is an attempt to avoid direct interaction with the 'window' object in Javascript land.
 * This also includes all interactions with objects such as 'location' or 'document', because they are simply a reference
 *    from 'window.location' and 'window.document' respectively.
 *
 * There are 2 main reasons for doing this:
 * 1. To allow the JS code to be QUnit testable. 'window' object is not mock-able, hence does not respond well
 *    when testing modules that refresh or navigate away from the page.
 * 2. To avoid the incident where important JS events are not run when the browser navigates away from the current page.
 *    This will allow the currently queue-ed up events to be completed first before the browser trashes the Javascript state
 *    and navigates away.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    return {
        getUrl: function getUrl() {
            return window.location.href;
        },
        reload: function reload() {
            _.defer(function () {
                window.location.reload();
            });
        },
        navigate: function navigate(url) {
            _.defer(function () {
                window.location = url;
            });
        },
        redirectToLogin: function redirectToLogin() {
            this.navigate(wrmContextPath() + '/login.jsp?permissionViolation=true&os_destination=' + encodeURIComponent(window.location.href));
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/DevStatusURLUtils.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__, __webpack_require__("jira.webresources:parse-uri/require('jira/libs/parse-uri')")], __WEBPACK_AMD_DEFINE_RESULT__ = function ($, _, require, parseUri) {
    var devStatusNavigate = __webpack_require__("./js/util/DevStatusNavigation.js");
    return {
        getDetailDialogParam: function getDetailDialogParam() {
            var url = this._removeKickAssIHashFromUrl(devStatusNavigate.getUrl());
            var parsedUri = parseUri(url);
            return parsedUri && parsedUri.queryKey && parsedUri.queryKey['devStatusDetailDialog'];
        },
        getUrlWithDetailDialogParam: function getUrlWithDetailDialogParam(summaryType) {
            var currentUrl = this._removeKickAssIHashFromUrl(devStatusNavigate.getUrl());
            var parsedUri = parseUri(currentUrl);

            /**
            * Insert/replace devStatusDetailDialog param/query into the url
            */
            parsedUri.queryKey['devStatusDetailDialog'] = encodeURIComponent(summaryType);
            return this.createUrlFromParsedUri(parsedUri);
        },

        getCreateReviewDetailUrl: function getCreateReviewDetailUrl(applicationType) {
            return this.getUrlWithDetailDialogParam('create-review-' + applicationType);
        },

        isCreateReviewDetailDialogLink: function isCreateReviewDetailDialogLink(dialogToOpen) {
            return dialogToOpen && dialogToOpen.lastIndexOf && dialogToOpen.lastIndexOf('create-review-', 0) === 0;
        },

        getCreateReviewDetailDialogApplicationType: function getCreateReviewDetailDialogApplicationType(dialogToOpen) {
            return dialogToOpen.substring('create-review-'.length);
        },

        _removeKickAssIHashFromUrl: function _removeKickAssIHashFromUrl(url) {
            /**
            * In order to support single page app behaviour for issue nav/view issue in IE,
            * KickAss appended 'i#' prefix between the base URL and the KA url, because IE doesn't support push state
            * For example: http://localhost:2990/jira/i#browse/DEV-1
            *
            * parseUri and the logic in getUrlWithDetailDialogParam simply wouldn't work with an URL format like the above,
            * instead, we need to remove the i# prefix to get the regular non-IE-specific URL
            *
            * KA will automatically redirect from a regular URL to a i# url for IE.
            */
            return url.replace('i#', '');
        },
        /**
        * Copied from JIRA Agile.
        * See https://stash.atlassian.com/projects/JAG/repos/jira-agile/browse/greenhopper/src/main/resources/includes/js/lib/ajs-future.js#118
        *
        * Transformed the uri object from {@code parseUri} into url string
        *
        * @param uri object from {@code parseUri}
        * @returns {string}
        */
        createUrlFromParsedUri: function createUrlFromParsedUri(uri) {
            var params = [];
            $.each(uri.queryKey, function (name, value) {
                if (_.isObject(value)) {
                    $.each(value, function (index, innerVal) {
                        params.push(name + '=' + innerVal);
                    });
                } else {
                    params.push(name + '=' + value);
                }
            });

            var url = '';
            if (uri.protocol) {
                url += uri.protocol + '://';
            }
            if (uri.authority) {
                url += uri.authority;
            }
            if (uri.path) {
                url += uri.path;
            }
            if (params.length > 0) {
                url += '?' + params.join('&');
            }
            if (uri.anchor) {
                url += '#' + uri.anchor;
            }
            return url;
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/DevStatusInit.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var devStatusStatePersist = __webpack_require__("./js/viewissue/DevStatusStatePersist.js");
var jQuery = __webpack_require__("jira.webresources:jquery/require('jquery')");

devStatusStatePersist.setDetailDialogParam();

jQuery(function () {
    return __webpack_require__.e/* require */(0).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__("./js/viewissue/DevStatusApp.js")]; (function (devStatusApp) {
        return devStatusApp.documentReadyInit(jQuery(document));
    }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
});

/***/ }),

/***/ "./js/viewissue/DevStatusStatePersist.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-metadata/require('jira/util/data/meta')"), __webpack_require__("./js/util/DevStatusURLUtils.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (Meta, devStatusURL) {
    return {
        setDetailDialogParam: function setDetailDialogParam() {
            /**
             * Attempt to get the summary type data from url parameter to automatically open the detail dialog.
             *
             * This is done on 'page load' as opposed to 'document ready' because KickAss will immediately strip off
             * non-KA parameter from the URL (the only KA parameter is jql and startIndex).
             *
             * Data is stored in AJS.Meta with key "fusion-open-detail-dialog", which will be later read by DevStatusModule
             * after all summary data has been loaded
             */
            Meta.set('fusion-open-detail-dialog', devStatusURL.getDetailDialogParam());
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:jira-metadata/require('jira/util/data/meta')":
/***/ (function(module, exports) {

module.exports = require('jira/util/data/meta');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:parse-uri/require('jira/libs/parse-uri')":
/***/ (function(module, exports) {

module.exports = require('jira/libs/parse-uri');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ })

},["./js/viewissue/DevStatusInit.js"]);
//# sourceMappingURL=devstatus-view-issue.db31d611e52e0febdb0b.js.map