jiraDevelopmentIntegrationPluginJsonp(["devstatus-triggers"],{

/***/ "./js/triggers/DevStatusTriggerHooks.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, exports) {
    var JIRADevStatusTriggersTriggerDiagnosticModel = __webpack_require__("./js/triggers/TriggerDiagnosticModel.js");
    var JIRADevStatusTriggersTriggerDiagnosticView = __webpack_require__("./js/triggers/TriggerDiagnosticView.js");
    var JIRADevStatusTriggersBuildDeploymentCompletedConfigModel = __webpack_require__("./js/triggers/builds/DeploymentCompletedConfigModel.js");
    var JIRADevStatusTriggersBuildDeploymentCompletedConfigView = __webpack_require__("./js/triggers/builds/DeploymentCompletedConfigView.js");

    exports.PullRequestDiagnosticsModule = function (data) {
        this.showDiagnostics = function () {
            renderDiagnostics(wrmContextPath() + '/rest/dev-status/1.0/trigger/diagnostics/pullrequests', true, data.container, false);
        };
    };

    exports.PullRequestReopenedDiagnosticsModule = function (data) {
        this.showDiagnostics = function () {
            renderDiagnostics(wrmContextPath() + '/rest/dev-status/1.0/trigger/diagnostics/pullrequestreopened', true, data.container, false);
        };
    };

    exports.BranchCreatedDiagnosticsModule = function (data) {
        this.showDiagnostics = function () {
            renderDiagnostics(wrmContextPath() + '/rest/dev-status/1.0/trigger/diagnostics/branchcreated', true, data.container, false);
        };
    };

    exports.CommitDiagnosticsModule = function (data) {
        this.showDiagnostics = function () {
            renderDiagnostics(wrmContextPath() + '/rest/dev-status/1.0/trigger/diagnostics/commit', true, data.container, false);
        };
    };

    exports.ReviewDiagnosticsModule = function (data) {
        this.showDiagnostics = function () {
            renderDiagnostics(wrmContextPath() + '/rest/dev-status/1.0/trigger/diagnostics/review', false, data.container, true);
        };
    };

    function renderDiagnostics(fetchUrl, includeDvcs, container, isReview) {
        var diagnosticModel = new JIRADevStatusTriggersTriggerDiagnosticModel({
            fetchUrl: fetchUrl,
            includeDvcs: includeDvcs,
            isReview: isReview
        });
        var diagnosticView = new JIRADevStatusTriggersTriggerDiagnosticView({
            model: diagnosticModel,
            el: container
        });
        diagnosticView.render();
    }
    exports.renderDiagnostics = renderDiagnostics;

    exports.DeploymentCompletedModule = function (data) {
        var deploymentCompletedConfigModel = new JIRADevStatusTriggersBuildDeploymentCompletedConfigModel({
            triggerKey: data.key,
            description: data.description,
            icon: data.icon
        });
        var deploymentCompletedConfigView = new JIRADevStatusTriggersBuildDeploymentCompletedConfigView({
            model: deploymentCompletedConfigModel
        });
        this.showConfig = function () {
            deploymentCompletedConfigView.render(data.container);
        };
        this.submitCallback = function () {
            return deploymentCompletedConfigView.submit();
        };
    };

    return exports;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/triggers/DevStatusTriggers.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var $ = __webpack_require__("jira.webresources:jquery/require('jquery')");
__webpack_require__(6);
$(function () {
    var JIRADevStatusTriggers = __webpack_require__("./js/triggers/DevStatusTriggerHooks.js");
    var pluginKey = 'com.atlassian.jira.plugins.jira-development-integration-plugin:';
    var devStatusDiagnostics = [{
        key: pluginKey + 'pull-request-created-trigger',
        module: JIRADevStatusTriggers.PullRequestDiagnosticsModule
    }, {
        key: pluginKey + 'pull-request-merged-trigger',
        module: JIRADevStatusTriggers.PullRequestDiagnosticsModule
    }, {
        key: pluginKey + 'pull-request-declined-trigger',
        module: JIRADevStatusTriggers.PullRequestDiagnosticsModule
    }, {
        key: pluginKey + 'pull-request-reopened-trigger',
        module: JIRADevStatusTriggers.PullRequestReopenedDiagnosticsModule
    }, {
        key: pluginKey + 'branch-created-trigger',
        module: JIRADevStatusTriggers.BranchCreatedDiagnosticsModule
    }, {
        key: pluginKey + 'commit-created-trigger',
        module: JIRADevStatusTriggers.CommitDiagnosticsModule
    }, {
        key: pluginKey + 'review-started-trigger',
        module: JIRADevStatusTriggers.ReviewDiagnosticsModule
    }, {
        key: pluginKey + 'review-abandoned-trigger',
        module: JIRADevStatusTriggers.ReviewDiagnosticsModule
    }, {
        key: pluginKey + 'review-approval-trigger',
        module: JIRADevStatusTriggers.ReviewDiagnosticsModule
    }, {
        key: pluginKey + 'review-closed-trigger',
        module: JIRADevStatusTriggers.ReviewDiagnosticsModule
    }, {
        key: pluginKey + 'review-rejected-trigger',
        module: JIRADevStatusTriggers.ReviewDiagnosticsModule
    }, {
        key: pluginKey + 'review-summarized-trigger',
        module: JIRADevStatusTriggers.ReviewDiagnosticsModule
    }];
    var devStatusConfigs = [{
        key: pluginKey + 'deployment-successful-trigger',
        module: JIRADevStatusTriggers.DeploymentCompletedModule
    }, {
        key: pluginKey + 'deployment-failed-trigger',
        module: JIRADevStatusTriggers.DeploymentCompletedModule
    }];

    for (var i = 0; i < devStatusDiagnostics.length; i++) {
        JIRA.Triggers.Diagnostics.register(devStatusDiagnostics[i].key, devStatusDiagnostics[i].module);
    }

    for (var j = 0; j < devStatusConfigs.length; j++) {
        JIRA.Triggers.Configuration.register(devStatusConfigs[j].key, devStatusConfigs[j].module);
    }
});

/***/ }),

/***/ "./js/triggers/TriggerDiagnosticModel.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

// @formatter:off
/**
 * @class JIRA.DevStatus.Triggers.TriggerDiagnosticModel
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (Backbone, $) {
    return Backbone.Model.extend({
        namedEvents: ['diagnosticsFetchSucceeded', 'diagnosticsFetchFailed'],

        initialize: function initialize(options) {
            this.diagnosticsUrl = options.fetchUrl;
            this.includeDvcs = options.includeDvcs;
            this.isReview = options.isReview;
        },

        fetchDiagnostics: function fetchDiagnostics() {
            var self = this;

            var fetchPromise = $.ajax({
                url: self.diagnosticsUrl,
                type: 'GET'
            }).promise();

            fetchPromise.done(function (result) {
                self.trigger('diagnosticsFetchSucceeded', result, self.includeDvcs, self.isReview);
            });
            fetchPromise.fail(function (xhr, status) {
                self.trigger('diagnosticsFetchFailed', xhr, status);
            });
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/triggers/TriggerDiagnosticView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(7);
__webpack_require__(8);

// @formatter:off
/**
 * @class JIRA.DevStatus.Triggers.PullRequestDiagnosticView
 * View for diagnostics of Pull Request Triggers.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (Backbone) {
    return Backbone.View.extend({
        initialize: function initialize(options) {
            this.model = options.model;

            this._initFetchHandlers();
        },

        render: function render() {
            this._renderLoadingState();
            this.model.fetchDiagnostics();
        },

        _renderLoadingState: function _renderLoadingState() {
            this.$el.html(JIRA.Templates.DevStatus.Triggers.Diagnostics.renderDiagnosticView());

            var loadingPane = this.$('#devstatus-trigger-diagnostics');
            loadingPane.spin('large');
            loadingPane.show();
        },

        _initFetchHandlers: function _initFetchHandlers() {
            this.listenTo(this.model, 'diagnosticsFetchSucceeded', this._handleDiagnosticResults);
            this.listenTo(this.model, 'diagnosticsFetchFailed', this._handleDiagnosticFetchFailed);
        },

        _handleDiagnosticResults: function _handleDiagnosticResults(result, includeDvcs, isReview) {
            if (result.appLinkDiagnosticResults.length == 0 && result.dvcsDiagnosticResult.dvcsAccountDiagnosticResults.length == 0) {
                // no Stash AppLinks or DVCS accounts
                this.$el.html(JIRA.Templates.DevStatus.Triggers.Diagnostics.renderNoAppsConnected({
                    devToolsLearnMoreLink: result.devToolsDocoUrl
                }));
            } else {
                this.$el.html(JIRA.Templates.DevStatus.Triggers.Diagnostics.renderDiagnostics({
                    result: result,
                    includeDvcs: includeDvcs,
                    isReview: isReview
                }));

                this.$('.supported-app-icon').tooltip();
            }
        },

        _handleDiagnosticFetchFailed: function _handleDiagnosticFetchFailed(xhr, status) {
            this.$el.html(JIRA.Templates.DevStatus.Triggers.Diagnostics.renderFetchFailed());
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/triggers/builds/DeploymentCompletedConfigModel.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

// @formatter:off
/**
 * @class JIRA.DevStatus.Triggers.Build.DeploymentCompletedConfigModel
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, Backbone, $) {
    return Backbone.Model.extend({
        initialize: function initialize(options) {
            this.set('triggerKey', options.triggerKey);
            this.set('description', options.description || '');
            this.set('icon', options.icon || {});
        },

        fetchBuildApps: function fetchBuildApps() {
            var fetchPromise = $.ajax({
                url: wrmContextPath() + '/rest/dev-status/1.0/trigger/build/config/apps',
                type: 'GET'
            }).promise();

            return fetchPromise;
        },

        fetchEnvironmentsAndProjectsForApp: function fetchEnvironmentsAndProjectsForApp(appLinkId) {
            var self = this;

            var fetchPromise = $.ajax({
                url: wrmContextPath() + '/rest/dev-status/1.0/trigger/build/config/apps/' + encodeURIComponent(appLinkId) + '/environments',
                type: 'GET'
            }).promise();

            fetchPromise.done(function (result) {
                self.set('environmentsByProject', result);
            });

            return fetchPromise;
        },

        fetchEnvironmentsForProject: function fetchEnvironmentsForProject(projectId) {
            var environmentsByProject = this.get('environmentsByProject');
            if (environmentsByProject !== undefined) {
                for (var i = 0; i < environmentsByProject.length; i++) {
                    if (environmentsByProject[i].projectId == projectId) {
                        return environmentsByProject[i].environmentList;
                    }
                }
            }

            return [];
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/triggers/builds/DeploymentCompletedConfigView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(9);
__webpack_require__(10);
__webpack_require__(3);
// @formatter:off
/**
 * @class JIRA.DevStatus.Triggers.Build.DeploymentCompletedConfigView
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:jquery/require('jira/jquery/deferred')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter, wrmContextPath, Deferred, Backbone, $, _) {
    return Backbone.View.extend({
        initialize: function initialize(options) {
            this.model = options.model;
        },

        render: function render(container) {
            var self = this;

            this.el = container;
            this.$el = $(container);
            this.$el.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderDeploymentCompletedConfigView({
                description: this.model.get('description'),
                icon: this.model.get('icon')
            }));
            this._disableSubmitBtnDelayed();
            var loadingIndicator = this.$el.find('.status-loading');
            loadingIndicator.spin('large');
            loadingIndicator.show();

            var fetchAppsPromise = this.model.fetchBuildApps();
            fetchAppsPromise.done(function (result) {
                self.$('#deployment-completed-config').html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderDeploymentConfigForm({ buildApps: result }));

                var appSelector = self.$('#appSelector');
                appSelector.auiSelect2();
                appSelector.on('change', function () {
                    self._selectedAppChanged(this.value);
                });

                // If there is only 1 Bamboo server connected, selected this one
                if (result.length == 1) {
                    var value = result[0].id;
                    appSelector.auiSelect2('val', value);
                    self._selectedAppChanged(value);
                } else {
                    self._renderDisabledProjectSelect();
                    self._renderDisabledEnvironmentSelect();
                }
            });
            fetchAppsPromise.fail(function (xhr, status) {
                AJS.messages.error('#deployment-completed-config', {
                    title: formatter.I18n.getText('triggers.deployment.completed.config.fetchapps.failed.title'),
                    body: formatter.I18n.getText('triggers.deployment.completed.config.fetchapps.failed.message'),
                    closeable: false
                });
            });
        },

        _selectedAppChanged: function _selectedAppChanged(selectedApp) {
            this._disableSubmitBtn();
            this._renderProjectSelection(selectedApp);
        },

        submit: function submit() {
            var projectSelector = this.$('#projectSelector');
            var environmentSelector = this.$('#environmentSelector');
            if (environmentSelector.length) {
                return new Deferred().resolve({
                    deploymentProjectId: projectSelector.select2('data').id,
                    deploymentProjectName: projectSelector.select2('data').text,
                    environmentId: environmentSelector.select2('data').id,
                    environmentName: environmentSelector.select2('data').text
                });
            } else {
                return new Deferred().fail();
            }
        },

        _renderDisabledProjectSelect: function _renderDisabledProjectSelect() {
            this._renderDisabledSelect(this.$('#projectSelector'));
        },

        _renderDisabledEnvironmentSelect: function _renderDisabledEnvironmentSelect() {
            this._renderDisabledSelect(this.$('#environmentSelector'));
        },

        _renderDisabledSelect: function _renderDisabledSelect($selector) {
            $selector.auiSelect2();
            $selector.auiSelect2('enable', false);
        },

        _renderProjectSelection: function _renderProjectSelection(appResult) {
            var self = this;
            var serverConfigContainer = self.$('#server-specific-config');

            // We have to re-render this because in some cases this might not be empty anymore.
            serverConfigContainer.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderProjectAndEnvironmentConfig({
                deploymentProjects: [],
                environments: []
            }));
            self._renderDisabledProjectSelect();
            self._renderDisabledEnvironmentSelect();
            var projectConfigContainer = self.$('#project-config');
            var appSelectorSpinner = self.$('.app-selector-spinner');

            appSelectorSpinner.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderSmallSpinner());

            var fetchEnvironmentsByProjectPromise = this.model.fetchEnvironmentsAndProjectsForApp(appResult);

            fetchEnvironmentsByProjectPromise.done(function (result) {
                self._hideAppSelectorSpinner();

                if (result.length == 0) {
                    var appName = self.$('#appSelector').select2('data').text;
                    serverConfigContainer.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderEmptyProjectConfig({ serverName: appName }));
                } else {
                    projectConfigContainer.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderProjectConfig({
                        deploymentProjects: result,
                        placeHolderText: formatter.I18n.getText('triggers.deployment.completed.config.project.select')
                    }));

                    var projectSelector = self.$('#projectSelector');
                    projectSelector.auiSelect2();
                    projectSelector.on('change', function () {
                        self._renderEnvironmentSelection(this.value);
                    });

                    var environmentContainer = self.$('#environment-config');
                    self._renderEnvironmentSelector(environmentContainer, [], formatter.I18n.getText('triggers.deployment.completed.config.project.select'));
                    self._renderDisabledEnvironmentSelect();

                    if (result.length == 1) {
                        // If there is 1 Deployment Project, select that
                        var value = result[0].projectKey;
                        projectSelector.auiSelect2('val', value);
                        self._renderEnvironmentSelection(value);
                    }
                }
            });

            fetchEnvironmentsByProjectPromise.fail(function (xhr) {
                if (xhr && xhr.status == 401) {
                    var source = $.parseJSON(xhr.responseText);
                    self._initiateAuthenticationCallbacks();
                    var authLink = self._createOAuthInstanceDiv(source);
                    serverConfigContainer.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderAuthenticationWarning({
                        authLink: '<span class="instance">' + authLink.html() + ''
                    }));
                    self._hideAppSelectorSpinner();
                } else {
                    serverConfigContainer.html('');
                    AJS.messages.error('#server-specific-config', {
                        title: formatter.I18n.getText('triggers.deployment.completed.config.fetchprojects.failed.title'),
                        body: formatter.I18n.getText('triggers.deployment.completed.config.fetchprojects.failed.message'),
                        closeable: false
                    });
                }
            });
        },

        _renderEnvironmentSelection: function _renderEnvironmentSelection(projectKey) {
            var self = this;
            var environmentConfigContainer = this.$('#environment-config');
            var environmentList = this.model.fetchEnvironmentsForProject(projectKey);

            self._disableSubmitBtn();
            if (environmentList.length == 0) {
                var deploymentProjectName = self.$('#projectSelector').select2('data').text;
                environmentConfigContainer.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderEmptyEnvironmentConfig({ deploymentProjectName: deploymentProjectName }));
            } else {
                this._renderEnvironmentSelector(environmentConfigContainer, environmentList, formatter.I18n.getText('triggers.deployment.completed.config.environment.select'));
                var environmentSelector = this.$('#environmentSelector');
                environmentSelector.auiSelect2();
                environmentSelector.on('change', function () {
                    self._enableSubmitBtn();
                });

                if (environmentList.length == 1) {
                    // If there is 1 Environment, select that
                    environmentSelector.auiSelect2('val', environmentList[0].environmentId);
                    this._enableSubmitBtn();
                }
            }
        },

        _renderEnvironmentSelector: function _renderEnvironmentSelector($container, environmentList, placeHolderText) {
            $container.html(JIRA.Templates.DevStatus.Triggers.BuildConfig.renderEnvironmentConfig({
                environments: environmentList,
                placeHolderText: placeHolderText
            }));
        },

        _disableSubmitBtn: function _disableSubmitBtn() {
            $('.select-trigger-button').attr('disabled', 'disabled');
        },

        _disableSubmitBtnDelayed: function _disableSubmitBtnDelayed() {
            var self = this;
            // We user a {@code _.defer()} here to overwrite the automatic enabling of the submit button which happens
            // as part of going to the next page after selecting the trigger on the first screen of the wizard
            // (see {@code JIRA.Triggers.AddTriggerDialogView.AddTriggerDialogView.addSubmitButton()} in the JIRA Transition Trigger Plugin).
            _.defer(function () {
                self._disableSubmitBtn();
            });
        },

        _enableSubmitBtn: function _enableSubmitBtn() {
            $('.select-trigger-button').removeAttr('disabled');
        },

        _hideAppSelectorSpinner: function _hideAppSelectorSpinner() {
            var appSelectorSpinner = this.$('.app-selector-spinner');
            appSelectorSpinner.empty();
        },

        _createOAuthInstanceDiv: function _createOAuthInstanceDiv(instance) {
            var div = ApplinksUtils.createAuthRequestInline(null, {
                id: instance.applicationLinkId,
                authUri: wrmContextPath() + '/plugins/servlet/applinks/oauth/login-dance/authorize?applicationLinkID=' + encodeURIComponent(instance.applicationLinkId),
                appUri: instance.baseUrl,
                appName: instance.name,
                appType: instance.type
            });
            return $('<span class="instance"></span>').append(div.find('a.applink-authenticate').text(instance.name).attr('target', '_blank'));
        },

        _initiateAuthenticationCallbacks: function _initiateAuthenticationCallbacks() {
            var self = this;
            var $document = $(document);

            function unbindAuthEventHandlers() {
                $document.unbind('applinks.auth.approved', oauthApprovedHandler);
                $document.unbind('applinks.auth.denied', oauthFailedHandler);
            }
            var oauthApprovedHandler = function oauthApprovedHandler(e, applinkProperties) {
                self._renderProjectSelection(applinkProperties.id);
                e.preventDefault();
                unbindAuthEventHandlers();
            };
            var oauthFailedHandler = function oauthFailedHandler(e, applinkProperties) {
                unbindAuthEventHandlers();
            };

            $document.bind('applinks.auth.approved', oauthApprovedHandler);
            $document.bind('applinks.auth.denied', oauthFailedHandler);

            // create a hidden banner div.applinks-auth-confirmation-container so that the confirmation msg is not shown
            $('<div class="applinks-auth-confirmation-container hidden"></div>').appendTo(this.$el);
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 10:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 3:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 6:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 7:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 8:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 9:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ "jira.webresources:ajs-backbone-amd-shim/require('backbone')":
/***/ (function(module, exports) {

module.exports = require('backbone');

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:jira-formatter/require('jira/util/formatter')":
/***/ (function(module, exports) {

module.exports = require('jira/util/formatter');

/***/ }),

/***/ "jira.webresources:jquery/require('jira/jquery/deferred')":
/***/ (function(module, exports) {

module.exports = require('jira/jquery/deferred');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ })

},["./js/triggers/DevStatusTriggers.js"]);
//# sourceMappingURL=devstatus-triggers.67541c17affe2a758e8b.js.map