jiraDevelopmentIntegrationPluginJsonp(["devstatus-admin"],{

/***/ "./js/admin/devstatus-admin.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var wrmContextPath = __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')");
var $ = __webpack_require__("jira.webresources:jquery/require('jquery')");
var parseUri = __webpack_require__("jira.webresources:parse-uri/require('jira/libs/parse-uri')");
var devStatusNavigate = __webpack_require__("./js/util/DevStatusNavigation.js");
var devStatusURL = __webpack_require__("./js/util/DevStatusURLUtils.js");
var devAnalytics = __webpack_require__("./js/analytics/devstatus-analytics.js");

var contextPath = wrmContextPath();

devAnalytics.AdminAnalytics.initialize();

var waitforRemoteFetch = 15000;
$(document).on('click', '#refresh-capabilities-link', function (e) {
    e.preventDefault();
    var $refreshIcon = $(e.target).find('#refresh-capabilities-icon');
    if (!$refreshIcon.hasClass('aui-icon-wait')) {
        $refreshIcon.toggleClass('aui-iconfont-build aui-icon-wait');
        $.ajax({
            url: contextPath + '/rest/capabilities-consumer/1.0/admin/refreshcache',
            type: 'POST',
            success: function success() {
                setTimeout(function () {
                    var location = parseUri(window.location.href);
                    location.queryKey['forceRefresh'] = 'true';
                    devStatusNavigate.navigate(devStatusURL.createUrlFromParsedUri(location));
                }, waitforRemoteFetch);
            },
            error: function error() {
                $refreshIcon.removeClass('aui-icon-wait').addClass('aui-iconfont-build');
            }
        });
    }
});

/***/ }),

/***/ "./js/analytics/devstatus-analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-global/require('jira/ajs/dark-features')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__, exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (DarkFeatures, _, jQuery, require, exports) {
    var Events = __webpack_require__("jira.webresources:jira-events/require('jira/util/events')");
    var Types = __webpack_require__("jira.webresources:jira-events/require('jira/util/events/types')");
    var Meta = __webpack_require__("jira.webresources:jira-metadata/require('jira/util/data/meta')");
    var analytics = __webpack_require__("./js/util/analytics.js");

    var editPermissionLinkSelector = '.edit-permission-link';

    /**
    * @returns {boolean} if analytics is enabled
    */
    function isAnalyticsEnabled() {
        return !DarkFeatures.isEnabled('jira.plugin.devstatus.analytics.disabled');
    }

    exports.Analytics = {
        /**
        * Fires an Atlassian Analytics event. Events will be subject to whitelist filtering as described in
        * <a href="https://extranet.atlassian.com/x/vkOJgw">Tagging & Whitelisting Analytics Events</a>.
        *
        * @param name  a unique name for the event, could be namespaced with ".", e.g., "createbranch.click"
        *              will be prepended with "devstatus."
        * @param data  an object containing any particular properties of relevance for this navigation type.
        */
        fireEvent: function fireEvent(name, data) {
            if (isAnalyticsEnabled()) {
                var eventName = 'devstatus.' + name;

                analytics.sendEvent(eventName, data);
            }
        },
        fireAgileDevStatusLinkClicked: function fireAgileDevStatusLinkClicked() {
            return exports.Analytics.fireEvent('panel.agile.icon.clicked');
        }
    };

    exports.LabsAnalytics = {
        fireLabsEvent: function fireLabsEvent(toggle) {
            var msg = toggle ? 'on' : 'off';
            return exports.Analytics.fireEvent('labs.toggle.' + msg);
        }
    };

    /**
    * Summary shown:
    *   * Current user is assigned: devstatus.summary.shown.assignee
    *   * Current user it NOT assigned: devstatus.summary.shown.nonassignee
    */
    exports.SummaryAnalytics = {
        fireSummaryShownEvent: function fireSummaryShownEvent(isAssignee, issueType, issueStatus, summarisedData) {
            var assigneeText = isAssignee ? 'assignee' : 'nonassignee';
            var opts = _.extend({
                issueType: issueType,
                issueStatus: issueStatus
            }, summarisedData);
            return exports.Analytics.fireEvent('summary.shown.' + assigneeText, opts);
        },

        /**
        * Fires a "dev summary clicked event". The events raised will be called <code>"devstatus.&lt;infoType&gt;.summary.clicked"</code>
        * or <code>"devstatus.&lt;infoType&gt;.summary.clicked.newcontext"</code>. The <code>summarisedData</code> param
        * should contain a boolean indicating whether there is summary information for each type, e.g.:
        * <pre>
        * {
        *     "branch": true,
        *     "build": true,
        *     "commit": true,
        *     "deployment-environment": false,
        *     "pullrequest": true,
        *     "review": false
        * }
        * </pre>
        * All information contained in <b>the event must adhere to the <a href="https://extranet.atlassian.com/x/x5Zxgw">Atlassian privacy policy</a></b>.
        *
        * @param {string} infoType the type of summary link clicked
        * @param {object} summarisedData
        * @returns {*}
        */
        fireSummaryClickedEvent: function fireSummaryClickedEvent(infoType, summarisedData) {
            var isNewContext = Meta.get('fusion-analytics-new-context-link');
            var event = '.clicked';
            if (isNewContext) {
                Meta.set('fusion-analytics-new-context-link', undefined);
                event += '.newcontext';
            }
            return exports.Analytics.fireEvent(infoType + '.summary' + event, summarisedData);
        },
        fireDetailTabClicked: function fireDetailTabClicked(applicationType, dataType) {
            return exports.Analytics.fireEvent(dataType + '.detail.' + applicationType + '.tab.clicked');
        }
    };

    exports.BuildsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('builds', summarisedData);
        },
        fireDetailProjectClicked: function fireDetailProjectClicked() {
            return exports.Analytics.fireEvent('builds.detail.project.clicked');
        },
        fireDetailPlanClicked: function fireDetailPlanClicked() {
            return exports.Analytics.fireEvent('builds.detail.plan.clicked');
        },
        fireDetailBuildClicked: function fireDetailBuildClicked() {
            return exports.Analytics.fireEvent('builds.detail.build.clicked');
        }
    };

    exports.DeploymentsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('deployments', summarisedData);
        },
        fireDetailProjectClicked: function fireDetailProjectClicked() {
            return exports.Analytics.fireEvent('deployments.detail.project.clicked');
        },
        fireDetailEnvironmentClicked: function fireDetailEnvironmentClicked() {
            return exports.Analytics.fireEvent('deployments.detail.environment.clicked');
        },
        fireDetailReleaseClicked: function fireDetailReleaseClicked() {
            return exports.Analytics.fireEvent('deployments.detail.release.clicked');
        }
    };

    exports.CommitsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('commits', summarisedData);
        },
        fireDetailRepoClicked: function fireDetailRepoClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.repo.clicked');
        },
        fireDetailCommitClicked: function fireDetailCommitClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.commit.clicked');
        },
        fireDetailTabClicked: function fireDetailTabClicked(type) {
            return exports.SummaryAnalytics.fireDetailTabClicked(type, 'commits');
        },
        fireDetailFileExpandedClicked: function fireDetailFileExpandedClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.file.expanded.clicked');
        },
        fireDetailFilesExpandedClicked: function fireDetailFilesExpandedClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.files.expanded.clicked');
        },
        fireDetailFileClicked: function fireDetailFileClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.file.clicked');
        },
        fireDetailReviewsShown: function fireDetailReviewsShown(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.reviews.shown');
        },
        fireDetailReviewClicked: function fireDetailReviewClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.review.clicked');
        },
        fireDetailBranchesShown: function fireDetailBranchesShown(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.branches.shown');
        },
        fireDetailCreateReviewClicked: function fireDetailCreateReviewClicked(type, allCommits) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.review.create' + (allCommits ? '.all' : ''));
        }
    };

    exports.ReviewsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('reviews', summarisedData);
        },
        fireDetailReviewClicked: function fireDetailReviewClicked() {
            return exports.Analytics.fireEvent('reviews.detail.review.clicked');
        }
    };

    /**
    * Branches:
    *
    * Summary clicked: devstatus.branches.summary.clicked
    * Detail:
    *   Repo: devstatus.branches.detail.bitbucket.repo.clicked
    *   Branch: devstatus.branches.detail.bitbucket.branch.clicked
    *   PR lozenge: devstatus.branches.detail.bitbucket.pullrequest.lozenge.clicked
    *   Create pull request:
    *     Current user is assigned: devstatus.branches.detail.bitbucket.pullrequest.create.assignee.clicked
    *     Current user is not assigned:
    *        Is assignable: devstatus.branches.detail.bitbucket.pullrequest.create.nonassignee.assignable.clicked
    *        Not assignable: devstatus.branches.detail.bitbucket.pullrequest.create.nonassignee.nonassignable.clicked
    *   Product tab: devstatus.branches.detail.bitbucket.tab.clicked
    *
    * Pull requests:
    * Summary clicked: devstatus.pullrequests.summary.clicked
    * Detail:
    *   Pull request link: devstatus.pullrequests.detail.bitbucket.pullrequest.clicked
    *   Product tab: devstatus.pullrequests.detail.bitbucket.tab.clicked
    *
    */
    exports.BranchesAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('branches', summarisedData);
        },
        _fireDetailClickedEvent: function _fireDetailClickedEvent(applicationType, eventType) {
            return exports.Analytics.fireEvent('branches.detail.' + applicationType + '.' + eventType + '.clicked');
        },
        _fireDetailClickedEventAssignable: function _fireDetailClickedEventAssignable(eventName, type, isAssignee, isAssignable) {
            if (typeof isAssignee !== 'undefined' && typeof isAssignable !== 'undefined') {
                if (isAssignee) {
                    eventName += '.assignee';
                } else {
                    eventName += '.nonassignee';
                    if (isAssignable) {
                        eventName += '.assignable';
                    } else {
                        eventName += '.nonassignable';
                    }
                }
            }
            this._fireDetailClickedEvent(type, eventName);
        },
        fireDetailRepoClicked: function fireDetailRepoClicked(type) {
            this._fireDetailClickedEvent(type, 'repo');
        },
        fireDetailBranchClicked: function fireDetailBranchClicked(type) {
            this._fireDetailClickedEvent(type, 'branch');
        },
        fireDetailPullRequestLozengeClick: function fireDetailPullRequestLozengeClick(type) {
            this._fireDetailClickedEvent(type, 'pullrequest.lozenge');
        },
        fireDetailReviewLozengeClick: function fireDetailReviewLozengeClick(type) {
            this._fireDetailClickedEvent(type, 'review.lozenge');
        },
        fireDetailTabClicked: function fireDetailTabClicked(type) {
            return exports.SummaryAnalytics.fireDetailTabClicked(type, 'branches');
        },
        fireDetailCreatePullRequestClicked: function fireDetailCreatePullRequestClicked(type, isAssignee, isAssignable) {
            this._fireDetailClickedEventAssignable('pullrequest.create', type, isAssignee, isAssignable);
        },
        fireDetailCreateReviewClicked: function fireDetailCreateReviewClicked(type, isAssignee, isAssignable) {
            this._fireDetailClickedEventAssignable('review.create', type, isAssignee, isAssignable);
        }
    };

    exports.PullRequestsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('pullrequests', summarisedData);
        },
        fireDetailPullRequestClicked: function fireDetailPullRequestClicked(type) {
            return exports.Analytics.fireEvent('pullrequests.detail.' + type + '.pullrequest.clicked');
        },
        fireDetailTabClicked: function fireDetailTabClicked(type) {
            return exports.SummaryAnalytics.fireDetailTabClicked(type, 'pullrequests');
        }
    };

    exports.LearnMoreAnalytics = {
        fireLearnMoreEvent: function fireLearnMoreEvent(name, opts) {
            return exports.Analytics.fireEvent('learnmore.' + name, opts);
        }
    };

    exports.CtaDialogAnalytics = {
        issueDetails: {}, // updated each time the create branch button is clicked

        fireCreateBranchEvent: function fireCreateBranchEvent(name, opts) {
            opts = (typeof opts === 'undefined' ? 'undefined' : _typeof(opts)) !== 'object' ? {} : opts;
            // add issue status and issue type
            var props = jQuery.extend({
                issueStatus: this.issueDetails.status,
                issueType: this.issueDetails.type
            }, opts);
            return exports.Analytics.fireEvent('createbranch.' + name + '.' + (this.issueDetails.isAssignee ? 'assignee' : 'nonassignee'), props);
        },

        _populateIssueDetails: function _populateIssueDetails(link) {
            this.issueDetails = {
                status: '' + link.data('issueStatus'), // to undo potential type conversion done by .data()
                type: '' + link.data('issueType'),
                isAssignee: link.data('isAssignee')
            };
        },

        /**
        * Pull out the handler as an independent function so that the tests could unbind it in tear down.
        * @param e the event. event.data should contains instance, panelSelector and linkSelector
        * @param context
        * @private
        */
        _initHandler: function _initHandler(e, context, panelSelector, linkSelector) {
            if (panelSelector && context.not(document).is(panelSelector)) {
                var instance = this;
                // Capture clicks on create branch button on view issue page
                context.find(linkSelector).on('simpleClick', function () {
                    var el = jQuery(this);
                    instance._fireCreateBranchEvent(el);
                });
            }
        },

        _fireCreateBranchEvent: function _fireCreateBranchEvent(el) {
            this._populateIssueDetails(el);
            /**
            * Whether the create branch link is being clicked in a new context (ie in a new tab)
            */
            var eventName = 'click';
            var isNewContext = Meta.get('fusion-analytics-new-context-link');
            if (isNewContext) {
                Meta.set('fusion-analytics-new-context-link', undefined);
                eventName += '.newcontext';
            }
            this.fireCreateBranchEvent(eventName);
        },

        initialize: function initialize(panelSelector, linkSelector, dialogId) {
            if (isAnalyticsEnabled()) {
                var instance = this;

                // for issue nav view
                // bind the create branch onclick event each time the panel is re-rendered
                //  if we bind on document, the click event will only be triggered after the dialog.open one.
                Events.bind(Types.NEW_CONTENT_ADDED, _.bind(function (e, context) {
                    this._initHandler(e, context, panelSelector, linkSelector);
                }, this));
                Events.bind('GH.DetailView.updated', _.bind(function (e) {
                    this._initHandler(e, jQuery(panelSelector), panelSelector, linkSelector);
                }, this));

                // for single page view issue page only, bind directly to the links, as the links should be available at this time
                // if it's issue nav, the links would not be available at this time, thus no double binding
                jQuery(linkSelector).on('simpleClick', function () {
                    var el = jQuery(this);
                    instance._fireCreateBranchEvent(el);
                });

                // These three have to be bound on document as the target is outside of the context
                // Capture clicks on an instance in the cta dialog
                jQuery(document).on('click', '#' + dialogId + ' .jira-dialog-content .target', function () {
                    var el = jQuery(this);
                    instance.fireCreateBranchEvent('dialog.click', {
                        title: el.find('.title').attr('title'),
                        applicationType: el.data('applicationType')
                    });
                });

                // Capture clicks on the cancel button in the cta dialog
                jQuery(document).on('click', '#' + dialogId + ' .jira-dialog-content button.cancel', function () {
                    instance.fireCreateBranchEvent('dialog.cancel');
                });

                // Capture clicks on the learn more link in the helptip
                jQuery(document).on('click', '.cta-tooltip .cta-learn-more-link', function () {
                    exports.LearnMoreAnalytics.fireLearnMoreEvent('click.ctahelptipbranching');
                });
            }
        }
    };

    exports.AdminAnalytics = {
        fireAdminEvent: function fireAdminEvent(name, opts) {
            return exports.Analytics.fireEvent('admin.' + name, opts);
        },

        initialize: function initialize() {
            if (isAnalyticsEnabled()) {
                var instance = this;
                var configPanel = jQuery('#project-config-panel-dev-status');
                // Capture clicks on edit permission link
                configPanel.find(editPermissionLinkSelector).on('click', function () {
                    instance.fireAdminEvent('editpermissionlink.config.' + (jQuery('ul.permissions-list li.devstatus-admin-permission-item').length > 0 ? 'withpermissions' : 'nopermissions'));
                });
                // Capture clicks on appvertisement link
                configPanel.find('.learn-more-link').on('click', function () {
                    exports.LearnMoreAnalytics.fireLearnMoreEvent('click.adminappvertisementlink');
                });
                // Capture clicks on the conenct button dropdown
                configPanel.find('#project-config-applinks-connect').on('click', function () {
                    instance.fireAdminEvent('connect');
                });
                // Capture clicks on the individual connect buttons
                configPanel.find('.devstatus-admin-connect-button-option').on('click', function () {
                    var key = jQuery(this).data('key') || 'unknown';
                    instance.fireAdminEvent('connect.' + key);
                });
            }
        }
    };

    exports.AdminSummaryAnalytics = {
        initialize: function initialize() {
            if (isAnalyticsEnabled()) {
                // Capture clicks on edit permission link
                // always no permission, because the link would only appear when no permissions
                jQuery('#project-config-webpanel-devstatus-admin-summary-panel').find(editPermissionLinkSelector).on('click', function () {
                    exports.AdminAnalytics.fireAdminEvent('editpermissionlink.summary.nopermissions');
                });
            }
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/DevStatusNavigation.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * This is an attempt to avoid direct interaction with the 'window' object in Javascript land.
 * This also includes all interactions with objects such as 'location' or 'document', because they are simply a reference
 *    from 'window.location' and 'window.document' respectively.
 *
 * There are 2 main reasons for doing this:
 * 1. To allow the JS code to be QUnit testable. 'window' object is not mock-able, hence does not respond well
 *    when testing modules that refresh or navigate away from the page.
 * 2. To avoid the incident where important JS events are not run when the browser navigates away from the current page.
 *    This will allow the currently queue-ed up events to be completed first before the browser trashes the Javascript state
 *    and navigates away.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    return {
        getUrl: function getUrl() {
            return window.location.href;
        },
        reload: function reload() {
            _.defer(function () {
                window.location.reload();
            });
        },
        navigate: function navigate(url) {
            _.defer(function () {
                window.location = url;
            });
        },
        redirectToLogin: function redirectToLogin() {
            this.navigate(wrmContextPath() + '/login.jsp?permissionViolation=true&os_destination=' + encodeURIComponent(window.location.href));
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/DevStatusURLUtils.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__, __webpack_require__("jira.webresources:parse-uri/require('jira/libs/parse-uri')")], __WEBPACK_AMD_DEFINE_RESULT__ = function ($, _, require, parseUri) {
    var devStatusNavigate = __webpack_require__("./js/util/DevStatusNavigation.js");
    return {
        getDetailDialogParam: function getDetailDialogParam() {
            var url = this._removeKickAssIHashFromUrl(devStatusNavigate.getUrl());
            var parsedUri = parseUri(url);
            return parsedUri && parsedUri.queryKey && parsedUri.queryKey['devStatusDetailDialog'];
        },
        getUrlWithDetailDialogParam: function getUrlWithDetailDialogParam(summaryType) {
            var currentUrl = this._removeKickAssIHashFromUrl(devStatusNavigate.getUrl());
            var parsedUri = parseUri(currentUrl);

            /**
            * Insert/replace devStatusDetailDialog param/query into the url
            */
            parsedUri.queryKey['devStatusDetailDialog'] = encodeURIComponent(summaryType);
            return this.createUrlFromParsedUri(parsedUri);
        },

        getCreateReviewDetailUrl: function getCreateReviewDetailUrl(applicationType) {
            return this.getUrlWithDetailDialogParam('create-review-' + applicationType);
        },

        isCreateReviewDetailDialogLink: function isCreateReviewDetailDialogLink(dialogToOpen) {
            return dialogToOpen && dialogToOpen.lastIndexOf && dialogToOpen.lastIndexOf('create-review-', 0) === 0;
        },

        getCreateReviewDetailDialogApplicationType: function getCreateReviewDetailDialogApplicationType(dialogToOpen) {
            return dialogToOpen.substring('create-review-'.length);
        },

        _removeKickAssIHashFromUrl: function _removeKickAssIHashFromUrl(url) {
            /**
            * In order to support single page app behaviour for issue nav/view issue in IE,
            * KickAss appended 'i#' prefix between the base URL and the KA url, because IE doesn't support push state
            * For example: http://localhost:2990/jira/i#browse/DEV-1
            *
            * parseUri and the logic in getUrlWithDetailDialogParam simply wouldn't work with an URL format like the above,
            * instead, we need to remove the i# prefix to get the regular non-IE-specific URL
            *
            * KA will automatically redirect from a regular URL to a i# url for IE.
            */
            return url.replace('i#', '');
        },
        /**
        * Copied from JIRA Agile.
        * See https://stash.atlassian.com/projects/JAG/repos/jira-agile/browse/greenhopper/src/main/resources/includes/js/lib/ajs-future.js#118
        *
        * Transformed the uri object from {@code parseUri} into url string
        *
        * @param uri object from {@code parseUri}
        * @returns {string}
        */
        createUrlFromParsedUri: function createUrlFromParsedUri(uri) {
            var params = [];
            $.each(uri.queryKey, function (name, value) {
                if (_.isObject(value)) {
                    $.each(value, function (index, innerVal) {
                        params.push(name + '=' + innerVal);
                    });
                } else {
                    params.push(name + '=' + value);
                }
            });

            var url = '';
            if (uri.protocol) {
                url += uri.protocol + '://';
            }
            if (uri.authority) {
                url += uri.authority;
            }
            if (uri.path) {
                url += uri.path;
            }
            if (params.length > 0) {
                url += '?' + params.join('&');
            }
            if (uri.anchor) {
                url += '#' + uri.anchor;
            }
            return url;
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/EventPublisher.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    'use strict';

    return {
        trigger: AJS.trigger
    };
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("./js/util/EventPublisher.js"), exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (eventPublisher, exports) {
    'use strict';

    /**
     * fires an analytics event
     * @param name of event
     * @param data data to be send with it
     */

    exports.sendEvent = function (name) {
        var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

        eventPublisher.trigger('analyticsEvent', {
            name: name,
            data: data
        });
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "jira.webresources:ajs-underscorejs-amd-shim/require('underscore')":
/***/ (function(module, exports) {

module.exports = require('underscore');

/***/ }),

/***/ "jira.webresources:jira-events/require('jira/util/events')":
/***/ (function(module, exports) {

module.exports = require('jira/util/events');

/***/ }),

/***/ "jira.webresources:jira-events/require('jira/util/events/types')":
/***/ (function(module, exports) {

module.exports = require('jira/util/events/types');

/***/ }),

/***/ "jira.webresources:jira-global/require('jira/ajs/dark-features')":
/***/ (function(module, exports) {

module.exports = require('jira/ajs/dark-features');

/***/ }),

/***/ "jira.webresources:jira-metadata/require('jira/util/data/meta')":
/***/ (function(module, exports) {

module.exports = require('jira/util/data/meta');

/***/ }),

/***/ "jira.webresources:jquery/require('jquery')":
/***/ (function(module, exports) {

module.exports = require('jquery');

/***/ }),

/***/ "jira.webresources:parse-uri/require('jira/libs/parse-uri')":
/***/ (function(module, exports) {

module.exports = require('jira/libs/parse-uri');

/***/ }),

/***/ "jira.webresources:wrm-context-path/require('wrm/context-path')":
/***/ (function(module, exports) {

module.exports = require('wrm/context-path');

/***/ })

},["./js/admin/devstatus-admin.js"]);
//# sourceMappingURL=devstatus-admin.23b9358cb358b1b587ae.js.map