jiraDevelopmentIntegrationPluginJsonp([8],{

/***/ "./js/viewissue/dialog/InstancePickerView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(25);
// @formatter:off
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-smart-ajax/require('jira/ajs/ajax/smart-ajax')"), __webpack_require__("jira.webresources:jquery/require('jira/jquery/deferred')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/util/DevStatusNavigation.js"), __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (SmartAjax, Deferred, Backbone, $, _, DevStatusNavigate, wrmContextPath) {
    return Backbone.View.extend({
        ARROW_KEY_UP_CODE: 38,
        ARROW_KEY_DOWN_CODE: 40,
        template: JIRA.Templates.DevStatus.Dialog.content,

        events: {
            'keydown .jira-dialog-content': '_onTargetKeyboardSelect',
            'focus .target': '_onTargetFocus'
        },

        initialize: function initialize(options) {
            this.currentSelected = null;
            this.link = options.activeTrigger;
            this.cta = options.cta;
            this.processTargets = options.processTargets;
            this.issueId = options.issueId;

            // the function to be called when only a single result is present
            this.uniqueResultAction = options.uniqueResultAction || function (uniqueResult) {
                DevStatusNavigate.navigate(uniqueResult.url);
            };
        },

        render: function render() {
            var issueId = this._getIssueId(this.link);
            var deferred = Deferred();

            this._fetchTargets(this.cta, issueId).done(_.bind(function (remoteApps) {
                if (this.processTargets) {
                    remoteApps.remoteApps = this.processTargets(remoteApps.remoteApps);
                }

                var uniqueResult = this._isUniqueResult(remoteApps);
                if (uniqueResult) {
                    this.uniqueResultAction(uniqueResult);
                } else {
                    var content = $(this.template(remoteApps));
                    deferred.resolve(content);
                }
            }, this)).fail(function (errorContent) {
                deferred.resolve(errorContent);
            });
            return deferred.promise();
        },

        _fetchTargets: function _fetchTargets(cta, issueId) {
            var deferred = Deferred();
            $.ajax({
                url: wrmContextPath() + '/rest/dev-status/1.0/issue/targets?cta=' + encodeURIComponent(cta) + '&issueId=' + encodeURIComponent(issueId)
            }).done(function (result) {
                deferred.resolve(result);
            }).fail(function (xhr, status) {
                deferred.reject(SmartAjax.buildDialogErrorContent(xhr).html());
            });
            return deferred.promise();
        },

        _getIssueId: function _getIssueId(link) {
            // Note: 'Create branch' link in the opsbar does not have the issue-id in the link neither this.issueId
            // so it is required to get it from #devstatus-container
            return this.issueId || link && link.data('issueid') || $('#devstatus-container').data('issue-id');
        },

        _isUniqueResult: function _isUniqueResult(data) {
            return data.remoteApps.length === 1 && data.remoteApps[0];
        },

        _toggleEntry: function _toggleEntry(elements, index, shouldFocus) {
            var entry = elements.eq(index);
            shouldFocus && entry.focus();
            entry.addClass('selected');
            this.currentSelected = entry;
        },

        _removeSelected: function _removeSelected() {
            if (this.currentSelected) {
                this.currentSelected.removeClass('selected');
                this.currentSelected = null;
            }
        },

        _onTargetKeyboardSelect: function _onTargetKeyboardSelect(e) {
            if (e.type === 'keydown') {
                var direction = 0;
                if (e.keyCode === this.ARROW_KEY_UP_CODE) {
                    direction = -1;
                } else if (e.keyCode === this.ARROW_KEY_DOWN_CODE) {
                    direction = 1;
                }

                if (direction !== 0) {
                    e.preventDefault();

                    var targets = this.$el.find('.target');
                    var focusedEntry = targets.index(this.$el.find('.selected'));

                    if (focusedEntry !== -1) {
                        targets.eq((focusedEntry + direction) % targets.size()).focus();
                    }
                }
            }
        },

        _onTargetFocus: function _onTargetFocus(e) {
            this._removeSelected();
            this._toggleEntry($(e.target), 0, false);
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 25:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ "jira.webresources:jira-smart-ajax/require('jira/ajs/ajax/smart-ajax')":
/***/ (function(module, exports) {

module.exports = require('jira/ajs/ajax/smart-ajax');

/***/ }),

/***/ "jira.webresources:jquery/require('jira/jquery/deferred')":
/***/ (function(module, exports) {

module.exports = require('jira/jquery/deferred');

/***/ })

});
//# sourceMappingURL=8.64567d428119bc70457e.js.map