jiraDevelopmentIntegrationPluginJsonp([5],{

/***/ "./js/analytics/devstatus-analytics.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-global/require('jira/ajs/dark-features')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__, exports], __WEBPACK_AMD_DEFINE_RESULT__ = function (DarkFeatures, _, jQuery, require, exports) {
    var Events = __webpack_require__("jira.webresources:jira-events/require('jira/util/events')");
    var Types = __webpack_require__("jira.webresources:jira-events/require('jira/util/events/types')");
    var Meta = __webpack_require__("jira.webresources:jira-metadata/require('jira/util/data/meta')");
    var analytics = __webpack_require__("./js/util/analytics.js");

    var editPermissionLinkSelector = '.edit-permission-link';

    /**
    * @returns {boolean} if analytics is enabled
    */
    function isAnalyticsEnabled() {
        return !DarkFeatures.isEnabled('jira.plugin.devstatus.analytics.disabled');
    }

    exports.Analytics = {
        /**
        * Fires an Atlassian Analytics event. Events will be subject to whitelist filtering as described in
        * <a href="https://extranet.atlassian.com/x/vkOJgw">Tagging & Whitelisting Analytics Events</a>.
        *
        * @param name  a unique name for the event, could be namespaced with ".", e.g., "createbranch.click"
        *              will be prepended with "devstatus."
        * @param data  an object containing any particular properties of relevance for this navigation type.
        */
        fireEvent: function fireEvent(name, data) {
            if (isAnalyticsEnabled()) {
                var eventName = 'devstatus.' + name;

                analytics.sendEvent(eventName, data);
            }
        },
        fireAgileDevStatusLinkClicked: function fireAgileDevStatusLinkClicked() {
            return exports.Analytics.fireEvent('panel.agile.icon.clicked');
        }
    };

    exports.LabsAnalytics = {
        fireLabsEvent: function fireLabsEvent(toggle) {
            var msg = toggle ? 'on' : 'off';
            return exports.Analytics.fireEvent('labs.toggle.' + msg);
        }
    };

    /**
    * Summary shown:
    *   * Current user is assigned: devstatus.summary.shown.assignee
    *   * Current user it NOT assigned: devstatus.summary.shown.nonassignee
    */
    exports.SummaryAnalytics = {
        fireSummaryShownEvent: function fireSummaryShownEvent(isAssignee, issueType, issueStatus, summarisedData) {
            var assigneeText = isAssignee ? 'assignee' : 'nonassignee';
            var opts = _.extend({
                issueType: issueType,
                issueStatus: issueStatus
            }, summarisedData);
            return exports.Analytics.fireEvent('summary.shown.' + assigneeText, opts);
        },

        /**
        * Fires a "dev summary clicked event". The events raised will be called <code>"devstatus.&lt;infoType&gt;.summary.clicked"</code>
        * or <code>"devstatus.&lt;infoType&gt;.summary.clicked.newcontext"</code>. The <code>summarisedData</code> param
        * should contain a boolean indicating whether there is summary information for each type, e.g.:
        * <pre>
        * {
        *     "branch": true,
        *     "build": true,
        *     "commit": true,
        *     "deployment-environment": false,
        *     "pullrequest": true,
        *     "review": false
        * }
        * </pre>
        * All information contained in <b>the event must adhere to the <a href="https://extranet.atlassian.com/x/x5Zxgw">Atlassian privacy policy</a></b>.
        *
        * @param {string} infoType the type of summary link clicked
        * @param {object} summarisedData
        * @returns {*}
        */
        fireSummaryClickedEvent: function fireSummaryClickedEvent(infoType, summarisedData) {
            var isNewContext = Meta.get('fusion-analytics-new-context-link');
            var event = '.clicked';
            if (isNewContext) {
                Meta.set('fusion-analytics-new-context-link', undefined);
                event += '.newcontext';
            }
            return exports.Analytics.fireEvent(infoType + '.summary' + event, summarisedData);
        },
        fireDetailTabClicked: function fireDetailTabClicked(applicationType, dataType) {
            return exports.Analytics.fireEvent(dataType + '.detail.' + applicationType + '.tab.clicked');
        }
    };

    exports.BuildsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('builds', summarisedData);
        },
        fireDetailProjectClicked: function fireDetailProjectClicked() {
            return exports.Analytics.fireEvent('builds.detail.project.clicked');
        },
        fireDetailPlanClicked: function fireDetailPlanClicked() {
            return exports.Analytics.fireEvent('builds.detail.plan.clicked');
        },
        fireDetailBuildClicked: function fireDetailBuildClicked() {
            return exports.Analytics.fireEvent('builds.detail.build.clicked');
        }
    };

    exports.DeploymentsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('deployments', summarisedData);
        },
        fireDetailProjectClicked: function fireDetailProjectClicked() {
            return exports.Analytics.fireEvent('deployments.detail.project.clicked');
        },
        fireDetailEnvironmentClicked: function fireDetailEnvironmentClicked() {
            return exports.Analytics.fireEvent('deployments.detail.environment.clicked');
        },
        fireDetailReleaseClicked: function fireDetailReleaseClicked() {
            return exports.Analytics.fireEvent('deployments.detail.release.clicked');
        }
    };

    exports.CommitsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('commits', summarisedData);
        },
        fireDetailRepoClicked: function fireDetailRepoClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.repo.clicked');
        },
        fireDetailCommitClicked: function fireDetailCommitClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.commit.clicked');
        },
        fireDetailTabClicked: function fireDetailTabClicked(type) {
            return exports.SummaryAnalytics.fireDetailTabClicked(type, 'commits');
        },
        fireDetailFileExpandedClicked: function fireDetailFileExpandedClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.file.expanded.clicked');
        },
        fireDetailFilesExpandedClicked: function fireDetailFilesExpandedClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.files.expanded.clicked');
        },
        fireDetailFileClicked: function fireDetailFileClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.file.clicked');
        },
        fireDetailReviewsShown: function fireDetailReviewsShown(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.reviews.shown');
        },
        fireDetailReviewClicked: function fireDetailReviewClicked(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.review.clicked');
        },
        fireDetailBranchesShown: function fireDetailBranchesShown(type) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.branches.shown');
        },
        fireDetailCreateReviewClicked: function fireDetailCreateReviewClicked(type, allCommits) {
            return exports.Analytics.fireEvent('commits.detail.' + type + '.review.create' + (allCommits ? '.all' : ''));
        }
    };

    exports.ReviewsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('reviews', summarisedData);
        },
        fireDetailReviewClicked: function fireDetailReviewClicked() {
            return exports.Analytics.fireEvent('reviews.detail.review.clicked');
        }
    };

    /**
    * Branches:
    *
    * Summary clicked: devstatus.branches.summary.clicked
    * Detail:
    *   Repo: devstatus.branches.detail.bitbucket.repo.clicked
    *   Branch: devstatus.branches.detail.bitbucket.branch.clicked
    *   PR lozenge: devstatus.branches.detail.bitbucket.pullrequest.lozenge.clicked
    *   Create pull request:
    *     Current user is assigned: devstatus.branches.detail.bitbucket.pullrequest.create.assignee.clicked
    *     Current user is not assigned:
    *        Is assignable: devstatus.branches.detail.bitbucket.pullrequest.create.nonassignee.assignable.clicked
    *        Not assignable: devstatus.branches.detail.bitbucket.pullrequest.create.nonassignee.nonassignable.clicked
    *   Product tab: devstatus.branches.detail.bitbucket.tab.clicked
    *
    * Pull requests:
    * Summary clicked: devstatus.pullrequests.summary.clicked
    * Detail:
    *   Pull request link: devstatus.pullrequests.detail.bitbucket.pullrequest.clicked
    *   Product tab: devstatus.pullrequests.detail.bitbucket.tab.clicked
    *
    */
    exports.BranchesAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('branches', summarisedData);
        },
        _fireDetailClickedEvent: function _fireDetailClickedEvent(applicationType, eventType) {
            return exports.Analytics.fireEvent('branches.detail.' + applicationType + '.' + eventType + '.clicked');
        },
        _fireDetailClickedEventAssignable: function _fireDetailClickedEventAssignable(eventName, type, isAssignee, isAssignable) {
            if (typeof isAssignee !== 'undefined' && typeof isAssignable !== 'undefined') {
                if (isAssignee) {
                    eventName += '.assignee';
                } else {
                    eventName += '.nonassignee';
                    if (isAssignable) {
                        eventName += '.assignable';
                    } else {
                        eventName += '.nonassignable';
                    }
                }
            }
            this._fireDetailClickedEvent(type, eventName);
        },
        fireDetailRepoClicked: function fireDetailRepoClicked(type) {
            this._fireDetailClickedEvent(type, 'repo');
        },
        fireDetailBranchClicked: function fireDetailBranchClicked(type) {
            this._fireDetailClickedEvent(type, 'branch');
        },
        fireDetailPullRequestLozengeClick: function fireDetailPullRequestLozengeClick(type) {
            this._fireDetailClickedEvent(type, 'pullrequest.lozenge');
        },
        fireDetailReviewLozengeClick: function fireDetailReviewLozengeClick(type) {
            this._fireDetailClickedEvent(type, 'review.lozenge');
        },
        fireDetailTabClicked: function fireDetailTabClicked(type) {
            return exports.SummaryAnalytics.fireDetailTabClicked(type, 'branches');
        },
        fireDetailCreatePullRequestClicked: function fireDetailCreatePullRequestClicked(type, isAssignee, isAssignable) {
            this._fireDetailClickedEventAssignable('pullrequest.create', type, isAssignee, isAssignable);
        },
        fireDetailCreateReviewClicked: function fireDetailCreateReviewClicked(type, isAssignee, isAssignable) {
            this._fireDetailClickedEventAssignable('review.create', type, isAssignee, isAssignable);
        }
    };

    exports.PullRequestsAnalytics = {
        fireSummaryClickedEvent: function fireSummaryClickedEvent(summarisedData) {
            return exports.SummaryAnalytics.fireSummaryClickedEvent('pullrequests', summarisedData);
        },
        fireDetailPullRequestClicked: function fireDetailPullRequestClicked(type) {
            return exports.Analytics.fireEvent('pullrequests.detail.' + type + '.pullrequest.clicked');
        },
        fireDetailTabClicked: function fireDetailTabClicked(type) {
            return exports.SummaryAnalytics.fireDetailTabClicked(type, 'pullrequests');
        }
    };

    exports.LearnMoreAnalytics = {
        fireLearnMoreEvent: function fireLearnMoreEvent(name, opts) {
            return exports.Analytics.fireEvent('learnmore.' + name, opts);
        }
    };

    exports.CtaDialogAnalytics = {
        issueDetails: {}, // updated each time the create branch button is clicked

        fireCreateBranchEvent: function fireCreateBranchEvent(name, opts) {
            opts = (typeof opts === 'undefined' ? 'undefined' : _typeof(opts)) !== 'object' ? {} : opts;
            // add issue status and issue type
            var props = jQuery.extend({
                issueStatus: this.issueDetails.status,
                issueType: this.issueDetails.type
            }, opts);
            return exports.Analytics.fireEvent('createbranch.' + name + '.' + (this.issueDetails.isAssignee ? 'assignee' : 'nonassignee'), props);
        },

        _populateIssueDetails: function _populateIssueDetails(link) {
            this.issueDetails = {
                status: '' + link.data('issueStatus'), // to undo potential type conversion done by .data()
                type: '' + link.data('issueType'),
                isAssignee: link.data('isAssignee')
            };
        },

        /**
        * Pull out the handler as an independent function so that the tests could unbind it in tear down.
        * @param e the event. event.data should contains instance, panelSelector and linkSelector
        * @param context
        * @private
        */
        _initHandler: function _initHandler(e, context, panelSelector, linkSelector) {
            if (panelSelector && context.not(document).is(panelSelector)) {
                var instance = this;
                // Capture clicks on create branch button on view issue page
                context.find(linkSelector).on('simpleClick', function () {
                    var el = jQuery(this);
                    instance._fireCreateBranchEvent(el);
                });
            }
        },

        _fireCreateBranchEvent: function _fireCreateBranchEvent(el) {
            this._populateIssueDetails(el);
            /**
            * Whether the create branch link is being clicked in a new context (ie in a new tab)
            */
            var eventName = 'click';
            var isNewContext = Meta.get('fusion-analytics-new-context-link');
            if (isNewContext) {
                Meta.set('fusion-analytics-new-context-link', undefined);
                eventName += '.newcontext';
            }
            this.fireCreateBranchEvent(eventName);
        },

        initialize: function initialize(panelSelector, linkSelector, dialogId) {
            if (isAnalyticsEnabled()) {
                var instance = this;

                // for issue nav view
                // bind the create branch onclick event each time the panel is re-rendered
                //  if we bind on document, the click event will only be triggered after the dialog.open one.
                Events.bind(Types.NEW_CONTENT_ADDED, _.bind(function (e, context) {
                    this._initHandler(e, context, panelSelector, linkSelector);
                }, this));
                Events.bind('GH.DetailView.updated', _.bind(function (e) {
                    this._initHandler(e, jQuery(panelSelector), panelSelector, linkSelector);
                }, this));

                // for single page view issue page only, bind directly to the links, as the links should be available at this time
                // if it's issue nav, the links would not be available at this time, thus no double binding
                jQuery(linkSelector).on('simpleClick', function () {
                    var el = jQuery(this);
                    instance._fireCreateBranchEvent(el);
                });

                // These three have to be bound on document as the target is outside of the context
                // Capture clicks on an instance in the cta dialog
                jQuery(document).on('click', '#' + dialogId + ' .jira-dialog-content .target', function () {
                    var el = jQuery(this);
                    instance.fireCreateBranchEvent('dialog.click', {
                        title: el.find('.title').attr('title'),
                        applicationType: el.data('applicationType')
                    });
                });

                // Capture clicks on the cancel button in the cta dialog
                jQuery(document).on('click', '#' + dialogId + ' .jira-dialog-content button.cancel', function () {
                    instance.fireCreateBranchEvent('dialog.cancel');
                });

                // Capture clicks on the learn more link in the helptip
                jQuery(document).on('click', '.cta-tooltip .cta-learn-more-link', function () {
                    exports.LearnMoreAnalytics.fireLearnMoreEvent('click.ctahelptipbranching');
                });
            }
        }
    };

    exports.AdminAnalytics = {
        fireAdminEvent: function fireAdminEvent(name, opts) {
            return exports.Analytics.fireEvent('admin.' + name, opts);
        },

        initialize: function initialize() {
            if (isAnalyticsEnabled()) {
                var instance = this;
                var configPanel = jQuery('#project-config-panel-dev-status');
                // Capture clicks on edit permission link
                configPanel.find(editPermissionLinkSelector).on('click', function () {
                    instance.fireAdminEvent('editpermissionlink.config.' + (jQuery('ul.permissions-list li.devstatus-admin-permission-item').length > 0 ? 'withpermissions' : 'nopermissions'));
                });
                // Capture clicks on appvertisement link
                configPanel.find('.learn-more-link').on('click', function () {
                    exports.LearnMoreAnalytics.fireLearnMoreEvent('click.adminappvertisementlink');
                });
                // Capture clicks on the conenct button dropdown
                configPanel.find('#project-config-applinks-connect').on('click', function () {
                    instance.fireAdminEvent('connect');
                });
                // Capture clicks on the individual connect buttons
                configPanel.find('.devstatus-admin-connect-button-option').on('click', function () {
                    var key = jQuery(this).data('key') || 'unknown';
                    instance.fireAdminEvent('connect.' + key);
                });
            }
        }
    };

    exports.AdminSummaryAnalytics = {
        initialize: function initialize() {
            if (isAnalyticsEnabled()) {
                // Capture clicks on edit permission link
                // always no permission, because the link would only appear when no permissions
                jQuery('#project-config-webpanel-devstatus-admin-summary-panel').find(editPermissionLinkSelector).on('click', function () {
                    exports.AdminAnalytics.fireAdminEvent('editpermissionlink.summary.nopermissions');
                });
            }
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/DateUtils.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

(function () {
    // TODO: this shared global state is just bad
    // May be overridden for tests
    var format = 'LLL';
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:momentjs/require('jira/moment')")], __WEBPACK_AMD_DEFINE_RESULT__ = function ($, moment) {
        return {
            addTooltip: function addTooltip($el) {
                var $timestamp = $el.find('time.livestamp');
                $timestamp.livestamp(); // show relative time
                // set tooltip like in issue Created/Updated timestamp. not very i18n, should try to reuse what java uses
                $timestamp.each(function () {
                    var $time_el = $(this);
                    var $time_val = $time_el.attr('datetime');
                    var fixed_time = isNaN($time_val) ? $time_val : +$time_val;
                    var fixedMoment = moment(fixed_time).zone(fixed_time);
                    if (!fixedMoment.isValid()) {
                        fixedMoment = moment(fixed_time);
                    }
                    $time_el.attr('title', fixedMoment.format(format));
                });
            },

            setFormat: function setFormat(newFormat) {
                format = newFormat;
            }
        };
    }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
})();

/***/ }),

/***/ "./js/util/DevStatusLocalStorage.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/util/LocalStorage.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (logger, _, localStorage) {
    'use strict';

    var devStatusLocalStorage = _.extend({}, localStorage);
    devStatusLocalStorage.setItem = function (key, value) {
        try {
            localStorage.setItem(key, value);
        } catch (err) {
            var info = '';
            // Error code 22 is a QuotaExceededException on Chrome and Edge
            // Error code 1014 with name 'NS_ERROR_DOM_QUOTA_REACHED' is a QuotaExceededException on Firefox
            if (err.code === 22 || err.code === 1014 && err.name === 'NS_ERROR_DOM_QUOTA_REACHED') {
                info = '. Browser local storage is full. For more information please follow ' + 'https://confluence.atlassian.com/jirakb/functionality-in-jira-fails-due-to-exceeding-chrome-quota-762874705.html';
            }
            logger.error("Couldn't store '" + key + "' & '" + value + "' key-value pair locally: " + err.name + info);
        }
    };
    devStatusLocalStorage.getItem = function (key) {
        try {
            return localStorage.getItem(key);
        } catch (err) {
            logger.error("Couldn't retrieve locally stored value for key '" + key + "': " + err.name);
        }
    };
    devStatusLocalStorage.removeItem = function (key) {
        try {
            localStorage.removeItem(key);
        } catch (err) {
            logger.error("Couldn't remove locally stored value for key '" + key + "': " + err.name);
        }
    };
    devStatusLocalStorage.clear = function () {
        try {
            localStorage.clear();
        } catch (err) {
            logger.error("Couldn't clear local storage: " + err.name);
        }
    };
    return devStatusLocalStorage;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/DevStatusNavigation.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/**
 * This is an attempt to avoid direct interaction with the 'window' object in Javascript land.
 * This also includes all interactions with objects such as 'location' or 'document', because they are simply a reference
 *    from 'window.location' and 'window.document' respectively.
 *
 * There are 2 main reasons for doing this:
 * 1. To allow the JS code to be QUnit testable. 'window' object is not mock-able, hence does not respond well
 *    when testing modules that refresh or navigate away from the page.
 * 2. To avoid the incident where important JS events are not run when the browser navigates away from the current page.
 *    This will allow the currently queue-ed up events to be completed first before the browser trashes the Javascript state
 *    and navigates away.
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    return {
        getUrl: function getUrl() {
            return window.location.href;
        },
        reload: function reload() {
            _.defer(function () {
                window.location.reload();
            });
        },
        navigate: function navigate(url) {
            _.defer(function () {
                window.location = url;
            });
        },
        redirectToLogin: function redirectToLogin() {
            this.navigate(wrmContextPath() + '/login.jsp?permissionViolation=true&os_destination=' + encodeURIComponent(window.location.href));
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/LocalStorage.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    'use strict';

    if (!localStorage) {
        return {
            setItem: function setItem() {},
            getItem: function getItem() {},
            removeItem: function removeItem() {},
            clear: function clear() {}
        };
    }
    return localStorage;
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/dialog/BaseDetailDialogModel.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

// @formatter:off

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, Backbone, $, _) {
    return Backbone.Model.extend({
        TAB_PREFIX: '#tab-menu-',
        PANE_PREFIX: '#tab-content-',

        properties: ['tabs', 'contentMap', //map of instance id to content json
        'oauthStatuses', // authentication status of each remote instance
        'selectedTab', 'selectedPane'],

        namedEvents: [
        // events related to detailed data rest call
        'fetchRequested', 'fetchFailed', 'fetchSucceeded',
        // events related to auth status rest call
        'fetchAuthRequested', 'fetchAuthFailed', 'fetchAuthSucceeded'],

        initialize: function initialize(data) {
            this.issueKey = data.issueKey;
            this.issueId = data.issueId;
            this.type = data.dataType;
            this.set('contentMap', {});
            this.set('tabs', data.tabs);
        },

        switchTab: function switchTab(applicationType, forceFetch) {
            this.set('selectedTab', this.TAB_PREFIX + applicationType);
            this.set('selectedPane', this.PANE_PREFIX + applicationType);

            if (this.get('contentMap')[applicationType] == null || forceFetch) {
                this._fetchContents(applicationType);
            }
        },

        _fetchContents: function _fetchContents(applicationType) {
            this.trigger('fetchRequested', applicationType);
            this._handleFetch(applicationType, $.ajax({
                url: wrmContextPath() + '/rest/dev-status/1.0/issue/detail',
                data: {
                    issueId: this.issueId,
                    applicationType: applicationType,
                    dataType: this.type
                }
            }).promise());
        },

        _handleFetch: function _handleFetch(applicationType, fetchXhr) {
            var instance = this;
            //noinspection JSUnusedLocalSymbols
            fetchXhr.done(function (result) {
                instance._fireSuccessResult(applicationType, result);
            }).fail(function (xhr, status) {
                instance._fireFailResult(applicationType, xhr);
            });
        },

        _fireSuccessResult: function _fireSuccessResult(applicationType, result) {
            this._updateContents(applicationType, result);
            this.trigger('fetchSucceeded', applicationType, result);
        },

        _fireFailResult: function _fireFailResult(applicationType, xhr) {
            this._updateContents(applicationType);
            this.trigger('fetchFailed', applicationType, xhr);
        },

        _updateContents: function _updateContents(applicationType, content) {
            this.get('contentMap')[applicationType] = content;
        },

        /**
        * Initiate the rest call to fetch authentication statuses based on the application types from the current tabs.
        */
        fetchAuthenticationStatuses: function fetchAuthenticationStatuses() {
            var applicationTypes = _.keys(this.get('tabs') || {});
            if (!_.isEmpty(applicationTypes)) {
                var instance = this;
                //noinspection JSUnusedLocalSymbols
                $.ajax({
                    url: wrmContextPath() + '/rest/dev-status/1.0/provider/auth-status',
                    data: {
                        applicationType: applicationTypes
                    }
                }).promise().done(function (result) {
                    if (result && result.data) {
                        instance._updateOAuthStatuses(result.data);
                        instance.trigger('fetchAuthSucceeded', result.data);
                    } else {
                        instance._updateOAuthStatuses();
                        instance.trigger('fetchAuthFailed', null, result);
                    }
                }).fail(function (xhr, status) {
                    instance._updateOAuthStatuses();
                    instance.trigger('fetchAuthFailed', xhr);
                });
            }
        },

        /**
        * Handle the change of oauth status of an instance belonging to an application type.
        * If it's the current tab, triggers the refresh of the current tab by starting the fetch of detailed data.
        * If it's not the current tab but it's content is cached, invalidate the cache.
        */
        oauthStatusChanged: function oauthStatusChanged(applicationType) {
            if (_.has(this.get('tabs'), applicationType)) {
                var currentApplicationType = this._getCurrentApplicationType();
                if (currentApplicationType === applicationType) {
                    this._fetchContents(currentApplicationType);
                } else {
                    // clear the cache, regardless of whether it's there
                    this.get('contentMap')[applicationType] = null;
                }
            }
        },

        _getCurrentApplicationType: function _getCurrentApplicationType() {
            var selectedTab = this.get('selectedTab');
            if (selectedTab) {
                return selectedTab.slice(this.TAB_PREFIX.length);
            }
            return null;
        },

        _updateOAuthStatuses: function _updateOAuthStatuses(content) {
            this.set('oauthStatuses', content);
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/dialog/BaseDetailDialogView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(2);
__webpack_require__(12);
__webpack_require__(13);
__webpack_require__(14);
__webpack_require__(15);
__webpack_require__(1);

__webpack_require__(3);

// @formatter:off
/**
 * This is the generic abstract backbone view for the detail dialog
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:dialogs/require('jira/dialog/form-dialog')"), __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/util/DevStatusLocalStorage.js"), __webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (logger, formatter, FormDialog, wrmContextPath, Backbone, $, _, detailDialogLocalStorage, require) {
    var devStatusNavigate = __webpack_require__("./js/util/DevStatusNavigation.js");
    var JIRADevStatusBaseDetailDialogModel = __webpack_require__("./js/viewissue/dialog/BaseDetailDialogModel.js");

    return Backbone.View.extend({
        frameEvents: {
            'click .menu-item': '_doTabClick'
        },

        frameTemplate: JIRA.Templates.DevStatus.DetailDialogFrame.frame,
        oauthStatusTemplate: JIRA.Templates.DevStatus.DetailDialog.oauthStatus,
        authenticationTemplate: JIRA.Templates.DevStatus.DetailDialog.authenticationScreen,
        connectionProblemTemplate: JIRA.Templates.DevStatus.DetailDialog.connectionProblemScreen,
        connectionProblemWarningTemplate: JIRA.Templates.DevStatus.connectionProblemAsWarning,
        noPermissionToViewAllTemplate: JIRA.Templates.DevStatus.DetailDialog.noPermissionToViewAll,
        oauthDanceFailedTemplate: JIRA.Templates.DevStatus.DetailDialog.oauthDanceFailed,

        /**
        * @param options
        * @param options.id {String} Dialog id
        * @param options.issueKey {String} Issue key
        * @param options.issueId {String} Issue id
        * @param options.count {Number} Number of the associated type
        * @param options.model {Backbone.Model} Optional, if none is given, then JIRA.DevStatus.BaseDetailDialogModel will be used
        * @param options.tabs {[{name: String, count: Number}]} A list of map containing name, type and count
        * @param options.type {String} The type of this dialog. Will be used as part of i18n.
        * @param options.dataType {String} the type of remote data (different from type)
        * @param options.width {Number} Width of the content area (does not include frame)
        * @param options.height {Number} Height of the content area (does not include frame)
        * @param options.initialTab {String} The application type of the tab to be active on open
        */
        initialize: function initialize(options) {
            this.options = _.defaults({}, options, {
                width: 560,
                model: new JIRADevStatusBaseDetailDialogModel(options)
            });
            this.model = this.options.model;
            this._initFetchHandlers();

            this._initFormDialog();
        },

        // ===============================================================================
        // The following methods are expected to be extended by the children of this class
        // ===============================================================================
        /**
        * Render the data into the canvas. Note that this is not necessarily the active pane.
        * It is possible that the user switches tab before the data for the tab comes back, in which case
        *  we are rendering the pane of a tab that's not active.
        */
        renderSuccess: function renderSuccess(applicationType, result) {
            return this;
        },
        /**
        * By default, visiting a tab in the detail dialog will cause BaseDetailDialogModel to cache the content
        * of the detail dialog. This is to indicate whether it should make another ajax call.
        */
        shouldRefreshOnTabSwitch: function shouldRefreshOnTabSwitch(applicationType) {
            return false;
        },
        /**
        * Returns the message to be displayed in the title of the detailed dialog.
        * @param count The combined count across all the instances of this entity
        * @param issue The key of the issue currently being displayed
        * @returns {String}
        */
        getTitle: function getTitle(count, issue) {
            // This should never happen
            logger.warn('Unimplemented getTitle() function', this);
            return issue;
        },
        /**
        * Returns the message to be displayed in the footer to inform users that some instances are not authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "You might be able to see more commits by authenticating with the following servers:"
        * @param instances [Object] the instances that are not authenticated yet. Could be useful for determining plurality.
        * @returns {String}
        */
        getOAuthMessageInFooter: function getOAuthMessageInFooter(instances) {
            return formatter.I18n.getText('devstatus.authentication.message.generic', instances.length);
        },
        /**
        * Returns the message to be displayed in the main canvas of the detailed dialog, when all instances of the current type
        * are not authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "Authenticate to see more commits"
        * @returns {String}
        */
        getOAuthMessageInCanvas: function getOAuthMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.authenticate.generic.title');
        },
        /**
        * Returns the message to be displayed in the main canvas of the detailed dialog, when all instances of the current type
        * are not authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "Unable to retrieve commit information"
        * @returns {String}
        */
        getConnectionMessageInCanvas: function getConnectionMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.connection-problem.generic.title');
        },
        /**
        * Returns the message to be displayed in the main canvas of the detailed dialog, when the user does not have permission
        * to view all dev status even after being authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "You don't have access to view all related commits. Please contact your administrator."
        * @returns {String}
        */
        getNoPermissionToViewAllMessageInCanvas: function getNoPermissionToViewAllMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.connection-problem.generic.title');
        },
        /**
        * Returns the message to be displayed when there are permission / connection problems.
        *
        * Either a contact administrators message for logged in users, or a log in message otherwise.
        *
        * @returns {String}
        */
        getContactAdmistratorsOrLoginMessageInCanvas: function getContactAdmistratorsOrLoginMessageInCanvas() {
            if (JIRA.Users.LoggedInUser.isAnonymous()) {
                return formatter.I18n.getText('devstatus.authentication.no-permission-to-view-all.generic.login');
            } else {
                return formatter.I18n.getText('devstatus.authentication.no-permission-to-view-all.generic.admin-contact');
            }
        },

        /**
        * Checks whether the detailed data has some data for the given detail dialog.
        * @param detail {Array} The detail json object.
        * @returns {boolean} true if there is some data for the given detail dialog.
        */
        hasData: function hasData(detail) {
            return detail.length > 0;
        },

        /* ============================================================================= */

        show: function show() {
            this.dialog.show();
        },

        hide: function hide() {
            this.dialog.hide();
        },

        _getPane: function _getPane(applicationType) {
            // http://learn.jquery.com/using-jquery-core/faq/how-do-i-select-an-element-by-an-id-that-has-characters-used-in-css-notation/
            return applicationType ? this.$el.find('#tab-content-' + applicationType.replace(/(:|\.|\[|\])/g, '\\$1')) : $();
        },

        /**
        * Get the content container for the given application type (tab).
        * If the applicaitonType is not specified, get the current one.
        */
        getContentContainer: function getContentContainer(applicationType) {
            return this._getPane(applicationType || this._getActiveApplicationType()).find('.detail-content-container');
        },

        _doTabClick: function _doTabClick(e) {
            e.preventDefault();
            var appType = this._getActiveApplicationType();
            detailDialogLocalStorage.setItem(this._getTabStorageId(), appType);
            this.model.switchTab(appType, this.shouldRefreshOnTabSwitch(appType));
            this.analytics && this.analytics.fireDetailTabClicked(appType);
        },

        _redirectToLoginIf401: function _redirectToLoginIf401(xhr) {
            if (xhr && xhr.status === 401) {
                // not logged in or session expired
                // redirect to login page by reloading the page
                devStatusNavigate.redirectToLogin();
                return true;
            }
            return false;
        },

        _initFetchHandlers: function _initFetchHandlers() {
            this.model.on('fetchRequested', this._showLoadingIndicator, this);
            this.model.on('fetchSucceeded', this._handleFetchSucceeded, this);
            this.model.on('fetchFailed', this._handleFetchFailed, this);
        },

        _handleFetchSucceeded: function _handleFetchSucceeded(applicationType, result) {
            this._hideLoadingIndicator(applicationType);
            // If there are any details show them, otherwise there was an error
            var hasData = result.detail && this.hasData(result.detail);
            if (hasData) {
                this.renderSuccess(applicationType, result.detail);
            }
            // always try to render error regardless of whether there are data displayed
            this._renderError(applicationType, result.errors, hasData);
            this._postRender();
        },

        _handleFetchFailed: function _handleFetchFailed(applicationType, xhr) {
            this._hideLoadingIndicator(applicationType);
            if (!this._redirectToLoginIf401(xhr)) {
                this._renderError(applicationType, [], false, true); // indicate ajaxFailed to render as generic connection problem
            }
        },

        _initAuthenticationCallbacks: function _initAuthenticationCallbacks() {
            this._patchAJSIconsForAppLinks();
            // setup handlers for oauth callback (via applinks)
            var instance = this;
            var oauthApprovedHandler = function oauthApprovedHandler(e, applinkProperties) {
                // notify the model about this change so that it could initiate the refresh if needed
                instance.model.oauthStatusChanged(applinkProperties.appType);
                // refresh authentication status by initiating the api call again
                instance.model.fetchAuthenticationStatuses();
                // stop the default applinks handler to reload the window
                e.preventDefault();
            };

            var getProductFromApplinkProperties = function getProductFromApplinkProperties(applinkProperties) {
                var product = null;
                if (applinkProperties.id && applinkProperties.appUri && applinkProperties.appName && applinkProperties.appType) {
                    product = {
                        applicationLinkId: applinkProperties.id,
                        baseUrl: applinkProperties.appUri,
                        name: applinkProperties.appName,
                        type: applinkProperties.appType
                    };
                }
                return product;
            };

            var renderOauthFailureErrorToUser = function renderOauthFailureErrorToUser(applinkProperties, messages) {
                var products = [getProductFromApplinkProperties(applinkProperties)];
                var Helpers = __webpack_require__("./js/util/Helpers.js");
                var sanitisedMessages = Helpers.copyAndMarkStringPropertiesAsSanitised(messages);

                var renderAdminError = function renderAdminError() {
                    if (JIRA.isAdmin()) {
                        instance._renderConnectionError(instance.model._getCurrentApplicationType(), products, {
                            message: sanitisedMessages.adminError,
                            details: sanitisedMessages.adminErrorDetails
                        });
                    } else {
                        instance._renderConnectionError(instance.model._getCurrentApplicationType(), products);
                    }
                };

                var renderUserError = function renderUserError() {
                    instance._renderAuthenticationError(instance.model._getCurrentApplicationType(), products, [], sanitisedMessages.userError);
                };

                if (sanitisedMessages.adminError) {
                    renderAdminError();
                } else if (sanitisedMessages.userError) {
                    renderUserError();
                }
            };

            /**
            * Control is handed to this function when applinks raises an "applinks.auth.denied" event, signalling that
            * some part of the oauth dance for a particular applink has failed.
            *
            * @param e {Object} an object representing the event
            * @param applinkProperties {Object} contains information about the applink involved such as:
            *      'id': the id for the applink
            *      'appUri': the URI for the remote app
            *      'appName': the name of the remote app
            *      'appType': the type of the remote app
            * @param messages {Object} an object containing the following properties
            *       'userError': an error message relevant to a non-admin user
            *       'adminError': an error message relevant to an admin user
            *       'adminErrorDetails': a list of details related to the admin message if there are any
            */
            var oauthFailedHandler = function oauthFailedHandler(e, applinkProperties, messages) {
                if (messages) {
                    renderOauthFailureErrorToUser(applinkProperties, messages);
                }
                // there could be different reasons why the denied event is fired
                // usually it's about some errors or the user explicitly denied
                // We handle one particular case differently:
                // When the user's session expired, we redirect to the login page
                $.ajax(wrmContextPath() + '/rest/auth/1/session').promise().fail(function (xhr) {
                    instance._redirectToLoginIf401(xhr);
                });
            };
            var $document = $(document);
            $document.bind('applinks.auth.approved', oauthApprovedHandler);
            $document.bind('applinks.auth.denied', oauthFailedHandler);

            // clean up the oauth callback upon dialog close
            $(this.dialog).bind('Dialog.beforeHide', function () {
                $document.unbind('applinks.auth.approved', oauthApprovedHandler);
                $document.unbind('applinks.auth.denied', oauthFailedHandler);

                // remove all callbacks on the model.
                instance.model.off(null, null, instance);

                // clean up the inline dialog if it exists
                instance.instanceListPopup && instance.instanceListPopup.remove();
            });

            // create a hidden banner div.applinks-auth-confirmation-container so that the confirmation msg is not shown
            $('<div class="applinks-auth-confirmation-container hidden"></div>').appendTo(this.$el);
        },

        _initFetchAuthenticationHandlers: function _initFetchAuthenticationHandlers() {
            this.model.on('fetchAuthRequested', this._showLoadingIndicator, this);
            this.model.on('fetchAuthSucceeded', this._handleAuthSucceeded, this);
            this.model.on('fetchAuthFailed', this._handleAuthFailed, this);
        },

        _handleAuthSucceeded: function _handleAuthSucceeded(result) {
            var instance = this;
            // get only those that are not authenticated
            var unauthInstances = _.filter(result, function (instanceWithStatus) {
                // only care about those that are not authenticated, and have an application link id
                return instanceWithStatus.configured && !instanceWithStatus.authenticated && instanceWithStatus.source && instanceWithStatus.source.applicationLinkId;
            });
            var statusDiv = this._getOAuthStatusDiv();
            if (unauthInstances.length > 0 && !JIRA.Users.LoggedInUser.isAnonymous()) {
                statusDiv.html(this.oauthStatusTemplate({
                    message: this.getOAuthMessageInFooter(unauthInstances)
                }));
                this._renderUnauthInstancesInFooter(unauthInstances);
                statusDiv.show();
            } else {
                statusDiv.hide();
            }
        },

        _handleAuthFailed: function _handleAuthFailed(xhr) {
            this._redirectToLoginIf401(xhr);
            // silently ignore this error
            this._getOAuthStatusDiv().hide();
        },

        _renderUnauthInstancesInFooter: function _renderUnauthInstancesInFooter(unauthInstances) {
            var statusDiv = this._getOAuthStatusDiv();
            var appLinkDivs = _.map(_.pluck(unauthInstances, 'source'), this._createOAuthInstanceDiv);
            if (appLinkDivs.length > 0) {
                statusDiv.append(appLinkDivs[0]);
                if (appLinkDivs.length > 1) {
                    statusDiv.append(', ');
                    statusDiv.append(appLinkDivs[1]);
                    if (appLinkDivs.length > 2) {
                        statusDiv.append(' ');
                        // show more link
                        var moreLink = $('<span class="more-instances"><a href="#">' + formatter.I18n.getText('devstatus.authentication.message.more.link') + '</a></span>');
                        statusDiv.append(moreLink);
                        var inlineDialogContent = $('<ul class="instance-list"></ul>');
                        _.each(appLinkDivs.slice(2), function (appLinkDiv) {
                            inlineDialogContent.append($('<li class="instance-in-popup"></li>').append(appLinkDiv));
                        });
                        AJS.InlineDialog(moreLink, 'instance-list-popup', function (content, trigger, showPopup) {
                            content.html(inlineDialogContent);
                            showPopup();
                            return false;
                        }, {
                            width: 150,
                            offsetX: -100,
                            onTop: true
                        });
                    }
                }
            }
        },

        _createOAuthInstanceDiv: function _createOAuthInstanceDiv(instance) {
            var div = ApplinksUtils.createAuthRequestInline(null, {
                id: instance.applicationLinkId,
                authUri: wrmContextPath() + '/plugins/servlet/applinks/oauth/login-dance/authorize?applicationLinkID=' + encodeURIComponent(instance.applicationLinkId),
                appUri: instance.baseUrl,
                appName: instance.name,
                appType: instance.type
            });
            return $('<span class="instance"></span>').append(div.find('a.applink-authenticate').text(instance.name));
        },

        /**
        * Not needed once APL-1106 is done and included in jira core
        * @private
        */
        _patchAJSIconsForAppLinks: function _patchAJSIconsForAppLinks() {
            AJS.icons = AJS.icons || {};
            AJS.icons.addIcon = AJS.icons.addIcon || {};
            AJS.icons.addIcon.init = AJS.icons.addIcon.init || function () {};
        },

        _getOAuthStatusDiv: function _getOAuthStatusDiv() {
            var oauthStatusDiv = this.$el.find('.buttons-container .oauth-status');
            if (oauthStatusDiv.length) {
                return oauthStatusDiv;
            } else {
                // create it if it's not there
                // insert it after the buttons, since it's not easy to make it left aligned if inserted before the buttons
                return $('<div class="oauth-status" />').appendTo(this.$el.find('.buttons-container.form-footer'));
            }
        },

        _renderError: function _renderError(applicationType, errors, hasData, ajaxFailed) {
            /**
            * split the errors into groups. Currently this includes: 'unauthorized', 'incapable' and others
            */
            var groups = _.groupBy(errors, function (errorInstance) {
                var errorType = errorInstance.error;
                if (errorType === 'unauthorized' || errorType === 'incapable') {
                    return errorType;
                } else {
                    return 'others';
                }
            });

            /**
            * Plucking the relevant error type from the groups to show in the UI
            * Currently we only show errors for unauthorized and others.
            * Incapable errors are not shown in the detail dialog.
            */
            var unauth = _.pluck(groups['unauthorized'], 'instance');
            var others = _.pluck(groups['others'], 'instance');

            if (unauth.length > 0) {
                // trigger a refresh of the authentication message in the footer
                this.model.fetchAuthenticationStatuses();
            }
            if (hasData) {
                if (others.length > 0) {
                    // prepend warning if there's any connection error
                    this._renderConnectionErrorBeforeData(applicationType, others);
                }
            } else {
                // we would take over the whole screen to display error, unless hasData
                if (unauth.length > 0) {
                    this._renderAuthenticationError(applicationType, unauth, others);
                } else {
                    if (ajaxFailed || others.length > 0) {
                        // render the connection problem screen only when hasData is false
                        this._renderConnectionError(applicationType, others);
                    } else {
                        // if not ajaxFailed and not errors at all, there must be some data that the user is not allowed to see
                        this._renderNoPermissionToViewAllWarning(applicationType);
                    }
                }
            }
        },

        _renderConnectionErrorBeforeData: function _renderConnectionErrorBeforeData(applicationType, otherInstances) {
            this.getContentContainer(applicationType).prepend(this.connectionProblemWarningTemplate({
                instances: otherInstances,
                showContactAdminForm: this.options.showContactAdminForm
            }));
        },

        _renderConnectionError: function _renderConnectionError(applicationType, otherInstances, adminError) {
            this.getContentContainer(applicationType).html(this.connectionProblemTemplate({
                instances: otherInstances,
                adminError: adminError,
                showContactAdminForm: this.options.showContactAdminForm,
                title: this.getConnectionMessageInCanvas()
            }));
        },

        /**
        * Render the no permission to view all warning if necessary.
        * @param applicationType the current application type
        * @param totalItemRendered the total number of data rendered on the canvas, e.g., total number of commits.
        */
        renderNoPermissionToViewAllWarningAtBottom: function renderNoPermissionToViewAllWarningAtBottom(applicationType, totalItemRendered) {
            var tab = this.model.get('tabs')[applicationType] || {};
            var content = this.model.get('contentMap')[applicationType] || {};

            if (totalItemRendered < tab.count) {
                if ((content.errors || []).length === 0 || JIRA.Users.LoggedInUser.isAnonymous()) {
                    // if no errors and total number of data is smaller than the count from summary
                    //  then we show the warning that the user might not have permission to see all data
                    // OR
                    // if the user is anonymous, we will show a login message
                    this.getContentContainer(applicationType).append(this._getNoPermissionToViewAllHtml());
                }
            }
        },

        _getNoPermissionToViewAllHtml: function _getNoPermissionToViewAllHtml() {
            return this.noPermissionToViewAllTemplate({
                message: this.getNoPermissionToViewAllMessageInCanvas(),
                secondaryMessage: this.getContactAdmistratorsOrLoginMessageInCanvas()
            });
        },

        _renderNoPermissionToViewAllWarning: function _renderNoPermissionToViewAllWarning(applicationType) {
            this.getContentContainer(applicationType).html(this._getNoPermissionToViewAllHtml());
        },

        _renderAuthenticationError: function _renderAuthenticationError(applicationType, unauthInstances, otherInstances, userError) {
            var container = this.getContentContainer(applicationType);
            container.html(this.authenticationTemplate({
                unauthInstances: unauthInstances,
                title: this.getOAuthMessageInCanvas(),
                otherInstances: otherInstances,
                showContactAdminForm: this.options.showContactAdminForm,
                userError: userError
            }));
            var appLinkDivs = _.map(unauthInstances, this._createOAuthInstanceDiv);
            var instancesDiv = container.find('.instances');
            _.each(appLinkDivs, function (appLinkDiv, index) {
                if (index !== 0) {
                    // add comma as separator if not the first one
                    instancesDiv.append(', ');
                }
                instancesDiv.append(appLinkDiv);
            });
        },

        _initFormDialog: function _initFormDialog() {
            var instance = this;
            this.dialog = new FormDialog({
                id: this.options.id,
                width: this.options.width,
                content: function content(ready) {
                    instance.setElement(this.$popup);
                    instance.delegateEvents(_.extend({}, instance.frameEvents, instance.events));

                    instance._renderFrame();

                    instance._initAuthenticationCallbacks();
                    instance._initFetchAuthenticationHandlers();
                    instance.model.fetchAuthenticationStatuses();

                    var targetTab = detailDialogLocalStorage.getItem(instance._getTabStorageId());
                    if (instance._tabHasContent(targetTab)) {
                        instance._activateTab(targetTab);
                    }
                    instance.model.switchTab(instance._getActiveApplicationType());

                    ready();
                },
                autoClose: true
            });
        },

        _postRender: function _postRender() {
            this.$el.find('.extra-content-in-title').tooltip();
            this.dialog._positionInCenter();
            // Select the first link element in the active tab
            this.$el.find('.active-pane a:eq(0)').focus();
        },

        _getActiveApplicationType: function _getActiveApplicationType() {
            return this.$el.find('.menu-item.active-tab').data('applicationType');
        },

        _getStorageRef: function _getStorageRef() {
            var projectKey = this.options.issueKey.split('-')[0];
            return projectKey + '-' + this.options.type;
        },

        _getTabStorageId: function _getTabStorageId() {
            return 'stored-tab-' + this._getStorageRef();
        },

        _tabHasContent: function _tabHasContent(tab) {
            return this.$el.find('#tab-menu-' + tab).length > 0;
        },

        _activateTab: function _activateTab(tab) {
            // Deactivate the default tab and content pane first
            this.$el.find('.menu-item.active-tab').toggleClass('active-tab');
            this.$el.find('.tabs-pane.active-pane').toggleClass('active-pane');

            this.$el.find('#tab-menu-' + tab).toggleClass('active-tab');
            this.$el.find('#tab-content-' + tab).toggleClass('active-pane');
        },

        _showLoadingIndicator: function _showLoadingIndicator(applicationType) {
            var targetPane = this._getPane(applicationType);
            targetPane._removeClass('ready');
            targetPane.addClass('loading');
            var loadingIndicator = targetPane.find('.status-loading');
            loadingIndicator.spin('large');
            loadingIndicator.show();
        },

        _hideLoadingIndicator: function _hideLoadingIndicator(applicationType) {
            var targetPane = this._getPane(applicationType);
            targetPane.addClass('ready');
            var loadingIndicator = targetPane.find('.status-loading');
            if (loadingIndicator) {
                targetPane.removeClass('loading');
                loadingIndicator.hide();
                loadingIndicator.spinStop();
            }
        },

        _renderFrame: function _renderFrame() {
            this.$el.html(this.frameTemplate({
                title: this.getTitle(this.options.count, this.options.issueKey),
                tabs: this._convertTabsForSoy(),
                initialTab: this.options.initialTab
            }));

            if (this.options.height) {
                this.$el.find('.form-body').css('min-height', this.options.height);
            }
        },

        _convertTabsForSoy: function _convertTabsForSoy() {
            /*
            Tabs given by model is in the form of:
            {
            "application": {
            count: number
            }
            }
            This is to convert the above map into an array so foreach in soy works
            */
            return _.chain(this.model.get('tabs')).map(function (data, name) {
                return _.extend({
                    type: name
                }, data);
            }).sortBy(function (data) {
                return data.type;
            }).value();
        },

        /**
        * Sorts a list of review overviews putting the ones with the more important states before the ones with the less important states, and filtering unknown states
        */
        _sortReviewsByStatus: function _sortReviewsByStatus(reviewOverviews) {
            var reviewPriorities = ['REVIEW', 'APPROVAL', 'SUMMARIZE', 'REJECTED', 'CLOSED'];
            return _.chain(reviewOverviews).filter(function (review) {
                return _.contains(reviewPriorities, review.state);
            }).sortBy(function (review) {
                return _.indexOf(reviewPriorities, review.state);
            }).value();
        },

        _setupReviewsPopup: function _setupReviewsPopup(e, dataFunction, onShowFunction, onSelectFunction) {
            e.preventDefault();

            var target = $(e.currentTarget);
            if (!target.data('inline-dialog-inited')) {
                var id = 'commit-reviews-popup-' + this._tooltipSeq++;
                this.activeReviewsToolTip = AJS.InlineDialog(target, id, function (content, trigger, showPopup) {
                    var reviewData = dataFunction($(trigger));
                    onShowFunction && onShowFunction();
                    content.html(JIRA.Templates.DevStatus.DetailDialog.reviewsInlineDialog({
                        reviewData: reviewData
                    }));

                    if (onSelectFunction) {
                        content.find('a').click(onSelectFunction);
                    }

                    showPopup();
                }, {
                    cacheContent: false,
                    hideDelay: 200,
                    showDelay: 50,
                    onHover: true,
                    width: false //Stop AUI from hardcoding inline dialog width
                });

                target.data('inline-dialog-inited', true).mouseenter();
            }
        },

        _removeInlineDialog: function _removeInlineDialog(inlineDialog) {
            if (this[inlineDialog]) {
                this[inlineDialog].hide();
                this[inlineDialog].remove();
                this[inlineDialog] = undefined;
            }
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/dialog/build/DetailDialogBuildView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(12);
__webpack_require__(18);

// @formatter:off
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/viewissue/dialog/BaseDetailDialogView.js"), __webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter, _, BaseDetailDialogView, require) {
    var devStatusDate = __webpack_require__("./js/util/DateUtils.js");
    var devAnalytics = __webpack_require__("./js/analytics/devstatus-analytics.js");

    return BaseDetailDialogView.extend({
        template: JIRA.Templates.DevStatus.DetailDialog.build,

        events: {
            'click a.project-link': '_onClickProjectLink',
            'click a.plan-link': '_onClickPlanLink',
            'click a.build-link': '_onClickBuildLink'
        },

        initialize: function initialize(options) {
            this.analytics = devAnalytics.BuildsAnalytics;
            BaseDetailDialogView.prototype.initialize.call(this, _.extend({
                type: 'build',
                width: 1000,
                height: 400
            }, options));
        },

        renderSuccess: function renderSuccess(applicationType, result) {
            var projects = _.reduce(result, function (memo, data) {
                return memo.concat(data.projects || []);
            }, []);
            var container = this.getContentContainer(applicationType);
            container.html(this.template({
                applicationType: applicationType,
                projects: this.sortProjectsAndPlans(projects),
                hasArtifacts: this.hasArtifacts(projects)
            }));
            this.renderNoPermissionToViewAllWarningAtBottom(applicationType, this.getBuildCount(projects));
            devStatusDate.addTooltip(container);
            return this;
        },

        getTitle: function getTitle(count, issue) {
            return formatter.I18n.getText('devstatus.detail.panel.title.build', count, issue);
        },

        getOAuthMessageInFooter: function getOAuthMessageInFooter(instances) {
            return formatter.I18n.getText('devstatus.authentication.message.build', instances.length);
        },

        getOAuthMessageInCanvas: function getOAuthMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.authenticate.build.title');
        },

        getConnectionMessageInCanvas: function getConnectionMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.connection-problem.build.title');
        },

        getNoPermissionToViewAllMessageInCanvas: function getNoPermissionToViewAllMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.no-permission-to-view-all.build.title');
        },

        hasData: function hasData(detail) {
            return _.reduce(detail, function (memo, data) {
                return memo.concat(data.projects || []);
            }, []).length > 0;
        },

        /**
        * Sort projects by most recent build first and plans from newest to oldest build.
        */
        sortProjectsAndPlans: function sortProjectsAndPlans(projects) {
            projects = _.sortBy(projects, function (project) {
                return _.last(_.sortBy(project.plans, function (plan) {
                    return plan.build.finishedDate;
                })).build.finishedDate;
            }).reverse();
            _.each(projects, function (project) {
                // Dates should _always_ be in ISO format - so ASCII sorting will work
                project.plans = _.sortBy(project.plans, function (plan) {
                    return plan.build.finishedDate;
                }).reverse();
            });
            return projects;
        },

        hasArtifacts: function hasArtifacts(projects) {
            return _.any(projects, function (project) {
                return _.any(project.plans, function (plan) {
                    return plan.build && plan.build.artifacts && plan.build.artifacts.length;
                });
            });
        },

        /**
        * Calculate the total number of builds in all projects.
        */
        getBuildCount: function getBuildCount(projects) {
            return _.union.apply(null, _.map(projects, function (project) {
                // project's plan
                return _.pluck(project.plans, 'key');
            })).length;
        },

        _onClickProjectLink: function _onClickProjectLink() {
            devAnalytics.BuildsAnalytics.fireDetailProjectClicked();
        },

        _onClickPlanLink: function _onClickPlanLink() {
            devAnalytics.BuildsAnalytics.fireDetailPlanClicked();
        },

        _onClickBuildLink: function _onClickBuildLink() {
            devAnalytics.BuildsAnalytics.fireDetailBuildClicked();
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 1:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 12:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 13:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 14:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 15:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 18:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 2:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 3:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ "jira.webresources:dialogs/require('jira/dialog/form-dialog')":
/***/ (function(module, exports) {

module.exports = require('jira/dialog/form-dialog');

/***/ }),

/***/ "jira.webresources:jira-events/require('jira/util/events')":
/***/ (function(module, exports) {

module.exports = require('jira/util/events');

/***/ }),

/***/ "jira.webresources:jira-events/require('jira/util/events/types')":
/***/ (function(module, exports) {

module.exports = require('jira/util/events/types');

/***/ }),

/***/ "jira.webresources:jira-global/require('jira/ajs/dark-features')":
/***/ (function(module, exports) {

module.exports = require('jira/ajs/dark-features');

/***/ }),

/***/ "jira.webresources:jira-logger/require('jira/util/logger')":
/***/ (function(module, exports) {

module.exports = require('jira/util/logger');

/***/ }),

/***/ "jira.webresources:jira-metadata/require('jira/util/data/meta')":
/***/ (function(module, exports) {

module.exports = require('jira/util/data/meta');

/***/ }),

/***/ "jira.webresources:momentjs/require('jira/moment')":
/***/ (function(module, exports) {

module.exports = require('jira/moment');

/***/ })

});
//# sourceMappingURL=5.3baf307a4455cdd0fe4f.js.map